/**************************************************************************

  "piconv.h"	K. J. Turner <kjt@cs.stir.ac.uk>	05/11/97

  Common declarations for "from_pi" and "to_pi".
  
**************************************************************************/

/********************************* Headers *******************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <sys/dir.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "pi-dlp.h"
#include "pi-file.h"
#include "pi-source.h"
#include "pi-socket.h"

#include "pi-address.h"
#include "pi-datebook.h"
#include "pi-expense.h"
#include "pi-memo.h"
#include "pi-todo.h"

#ifdef sun
  extern char* optarg;
  extern int optind;
#endif

/********************************* Macros *******************************/

# define ADDR_FLD_COUNT 19			/* address field count */
# define ADDR_LAB_COUNT 22			/* address label count */
# define ADDR_SIZE 1024				/* size of address line */
# define APPT_SIZE 1024				/* size of appointment line */
# define BUFF_SIZE 16384			/* size of data buffer */
# define CAT_COUNT 16				/* category count */
# define CAT_SIZE 16				/* size of category name */
# define DAY_SECS 24 * HOUR_SECS		/* seconds in day */
# define EXP_CURR_MAX 128			/* max expense currency no. */
# define EXP_SIZE 1024				/* size of expense line */
# define FIELD_SIZE 1024			/* size of record field */
# define HOUR_SECS 60 * 60			/* seconds in hour */
# define LINE_SIZE 80				/* size of file name */
# define MEMO_SIZE 15000			/* size of memo */
# define MEMO_NAME_SIZE 32			/* size of memo name */
# define TODO_SIZE 1024				/* size of todo line */
# define WEEK_SECS 7 * DAY_SECS			/* seconds in week */

/**************************** General Variables ****************************/

char * mon_name [] = {				/* month names */
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
  };

FILE * cat_file[CAT_SIZE];			/* category file handles */
int title_fld, first_fld, last_fld;		/* title, first/last name */
int workph_fld, homeph_fld, fax_fld;		/* work/home/fax phone */
int main_fld, pager_fld, mobile_fld;		/* main/pager/mobile phone */
int workad_fld, homead_fld;			/* work/home address */
int comp_fld, town_fld, county_fld;		/* company/town/county */
int code_fld, country_fld;			/* post code, country */
int email1_fld, email2_fld, web_fld;		/* email 1/2, web */
int link_fld;					/* links */
int other_fld, note_fld;			/* other, note */
char * prev_fld;				/* previous field pointer */
char * progname;				/* program name */
char message[256];				/* program message */

/**************************** Expense Variables ****************************/

char * exp_type [] = {				/* expense types */
    "Airfare", "Breakfast", "Bus", "BusinessMeals", "CarRental", "Dinner",
    "Entertainment", "Fax", "Gas", "Gifts", "Hotel", "Incidentals", "Laundry",
    "Limo", "Lodging", "Lunch", "Mileage", "Other", "Parking", "Postage",
    "Snack", "Subway", "Supplies", "Taxi", "Telephone", "Tips", "Tolls",
    "Train"
  };

char * exp_pay [] = {				/* expense payment types */
    "AmEx", "Cash", "Check", "CreditCard", "MasterCard", "Prepaid", "Visa",
    NULL /* Unfiled */
  };

char * exp_curr [] = {				/* expense currencncy types */
    "AU$", "SCH", "BFR", "CRZ", "CN$", "DKR", "FMK", "FFR",
    "DM", "HK$", "IL", "PNT", "LIR", "", "LUX", "PSO", "DFL",
    "NZ$", "NKR", "PST", "SKR", "SFR", "", "$", NULL /* None */
  };

/********************************* Functions *******************************/

/*** print program usage message ***/

void usage (void)
{
  fprintf (stderr, "usage: %s -a(ddress) | -d(ate) | -e(xpense) ", progname);
  fprintf (stderr, "| -h(elp) | -m(emo) | -t(odo)\n");
  exit (1);
}

/*** report warning message ***/

void warning (char * mess)
{
  fprintf (stderr, "%s: %s\n", progname, mess);
}

/*** report fatal error message ***/

void fatal (char * mess)
{
  fprintf (stderr, "%s: %s\n", progname, mess);
  exit (1);
}

/*************************************************************************/
