/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.stir.cs.terrawiz;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import uk.ac.stir.cs.terrawiz.AboutTerraWiz;
import uk.ac.stir.cs.terrawiz.Common;
import uk.ac.stir.cs.terrawiz.ErrorChecker;
import uk.ac.stir.cs.terrawiz.HTMLPane;
import uk.ac.stir.cs.terrawiz.SettingWindow;

public class Advanced
extends JFrame
implements ActionListener {
    private JMenuBar menubar;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenu openRecentMenu;
    private JMenuItem newFile;
    private JMenuItem openFile;
    private JMenuItem save;
    private JMenuItem saveAs;
    private JMenuItem reload;
    private JMenuItem exit;
    private JMenuItem helpContent;
    private JMenuItem about;
    private JMenuItem recentFile1;
    private JMenuItem recentFile2;
    private JMenuItem recentFile3;
    private JMenuItem recentFile4;
    private JMenuItem preference;
    private JTabbedPane switchable;
    private JPanel panelLake;
    private JPanel panelMountain;
    private JPanel panelSurface;
    private JPanel panelCloud;
    private JPanel panelLight;
    private JPanel panelCamera;
    private JLabel labEnableLake;
    private JLabel labEnableMount;
    private JLabel labEnableSurface;
    private JLabel labEnableCloud;
    private JCheckBox cboxLake;
    private JCheckBox cboxMountain;
    private JCheckBox cboxSurface;
    private JCheckBox cboxCloud;
    private JRadioButton radioLakeDepth1;
    private JRadioButton radioLakeDepth2;
    private JRadioButton radioLakeRadius1;
    private JRadioButton radioLakeRadius2;
    private JRadioButton radioLakeRough1;
    private JRadioButton radioLakeRough2;
    private JRadioButton radioLakeWave1;
    private JRadioButton radioLakeWave2;
    private JRadioButton radioLakeReflect1;
    private JRadioButton radioLakeReflect2;
    private JRadioButton radioMountRough1;
    private JRadioButton radioMountRough2;
    private JRadioButton radioMountFlat1;
    private JRadioButton radioMountFlat2;
    private JRadioButton radioSurface1;
    private JRadioButton radioSurface2;
    private JRadioButton radioSurfaceMaxalt1;
    private JRadioButton radioSurfaceMaxalt2;
    private JRadioButton radioSurfaceMaxalt3;
    private JRadioButton radioSurfaceMinalt1;
    private JRadioButton radioSurfaceMinalt2;
    private JRadioButton radioSurfaceMinalt3;
    private JRadioButton radioCloudCategory1;
    private JRadioButton radioCloudCategory2;
    private JRadioButton radioCloudColor1;
    private JRadioButton radioCloudColor2;
    private JRadioButton radioCloudDensity1;
    private JRadioButton radioCloudDensity2;
    private JRadioButton radioCloudAltitude1;
    private JRadioButton radioCloudAltitude2;
    private JRadioButton radioCloudDepth1;
    private JRadioButton radioCloudDepth2;
    private JLabel labLightHeading;
    private JLabel labSunHeight;
    private JRadioButton radioLightHeading1;
    private JRadioButton radioLightHeading2;
    private JRadioButton radioLightHeading3;
    private JRadioButton radioLightHeading4;
    private JRadioButton radioLightElevation1;
    private JRadioButton radioLightElevation2;
    private JRadioButton radioLightElevation3;
    private JLabel labCamHeight;
    private JLabel labCamHeading;
    private JLabel labSurfaceMax;
    private JLabel labSurfaceMin;
    private JRadioButton radioCameraHeight1;
    private JRadioButton radioCameraHeight2;
    private JRadioButton radioCameraHeading1;
    private JRadioButton radioCameraHeading2;
    private JRadioButton radioCameraHeading3;
    private JRadioButton radioCameraHeading4;
    private ButtonGroup aButtonGroup;
    private DOMParser parser;
    private Document domTGD;
    private Document domTGW;
    private Document domSetting;
    private Element rootTGD;
    private Element lakeTGD;
    private Element waterShader;
    private Element fractalShader;
    private Element surfaceShader;
    private Element surfaceLayer;
    private Element cloudLayer;
    private Element cloudShader;
    private Element rootTGW;
    private Element lakeTGW;
    private Element mountain;
    private Element surface;
    private Element cloud;
    private Element lighting;
    private Element camera;
    private Element rootSetting;
    private Element recentFile;
    private Element language;
    private Element mode;
    private Node file;
    private Text fileTextNode;
    private JFileChooser fileChooser;
    private File selectedFile;
    private int[][] loadedSetting;
    private int[][] tempSetting;
    private Properties translation;
    private String settingsFullPath;
    private String homeDirectory = System.getProperty("user.home");
    public String lang;

    public Advanced() {
        this.initWindow();
        this.initLang();
        this.createGUI();
        this.initParser();
        this.initVariables();
        if (!this.loadSettingDOM("/.terrawiz.xml")) {
            this.initSettingFile();
        }
        this.resetLang();
    }

    public Advanced(String string) {
        this.initWindow();
        if (!this.loadSettingDOM("/.terrawiz.xml")) {
            this.initSettingFile();
        }
        this.initLang(string);
        this.createGUI();
        this.initParser();
        this.initVariables();
        this.resetLang();
    }

    private InputStream getResourceStream(String string) {
        return this.getClass().getClassLoader().getResourceAsStream(string);
    }

    void resetLang() {
        this.fileMenu.setText(this.translate("menu.file"));
        this.helpMenu.setText(this.translate("menu.help"));
        this.newFile.setText(this.translate("menuitem.new"));
        this.openFile.setText(this.translate("menuitem.open"));
        this.openRecentMenu.setText(this.translate("menuitem.openrecent"));
        this.save.setText(this.translate("menuitem.save"));
        this.saveAs.setText(this.translate("menuitem.saveas"));
        this.reload.setText(this.translate("menuitem.reload"));
        this.exit.setText(this.translate("menuitem.exit"));
        this.preference.setText(this.translate("menuitem.preference"));
        this.helpContent.setText(this.translate("menuitem.helpcontents"));
        this.about.setText(this.translate("menuitem.about"));
        this.switchable.setTitleAt(0, this.translate("tab.lake"));
        this.switchable.setTitleAt(1, this.translate("tab.mountain"));
        this.switchable.setTitleAt(2, this.translate("tab.surface"));
        this.switchable.setTitleAt(3, this.translate("tab.cloud"));
        this.switchable.setTitleAt(4, this.translate("tab.lighting"));
        this.switchable.setTitleAt(5, this.translate("tab.camera"));
        this.labEnableLake.setText(this.translate("label.lake"));
        this.radioLakeDepth1.setText(this.translate("label.lake.shallow"));
        this.radioLakeDepth2.setText(this.translate("label.lake.deep"));
        this.radioLakeRadius1.setText(this.translate("label.lake.narrow"));
        this.radioLakeRadius2.setText(this.translate("label.lake.broad"));
        this.radioLakeRough1.setText(this.translate("label.lake.smooth"));
        this.radioLakeRough2.setText(this.translate("label.lake.rough"));
        this.radioLakeWave1.setText(this.translate("label.lake.smallwave"));
        this.radioLakeWave2.setText(this.translate("label.lake.bigwave"));
        this.radioLakeReflect1.setText(this.translate("label.lake.lowreflect"));
        this.radioLakeReflect2.setText(this.translate("label.lake.highreflect"));
        this.labEnableMount.setText(this.translate("label.mountain"));
        this.radioMountRough1.setText(this.translate("label.mountain.smooth"));
        this.radioMountRough2.setText(this.translate("label.mountain.rough"));
        this.radioMountFlat1.setText(this.translate("label.mountain.flat"));
        this.radioMountFlat2.setText(this.translate("label.mountain.bumpy"));
        this.labEnableSurface.setText(this.translate("label.surface"));
        this.radioSurface1.setText(this.translate("label.surface.snow"));
        this.radioSurface2.setText(this.translate("label.surface.grass"));
        this.labSurfaceMax.setText(this.translate("label.surface.labmax"));
        this.labSurfaceMin.setText(this.translate("label.surface.labmin"));
        this.radioSurfaceMaxalt1.setText(this.translate("label.surface.lowmaxalt"));
        this.radioSurfaceMaxalt2.setText(this.translate("label.surface.highmaxalt"));
        this.radioSurfaceMaxalt3.setText(this.translate("label.surface.nonemaxalt"));
        this.radioSurfaceMinalt1.setText(this.translate("label.surface.lowminalt"));
        this.radioSurfaceMinalt2.setText(this.translate("label.surface.highminalt"));
        this.radioSurfaceMinalt3.setText(this.translate("label.surface.noneminalt"));
        this.labEnableCloud.setText(this.translate("label.cloud"));
        this.radioCloudCategory1.setText(this.translate("label.cloud.alto"));
        this.radioCloudCategory2.setText(this.translate("label.cloud.cirrus"));
        this.radioCloudColor1.setText(this.translate("label.cloud.white"));
        this.radioCloudColor2.setText(this.translate("label.cloud.gray"));
        this.radioCloudAltitude1.setText(this.translate("label.cloud.lowalt"));
        this.radioCloudAltitude2.setText(this.translate("label.cloud.highalt"));
        this.radioCloudDepth1.setText(this.translate("label.cloud.thin"));
        this.radioCloudDepth2.setText(this.translate("label.cloud.thick"));
        this.radioCloudDensity1.setText(this.translate("label.cloud.lowdensity"));
        this.radioCloudDensity2.setText(this.translate("label.cloud.highdensity"));
        this.labLightHeading.setText(this.translate("label.lighting.lightheading"));
        this.radioLightHeading1.setText(this.translate("label.lighting.east"));
        this.radioLightHeading2.setText(this.translate("label.lighting.north"));
        this.radioLightHeading3.setText(this.translate("label.lighting.west"));
        this.radioLightHeading4.setText(this.translate("label.lighting.south"));
        this.labSunHeight.setText(this.translate("label.lighting.sunheight"));
        this.radioLightElevation1.setText(this.translate("label.lighting.low"));
        this.radioLightElevation2.setText(this.translate("label.lighting.medium"));
        this.radioLightElevation3.setText(this.translate("label.lighting.high"));
        this.labCamHeight.setText(this.translate("label.camera.height"));
        this.radioCameraHeight1.setText(this.translate("label.camera.low"));
        this.radioCameraHeight2.setText(this.translate("label.camera.high"));
        this.labCamHeading.setText(this.translate("label.camera.heading"));
        this.radioCameraHeading1.setText(this.translate("label.camera.east"));
        this.radioCameraHeading2.setText(this.translate("label.camera.north"));
        this.radioCameraHeading3.setText(this.translate("label.camera.west"));
        this.radioCameraHeading4.setText(this.translate("label.camera.south"));
    }

    private void initWindow() {
        this.setTitle(this.translate("title.advancedmodenew"));
        this.setSize(450, 500);
        int n = (Toolkit.getDefaultToolkit().getScreenSize().width - 430) / 2;
        int n2 = (Toolkit.getDefaultToolkit().getScreenSize().height - 430) / 2;
        this.setLocation(n, n2);
        this.setVisible(true);
    }

    private void initParser() {
        this.loadTGDDOM("res/terragen.xml");
        this.createTGWDOM();
    }

    private void loadTGDDOM(String string) {
        this.parser = new DOMParser();
        try {
            this.parser.parse(new InputSource(this.getResourceStream(string)));
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, this.translate("err.filenotexist") + " - " + string);
            this.setWindowTitle("");
            Common.fileState = 0;
            return;
        }
        this.domTGD = this.parser.getDocument();
        this.rootTGD = this.domTGD.getDocumentElement();
    }

    private void createTGWDOM() {
        this.domTGW = DOMImplementationImpl.getDOMImplementation().createDocument(null, null, null);
        this.rootTGW = this.domTGW.createElement("terragen");
        this.rootTGW.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.rootTGW.setAttribute("xsi:noNamespaceSchemaLocation", "http://www.cs.stir.ac.uk/schemas/terragen_wizard.xsd");
        this.lighting = this.domTGW.createElement("lighting");
        this.camera = this.domTGW.createElement("camera");
        this.lighting.setAttribute("heading", "East");
        this.lighting.setAttribute("elevation", "East");
        this.camera.setAttribute("height", "Low");
        this.camera.setAttribute("heading", "East");
        this.rootTGW.appendChild(this.lighting);
        this.rootTGW.appendChild(this.camera);
        this.domTGW.appendChild(this.rootTGW);
    }

    private void loadTGWDOM(String string) {
        this.parser = new DOMParser();
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", true);
            this.parser.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        ErrorChecker errorChecker = new ErrorChecker();
        this.parser.setErrorHandler(errorChecker);
        try {
            this.parser.parse(string);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, this.translate("err.filenotexist") + " - " + string);
            this.setWindowTitle("");
            Common.fileState = 0;
            return;
        }
        this.domTGW = this.parser.getDocument();
        this.rootTGW = this.domTGW.getDocumentElement();
    }

    private void initVariables() {
        int n;
        int n2;
        this.loadedSetting = new int[6][6];
        for (n2 = 0; n2 < this.loadedSetting.length; ++n2) {
            for (n = 0; n < this.loadedSetting[n2].length; ++n) {
                this.loadedSetting[n2][n] = 0;
            }
        }
        this.tempSetting = new int[6][6];
        for (n2 = 0; n2 < this.tempSetting.length; ++n2) {
            for (n = 0; n < this.tempSetting[n2].length; ++n) {
                this.tempSetting[n2][n] = 0;
            }
        }
        this.loadedSetting[4][0] = 1;
        this.loadedSetting[5][0] = 1;
    }

    private void initSettingFile() {
        this.domSetting = DOMImplementationImpl.getDOMImplementation().createDocument(null, null, null);
        this.rootSetting = this.domSetting.createElement("Setting");
        this.recentFile = this.domSetting.createElement("RecentFile");
        this.language = this.domSetting.createElement("Language");
        this.language.appendChild(this.domSetting.createTextNode("en-GB"));
        this.mode = this.domSetting.createElement("Mode");
        this.mode.appendChild(this.domSetting.createTextNode("Advanced"));
        this.rootSetting.appendChild(this.recentFile);
        this.rootSetting.appendChild(this.language);
        this.rootSetting.appendChild(this.mode);
        this.domSetting.appendChild(this.rootSetting);
        this.settingsFullPath = this.homeDirectory + "/.terrawiz.xml";
        Common.writeXML(this.domSetting, this.settingsFullPath);
    }

    private boolean loadSettingDOM(String string) {
        this.parser = new DOMParser();
        try {
            this.settingsFullPath = this.homeDirectory + string;
            this.parser.parse(this.settingsFullPath);
        }
        catch (SAXException sAXException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        this.domSetting = this.parser.getDocument();
        this.rootSetting = this.domSetting.getDocumentElement();
        NodeList nodeList = this.rootSetting.getElementsByTagName("RecentFile");
        if (nodeList.getLength() == 0) {
            return false;
        }
        this.recentFile = (Element)nodeList.item(0);
        this.changeRecentFiles();
        return true;
    }

    private void changeRecentFiles() {
        NodeList nodeList = this.rootSetting.getElementsByTagName("File");
        if (nodeList.getLength() == 0) {
            this.recentFile1.setVisible(false);
            this.recentFile2.setVisible(false);
            this.recentFile3.setVisible(false);
            this.recentFile4.setVisible(false);
        } else {
            Common.openedFileNum = nodeList.getLength();
            block6: for (int i = 0; i < Common.openedFileNum; ++i) {
                Node node = nodeList.item(i);
                if (node.getFirstChild().getNodeValue() == null) continue;
                switch (i) {
                    case 0: {
                        this.recentFile1.setText(node.getFirstChild().getNodeValue());
                        this.recentFile1.setVisible(true);
                        continue block6;
                    }
                    case 1: {
                        this.recentFile2.setText(node.getFirstChild().getNodeValue());
                        this.recentFile2.setVisible(true);
                        continue block6;
                    }
                    case 2: {
                        this.recentFile3.setText(node.getFirstChild().getNodeValue());
                        this.recentFile3.setVisible(true);
                        continue block6;
                    }
                    case 3: {
                        this.recentFile4.setText(node.getFirstChild().getNodeValue());
                        this.recentFile4.setVisible(true);
                        continue block6;
                    }
                }
            }
        }
    }

    private void initLang() {
        this.parser = new DOMParser();
        try {
            this.settingsFullPath = this.homeDirectory + "/.terrawiz.xml";
            this.parser.parse(this.settingsFullPath);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.domSetting = this.parser.getDocument();
        this.rootSetting = this.domSetting.getDocumentElement();
        NodeList nodeList = this.rootSetting.getElementsByTagName("Language");
        this.lang = nodeList.item(0).getFirstChild().getNodeValue();
        this.translation = new Properties();
        InputStream inputStream = this.getResourceStream("res/" + this.lang + ".properties");
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-16");
            this.translation.load(inputStreamReader);
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            System.err.println("Wrong path or filename");
        }
        this.setTitle(this.translate("title.advancedmodenew"));
    }

    public void initLang(String string) {
        this.translation = new Properties();
        InputStream inputStream = this.getResourceStream("res/" + string + ".properties");
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-16");
            this.translation.load(inputStreamReader);
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            System.err.println("Wrong path or filename");
        }
        this.changeSetting(string, "Language");
    }

    public void changeSetting(String string, String string2) {
        Common.changeElem(this.rootSetting, string2, string);
        Common.writeXML(this.domSetting, this.homeDirectory + "/.terrawiz.xml");
    }

    public String translate(String string) {
        String string2 = "";
        if (this.translation == null || (string2 = this.translation.getProperty(string)) == null) {
            string2 = string + "?";
        }
        return string2;
    }

    private void createGUI() {
        this.setDefaultCloseOperation(3);
        Container container = this.getContentPane();
        container.setLayout(new FlowLayout());
        ImageIcon imageIcon = new ImageIcon("res/icon.png");
        this.setIconImage(imageIcon.getImage());
        this.menubar = new JMenuBar();
        this.fileMenu = new JMenu(this.translate("menu.file"));
        this.fileMenu.setMnemonic(70);
        this.helpMenu = new JMenu(this.translate("menu.help"));
        this.helpMenu.setMnemonic(72);
        this.newFile = new JMenuItem(this.translate("menuitem.new"));
        this.newFile.setIcon(new ImageIcon("res/new.png"));
        this.newFile.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openFile = new JMenuItem(this.translate("menuitem.open"));
        this.openFile.setIcon(new ImageIcon("res/open.png"));
        this.openFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openRecentMenu = new JMenu(this.translate("menuitem.openrecent"));
        this.openRecentMenu.setIcon(new ImageIcon("res/openrecent.png"));
        this.recentFile1 = new JMenuItem("");
        this.recentFile1.setVisible(false);
        this.recentFile2 = new JMenuItem("");
        this.recentFile2.setVisible(false);
        this.recentFile3 = new JMenuItem("");
        this.recentFile3.setVisible(false);
        this.recentFile4 = new JMenuItem("");
        this.recentFile4.setVisible(false);
        this.save = new JMenuItem(this.translate("menuitem.save"));
        this.save.setIcon(new ImageIcon("res/save.png"));
        this.save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveAs = new JMenuItem(this.translate("menuitem.saveas"));
        this.saveAs.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.reload = new JMenuItem(this.translate("menuitem.reload"));
        this.reload.setIcon(new ImageIcon("res/reload.png"));
        this.reload.setEnabled(false);
        this.reload.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.preference = new JMenuItem(this.translate("menuitem.preference"));
        this.preference.setIcon(new ImageIcon("res/preference.png"));
        this.preference.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.exit = new JMenuItem(this.translate("menuitem.exit"));
        this.exit.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.helpContent = new JMenuItem(this.translate("menuitem.helpcontents"));
        this.helpContent.setIcon(new ImageIcon("res/help.png"));
        this.helpContent.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.about = new JMenuItem(this.translate("menuitem.about"));
        this.fileMenu.add(this.newFile);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.openFile);
        this.fileMenu.add(this.openRecentMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.save);
        this.fileMenu.add(this.saveAs);
        this.fileMenu.add(this.reload);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.preference);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exit);
        this.openRecentMenu.add(this.recentFile1);
        this.openRecentMenu.add(this.recentFile2);
        this.openRecentMenu.add(this.recentFile3);
        this.openRecentMenu.add(this.recentFile4);
        this.helpMenu.add(this.helpContent);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.about);
        this.menubar.add(this.fileMenu);
        this.menubar.add(this.helpMenu);
        this.newFile.addActionListener(this);
        this.openFile.addActionListener(this);
        this.recentFile1.addActionListener(this);
        this.recentFile2.addActionListener(this);
        this.recentFile3.addActionListener(this);
        this.recentFile4.addActionListener(this);
        this.save.addActionListener(this);
        this.saveAs.addActionListener(this);
        this.exit.addActionListener(this);
        this.reload.addActionListener(this);
        this.helpContent.addActionListener(this);
        this.about.addActionListener(this);
        this.preference.addActionListener(this);
        this.setJMenuBar(this.menubar);
        this.panelLake = new JPanel();
        this.panelLake.setPreferredSize(new Dimension(430, 430));
        this.panelLake.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.labEnableLake = new JLabel(this.translate("label.lake"));
        this.panelLake.add((Component)this.labEnableLake, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.cboxLake = new JCheckBox();
        this.cboxLake.addActionListener(this);
        this.panelLake.add((Component)this.cboxLake, gridBagConstraints);
        this.radioLakeDepth1 = new JRadioButton(this.translate("label.lake.shallow"), true);
        this.radioLakeDepth2 = new JRadioButton(this.translate("label.lake.deep"));
        this.radioLakeDepth1.addActionListener(this);
        this.radioLakeDepth2.addActionListener(this);
        this.radioLakeDepth1.setEnabled(false);
        this.radioLakeDepth2.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioLakeDepth1);
        this.aButtonGroup.add(this.radioLakeDepth2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.panelLake.add((Component)this.radioLakeDepth1, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.panelLake.add((Component)this.radioLakeDepth2, gridBagConstraints);
        this.radioLakeRadius1 = new JRadioButton(this.translate("label.lake.narrow"), true);
        this.radioLakeRadius2 = new JRadioButton(this.translate("label.lake.broad"));
        this.radioLakeRadius1.addActionListener(this);
        this.radioLakeRadius2.addActionListener(this);
        this.radioLakeRadius1.setEnabled(false);
        this.radioLakeRadius2.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioLakeRadius1);
        this.aButtonGroup.add(this.radioLakeRadius2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        this.panelLake.add((Component)this.radioLakeRadius1, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        this.panelLake.add((Component)this.radioLakeRadius2, gridBagConstraints);
        this.radioLakeRough1 = new JRadioButton(this.translate("label.lake.smooth"), true);
        this.radioLakeRough2 = new JRadioButton(this.translate("label.lake.rough"));
        this.radioLakeRough1.addActionListener(this);
        this.radioLakeRough2.addActionListener(this);
        this.radioLakeRough1.setEnabled(false);
        this.radioLakeRough2.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioLakeRough1);
        this.aButtonGroup.add(this.radioLakeRough2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        this.panelLake.add((Component)this.radioLakeRough1, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        this.panelLake.add((Component)this.radioLakeRough2, gridBagConstraints);
        this.radioLakeWave1 = new JRadioButton(this.translate("label.lake.smallwave"), true);
        this.radioLakeWave2 = new JRadioButton(this.translate("label.lake.bigwave"));
        this.radioLakeWave1.addActionListener(this);
        this.radioLakeWave2.addActionListener(this);
        this.radioLakeWave1.setEnabled(false);
        this.radioLakeWave2.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioLakeWave1);
        this.aButtonGroup.add(this.radioLakeWave2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        this.panelLake.add((Component)this.radioLakeWave1, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        this.panelLake.add((Component)this.radioLakeWave2, gridBagConstraints);
        this.radioLakeReflect1 = new JRadioButton(this.translate("label.lake.lowreflect"), true);
        this.radioLakeReflect2 = new JRadioButton(this.translate("label.lake.highreflect"));
        this.radioLakeReflect1.addActionListener(this);
        this.radioLakeReflect2.addActionListener(this);
        this.radioLakeReflect1.setEnabled(false);
        this.radioLakeReflect2.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioLakeReflect1);
        this.aButtonGroup.add(this.radioLakeReflect2);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        this.panelLake.add((Component)this.radioLakeReflect1, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        this.panelLake.add((Component)this.radioLakeReflect2, gridBagConstraints);
        this.panelMountain = new JPanel();
        this.panelMountain.setPreferredSize(new Dimension(430, 430));
        this.panelMountain.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 17;
        this.labEnableMount = new JLabel(this.translate("label.mountain"));
        this.panelMountain.add((Component)this.labEnableMount, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        this.cboxMountain = new JCheckBox();
        this.cboxMountain.addActionListener(this);
        this.panelMountain.add((Component)this.cboxMountain, gridBagConstraints2);
        this.radioMountRough1 = new JRadioButton(this.translate("label.mountain.smooth"), true);
        this.radioMountRough2 = new JRadioButton(this.translate("label.mountain.rough"));
        this.radioMountRough1.addActionListener(this);
        this.radioMountRough2.addActionListener(this);
        this.radioMountRough1.setEnabled(false);
        this.radioMountRough2.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioMountRough1);
        this.aButtonGroup.add(this.radioMountRough2);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 1;
        this.panelMountain.add((Component)this.radioMountRough1, gridBagConstraints2);
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.gridy = 1;
        this.panelMountain.add((Component)this.radioMountRough2, gridBagConstraints2);
        this.radioMountFlat1 = new JRadioButton(this.translate("label.mountain.flat"), true);
        this.radioMountFlat2 = new JRadioButton(this.translate("label.mountain.bumpy"));
        this.radioMountFlat1.addActionListener(this);
        this.radioMountFlat2.addActionListener(this);
        this.radioMountFlat1.setEnabled(false);
        this.radioMountFlat2.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioMountFlat1);
        this.aButtonGroup.add(this.radioMountFlat2);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 2;
        this.panelMountain.add((Component)this.radioMountFlat1, gridBagConstraints2);
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.gridy = 2;
        this.panelMountain.add((Component)this.radioMountFlat2, gridBagConstraints2);
        this.panelSurface = new JPanel();
        this.panelSurface.setPreferredSize(new Dimension(430, 430));
        this.panelSurface.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.anchor = 17;
        this.labEnableSurface = new JLabel(this.translate("label.surface"));
        this.panelSurface.add((Component)this.labEnableSurface, gridBagConstraints3);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        this.cboxSurface = new JCheckBox();
        this.cboxSurface.addActionListener(this);
        this.panelSurface.add((Component)this.cboxSurface, gridBagConstraints3);
        this.radioSurface1 = new JRadioButton(this.translate("label.surface.snow"), true);
        this.radioSurface2 = new JRadioButton(this.translate("label.surface.grass"));
        this.radioSurface1.addActionListener(this);
        this.radioSurface2.addActionListener(this);
        this.radioSurface1.setEnabled(false);
        this.radioSurface2.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioSurface1);
        this.aButtonGroup.add(this.radioSurface2);
        gridBagConstraints3.gridx = 3;
        gridBagConstraints3.gridy = 1;
        this.panelSurface.add((Component)this.radioSurface1, gridBagConstraints3);
        gridBagConstraints3.gridx = 4;
        gridBagConstraints3.gridy = 1;
        this.panelSurface.add((Component)this.radioSurface2, gridBagConstraints3);
        this.radioSurfaceMaxalt1 = new JRadioButton(this.translate("label.surface.lowmaxalt"), true);
        this.radioSurfaceMaxalt2 = new JRadioButton(this.translate("label.surface.highmaxalt"));
        this.radioSurfaceMaxalt3 = new JRadioButton(this.translate("label.surface.nonemaxalt"));
        this.radioSurfaceMaxalt1.addActionListener(this);
        this.radioSurfaceMaxalt2.addActionListener(this);
        this.radioSurfaceMaxalt3.addActionListener(this);
        this.radioSurfaceMaxalt1.setEnabled(false);
        this.radioSurfaceMaxalt2.setEnabled(false);
        this.radioSurfaceMaxalt3.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioSurfaceMaxalt1);
        this.aButtonGroup.add(this.radioSurfaceMaxalt2);
        this.aButtonGroup.add(this.radioSurfaceMaxalt3);
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 2;
        this.labSurfaceMax = new JLabel(this.translate("label.surface.labmax"));
        this.labSurfaceMax.setEnabled(false);
        this.panelSurface.add((Component)this.labSurfaceMax, gridBagConstraints3);
        gridBagConstraints3.gridx = 3;
        gridBagConstraints3.gridy = 2;
        this.panelSurface.add((Component)this.radioSurfaceMaxalt1, gridBagConstraints3);
        gridBagConstraints3.gridx = 4;
        gridBagConstraints3.gridy = 2;
        this.panelSurface.add((Component)this.radioSurfaceMaxalt2, gridBagConstraints3);
        gridBagConstraints3.gridx = 5;
        gridBagConstraints3.gridy = 2;
        this.panelSurface.add((Component)this.radioSurfaceMaxalt3, gridBagConstraints3);
        this.radioSurfaceMinalt1 = new JRadioButton(this.translate("label.surface.lowminalt"), true);
        this.radioSurfaceMinalt2 = new JRadioButton(this.translate("label.surface.highminalt"));
        this.radioSurfaceMinalt3 = new JRadioButton(this.translate("label.surface.noneminalt"));
        this.radioSurfaceMinalt1.addActionListener(this);
        this.radioSurfaceMinalt2.addActionListener(this);
        this.radioSurfaceMinalt3.addActionListener(this);
        this.radioSurfaceMinalt1.setEnabled(false);
        this.radioSurfaceMinalt2.setEnabled(false);
        this.radioSurfaceMinalt3.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioSurfaceMinalt1);
        this.aButtonGroup.add(this.radioSurfaceMinalt2);
        this.aButtonGroup.add(this.radioSurfaceMinalt3);
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 3;
        this.labSurfaceMin = new JLabel(this.translate("label.surface.labmin"));
        this.labSurfaceMin.setEnabled(false);
        this.panelSurface.add((Component)this.labSurfaceMin, gridBagConstraints3);
        gridBagConstraints3.gridx = 3;
        gridBagConstraints3.gridy = 3;
        this.panelSurface.add((Component)this.radioSurfaceMinalt1, gridBagConstraints3);
        gridBagConstraints3.gridx = 4;
        gridBagConstraints3.gridy = 3;
        this.panelSurface.add((Component)this.radioSurfaceMinalt2, gridBagConstraints3);
        gridBagConstraints3.gridx = 5;
        gridBagConstraints3.gridy = 3;
        this.panelSurface.add((Component)this.radioSurfaceMinalt3, gridBagConstraints3);
        this.panelCloud = new JPanel();
        this.panelCloud.setPreferredSize(new Dimension(430, 430));
        this.panelCloud.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.anchor = 17;
        this.labEnableCloud = new JLabel(this.translate("label.cloud"));
        this.panelCloud.add((Component)this.labEnableCloud, gridBagConstraints4);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 0;
        this.cboxCloud = new JCheckBox();
        this.cboxCloud.addActionListener(this);
        this.panelCloud.add((Component)this.cboxCloud, gridBagConstraints4);
        this.radioCloudCategory1 = new JRadioButton(this.translate("label.cloud.alto"), true);
        this.radioCloudCategory2 = new JRadioButton(this.translate("label.cloud.cirrus"));
        this.radioCloudCategory1.addActionListener(this);
        this.radioCloudCategory2.addActionListener(this);
        this.radioCloudCategory1.setEnabled(false);
        this.radioCloudCategory2.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioCloudCategory1);
        this.aButtonGroup.add(this.radioCloudCategory2);
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 1;
        this.panelCloud.add((Component)this.radioCloudCategory1, gridBagConstraints4);
        gridBagConstraints4.gridx = 4;
        gridBagConstraints4.gridy = 1;
        this.panelCloud.add((Component)this.radioCloudCategory2, gridBagConstraints4);
        this.radioCloudColor1 = new JRadioButton(this.translate("label.cloud.white"), true);
        this.radioCloudColor2 = new JRadioButton(this.translate("label.cloud.gray"));
        this.radioCloudColor1.addActionListener(this);
        this.radioCloudColor2.addActionListener(this);
        this.radioCloudColor1.setEnabled(false);
        this.radioCloudColor2.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioCloudColor1);
        this.aButtonGroup.add(this.radioCloudColor2);
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 2;
        this.panelCloud.add((Component)this.radioCloudColor1, gridBagConstraints4);
        gridBagConstraints4.gridx = 4;
        gridBagConstraints4.gridy = 2;
        this.panelCloud.add((Component)this.radioCloudColor2, gridBagConstraints4);
        this.radioCloudAltitude1 = new JRadioButton(this.translate("label.cloud.lowalt"), true);
        this.radioCloudAltitude2 = new JRadioButton(this.translate("label.cloud.highalt"));
        this.radioCloudAltitude1.addActionListener(this);
        this.radioCloudAltitude2.addActionListener(this);
        this.radioCloudAltitude1.setEnabled(false);
        this.radioCloudAltitude2.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioCloudAltitude1);
        this.aButtonGroup.add(this.radioCloudAltitude2);
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 3;
        this.panelCloud.add((Component)this.radioCloudAltitude1, gridBagConstraints4);
        gridBagConstraints4.gridx = 4;
        gridBagConstraints4.gridy = 3;
        this.panelCloud.add((Component)this.radioCloudAltitude2, gridBagConstraints4);
        this.radioCloudDepth1 = new JRadioButton(this.translate("label.cloud.thin"), true);
        this.radioCloudDepth2 = new JRadioButton(this.translate("label.cloud.thick"));
        this.radioCloudDepth1.addActionListener(this);
        this.radioCloudDepth2.addActionListener(this);
        this.radioCloudDepth1.setEnabled(false);
        this.radioCloudDepth2.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioCloudDepth1);
        this.aButtonGroup.add(this.radioCloudDepth2);
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 4;
        this.panelCloud.add((Component)this.radioCloudDepth1, gridBagConstraints4);
        gridBagConstraints4.gridx = 4;
        gridBagConstraints4.gridy = 4;
        this.panelCloud.add((Component)this.radioCloudDepth2, gridBagConstraints4);
        this.radioCloudDensity1 = new JRadioButton(this.translate("label.cloud.lowdensity"), true);
        this.radioCloudDensity2 = new JRadioButton(this.translate("label.cloud.highdensity"));
        this.radioCloudDensity1.addActionListener(this);
        this.radioCloudDensity2.addActionListener(this);
        this.radioCloudDensity1.setEnabled(false);
        this.radioCloudDensity2.setEnabled(false);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioCloudDensity1);
        this.aButtonGroup.add(this.radioCloudDensity2);
        gridBagConstraints4.gridx = 3;
        gridBagConstraints4.gridy = 5;
        this.panelCloud.add((Component)this.radioCloudDensity1, gridBagConstraints4);
        gridBagConstraints4.gridx = 4;
        gridBagConstraints4.gridy = 5;
        this.panelCloud.add((Component)this.radioCloudDensity2, gridBagConstraints4);
        this.panelLight = new JPanel();
        this.panelLight.setPreferredSize(new Dimension(430, 430));
        this.panelLight.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.anchor = 17;
        this.radioLightHeading1 = new JRadioButton(this.translate("label.lighting.east"), true);
        this.radioLightHeading2 = new JRadioButton(this.translate("label.lighting.north"));
        this.radioLightHeading3 = new JRadioButton(this.translate("label.lighting.west"));
        this.radioLightHeading4 = new JRadioButton(this.translate("label.lighting.south"));
        this.radioLightHeading1.addActionListener(this);
        this.radioLightHeading2.addActionListener(this);
        this.radioLightHeading3.addActionListener(this);
        this.radioLightHeading4.addActionListener(this);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioLightHeading1);
        this.aButtonGroup.add(this.radioLightHeading2);
        this.aButtonGroup.add(this.radioLightHeading3);
        this.aButtonGroup.add(this.radioLightHeading4);
        gridBagConstraints5.gridx = 3;
        gridBagConstraints5.gridy = 1;
        this.labLightHeading = new JLabel(this.translate("label.lighting.lightheading"));
        this.panelLight.add((Component)this.labLightHeading, gridBagConstraints5);
        gridBagConstraints5.gridx = 4;
        gridBagConstraints5.gridy = 1;
        this.panelLight.add((Component)this.radioLightHeading1, gridBagConstraints5);
        gridBagConstraints5.gridx = 5;
        gridBagConstraints5.gridy = 1;
        this.panelLight.add((Component)this.radioLightHeading2, gridBagConstraints5);
        gridBagConstraints5.gridx = 6;
        gridBagConstraints5.gridy = 1;
        this.panelLight.add((Component)this.radioLightHeading3, gridBagConstraints5);
        gridBagConstraints5.gridx = 7;
        gridBagConstraints5.gridy = 1;
        this.panelLight.add((Component)this.radioLightHeading4, gridBagConstraints5);
        this.radioLightElevation1 = new JRadioButton(this.translate("label.lighting.low"), true);
        this.radioLightElevation2 = new JRadioButton(this.translate("label.lighting.medium"));
        this.radioLightElevation3 = new JRadioButton(this.translate("label.lighting.high"));
        this.radioLightElevation1.addActionListener(this);
        this.radioLightElevation2.addActionListener(this);
        this.radioLightElevation3.addActionListener(this);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioLightElevation1);
        this.aButtonGroup.add(this.radioLightElevation2);
        this.aButtonGroup.add(this.radioLightElevation3);
        gridBagConstraints5.gridx = 3;
        gridBagConstraints5.gridy = 2;
        this.labSunHeight = new JLabel(this.translate("label.lighting.sunheight"));
        this.panelLight.add((Component)this.labSunHeight, gridBagConstraints5);
        gridBagConstraints5.gridx = 4;
        gridBagConstraints5.gridy = 2;
        this.panelLight.add((Component)this.radioLightElevation1, gridBagConstraints5);
        gridBagConstraints5.gridx = 5;
        gridBagConstraints5.gridy = 2;
        this.panelLight.add((Component)this.radioLightElevation2, gridBagConstraints5);
        gridBagConstraints5.gridx = 6;
        gridBagConstraints5.gridy = 2;
        this.panelLight.add((Component)this.radioLightElevation3, gridBagConstraints5);
        this.panelCamera = new JPanel();
        this.panelCamera.setPreferredSize(new Dimension(400, 200));
        this.panelCamera.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints5.anchor = 17;
        this.radioCameraHeight1 = new JRadioButton(this.translate("label.camera.low"), true);
        this.radioCameraHeight2 = new JRadioButton(this.translate("label.camera.high"));
        this.radioCameraHeight1.addActionListener(this);
        this.radioCameraHeight2.addActionListener(this);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioCameraHeight1);
        this.aButtonGroup.add(this.radioCameraHeight2);
        gridBagConstraints6.gridx = 3;
        gridBagConstraints6.gridy = 1;
        this.labCamHeight = new JLabel(this.translate("label.camera.height"));
        this.panelCamera.add((Component)this.labCamHeight, gridBagConstraints6);
        gridBagConstraints6.gridx = 4;
        gridBagConstraints6.gridy = 1;
        this.panelCamera.add((Component)this.radioCameraHeight1, gridBagConstraints6);
        gridBagConstraints6.gridx = 5;
        gridBagConstraints6.gridy = 1;
        this.panelCamera.add((Component)this.radioCameraHeight2, gridBagConstraints6);
        this.radioCameraHeading1 = new JRadioButton(this.translate("label.camera.east"), true);
        this.radioCameraHeading2 = new JRadioButton(this.translate("label.camera.north"));
        this.radioCameraHeading3 = new JRadioButton(this.translate("label.camera.west"));
        this.radioCameraHeading4 = new JRadioButton(this.translate("label.camera.south"));
        this.radioCameraHeading1.addActionListener(this);
        this.radioCameraHeading2.addActionListener(this);
        this.radioCameraHeading3.addActionListener(this);
        this.radioCameraHeading4.addActionListener(this);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioCameraHeading1);
        this.aButtonGroup.add(this.radioCameraHeading2);
        this.aButtonGroup.add(this.radioCameraHeading3);
        this.aButtonGroup.add(this.radioCameraHeading4);
        gridBagConstraints6.gridx = 3;
        gridBagConstraints6.gridy = 2;
        this.labCamHeading = new JLabel(this.translate("label.camera.heading"));
        this.panelCamera.add((Component)this.labCamHeading, gridBagConstraints6);
        gridBagConstraints6.gridx = 4;
        gridBagConstraints6.gridy = 2;
        this.panelCamera.add((Component)this.radioCameraHeading1, gridBagConstraints6);
        gridBagConstraints6.gridx = 5;
        gridBagConstraints6.gridy = 2;
        this.panelCamera.add((Component)this.radioCameraHeading2, gridBagConstraints6);
        gridBagConstraints6.gridx = 6;
        gridBagConstraints6.gridy = 2;
        this.panelCamera.add((Component)this.radioCameraHeading3, gridBagConstraints6);
        gridBagConstraints6.gridx = 7;
        gridBagConstraints6.gridy = 2;
        this.panelCamera.add((Component)this.radioCameraHeading4, gridBagConstraints6);
        this.switchable = new JTabbedPane();
        this.switchable.setPreferredSize(new Dimension(430, 430));
        this.switchable.add(this.translate("tab.lake"), this.panelLake);
        this.switchable.add(this.translate("tab.mountain"), this.panelMountain);
        this.switchable.add(this.translate("tab.surface"), this.panelSurface);
        this.switchable.add(this.translate("tab.cloud"), this.panelCloud);
        this.switchable.add(this.translate("tab.lighting"), this.panelLight);
        this.switchable.add(this.translate("tab.camera"), this.panelCamera);
        container.add(this.switchable);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        this.checkOptions();
        this.storeSetting(this.tempSetting);
        this.checkSetting();
        if (actionEvent.getSource() == this.newFile) {
            if (Common.fileChanged) {
                if (this.checkSave(1)) {
                    Common.fileState = 0;
                    Common.fileCategory = 0;
                    Common.fileChanged = false;
                    this.resetAllSetting();
                    this.setTitle(this.translate("title.advancedmodenew"));
                }
            } else {
                Common.fileState = 0;
                Common.fileCategory = 0;
                Common.fileChanged = false;
                this.resetAllSetting();
                this.setTitle(this.translate("title.advancedmodenew"));
            }
        }
        if (actionEvent.getSource() == this.openFile) {
            int n;
            if (Common.fileChanged) {
                if (this.checkSave(2)) {
                    this.addFileChooser();
                    n = this.fileChooser.showOpenDialog(this);
                    if (n == 0) {
                        ++Common.openedFileNum;
                        Common.fileState = 1;
                        this.selectedFile = this.fileChooser.getSelectedFile();
                        this.setWindowTitle(this.selectedFile.getAbsolutePath());
                        object = Common.getFileExtension(this.selectedFile);
                        if (((String)object).equalsIgnoreCase("tgd")) {
                            Common.fileCategory = 1;
                            this.loadTGDDOM(this.selectedFile.getAbsolutePath());
                            this.loadTGDsetting();
                        } else {
                            Common.fileCategory = 0;
                            this.loadTGWDOM(this.selectedFile.getAbsolutePath());
                            this.loadTGWsetting();
                        }
                        this.storeSetting(this.loadedSetting);
                        Common.fileChanged = false;
                        this.changeRecentFilesDOM();
                        Common.writeXML(this.domSetting, this.settingsFullPath);
                    }
                }
            } else {
                this.addFileChooser();
                n = this.fileChooser.showOpenDialog(this);
                if (n == 0) {
                    ++Common.openedFileNum;
                    Common.fileState = 1;
                    this.selectedFile = this.fileChooser.getSelectedFile();
                    this.setWindowTitle(this.selectedFile.getAbsolutePath());
                    object = Common.getFileExtension(this.selectedFile);
                    if (((String)object).equalsIgnoreCase("tgd")) {
                        Common.fileCategory = 1;
                        this.loadTGDDOM(this.selectedFile.getAbsolutePath());
                        this.loadTGDsetting();
                    } else {
                        Common.fileCategory = 0;
                        this.loadTGWDOM(this.selectedFile.getAbsolutePath());
                        this.loadTGWsetting();
                    }
                    this.storeSetting(this.loadedSetting);
                    Common.fileChanged = false;
                    this.changeRecentFilesDOM();
                    Common.writeXML(this.domSetting, this.settingsFullPath);
                }
            }
        }
        if (actionEvent.getSource() == this.recentFile1 || actionEvent.getSource() == this.recentFile2 || actionEvent.getSource() == this.recentFile3 || actionEvent.getSource() == this.recentFile4) {
            if (Common.fileChanged) {
                if (this.checkSave(2)) {
                    Common.fileState = 1;
                    String string = ((AbstractButton)actionEvent.getSource()).getText();
                    object = Common.getFileExtension(string);
                    this.setWindowTitle(string);
                    this.addFileChooser();
                    this.fileChooser.setSelectedFile(new File(string));
                    this.selectedFile = new File(string);
                    if (((String)object).equalsIgnoreCase("tgd")) {
                        Common.fileCategory = 1;
                        this.loadTGDDOM(string);
                        this.loadTGDsetting();
                    } else if (((String)object).equalsIgnoreCase("tgw")) {
                        Common.fileCategory = 0;
                        this.loadTGWDOM(string);
                        this.loadTGWsetting();
                    }
                    this.storeSetting(this.loadedSetting);
                    Common.fileChanged = false;
                }
            } else {
                Common.fileState = 1;
                String string = ((AbstractButton)actionEvent.getSource()).getText();
                object = Common.getFileExtension(string);
                this.setWindowTitle(string);
                this.addFileChooser();
                this.fileChooser.setSelectedFile(new File(string));
                this.selectedFile = new File(string);
                if (((String)object).equalsIgnoreCase("tgd")) {
                    Common.fileCategory = 1;
                    this.loadTGDDOM(string);
                    this.loadTGDsetting();
                } else if (((String)object).equalsIgnoreCase("tgw")) {
                    Common.fileCategory = 0;
                    this.loadTGWDOM(string);
                    this.loadTGWsetting();
                }
                this.storeSetting(this.loadedSetting);
                Common.fileChanged = false;
            }
        }
        if (actionEvent.getSource() == this.save) {
            if (Common.fileState == 0) {
                this.saveAs.doClick();
            } else if (Common.fileState == 1) {
                if (Common.fileCategory == 1) {
                    this.changeTGDDOM();
                    if (Common.getFileExtension(this.selectedFile).equalsIgnoreCase("tgd")) {
                        this.warnSaveCompleted(this.domTGD, this.selectedFile, "none");
                    } else {
                        this.warnSaveCompleted(this.domTGD, this.selectedFile, "tgd");
                    }
                } else if (Common.fileCategory == 0) {
                    this.changeTGWDOM();
                    if (Common.getFileExtension(this.selectedFile).equalsIgnoreCase("tgw")) {
                        this.warnSaveCompleted(this.domTGW, this.selectedFile, "none");
                    } else {
                        this.warnSaveCompleted(this.domTGW, this.selectedFile, "tgw");
                    }
                } else if (this.fileChooser.getFileFilter().getDescription().equalsIgnoreCase("tgd")) {
                    Common.fileCategory = 1;
                    this.changeTGDDOM();
                    if (Common.getFileExtension(this.selectedFile).equalsIgnoreCase("tgd")) {
                        this.warnSaveCompleted(this.domTGD, this.selectedFile, "none");
                    } else {
                        this.warnSaveCompleted(this.domTGD, this.selectedFile, "tgd");
                    }
                } else if (this.fileChooser.getFileFilter().getDescription().equalsIgnoreCase("tgw")) {
                    Common.fileCategory = 0;
                    this.changeTGWDOM();
                    if (Common.getFileExtension(this.selectedFile).equalsIgnoreCase("tgw")) {
                        this.warnSaveCompleted(this.domTGW, this.selectedFile, "none");
                    } else {
                        this.warnSaveCompleted(this.domTGW, this.selectedFile, "tgw");
                    }
                }
            }
            Common.fileChanged = false;
            this.storeSetting(this.loadedSetting);
        }
        if (actionEvent.getSource() == this.saveAs) {
            this.addFileChooser();
            int n = this.fileChooser.showSaveDialog(this);
            if (n == 0) {
                Common.fileState = 1;
                this.selectedFile = this.fileChooser.getSelectedFile();
                ++Common.openedFileNum;
                object = Common.getFileExtension(this.selectedFile);
                if (((String)object).equalsIgnoreCase("tgd") || ((String)object).equalsIgnoreCase("tgw")) {
                    this.setWindowTitle(this.selectedFile.getAbsolutePath());
                } else {
                    object = this.fileChooser.getFileFilter().getDescription();
                    this.selectedFile = new File(this.selectedFile.getAbsolutePath() + "." + (String)object);
                    this.setWindowTitle(this.selectedFile.getAbsolutePath());
                }
                if (((String)object).equalsIgnoreCase("tgd")) {
                    Common.fileCategory = 1;
                    this.changeTGDDOM();
                    this.warnSaveCompleted(this.domTGD, this.selectedFile, "none");
                } else if (((String)object).equalsIgnoreCase("tgw")) {
                    Common.fileCategory = 0;
                    this.changeTGWDOM();
                    this.warnSaveCompleted(this.domTGW, this.selectedFile, "none");
                } else if (this.fileChooser.getFileFilter().getDescription().equalsIgnoreCase("tgd")) {
                    Common.fileCategory = 1;
                    this.changeTGDDOM();
                    this.warnSaveCompleted(this.domTGD, this.selectedFile, "tgd");
                } else if (this.fileChooser.getFileFilter().getDescription().equalsIgnoreCase("tgw")) {
                    Common.fileCategory = 0;
                    this.changeTGWDOM();
                    this.warnSaveCompleted(this.domTGW, this.selectedFile, "tgw");
                }
                Common.fileChanged = false;
                this.changeRecentFilesDOM();
                Common.writeXML(this.domSetting, this.settingsFullPath);
                this.storeSetting(this.loadedSetting);
            }
        }
        if (actionEvent.getSource() == this.reload && Common.fileChanged && this.checkSave(3)) {
            if (Common.fileState == 1) {
                this.selectedFile = this.fileChooser.getSelectedFile();
                String string = Common.getFileExtension(this.selectedFile);
                if (string.equalsIgnoreCase("tgd")) {
                    Common.fileCategory = 1;
                    this.loadTGDDOM(this.selectedFile.getAbsolutePath());
                    this.loadTGDsetting();
                    this.setWindowTitle(this.selectedFile.getAbsolutePath());
                } else if (string.equalsIgnoreCase("tgw")) {
                    Common.fileCategory = 0;
                    this.loadTGWDOM(this.selectedFile.getAbsolutePath());
                    this.loadTGWsetting();
                    this.setWindowTitle(this.selectedFile.getAbsolutePath());
                } else {
                    if (Common.fileCategory == 1) {
                        this.loadTGDDOM(this.selectedFile.getAbsolutePath() + ".tgd");
                        this.loadTGDsetting();
                        this.setWindowTitle(this.selectedFile.getAbsolutePath() + ".tgd");
                    }
                    if (Common.fileCategory == 0) {
                        this.loadTGWDOM(this.selectedFile.getAbsolutePath() + ".tgw");
                        this.loadTGWsetting();
                        this.setWindowTitle(this.selectedFile.getAbsolutePath() + ".tgw");
                    }
                }
                Common.fileChanged = false;
            } else {
                JOptionPane.showMessageDialog(this, this.translate("warn.reload.success"));
            }
        }
        if (actionEvent.getSource() == this.exit) {
            if (Common.fileChanged) {
                if (this.checkSave(0)) {
                    System.exit(0);
                }
            } else {
                System.exit(0);
            }
        }
        if (actionEvent.getSource() == this.helpContent) {
            JDialog jDialog = new JDialog(this, "Wizard Help", false);
            object = jDialog.getContentPane();
            try {
                URL uRL = this.getClass().getClassLoader().getResource("res/help.html");
                HTMLPane hTMLPane = new HTMLPane(uRL);
                hTMLPane.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(hTMLPane, 22, 31);
                jScrollPane.setPreferredSize(new Dimension(500, 500));
                ((Container)object).add(jScrollPane);
                jDialog.pack();
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension dimension2 = jDialog.getPreferredSize();
                int n = (int)((dimension.getWidth() - dimension2.getWidth()) / 2.0);
                int n2 = (int)((dimension.getHeight() - dimension2.getHeight()) / 2.0);
                jDialog.setLocation(n, n2);
                jDialog.setVisible(true);
                jDialog.setDefaultCloseOperation(2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (actionEvent.getSource() == this.preference) {
            new SettingWindow(this, this.rootSetting);
        }
        if (actionEvent.getSource() == this.about) {
            new AboutTerraWiz(this);
        }
        if (Common.fileChanged) {
            if (!this.getTitle().endsWith("*")) {
                this.setTitle(this.getTitle() + " *");
            }
            this.reload.setEnabled(true);
        } else {
            if (this.getTitle().endsWith("*")) {
                this.setTitle(this.getTitle().substring(0, this.getTitle().length() - 2));
            }
            this.reload.setEnabled(false);
        }
    }

    private void warnSaveCompleted(Document document, File file, String string) {
        if (string.equals("tgd") || string.equals("tgw")) {
            if (!Common.writeXML(document, file.getAbsolutePath() + "." + string)) {
                JOptionPane.showMessageDialog(this, this.translate("warn.savenotcomplete"));
            }
        } else if (string.equals("none") && !Common.writeXML(document, file.getAbsolutePath())) {
            JOptionPane.showMessageDialog(this, this.translate("warn.savenotcomplete"));
        }
    }

    private void addFileChooser() {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(new File(this.homeDirectory));
        this.fileChooser.setFileFilter(new FileNameExtensionFilter("tgd", "tgd"));
        this.fileChooser.setFileFilter(new FileNameExtensionFilter("tgw", "tgw"));
    }

    private void changeRecentFilesDOM() {
        NodeList nodeList = this.rootSetting.getElementsByTagName("File");
        if (nodeList.getLength() == 0 || nodeList.getLength() < 4) {
            this.file = this.domSetting.createElement("File");
            this.fileTextNode = this.domSetting.createTextNode(this.selectedFile.getAbsolutePath());
            this.file.appendChild(this.fileTextNode);
            this.recentFile.appendChild(this.file);
        } else {
            this.recentFile.removeChild(nodeList.item(0));
            this.file = this.domSetting.createElement("File");
            this.fileTextNode = this.domSetting.createTextNode(this.selectedFile.getAbsolutePath());
            this.file.appendChild(this.fileTextNode);
            this.recentFile.appendChild(this.file);
        }
        if (nodeList.getLength() != 0) {
            int n = Common.openedFileNum % 4;
            switch (n) {
                case 1: {
                    this.recentFile1.setText(this.selectedFile.getAbsolutePath());
                    this.recentFile1.setVisible(true);
                    break;
                }
                case 2: {
                    this.recentFile2.setText(this.selectedFile.getAbsolutePath());
                    this.recentFile2.setVisible(true);
                    break;
                }
                case 3: {
                    this.recentFile3.setText(this.selectedFile.getAbsolutePath());
                    this.recentFile3.setVisible(true);
                    break;
                }
                case 0: {
                    this.recentFile4.setText(this.selectedFile.getAbsolutePath());
                    this.recentFile4.setVisible(true);
                    break;
                }
            }
        }
    }

    private boolean checkSave(int n) {
        int n2 = 0;
        if (n == 1) {
            n2 = JOptionPane.showConfirmDialog(this, this.translate("warn.newfilewithoutsave"), this.translate("warn.warning"), 2);
        } else if (n == 0) {
            n2 = JOptionPane.showConfirmDialog(this, this.translate("warn.closefilewithoutsave"), this.translate("warn.warning"), 2);
        } else if (n == 2) {
            n2 = JOptionPane.showConfirmDialog(this, this.translate("warn.openfilewithoutsave"), this.translate("warn.warning"), 2);
        } else if (n == 3) {
            n2 = JOptionPane.showConfirmDialog(this, this.translate("warn.reloadfilewithoutsave"), this.translate("warn.warning"), 2);
        }
        return n2 == 0;
    }

    private void checkSetting() {
        for (int i = 0; i < this.tempSetting.length; ++i) {
            if (this.tempSetting[i][0] == 0 && this.loadedSetting[i][0] == 0) {
                Common.fileChanged = false;
                continue;
            }
            if (this.tempSetting[i][0] == 1 && this.loadedSetting[i][0] == 1) {
                for (int j = 1; j < this.tempSetting[i].length; ++j) {
                    if (this.tempSetting[i][j] != this.loadedSetting[i][j]) {
                        Common.fileChanged = true;
                        return;
                    }
                    Common.fileChanged = false;
                }
                continue;
            }
            Common.fileChanged = true;
            return;
        }
    }

    private void storeSetting(int[][] nArray) {
        if (this.cboxLake.isSelected()) {
            nArray[0][0] = 1;
            if (this.radioLakeDepth1.isSelected()) {
                nArray[0][1] = 0;
            } else if (this.radioLakeDepth2.isSelected()) {
                nArray[0][1] = 1;
            }
            if (this.radioLakeRadius1.isSelected()) {
                nArray[0][2] = 0;
            } else if (this.radioLakeRadius2.isSelected()) {
                nArray[0][2] = 1;
            }
            if (this.radioLakeRough1.isSelected()) {
                nArray[0][3] = 0;
            } else if (this.radioLakeRadius2.isSelected()) {
                nArray[0][3] = 1;
            }
            if (this.radioLakeWave1.isSelected()) {
                nArray[0][4] = 0;
            } else if (this.radioLakeWave2.isSelected()) {
                nArray[0][4] = 1;
            }
            if (this.radioLakeReflect1.isSelected()) {
                nArray[0][5] = 0;
            } else if (this.radioLakeReflect2.isSelected()) {
                nArray[0][5] = 1;
            }
        } else {
            nArray[0][0] = 0;
        }
        if (this.cboxMountain.isSelected()) {
            nArray[1][0] = 1;
            if (this.radioMountRough1.isSelected()) {
                nArray[1][1] = 0;
            } else if (this.radioMountRough2.isSelected()) {
                nArray[1][1] = 1;
            }
            if (this.radioMountFlat1.isSelected()) {
                nArray[1][2] = 0;
            } else if (this.radioMountFlat2.isSelected()) {
                nArray[1][2] = 1;
            }
        } else {
            nArray[1][0] = 0;
        }
        if (this.cboxSurface.isSelected()) {
            nArray[2][0] = 1;
            if (this.radioSurface1.isSelected()) {
                nArray[2][1] = 0;
            } else if (this.radioSurface2.isSelected()) {
                nArray[2][1] = 1;
            }
            if (this.radioSurfaceMaxalt1.isSelected()) {
                nArray[2][2] = 0;
            } else if (this.radioSurfaceMaxalt2.isSelected()) {
                nArray[2][2] = 1;
            } else if (this.radioSurfaceMaxalt3.isSelected()) {
                nArray[2][2] = 2;
            }
            if (this.radioSurfaceMinalt1.isSelected()) {
                nArray[2][3] = 0;
            } else if (this.radioSurfaceMinalt2.isSelected()) {
                nArray[2][3] = 1;
            } else if (this.radioSurfaceMinalt3.isSelected()) {
                nArray[2][3] = 2;
            }
        } else {
            nArray[2][0] = 0;
        }
        if (this.cboxCloud.isSelected()) {
            nArray[3][0] = 1;
            if (this.radioCloudCategory1.isSelected()) {
                nArray[3][1] = 0;
            } else if (this.radioCloudCategory2.isSelected()) {
                nArray[3][1] = 1;
            }
            if (this.radioCloudColor1.isSelected()) {
                nArray[3][2] = 0;
            } else if (this.radioCloudColor2.isSelected()) {
                nArray[3][2] = 1;
            }
            if (this.radioCloudAltitude1.isSelected()) {
                nArray[3][3] = 0;
            } else if (this.radioCloudAltitude2.isSelected()) {
                nArray[3][3] = 1;
            }
            if (this.radioCloudDepth1.isSelected()) {
                nArray[3][4] = 0;
            } else if (this.radioCloudDepth2.isSelected()) {
                nArray[3][4] = 1;
            }
            if (this.radioCloudDensity1.isSelected()) {
                nArray[3][5] = 0;
            } else if (this.radioCloudDensity2.isSelected()) {
                nArray[3][5] = 1;
            }
        } else {
            nArray[3][0] = 0;
        }
        nArray[4][0] = 1;
        nArray[5][0] = 1;
        if (this.radioLightHeading1.isSelected()) {
            nArray[4][1] = 0;
        } else if (this.radioLightHeading2.isSelected()) {
            nArray[4][1] = 1;
        } else if (this.radioLightHeading3.isSelected()) {
            nArray[4][1] = 2;
        } else if (this.radioLightHeading4.isSelected()) {
            nArray[4][1] = 3;
        }
        if (this.radioLightElevation1.isSelected()) {
            nArray[4][2] = 0;
        } else if (this.radioLightElevation2.isSelected()) {
            nArray[4][2] = 1;
        } else if (this.radioLightElevation3.isSelected()) {
            nArray[4][2] = 2;
        }
        if (this.radioCameraHeight1.isSelected()) {
            nArray[5][1] = 0;
        } else if (this.radioCameraHeight2.isSelected()) {
            nArray[5][1] = 1;
        }
        if (this.radioCameraHeading1.isSelected()) {
            nArray[5][2] = 0;
        } else if (this.radioCameraHeading2.isSelected()) {
            nArray[5][2] = 1;
        } else if (this.radioCameraHeading3.isSelected()) {
            nArray[5][2] = 2;
        } else if (this.radioCameraHeading4.isSelected()) {
            nArray[5][2] = 3;
        }
    }

    private void checkOptions() {
        if (Common.fileState == 1) {
            this.reload.setEnabled(true);
        } else {
            this.reload.setEnabled(false);
        }
        if (this.cboxLake.isSelected()) {
            this.enableLake(true);
        } else {
            this.enableLake(false);
        }
        if (this.cboxMountain.isSelected()) {
            this.enableMount(true);
        } else {
            this.enableMount(false);
        }
        if (this.cboxSurface.isSelected()) {
            this.enableSurface(true);
        } else {
            this.enableSurface(false);
        }
        if (this.cboxCloud.isSelected()) {
            this.enableCloud(true);
        } else {
            this.enableCloud(false);
        }
    }

    private void changeTGDDOM() {
        if (this.cboxLake.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGD, "lake") == 0) {
                Common.enableTGDLakeNodes(this.rootTGD, this.domTGD, this.lakeTGD, this.waterShader);
            }
            if (this.radioLakeDepth1.isSelected()) {
                Common.changeAttr(this.rootTGD, "lake", "water_level", 10, 0);
                Common.changeAttr(this.rootTGD, "lake", "centre", "0 10 0", 0);
            } else if (this.radioLakeDepth2.isSelected()) {
                Common.changeAttr(this.rootTGD, "lake", "water_level", 300, 0);
                Common.changeAttr(this.rootTGD, "lake", "centre", "0 300 0", 0);
            }
            if (this.radioLakeRadius1.isSelected()) {
                Common.changeAttr(this.rootTGD, "lake", "max_radius", 50000, 0);
            } else if (this.radioLakeRadius2.isSelected()) {
                Common.changeAttr(this.rootTGD, "lake", "max_radius", 100000, 0);
            }
            if (this.radioLakeRough1.isSelected()) {
                Common.changeAttr(this.rootTGD, "water_shader", "roughness", 0.02, 0);
            } else if (this.radioLakeRough2.isSelected()) {
                Common.changeAttr(this.rootTGD, "water_shader", "roughness", 0.3, 0);
            }
            if (this.radioLakeWave1.isSelected()) {
                Common.changeAttr(this.rootTGD, "water_shader", "wave_scale", 5, 0);
            } else if (this.radioLakeWave2.isSelected()) {
                Common.changeAttr(this.rootTGD, "water_shader", "wave_scale", 80, 0);
            }
            if (this.radioLakeReflect1.isSelected()) {
                Common.changeAttr(this.rootTGD, "water_shader", "master_reflectivity", 0.05, 0);
            } else if (this.radioLakeReflect2.isSelected()) {
                Common.changeAttr(this.rootTGD, "water_shader", "master_reflectivity", 0.8, 0);
            }
        } else {
            Common.disableTGDLakeNodes(this.rootTGD);
        }
        boolean bl = false;
        if (this.cboxMountain.isSelected()) {
            NodeList nodeList = this.rootTGD.getElementsByTagName("power_fractal_shader_v3");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    Node node = namedNodeMap.item(j);
                    if (!node.getNodeName().equals("gui_group") || !node.getNodeValue().equals("Terrain")) continue;
                    bl = true;
                }
            }
            if (!bl) {
                Common.enableTGDMountNodes(this.rootTGD, this.domTGD, this.fractalShader);
                Common.changeAttr(this.rootTGD, "compute_terrain", "input_node", "Fractal terrain 01", 0);
            }
            if (this.radioMountRough1.isSelected()) {
                Common.changeAttr(this.rootTGD, "power_fractal_shader_v3", "feature_scale", 20000, 1);
            } else if (this.radioMountRough2.isSelected()) {
                Common.changeAttr(this.rootTGD, "power_fractal_shader_v3", "feature_scale", 1000, 1);
            }
            if (this.radioMountFlat1.isSelected()) {
                Common.changeAttr(this.rootTGD, "power_fractal_shader_v3", "smallest_scale", 0.002, 1);
            } else if (this.radioMountFlat2.isSelected()) {
                Common.changeAttr(this.rootTGD, "power_fractal_shader_v3", "smallest_scale", 0.2, 1);
            }
        } else {
            Common.disableTGDMountNodes(this.rootTGD);
        }
        if (this.cboxSurface.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGD, "surface_layer") == 0) {
                Common.enableTGDSurfaceNodes(this.rootTGD, this.domTGD, this.surfaceLayer, this.surfaceShader, this.cboxMountain);
            }
            Common.changeAttr(this.rootTGD, "planet", "surface_shader", "Surface layer 01", 0);
            if (this.radioSurface1.isSelected()) {
                Common.changeAttr(this.rootTGD, "surface_layer", "diffuse_colour", "1 1 1", 0);
            } else if (this.radioSurface2.isSelected()) {
                Common.changeAttr(this.rootTGD, "surface_layer", "diffuse_colour", "0.0236995 0.18125 0.00057709", 0);
            }
            if (this.radioSurfaceMaxalt1.isSelected()) {
                Common.changeAttr(this.rootTGD, "surface_layer", "limit_maximum_altitude", "1", 0);
                Common.changeAttr(this.rootTGD, "surface_layer", "maximum_altitude", 800, 0);
            } else if (this.radioSurfaceMaxalt2.isSelected()) {
                Common.changeAttr(this.rootTGD, "surface_layer", "limit_maximum_altitude", "1", 0);
                Common.changeAttr(this.rootTGD, "surface_layer", "maximum_altitude", 1000, 0);
            } else if (this.radioSurfaceMaxalt3.isSelected()) {
                Common.changeAttr(this.rootTGD, "surface_layer", "limit_maximum_altitude", "0", 0);
            }
            if (this.radioSurfaceMinalt1.isSelected()) {
                Common.changeAttr(this.rootTGD, "surface_layer", "limit_minimum_altitude", "1", 0);
                Common.changeAttr(this.rootTGD, "surface_layer", "minimum_altitude", 100, 0);
            } else if (this.radioSurfaceMinalt2.isSelected()) {
                Common.changeAttr(this.rootTGD, "surface_layer", "limit_minimum_altitude", "1", 0);
                Common.changeAttr(this.rootTGD, "surface_layer", "minimum_altitude", 400, 0);
            } else if (this.radioSurfaceMinalt3.isSelected()) {
                Common.changeAttr(this.rootTGD, "surface_layer", "limit_minimum_altitude", "0", 0);
            }
        } else {
            Common.disableTGDSurfaceNodes(this.rootTGD);
        }
        if (this.cboxCloud.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGD, "cloud_layer_v2") == 0) {
                Common.enableTGDCloudNodes(this.rootTGD, this.domTGD, this.cloudLayer, this.cloudShader);
            }
            if (this.radioCloudCategory1.isSelected()) {
                Common.changeAttr(this.rootTGD, "planet", "atmosphere_shader", "Altocumulus layer 01", 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "name", "Altocumulus layer 01", 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "rendering_method", 1, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "quality", 0.289898, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "number_of_samples", 6, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "feature_scale", 150, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "lead-in_scale", 20000, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "noise_octaves", 13, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "roughness", 1.75, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "variation_method", 2, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "lead-in_warp_amount", 0.5, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "less_warp_at_feature_scale", 1, 0);
            } else if (this.radioCloudCategory2.isSelected()) {
                Common.changeAttr(this.rootTGD, "planet", "atmosphere_shader", "Cirrus layer 01", 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "name", "Cirrus layer 01", 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "rendering_method", 0, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "quality", 0.510478, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "number_of_samples", 5, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "feature_scale", 20000, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "lead-in_scale", 50000, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "noise_octaves", 14, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "roughness", 1.5, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "variation_method", 1, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "lead-in_warp_amount", 1.0, 0);
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "less_warp_at_feature_scale", 0, 0);
            }
            if (this.radioCloudCategory2.isSelected()) {
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "cloud_colour", "1 1 1", 0);
            } else if (this.radioCloudColor2.isSelected()) {
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "cloud_colour", "0.2 0.2 0.2", 0);
            }
            if (this.radioCloudAltitude1.isSelected()) {
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "cloud_altitude", 2000, 0);
            } else if (this.radioCloudAltitude2.isSelected()) {
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "cloud_altitude", 5000, 0);
            }
            if (this.radioCloudDensity1.isSelected()) {
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "cloud_density", 0.01, 0);
            } else if (this.radioCloudDensity2.isSelected()) {
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "cloud_density", 0.07, 0);
            }
            if (this.radioCloudDepth1.isSelected()) {
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "cloud_depth", 100, 0);
            } else if (this.radioCloudDepth2.isSelected()) {
                Common.changeAttr(this.rootTGD, "cloud_layer_v2", "cloud_depth", 200, 0);
            }
        } else {
            Common.disableTGDCloudNodes(this.rootTGD);
        }
        if (this.radioLightHeading1.isSelected()) {
            Common.changeAttr(this.rootTGD, "sunlight", "heading", 90, 0);
        } else if (this.radioLightHeading2.isSelected()) {
            Common.changeAttr(this.rootTGD, "sunlight", "heading", 180, 0);
        } else if (this.radioLightHeading3.isSelected()) {
            Common.changeAttr(this.rootTGD, "sunlight", "heading", 270, 0);
        } else if (this.radioLightHeading4.isSelected()) {
            Common.changeAttr(this.rootTGD, "sunlight", "heading", 360, 0);
        }
        if (this.radioLightElevation1.isSelected()) {
            Common.changeAttr(this.rootTGD, "sunlight", "elevation", 10, 0);
        } else if (this.radioLightElevation2.isSelected()) {
            Common.changeAttr(this.rootTGD, "sunlight", "elevation", 50, 0);
        } else if (this.radioLightElevation3.isSelected()) {
            Common.changeAttr(this.rootTGD, "sunlight", "elevation", 90, 0);
        }
        if (this.radioCameraHeight1.isSelected()) {
            Common.changeAttr(this.rootTGD, "camera", "position", "0 1000 -1300", 0);
        } else if (this.radioCameraHeight2.isSelected()) {
            Common.changeAttr(this.rootTGD, "camera", "position", "0 5000 -1300", 0);
        }
        if (this.radioCameraHeading1.isSelected()) {
            Common.changeAttr(this.rootTGD, "camera", "rotation", "-20 90 0", 0);
        } else if (this.radioCameraHeading2.isSelected()) {
            Common.changeAttr(this.rootTGD, "camera", "rotation", "-20 180 0", 0);
        } else if (this.radioCameraHeading3.isSelected()) {
            Common.changeAttr(this.rootTGD, "camera", "rotation", "-20 270 0", 0);
        } else if (this.radioCameraHeading4.isSelected()) {
            Common.changeAttr(this.rootTGD, "camera", "rotation", "-20 360 0", 0);
        }
    }

    private void changeTGWDOM() {
        if (this.cboxLake.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGW, "lake") == 0) {
                Common.enableTGWLakeNodes(this.rootTGW, this.domTGW, this.lakeTGW);
            }
            if (this.radioLakeDepth1.isSelected()) {
                Common.changeAttr(this.rootTGW, "lake", "water_level", "shallow", 0);
            } else if (this.radioLakeDepth2.isSelected()) {
                Common.changeAttr(this.rootTGW, "lake", "water_level", "deep", 0);
            }
            if (this.radioLakeRadius1.isSelected()) {
                Common.changeAttr(this.rootTGW, "lake", "max_radius", "narrow", 0);
            } else if (this.radioLakeRadius2.isSelected()) {
                Common.changeAttr(this.rootTGW, "lake", "max_radius", "broad", 0);
            }
            if (this.radioLakeRough1.isSelected()) {
                Common.changeAttr(this.rootTGW, "lake", "roughness", "smooth", 0);
            } else if (this.radioLakeRough2.isSelected()) {
                Common.changeAttr(this.rootTGW, "lake", "roughness", "rough", 0);
            }
            if (this.radioLakeWave1.isSelected()) {
                Common.changeAttr(this.rootTGW, "lake", "wave_scale", "small", 0);
            } else if (this.radioLakeWave2.isSelected()) {
                Common.changeAttr(this.rootTGW, "lake", "wave_scale", "big", 0);
            }
            if (this.radioLakeReflect1.isSelected()) {
                Common.changeAttr(this.rootTGW, "lake", "reflectivity", "low", 0);
            } else if (this.radioLakeReflect2.isSelected()) {
                Common.changeAttr(this.rootTGW, "lake", "reflectivity", "high", 0);
            }
        } else {
            Common.disableTGWLakeNodes(this.rootTGW);
        }
        if (this.cboxMountain.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGW, "mountain") == 0) {
                Common.enableTGWMountNodes(this.rootTGW, this.domTGW, this.mountain);
            }
            if (this.radioMountRough1.isSelected()) {
                Common.changeAttr(this.rootTGW, "mountain", "feature_scale", "smooth", 0);
            } else if (this.radioMountRough2.isSelected()) {
                Common.changeAttr(this.rootTGW, "mountain", "feature_scale", "rough", 0);
            }
            if (this.radioMountFlat1.isSelected()) {
                Common.changeAttr(this.rootTGW, "mountain", "flat", "flat", 0);
            } else if (this.radioMountFlat2.isSelected()) {
                Common.changeAttr(this.rootTGW, "mountain", "flat", "bumpy", 0);
            }
        } else {
            Common.disableTGWMountNodes(this.rootTGW);
        }
        if (this.cboxSurface.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGW, "surface") == 0) {
                Common.enableTGWSurfaceNodes(this.rootTGW, this.domTGW, this.surface);
            }
            if (this.radioSurface1.isSelected()) {
                Common.changeAttr(this.rootTGW, "surface", "skin", "snow", 0);
            } else if (this.radioSurface2.isSelected()) {
                Common.changeAttr(this.rootTGW, "surface", "skin", "grass", 0);
            }
            if (this.radioSurfaceMaxalt1.isSelected()) {
                Common.changeAttr(this.rootTGW, "surface", "maxAlt", "low", 0);
            } else if (this.radioSurfaceMaxalt2.isSelected()) {
                Common.changeAttr(this.rootTGW, "surface", "maxAlt", "high", 0);
            } else if (this.radioSurfaceMaxalt3.isSelected()) {
                Common.changeAttr(this.rootTGW, "surface", "maxAlt", "none", 0);
            }
            if (this.radioSurfaceMinalt1.isSelected()) {
                Common.changeAttr(this.rootTGW, "surface", "minAlt", "low", 0);
            } else if (this.radioSurfaceMinalt2.isSelected()) {
                Common.changeAttr(this.rootTGW, "surface", "minAlt", "high", 0);
            } else if (this.radioSurfaceMinalt3.isSelected()) {
                Common.changeAttr(this.rootTGW, "surface", "minAlt", "none", 0);
            }
        } else {
            Common.disableTGWSurfaceNodes(this.rootTGW);
        }
        if (this.cboxCloud.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGW, "cloud") == 0) {
                Common.enableTGWCloudNodes(this.rootTGW, this.domTGW, this.cloud);
            }
            if (this.radioCloudCategory1.isSelected()) {
                Common.changeAttr(this.rootTGW, "cloud", "category", "Altocumulus", 0);
            } else if (this.radioCloudCategory2.isSelected()) {
                Common.changeAttr(this.rootTGW, "cloud", "category", "Cirrus", 0);
            }
            if (this.radioCloudColor1.isSelected()) {
                Common.changeAttr(this.rootTGW, "cloud", "colour", "white", 0);
            } else if (this.radioCloudColor2.isSelected()) {
                Common.changeAttr(this.rootTGW, "cloud", "colour", "gray", 0);
            }
            if (this.radioCloudAltitude1.isSelected()) {
                Common.changeAttr(this.rootTGW, "cloud", "altitude", "low", 0);
            } else if (this.radioCloudAltitude2.isSelected()) {
                Common.changeAttr(this.rootTGW, "cloud", "altitude", "high", 0);
            }
            if (this.radioCloudDepth1.isSelected()) {
                Common.changeAttr(this.rootTGW, "cloud", "depth", "thin", 0);
            } else if (this.radioCloudDepth2.isSelected()) {
                Common.changeAttr(this.rootTGW, "cloud", "depth", "thick", 0);
            }
            if (this.radioCloudDensity1.isSelected()) {
                Common.changeAttr(this.rootTGW, "cloud", "density", "low", 0);
            } else if (this.radioCloudDensity2.isSelected()) {
                Common.changeAttr(this.rootTGW, "cloud", "density", "high", 0);
            }
        } else {
            Common.disableTGWCloudNodes(this.rootTGW);
        }
        if (this.radioLightHeading1.isSelected()) {
            Common.changeAttr(this.rootTGW, "lighting", "heading", "East", 0);
        } else if (this.radioLightHeading2.isSelected()) {
            Common.changeAttr(this.rootTGW, "lighting", "heading", "North", 0);
        } else if (this.radioLightHeading3.isSelected()) {
            Common.changeAttr(this.rootTGW, "lighting", "heading", "West", 0);
        } else if (this.radioLightHeading4.isSelected()) {
            Common.changeAttr(this.rootTGW, "lighting", "heading", "South", 0);
        }
        if (this.radioLightElevation1.isSelected()) {
            Common.changeAttr(this.rootTGW, "lighting", "elevation", "Low", 0);
        } else if (this.radioLightElevation2.isSelected()) {
            Common.changeAttr(this.rootTGW, "lighting", "elevation", "Medium", 0);
        } else if (this.radioLightElevation3.isSelected()) {
            Common.changeAttr(this.rootTGW, "lighting", "elevation", "High", 0);
        }
        if (this.radioCameraHeight1.isSelected()) {
            Common.changeAttr(this.rootTGW, "camera", "height", "Low", 0);
        } else if (this.radioCameraHeight2.isSelected()) {
            Common.changeAttr(this.rootTGW, "camera", "height", "High", 0);
        }
        if (this.radioCameraHeading1.isSelected()) {
            Common.changeAttr(this.rootTGW, "camera", "heading", "East", 0);
        } else if (this.radioCameraHeading2.isSelected()) {
            Common.changeAttr(this.rootTGW, "camera", "heading", "North", 0);
        } else if (this.radioCameraHeading3.isSelected()) {
            Common.changeAttr(this.rootTGW, "camera", "heading", "West", 0);
        } else if (this.radioCameraHeading4.isSelected()) {
            Common.changeAttr(this.rootTGW, "camera", "heading", "South", 0);
        }
    }

    private void loadTGDsetting() {
        Object object;
        int n;
        Object object2;
        int n2;
        if (Common.checkNodeExistNum(this.rootTGD, "lake") > 0) {
            this.cboxLake.setSelected(true);
            this.checkOptions();
            if (Integer.parseInt(Common.getValue(this.rootTGD, "lake", "water_level", 0)) <= 10) {
                this.radioLakeDepth1.setSelected(true);
            } else {
                this.radioLakeDepth2.setSelected(true);
            }
            if (Integer.parseInt(Common.getValue(this.rootTGD, "lake", "max_radius", 0)) <= 50000) {
                this.radioLakeRadius1.setSelected(true);
            } else {
                this.radioLakeRadius2.setSelected(true);
            }
            if (Double.parseDouble(Common.getValue(this.rootTGD, "water_shader", "roughness", 0)) <= 0.02) {
                this.radioLakeRough1.setSelected(true);
            } else {
                this.radioLakeRough2.setSelected(true);
            }
            if (Integer.parseInt(Common.getValue(this.rootTGD, "water_shader", "wave_scale", 0)) <= 5) {
                this.radioLakeWave1.setSelected(true);
            } else {
                this.radioLakeWave2.setSelected(true);
            }
            if (Double.parseDouble(Common.getValue(this.rootTGD, "water_shader", "master_reflectivity", 0)) <= 0.05) {
                this.radioLakeReflect1.setSelected(true);
            } else {
                this.radioLakeReflect2.setSelected(true);
            }
        } else {
            this.cboxLake.setSelected(false);
            this.checkOptions();
        }
        int n3 = 0;
        NodeList nodeList = this.rootTGD.getElementsByTagName("power_fractal_shader_v3");
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            object2 = nodeList.item(n2).getAttributes();
            for (n = 0; n < object2.getLength(); ++n) {
                object = object2.item(n);
                if (!object.getNodeName().equals("gui_group") || !object.getNodeValue().equals("Terrain")) continue;
                ++n3;
            }
        }
        if (n3 == 1) {
            this.cboxMountain.setSelected(true);
            this.checkOptions();
            if (Integer.parseInt(Common.getValue(this.rootTGD, "power_fractal_shader_v3", "feature_scale", 1)) <= 1000) {
                this.radioMountRough2.setSelected(true);
            } else {
                this.radioMountRough1.setSelected(true);
            }
            if (Double.parseDouble(Common.getValue(this.rootTGD, "power_fractal_shader_v3", "smallest_scale", 1)) <= 0.002) {
                this.radioMountFlat1.setSelected(true);
            } else {
                this.radioMountFlat2.setSelected(true);
            }
        } else {
            this.cboxMountain.setSelected(false);
            this.checkOptions();
        }
        n2 = 0;
        object2 = this.rootTGD.getElementsByTagName("power_fractal_shader_v3");
        for (n = 0; n < object2.getLength(); ++n) {
            object = object2.item(n).getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (!node.getNodeName().equals("gui_group") || !node.getNodeValue().equals("Shaders")) continue;
                ++n2;
            }
        }
        if (n2 == 2) {
            this.cboxSurface.setSelected(true);
            this.checkOptions();
            if (Common.getValue(this.rootTGD, "surface_layer", "diffuse_colour", 0).equals("1 1 1")) {
                this.radioSurface1.setSelected(true);
            } else if (Common.getValue(this.rootTGD, "surface_layer", "diffuse_colour", 0).equals("0.0236995 0.18125 0.00057709")) {
                this.radioSurface2.setSelected(true);
            }
            if (Common.getValue(this.rootTGD, "surface_layer", "limit_maximum_altitude", 0).equals("0")) {
                this.radioSurfaceMaxalt3.setSelected(true);
            } else if (Integer.parseInt(Common.getValue(this.rootTGD, "surface_layer", "maximum_altitude", 0)) <= 800) {
                this.radioSurfaceMaxalt1.setSelected(true);
            } else {
                this.radioSurfaceMaxalt2.setSelected(true);
            }
            if (Common.getValue(this.rootTGD, "surface_layer", "limit_minimum_altitude", 0).equals("0")) {
                this.radioSurfaceMinalt3.setSelected(true);
            } else if (Integer.parseInt(Common.getValue(this.rootTGD, "surface_layer", "minimum_altitude", 0)) <= 100) {
                this.radioSurfaceMinalt1.setSelected(true);
            } else {
                this.radioSurfaceMinalt2.setSelected(true);
            }
        } else {
            this.cboxSurface.setSelected(false);
            this.checkOptions();
        }
        if (Common.checkNodeExistNum(this.rootTGD, "cloud_layer_v2") > 0) {
            this.cboxCloud.setSelected(true);
            this.checkOptions();
            if (Common.getValue(this.rootTGD, "cloud_layer_v2", "name", 0).equals("Altocumulus layer 01")) {
                this.radioCloudCategory1.setSelected(true);
            } else if (Common.getValue(this.rootTGD, "cloud_layer_v2", "name", 0).equals("Cirrus layer 01")) {
                this.radioCloudCategory2.setSelected(true);
            }
            if (Common.getValue(this.rootTGD, "cloud_layer_v2", "cloud_colour", 0).equals("1 1 1")) {
                this.radioCloudColor1.setSelected(true);
            } else if (Common.getValue(this.rootTGD, "cloud_layer_v2", "cloud_colour", 0).equals("0.2 0.2 0.2")) {
                this.radioCloudColor2.setSelected(true);
            }
            if (Integer.parseInt(Common.getValue(this.rootTGD, "cloud_layer_v2", "cloud_altitude", 0)) <= 2000) {
                this.radioCloudAltitude1.setSelected(true);
            } else {
                this.radioCloudAltitude2.setSelected(true);
            }
            if (Double.parseDouble(Common.getValue(this.rootTGD, "cloud_layer_v2", "cloud_density", 0)) <= 0.01) {
                this.radioCloudDensity1.setSelected(true);
            } else {
                this.radioCloudDensity2.setSelected(true);
            }
            if (Integer.parseInt(Common.getValue(this.rootTGD, "cloud_layer_v2", "cloud_depth", 0)) <= 100) {
                this.radioCloudDepth1.setSelected(true);
            } else {
                this.radioCloudDepth2.setSelected(true);
            }
        } else {
            this.cboxCloud.setSelected(false);
            this.checkOptions();
        }
        n = Integer.parseInt(Common.getValue(this.rootTGD, "sunlight", "heading", 0));
        if (n <= 90) {
            this.radioLightHeading1.setSelected(true);
        } else if (n > 90 && n <= 180) {
            this.radioLightHeading2.setSelected(true);
        } else if (n > 180 && n <= 270) {
            this.radioLightHeading3.setSelected(true);
        } else if (n > 270) {
            this.radioLightHeading4.setSelected(true);
        }
        int n4 = Integer.parseInt(Common.getValue(this.rootTGD, "sunlight", "elevation", 0));
        if (n4 <= 10) {
            this.radioLightElevation1.setSelected(true);
        } else if (n4 > 10 && n4 <= 50) {
            this.radioLightElevation2.setSelected(true);
        } else if (n4 > 50 && n4 <= 90) {
            this.radioLightElevation3.setSelected(true);
        }
        if (Common.getValue(this.rootTGD, "camera", "position", 0).equals("0 1000 -1300")) {
            this.radioCameraHeight1.setSelected(true);
        } else if (Common.getValue(this.rootTGD, "camera", "position", 0).equals("0 5000 -1300")) {
            this.radioCameraHeight2.setSelected(true);
        }
        if (Common.getValue(this.rootTGD, "camera", "rotation", 0).equals("-20 90 0")) {
            this.radioCameraHeading1.setSelected(true);
        } else if (Common.getValue(this.rootTGD, "camera", "rotation", 0).equals("-20 180 0")) {
            this.radioCameraHeading2.setSelected(true);
        } else if (Common.getValue(this.rootTGD, "camera", "rotation", 0).equals("-20 270 0")) {
            this.radioCameraHeading3.setSelected(true);
        } else if (Common.getValue(this.rootTGD, "camera", "rotation", 0).equals("-20 360 0")) {
            this.radioCameraHeading4.setSelected(true);
        }
    }

    private void loadTGWsetting() {
        if (Common.checkNodeExistNum(this.rootTGW, "lake") > 0) {
            this.cboxLake.setSelected(true);
            this.checkOptions();
            if (Common.getValue(this.rootTGW, "lake", "water_level", 0).equalsIgnoreCase("shallow")) {
                this.radioLakeDepth1.setSelected(true);
            } else {
                this.radioLakeDepth2.setSelected(true);
            }
            if (Common.getValue(this.rootTGW, "lake", "max_radius", 0).equalsIgnoreCase("narrow")) {
                this.radioLakeRadius1.setSelected(true);
            } else {
                this.radioLakeRadius2.setSelected(true);
            }
            if (Common.getValue(this.rootTGW, "lake", "roughness", 0).equalsIgnoreCase("smooth")) {
                this.radioLakeRough1.setSelected(true);
            } else {
                this.radioLakeRough2.setSelected(true);
            }
            if (Common.getValue(this.rootTGW, "lake", "wave_scale", 0).equalsIgnoreCase("small")) {
                this.radioLakeWave1.setSelected(true);
            } else {
                this.radioLakeWave2.setSelected(true);
            }
            if (Common.getValue(this.rootTGW, "lake", "reflectivity", 0).equalsIgnoreCase("low")) {
                this.radioLakeReflect1.setSelected(true);
            } else {
                this.radioLakeReflect2.setSelected(true);
            }
        } else {
            this.cboxLake.setSelected(false);
            this.checkOptions();
        }
        if (Common.checkNodeExistNum(this.rootTGW, "mountain") > 0) {
            this.cboxMountain.setSelected(true);
            this.checkOptions();
            if (Common.getValue(this.rootTGW, "mountain", "feature_scale", 0).equalsIgnoreCase("smooth")) {
                this.radioMountRough1.setSelected(true);
            } else {
                this.radioMountRough2.setSelected(true);
            }
            if (Common.getValue(this.rootTGW, "mountain", "flat", 0).equalsIgnoreCase("flat")) {
                this.radioMountFlat1.setSelected(true);
            } else {
                this.radioMountFlat2.setSelected(true);
            }
        } else {
            this.cboxMountain.setSelected(false);
            this.checkOptions();
        }
        if (Common.checkNodeExistNum(this.rootTGW, "surface") > 0) {
            this.cboxSurface.setSelected(true);
            this.checkOptions();
            if (Common.getValue(this.rootTGW, "surface", "skin", 0).equalsIgnoreCase("snow")) {
                this.radioSurface1.setSelected(true);
            } else {
                this.radioSurface2.setSelected(true);
            }
            if (Common.getValue(this.rootTGW, "surface", "maxAlt", 0).equalsIgnoreCase("low")) {
                this.radioSurfaceMaxalt1.setSelected(true);
            } else if (Common.getValue(this.rootTGW, "surface", "maxAlt", 0).equalsIgnoreCase("high")) {
                this.radioSurfaceMaxalt2.setSelected(true);
            } else if (Common.getValue(this.rootTGW, "surface", "maxAlt", 0).equalsIgnoreCase("none")) {
                this.radioSurfaceMaxalt3.setSelected(true);
            }
            if (Common.getValue(this.rootTGW, "surface", "minAlt", 0).equalsIgnoreCase("low")) {
                this.radioSurfaceMinalt1.setSelected(true);
            } else if (Common.getValue(this.rootTGW, "surface", "minAlt", 0).equalsIgnoreCase("high")) {
                this.radioSurfaceMinalt2.setSelected(true);
            } else if (Common.getValue(this.rootTGW, "surface", "minAlt", 0).equalsIgnoreCase("none")) {
                this.radioSurfaceMinalt3.setSelected(true);
            }
        } else {
            this.cboxSurface.setSelected(false);
            this.checkOptions();
        }
        if (Common.checkNodeExistNum(this.rootTGW, "cloud") > 0) {
            this.cboxCloud.setSelected(true);
            this.checkOptions();
            if (Common.getValue(this.rootTGW, "cloud", "category", 0).equalsIgnoreCase("Altocumulus")) {
                this.radioCloudCategory1.setSelected(true);
            } else {
                this.radioCloudCategory2.setSelected(true);
            }
            if (Common.getValue(this.rootTGW, "cloud", "colour", 0).equalsIgnoreCase("white")) {
                this.radioCloudColor1.setSelected(true);
            } else {
                this.radioCloudColor2.setSelected(true);
            }
            if (Common.getValue(this.rootTGW, "cloud", "altitude", 0).equalsIgnoreCase("low")) {
                this.radioCloudAltitude1.setSelected(true);
            } else {
                this.radioCloudAltitude2.setSelected(true);
            }
            if (Common.getValue(this.rootTGW, "cloud", "depth", 0).equalsIgnoreCase("thin")) {
                this.radioCloudDepth1.setSelected(true);
            } else {
                this.radioCloudDepth2.setSelected(true);
            }
            if (Common.getValue(this.rootTGW, "cloud", "density", 0).equalsIgnoreCase("low")) {
                this.radioCloudDensity1.setSelected(true);
            } else {
                this.radioCloudDensity2.setSelected(true);
            }
        } else {
            this.cboxCloud.setSelected(false);
            this.checkOptions();
        }
        String string = Common.getValue(this.rootTGW, "lighting", "heading", 0);
        if (string.equalsIgnoreCase("East")) {
            this.radioLightHeading1.setSelected(true);
        } else if (string.equalsIgnoreCase("North")) {
            this.radioLightHeading2.setSelected(true);
        } else if (string.equalsIgnoreCase("West")) {
            this.radioLightHeading3.setSelected(true);
        } else if (string.equalsIgnoreCase("South")) {
            this.radioLightHeading4.setSelected(true);
        }
        String string2 = Common.getValue(this.rootTGW, "lighting", "elevation", 0);
        if (string2.equalsIgnoreCase("Low")) {
            this.radioLightElevation1.setSelected(true);
        } else if (string2.equalsIgnoreCase("Medium")) {
            this.radioLightElevation2.setSelected(true);
        } else if (string2.equalsIgnoreCase("High")) {
            this.radioLightElevation3.setSelected(true);
        }
        if (Common.getValue(this.rootTGW, "camera", "height", 0).equalsIgnoreCase("Low")) {
            this.radioCameraHeight1.setSelected(true);
        } else {
            this.radioCameraHeight2.setSelected(true);
        }
        String string3 = Common.getValue(this.rootTGW, "camera", "heading", 0);
        if (string3.equalsIgnoreCase("East")) {
            this.radioCameraHeading1.setSelected(true);
        } else if (string3.equalsIgnoreCase("North")) {
            this.radioCameraHeading2.setSelected(true);
        } else if (string3.equalsIgnoreCase("West")) {
            this.radioCameraHeading3.setSelected(true);
        } else if (string3.equalsIgnoreCase("South")) {
            this.radioCameraHeading4.setSelected(true);
        }
    }

    private void enableLake(boolean bl) {
        this.radioLakeDepth1.setEnabled(bl);
        this.radioLakeDepth2.setEnabled(bl);
        this.radioLakeRadius1.setEnabled(bl);
        this.radioLakeRadius2.setEnabled(bl);
        this.radioLakeRough1.setEnabled(bl);
        this.radioLakeRough2.setEnabled(bl);
        this.radioLakeWave1.setEnabled(bl);
        this.radioLakeWave2.setEnabled(bl);
        this.radioLakeReflect1.setEnabled(bl);
        this.radioLakeReflect2.setEnabled(bl);
    }

    private void enableMount(boolean bl) {
        this.radioMountRough1.setEnabled(bl);
        this.radioMountRough2.setEnabled(bl);
        this.radioMountFlat1.setEnabled(bl);
        this.radioMountFlat2.setEnabled(bl);
    }

    private void enableSurface(boolean bl) {
        this.radioSurface1.setEnabled(bl);
        this.radioSurface2.setEnabled(bl);
        this.labSurfaceMax.setEnabled(bl);
        this.labSurfaceMin.setEnabled(bl);
        this.radioSurfaceMaxalt1.setEnabled(bl);
        this.radioSurfaceMaxalt2.setEnabled(bl);
        this.radioSurfaceMaxalt3.setEnabled(bl);
        this.radioSurfaceMinalt1.setEnabled(bl);
        this.radioSurfaceMinalt2.setEnabled(bl);
        this.radioSurfaceMinalt3.setEnabled(bl);
    }

    private void enableCloud(boolean bl) {
        this.radioCloudCategory1.setEnabled(bl);
        this.radioCloudCategory2.setEnabled(bl);
        this.radioCloudColor1.setEnabled(bl);
        this.radioCloudColor2.setEnabled(bl);
        this.radioCloudAltitude1.setEnabled(bl);
        this.radioCloudAltitude2.setEnabled(bl);
        this.radioCloudDepth1.setEnabled(bl);
        this.radioCloudDepth2.setEnabled(bl);
        this.radioCloudDensity1.setEnabled(bl);
        this.radioCloudDensity2.setEnabled(bl);
    }

    private void resetAllSetting() {
        this.resetLake();
        this.resetMount();
        this.resetSurface();
        this.resetCloud();
        this.resetLight();
        this.resetCamera();
        this.checkOptions();
    }

    private void resetLake() {
        this.cboxLake.setSelected(false);
        this.radioLakeDepth1.setSelected(true);
        this.radioLakeRadius1.setSelected(true);
        this.radioLakeRough1.setSelected(true);
        this.radioLakeWave1.setSelected(true);
        this.radioLakeReflect1.setSelected(true);
    }

    private void resetMount() {
        this.cboxMountain.setSelected(false);
        this.radioMountRough1.setSelected(true);
        this.radioMountFlat1.setSelected(true);
    }

    private void resetSurface() {
        this.cboxSurface.setSelected(false);
        this.radioSurface1.setSelected(true);
        this.radioSurfaceMaxalt1.setSelected(true);
        this.radioSurfaceMinalt1.setSelected(true);
    }

    private void resetCloud() {
        this.cboxCloud.setSelected(false);
        this.radioCloudCategory1.setSelected(true);
        this.radioCloudColor1.setSelected(true);
        this.radioCloudAltitude1.setSelected(true);
        this.radioCloudDensity1.setSelected(true);
        this.radioCloudDepth1.setSelected(true);
    }

    private void resetLight() {
        this.radioLightHeading1.setSelected(true);
        this.radioLightElevation1.setSelected(true);
    }

    private void resetCamera() {
        this.radioCameraHeight1.setSelected(true);
        this.radioCameraHeading1.setSelected(true);
    }

    private void setWindowTitle(String string) {
        this.setTitle(this.translate("title.advancedmode") + " " + string);
    }
}

