/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.stir.cs.terrawiz;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.stir.cs.terrawiz.Common;

public class Beginner
extends JFrame
implements ActionListener {
    private JLabel labNote;
    private JLabel labLake;
    private JLabel labMountain;
    private JLabel labGrass;
    private JLabel labCloud;
    private JCheckBox cboxLake;
    private JCheckBox cboxMountain;
    private JCheckBox cboxGrass;
    private JCheckBox cboxCloud;
    private JButton btnSave;
    private JButton btnAdvanced;
    private JButton btnLang;
    private JFileChooser fileChooser;
    private JPanel panelUp;
    private JPanel panelDown;
    private String settingsFullPath;
    private String strLang;
    private String homeDirectory = System.getProperty("user.home");
    private File selectedFile;
    private Properties translation;
    private DOMParser parser;
    private Document domTGD;
    private Document domTGW;
    private Document domSetting;
    private Element rootSetting;
    private Element recentFile;
    private Element language;
    private Element rootTGW;
    private Element mode;
    private Element lighting;
    private Element camera;
    private Element lakeTGD;
    private Element waterShader;
    private Element fractalShader;
    private Element surfaceLayer;
    private Element surfaceShader;
    private Element cloudShader;
    private Element cloudLayer;
    private Element lakeTGW;
    private Element mountain;
    private Element surface;
    private Element cloud;
    private Element rootTGD;

    public Beginner() {
        this.setWindowTitle("");
        this.setSize(400, 350);
        int n = (Toolkit.getDefaultToolkit().getScreenSize().width - 400) / 2;
        int n2 = (Toolkit.getDefaultToolkit().getScreenSize().height - 350) / 2;
        this.setLocation(n, n2);
        this.initParser();
        if (!this.loadSettingDOM("/.terrawiz.xml")) {
            this.initSettingFile();
        }
        this.createGUI();
        this.resetLang();
        this.pack();
        this.setVisible(true);
    }

    public Beginner(String string) {
        this.setTitle(this.translate("title.beginnermodenew"));
        this.setSize(400, 350);
        int n = (Toolkit.getDefaultToolkit().getScreenSize().width - 400) / 2;
        int n2 = (Toolkit.getDefaultToolkit().getScreenSize().height - 350) / 2;
        this.setLocation(n, n2);
        this.initSettingFile(string);
        this.initParser();
        if (!this.loadSettingDOM("/.terrawiz.xml")) {
            this.initSettingFile();
        }
        this.createGUI();
        this.resetLang();
        this.pack();
        this.setVisible(true);
    }

    private InputStream getResourceStream(String string) {
        return this.getClass().getClassLoader().getResourceAsStream(string);
    }

    private void initSettingFile(String string) {
        this.strLang = string;
        this.domSetting = DOMImplementationImpl.getDOMImplementation().createDocument(null, null, null);
        this.rootSetting = this.domSetting.createElement("Setting");
        this.recentFile = this.domSetting.createElement("RecentFile");
        this.language = this.domSetting.createElement("Language");
        this.language.appendChild(this.domSetting.createTextNode(string));
        this.mode = this.domSetting.createElement("Mode");
        this.mode.appendChild(this.domSetting.createTextNode("Beginner"));
        this.rootSetting.appendChild(this.recentFile);
        this.rootSetting.appendChild(this.language);
        this.rootSetting.appendChild(this.mode);
        this.domSetting.appendChild(this.rootSetting);
        this.settingsFullPath = this.homeDirectory + "/.terrawiz.xml";
        Common.writeXML(this.domSetting, this.settingsFullPath);
    }

    private void initParser() {
        this.loadTGDDOM("res/terragen.xml");
        this.createTGWDOM();
    }

    private void loadTGDDOM(String string) {
        this.parser = new DOMParser();
        try {
            this.parser.parse(new InputSource(this.getResourceStream(string)));
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, this.translate("err.filenotexist") + " - " + string);
            this.setWindowTitle("");
            Common.fileState = 0;
            return;
        }
        this.domTGD = this.parser.getDocument();
        this.rootTGD = this.domTGD.getDocumentElement();
    }

    private void createTGWDOM() {
        this.domTGW = DOMImplementationImpl.getDOMImplementation().createDocument(null, null, null);
        this.rootTGW = this.domTGW.createElement("terragen");
        this.rootTGW.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.rootTGW.setAttribute("xsi:noNamespaceSchemaLocation", "http://www.cs.stir.ac.uk/schemas/terragen_wizard.xsd");
        this.lighting = this.domTGW.createElement("lighting");
        this.camera = this.domTGW.createElement("camera");
        this.lighting.setAttribute("heading", "East");
        this.lighting.setAttribute("elevation", "Low");
        this.camera.setAttribute("height", "Low");
        this.camera.setAttribute("heading", "East");
        this.rootTGW.appendChild(this.lighting);
        this.rootTGW.appendChild(this.camera);
        this.domTGW.appendChild(this.rootTGW);
    }

    private void initSettingFile() {
        this.domSetting = DOMImplementationImpl.getDOMImplementation().createDocument(null, null, null);
        this.rootSetting = this.domSetting.createElement("Setting");
        this.recentFile = this.domSetting.createElement("RecentFile");
        this.language = this.domSetting.createElement("Language");
        this.language.appendChild(this.domSetting.createTextNode("en-GB"));
        this.mode = this.domSetting.createElement("Mode");
        this.mode.appendChild(this.domSetting.createTextNode("Advanced"));
        this.rootSetting.appendChild(this.recentFile);
        this.rootSetting.appendChild(this.language);
        this.rootSetting.appendChild(this.mode);
        this.domSetting.appendChild(this.rootSetting);
        this.settingsFullPath = this.homeDirectory + "/.terrawiz.xml";
        Common.writeXML(this.domSetting, this.settingsFullPath);
    }

    private boolean loadSettingDOM(String string) {
        this.parser = new DOMParser();
        try {
            this.settingsFullPath = this.homeDirectory + string;
            this.parser.parse(this.settingsFullPath);
        }
        catch (SAXException sAXException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        this.domSetting = this.parser.getDocument();
        this.rootSetting = this.domSetting.getDocumentElement();
        NodeList nodeList = this.rootSetting.getElementsByTagName("RecentFile");
        if (nodeList.getLength() == 0) {
            return false;
        }
        this.recentFile = (Element)nodeList.item(0);
        NodeList nodeList2 = this.rootSetting.getElementsByTagName("Language");
        if (nodeList2.getLength() == 0) {
            return false;
        }
        this.strLang = nodeList2.item(0).getFirstChild().getNodeValue();
        return true;
    }

    private void createGUI() {
        ImageIcon imageIcon = new ImageIcon("res/icon.png");
        this.setIconImage(imageIcon.getImage());
        this.setDefaultCloseOperation(3);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.panelDown = new JPanel();
        this.panelDown.setPreferredSize(new Dimension(400, 50));
        this.panelDown.setLayout(new FlowLayout());
        this.panelUp = new JPanel();
        this.panelUp.setPreferredSize(new Dimension(400, 300));
        this.panelUp.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.labNote = new JLabel(this.translate("beginner.label.labnote") + ":");
        this.panelUp.add((Component)this.labNote, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        this.panelUp.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        this.labLake = new JLabel(this.translate("beginner.label.lake"));
        this.panelUp.add((Component)this.labLake, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.cboxLake = new JCheckBox();
        this.panelUp.add((Component)this.cboxLake, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.labMountain = new JLabel(this.translate("beginner.label.mountain"));
        this.panelUp.add((Component)this.labMountain, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.cboxMountain = new JCheckBox();
        this.panelUp.add((Component)this.cboxMountain, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.labGrass = new JLabel(this.translate("beginner.label.grass"));
        this.panelUp.add((Component)this.labGrass, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.cboxGrass = new JCheckBox();
        this.panelUp.add((Component)this.cboxGrass, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.labCloud = new JLabel(this.translate("beginner.label.cloud"));
        this.panelUp.add((Component)this.labCloud, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.cboxCloud = new JCheckBox();
        this.panelUp.add((Component)this.cboxCloud, gridBagConstraints);
        this.btnSave = new JButton(this.translate("beginner.btn.save"));
        this.btnSave.addActionListener(this);
        this.panelDown.add(this.btnSave);
        this.btnAdvanced = new JButton(this.translate("beginner.btn.advancedmode"));
        this.btnAdvanced.addActionListener(this);
        this.panelDown.add(this.btnAdvanced);
        this.btnLang = new JButton(this.translate("beginner.btn.lang"));
        this.btnLang.addActionListener(this);
        this.panelDown.add(this.btnLang);
        container.add("North", this.panelUp);
        container.add("South", this.panelDown);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnSave) {
            this.addFileChooser();
            int n = this.fileChooser.showSaveDialog(this);
            if (n == 0) {
                Common.fileState = 1;
                this.selectedFile = this.fileChooser.getSelectedFile();
                String string = Common.getFileExtension(this.selectedFile);
                if (string.equalsIgnoreCase("tgd") || string.equalsIgnoreCase("tgw")) {
                    this.setWindowTitle(this.selectedFile.getAbsolutePath());
                } else {
                    this.setWindowTitle(this.selectedFile.getAbsolutePath() + "." + this.fileChooser.getFileFilter().getDescription());
                }
                if (string.equalsIgnoreCase("tgd")) {
                    Common.fileCategory = 1;
                    this.changeTGDDOM();
                    this.warnSaveCompleted(this.domTGD, this.selectedFile, "none");
                } else if (string.equalsIgnoreCase("tgw")) {
                    Common.fileCategory = 0;
                    this.changeTGWDOM();
                    this.warnSaveCompleted(this.domTGW, this.selectedFile, "none");
                } else if (this.fileChooser.getFileFilter().getDescription().equalsIgnoreCase("tgd")) {
                    Common.fileCategory = 1;
                    this.changeTGDDOM();
                    this.warnSaveCompleted(this.domTGD, this.selectedFile, "tgd");
                } else if (this.fileChooser.getFileFilter().getDescription().equalsIgnoreCase("tgw")) {
                    Common.fileCategory = 0;
                    this.changeTGWDOM();
                    this.warnSaveCompleted(this.domTGW, this.selectedFile, "tgw");
                }
                Common.fileChanged = false;
            }
        }
        if (actionEvent.getSource() == this.btnAdvanced) {
            this.changeSetting("Advanced", "Mode");
            JOptionPane.showMessageDialog(this, this.translate("beginner.popup.mode"));
        }
        if (actionEvent.getSource() == this.btnLang) {
            NodeList nodeList = this.rootSetting.getElementsByTagName("Language");
            this.strLang = nodeList.item(0).getFirstChild().getNodeValue();
            if (this.strLang.equals("en-GB")) {
                this.changeSetting("zh-CN", "Language");
            } else if (this.strLang.equals("zh-CN")) {
                this.changeSetting("en-GB", "Language");
            }
            this.resetLang();
        }
    }

    public void resetLang() {
        this.initLang();
        this.labNote.setText(this.translate("beginner.label.labnote"));
        this.btnSave.setText(this.translate("beginner.btn.save"));
        this.btnAdvanced.setText(this.translate("beginner.btn.advancedmode"));
        this.btnLang.setText(this.translate("beginner.btn.lang"));
        this.labLake.setText(this.translate("beginner.label.lake"));
        this.labMountain.setText(this.translate("beginner.label.mountain"));
        this.labGrass.setText(this.translate("beginner.label.grass"));
        this.labCloud.setText(this.translate("beginner.label.cloud"));
    }

    private void initLang() {
        this.parser = new DOMParser();
        try {
            this.settingsFullPath = this.homeDirectory + "/.terrawiz.xml";
            this.parser.parse(this.settingsFullPath);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.domSetting = this.parser.getDocument();
        this.rootSetting = this.domSetting.getDocumentElement();
        NodeList nodeList = this.rootSetting.getElementsByTagName("Language");
        String string = nodeList.item(0).getFirstChild().getNodeValue();
        this.translation = new Properties();
        InputStream inputStream = this.getResourceStream("res/" + string + ".properties");
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-16");
            this.translation.load(inputStreamReader);
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            System.err.println("Wrong path or filename");
        }
        this.setTitle(this.translate("title.beginnermodenew"));
    }

    public String translate(String string) {
        String string2 = "";
        if (this.translation == null || (string2 = this.translation.getProperty(string)) == null) {
            string2 = string + "?";
        }
        return string2;
    }

    private void warnSaveCompleted(Document document, File file, String string) {
        if (string.equals("tgd") || string.equals("tgw")) {
            if (!Common.writeXML(document, file.getAbsolutePath() + "." + string)) {
                JOptionPane.showMessageDialog(this, this.translate("warn.savenotcomplete"));
            }
        } else if (string.equals("none") && !Common.writeXML(document, file.getAbsolutePath())) {
            JOptionPane.showMessageDialog(this, this.translate("warn.savenotcomplete"));
        }
    }

    private void addFileChooser() {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(new File(this.homeDirectory));
        this.fileChooser.setFileFilter(new FileNameExtensionFilter("tgd", "tgd"));
        this.fileChooser.setFileFilter(new FileNameExtensionFilter("tgw", "tgw"));
    }

    private void changeTGDDOM() {
        if (this.cboxLake.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGD, "lake") == 0) {
                Common.enableTGDLakeNodes(this.rootTGD, this.domTGD, this.lakeTGD, this.waterShader);
            }
        } else {
            Common.disableTGDLakeNodes(this.rootTGD);
        }
        boolean bl = false;
        if (this.cboxMountain.isSelected()) {
            NodeList nodeList = this.rootTGD.getElementsByTagName("power_fractal_shader_v3");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    Node node = namedNodeMap.item(j);
                    if (!node.getNodeName().equals("gui_group") || !node.getNodeValue().equals("Terrain")) continue;
                    bl = true;
                }
            }
            if (!bl) {
                Common.enableTGDMountNodes(this.rootTGD, this.domTGD, this.fractalShader);
                Common.changeAttr(this.rootTGD, "compute_terrain", "input_node", "Fractal terrain 01", 0);
            }
        } else {
            Common.disableTGDMountNodes(this.rootTGD);
        }
        if (this.cboxGrass.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGD, "surface_layer") == 0) {
                Common.enableTGDSurfaceNodes(this.rootTGD, this.domTGD, this.surfaceLayer, this.surfaceShader, this.cboxMountain);
            }
            Common.changeAttr(this.rootTGD, "planet", "surface_shader", "Surface layer 01", 0);
            Common.changeAttr(this.rootTGD, "surface_layer", "diffuse_colour", "0.0236995 0.18125 0.00057709", 0);
        } else {
            Common.disableTGDSurfaceNodes(this.rootTGD);
        }
        if (this.cboxCloud.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGD, "cloud_layer_v2") == 0) {
                Common.enableTGDCloudNodes(this.rootTGD, this.domTGD, this.cloudLayer, this.cloudShader);
            }
        } else {
            Common.disableTGDCloudNodes(this.rootTGD);
        }
    }

    private void changeTGWDOM() {
        if (this.cboxLake.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGW, "lake") == 0) {
                Common.enableTGWLakeNodes(this.rootTGW, this.domTGW, this.lakeTGW);
            }
        } else {
            Common.disableTGWLakeNodes(this.rootTGW);
        }
        if (this.cboxMountain.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGW, "mountain") == 0) {
                Common.enableTGWMountNodes(this.rootTGW, this.domTGW, this.mountain);
            }
        } else {
            Common.disableTGWMountNodes(this.rootTGW);
        }
        if (this.cboxGrass.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGW, "surface") == 0) {
                Common.enableTGWSurfaceNodes(this.rootTGW, this.domTGW, this.surface);
            }
        } else {
            Common.disableTGWSurfaceNodes(this.rootTGW);
        }
        if (this.cboxCloud.isSelected()) {
            if (Common.checkNodeExistNum(this.rootTGW, "cloud") == 0) {
                Common.enableTGWCloudNodes(this.rootTGW, this.domTGW, this.cloud);
            }
        } else {
            Common.disableTGWCloudNodes(this.rootTGW);
        }
    }

    public void changeSetting(String string, String string2) {
        Common.changeElem(this.rootSetting, string2, string);
        Common.writeXML(this.domSetting, this.homeDirectory + "/.terrawiz.xml");
    }

    private void setWindowTitle(String string) {
        this.setTitle(this.translate("title.beginnermode") + " " + string);
    }
}

