/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.stir.cs.terrawiz;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.ac.stir.cs.terrawiz.Advanced;

public class SettingWindow
extends JFrame
implements ActionListener {
    private final int frameWidth = 300;
    private final int frameHeight = 350;
    private JPanel panelSetting;
    private JPanel panelLang;
    private JPanel panelMode;
    private JPanel panelDown;
    private JButton btnOk;
    private JButton btnCancel;
    private JRadioButton radioEN;
    private JRadioButton radioCN;
    private JRadioButton radioBeginner;
    private JRadioButton radioAdvanced;
    private ButtonGroup aButtonGroup;
    private Advanced advanced;
    private final String langEN = "en-GB";
    private final String langCN = "zh-CN";
    private Element rootSetting;

    public SettingWindow(Advanced advanced, Element element) {
        this.advanced = advanced;
        this.rootSetting = element;
        this.setTitle(advanced.translate("title.setting"));
        this.setSize(300, 350);
        int n = (Toolkit.getDefaultToolkit().getScreenSize().width - 300) / 2;
        int n2 = (Toolkit.getDefaultToolkit().getScreenSize().height - 350) / 2;
        this.setLocation(n, n2);
        this.createGUI();
        this.checkCurrentSetting(element);
        this.pack();
        this.setVisible(true);
    }

    private void checkCurrentSetting(Element element) {
        if (this.getNodeValue(element, "Language").equals("en-GB")) {
            this.radioEN.setSelected(true);
        } else if (this.getNodeValue(element, "Language").equals("zh-CN")) {
            this.radioCN.setSelected(true);
        }
        if (this.getNodeValue(element, "Mode").equals("Beginner")) {
            this.radioBeginner.setSelected(true);
        } else if (this.getNodeValue(element, "Mode").equals("Advanced")) {
            this.radioAdvanced.setSelected(true);
        }
    }

    private String getNodeValue(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        return nodeList.item(0).getFirstChild().getNodeValue();
    }

    private void createGUI() {
        SettingWindow.setDefaultLookAndFeelDecorated(true);
        this.setUndecorated(true);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        ImageIcon imageIcon = new ImageIcon(this.getResource("res/icon.png"));
        this.setIconImage(imageIcon.getImage());
        Container container = this.getContentPane();
        container.setPreferredSize(new Dimension(300, 350));
        this.panelSetting = new JPanel();
        this.panelSetting.setPreferredSize(new Dimension(300, 250));
        this.panelLang = new JPanel();
        this.panelLang.setPreferredSize(new Dimension(200, 150));
        this.panelLang.setLayout(new BoxLayout(this.panelLang, 1));
        this.panelLang.setBorder(BorderFactory.createTitledBorder(this.advanced.translate("title.setting.lang")));
        this.radioEN = new JRadioButton(this.advanced.translate("title.setting.lang.eng"));
        this.radioEN.setAlignmentX(0.5f);
        this.panelLang.add(this.radioEN);
        this.radioCN = new JRadioButton(this.advanced.translate("title.setting.lang.chn"));
        this.radioCN.setAlignmentX(0.5f);
        this.panelLang.add(this.radioCN);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioEN);
        this.aButtonGroup.add(this.radioCN);
        this.panelMode = new JPanel();
        this.panelMode.setPreferredSize(new Dimension(200, 100));
        this.panelMode.setLayout(new BoxLayout(this.panelMode, 1));
        this.panelMode.setBorder(BorderFactory.createTitledBorder(this.advanced.translate("title.setting.mode")));
        this.radioBeginner = new JRadioButton(this.advanced.translate("title.setting.mode.beginner"));
        this.radioBeginner.setAlignmentX(0.5f);
        this.panelMode.add(this.radioBeginner);
        this.radioAdvanced = new JRadioButton(this.advanced.translate("title.setting.mode.advanced"));
        this.radioAdvanced.setAlignmentX(0.5f);
        this.panelMode.add(this.radioAdvanced);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioBeginner);
        this.aButtonGroup.add(this.radioAdvanced);
        this.panelDown = new JPanel();
        this.panelDown.setPreferredSize(new Dimension(200, 100));
        this.panelDown.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.btnOk = new JButton(this.advanced.translate("btn.setting.ok"));
        this.btnOk.addActionListener(this);
        this.panelDown.add((Component)this.btnOk, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.btnCancel = new JButton(this.advanced.translate("btn.setting.cancel"));
        this.btnCancel.addActionListener(this);
        this.panelDown.add((Component)this.btnCancel, gridBagConstraints);
        this.panelSetting.add(this.panelLang);
        this.panelSetting.add(this.panelMode);
        this.panelSetting.add(this.panelDown);
        container.add(this.panelSetting);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnOk) {
            if (this.radioEN.isSelected()) {
                this.advanced.lang = "en-GB";
                this.advanced.initLang("en-GB");
                this.advanced.resetLang();
            } else if (this.radioCN.isSelected()) {
                this.advanced.lang = "zh-CN";
                this.advanced.initLang("zh-CN");
                this.advanced.resetLang();
            }
            if (this.radioBeginner.isSelected()) {
                this.advanced.changeSetting("Beginner", "Mode");
            } else if (this.radioAdvanced.isSelected()) {
                this.advanced.changeSetting("Advanced", "Mode");
            }
            JOptionPane.showMessageDialog(this, this.advanced.translate("setting.popup"));
            this.setVisible(false);
        } else {
            this.setVisible(false);
        }
    }

    private URL getResource(String string) {
        return this.getClass().getClassLoader().getResource(string);
    }
}

