package uk.ac.stir.cs.terrawiz;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.net.URL;

import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;

/**
  Class for describing TerraWiz.

  @author	Tao (Fred) Lu, Kenneth J. Turner
  @version	1.0 (6th April 2009)
*/

public class AboutTerraWiz extends JFrame implements ActionListener {

  private final int frameWidth = 300;
  private final int frameHeight = 350;

  private JButton btnOk;

  private Advanced advanced;

  private JPanel panelSetting, panelDown, panelLogo;

  /**
   Constructor for the AboutTerraWiz object.

   @param advanced  beginner or advanced mode
  */

  public AboutTerraWiz(Advanced advanced) {
    this.advanced = advanced;
    this.setTitle(advanced.translate("title.setting"));
    this.setSize(frameWidth, frameHeight);
    int w =
      (Toolkit.getDefaultToolkit().getScreenSize().width - frameWidth) / 2;
    int h =
      (Toolkit.getDefaultToolkit().getScreenSize().height - frameHeight) / 2;
    this.setLocation(w, h);
    createGUI();
    this.pack();
    this.setVisible(true);

  }

  /** Create GUI. */

  private void createGUI() {
    setDefaultLookAndFeelDecorated(true);
    setUndecorated(true);
    setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    setResizable(false);

    ImageIcon titleIcon = new ImageIcon(getResource(Common.iconPath));
    setIconImage(titleIcon.getImage());

    Container window = getContentPane();
    window.setPreferredSize(new Dimension(frameWidth, frameHeight));
    window.setLayout(new BorderLayout());
    panelSetting = new JPanel();
    panelSetting.setPreferredSize(new Dimension(frameWidth, 250));
    panelSetting.setLayout(new BoxLayout(panelSetting, BoxLayout.X_AXIS));

    if (advanced.lang.equals("en-GB"))
      panelLogo = new PicPanel("res/about.png", 1);
    else if (advanced.lang.equals("zh-CN"))
      panelLogo = new PicPanel("res/about.png", 2);

    panelLogo.setPreferredSize(new Dimension(frameWidth, 300));
    JSeparator separator = new JSeparator(JSeparator.VERTICAL);
    separator.setOrientation(SwingConstants.HORIZONTAL);

    panelDown = new JPanel();
    panelDown.setPreferredSize(new Dimension(200, 50));
    panelDown.setLayout(new GridBagLayout());
    GridBagConstraints constraints1 = new GridBagConstraints();

    constraints1.gridx = 0;
    constraints1.gridy = 0;
    btnOk = new JButton(advanced.translate("btn.setting.ok"));
    btnOk.addActionListener(this);
    panelDown.add(btnOk, constraints1);

    window.add("North", panelLogo);
    window.add("South", panelDown);
  }

  /**
    Respond to action event.

    @param e  action event
  */

  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == btnOk)
      this.setVisible(false);
    else
      this.setVisible(false);
  }

  /**
    Get URL for resource/library file.

    @param fileName	file name relative to program base directory
    @return		file input stream
  */

  private URL getResource(String fileName) {
    return(getClass().getClassLoader().getResource(fileName));
  }

}

