package uk.ac.stir.cs.terrawiz;

import javax.swing.*;
import java.awt.*;
import java.awt.image.*;
import java.io.File;
import java.io.InputStream;

import javax.imageio.*;

/**
  Class for creating a panel from an image file.

  @author	Tao (Fred) Lu, Kenneth J. Turner
  @version	1.0 (6th April 2009)
*/

public class PicPanel extends JPanel {

  BufferedImage img, img2;
  private int category;

  /**
    Constructor for a PicPanel object.

    @param fileName	file name
    @param category	image category (0 for version, 1 for English logo,
			2 for Chinese logo)
  */

  public PicPanel(String fileName, int category) {
    super();
    this.category = category;
    try {
      img = getImage(fileName);
    }
    catch (Exception exception) {
      System.err.println("PicPanel: could not load image " + fileName +
	" - " + exception);
    }
  }

  /**
    Paint image panel (0 spash screen, 1 "About TerraWiz" for English, 2 "About
    TerraWiz" for Chinese).

    @param g  Parameter
  */

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    g.setColor(Color.white);
    g.fillRect(0, 0, 600, 300);
    g.drawImage(img, 0, 0, this);
    if (category == 0) {
      g.setColor(Common.versionColour);
      g.drawString("Version " + Common.programVersion, 80, 120);
    }
    else if (category == 1) {
      img2 = getImage("res/stirling.png");
      g.drawImage(img2, 170, 0, this);
      g.setColor(Common.versionColour);
      g.drawString("Version " + Common.programVersion, 5, 170);
      g.setColor(Color.black);
      g.drawString("Developer: Tao (Fred) Lu", 160, 230);
      g.drawString("Supervisor: Ken Turner", 160, 250);
    }
    else if (category == 2) {
      img2 = getImage("res/stirling.png");
      g.drawImage(img2, 170, 0, this);
      g.setColor(Common.versionColour);
      g.drawString("Version " + Common.programVersion, 5, 170);
      g.setColor(Color.black);
      g.drawString("\u9646\u97ec: \u8bbe\u8ba1", 160, 230);
      g.drawString("\u5bfc\u5e08: Ken Turner", 160, 250);
    }
  }

  /**
    Get input stream for resource/library file.

    @param fileName	file name relative to program base directory
    @return		file input stream
  */

  private InputStream getResourceStream(String fileName) {
    return(getClass().getClassLoader().getResourceAsStream(fileName));
  }

  /**
    Get a buffer image from its file name.

    @param fileName	image file path
    @return		buffered image
  */

  public BufferedImage getImage(String fileName) {
    BufferedImage image = null;
    try {
      image = ImageIO.read(getResourceStream(fileName));
      this.repaint();
    }
    catch (Exception e) {
      System.err.println("PicPanel: could not load image " + fileName + " - " +
	e.toString());
    }
    return(image);
  }

}
