package uk.ac.stir.cs.terrawiz;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
  Class for settings window.

  @author	Tao (Fred) Lu, Kenneth J. Turner
  @version	1.0 (6th April 2009)
*/

public class SettingWindow extends JFrame implements ActionListener {

  private final int frameWidth = 300;
  private final int frameHeight = 350;

  private JPanel panelSetting, panelLang, panelMode, panelDown;

  private JButton btnOk, btnCancel;

  private JRadioButton radioEN, radioCN, radioBeginner, radioAdvanced;
  private ButtonGroup aButtonGroup;

  private Advanced advanced;

  private final String langEN = "en-GB";
  private final String langCN = "zh-CN";

  @SuppressWarnings("unused")
  private Element rootSetting;

  /**
    Constructor for a SettingWindow object.

    @param advanced	whether advanced mode or not
    @param rootSetting	root settings node
  */

  public SettingWindow(Advanced advanced, Element rootSetting) {
    this.advanced = advanced;
    this.rootSetting = rootSetting;
    setTitle(advanced.translate("title.setting"));
    setSize(frameWidth, frameHeight);
    int w =
      (Toolkit.getDefaultToolkit().getScreenSize().width - frameWidth) / 2;
    int h =
      (Toolkit.getDefaultToolkit().getScreenSize().height - frameHeight) / 2;
    setLocation(w, h);
    createGUI();
    checkCurrentSetting(rootSetting);
    pack();
    setVisible(true);
  }

  /**
    Check current settings.

    @param root		root settings node
  */

  private void checkCurrentSetting(Element root) {
    if (getNodeValue(root, "Language").equals("en-GB"))
      radioEN.setSelected(true);
    else if (getNodeValue(root, "Language").equals("zh-CN"))
      radioCN.setSelected(true);

    if (getNodeValue(root, "Mode").equals("Beginner"))
      radioBeginner.setSelected(true);
    else if (getNodeValue(root, "Mode").equals("Advanced"))
      radioAdvanced.setSelected(true);

  }

  /**
    Gets the node value attribute of the SettingWindow object.

    @param root		root settings node
    @param nodeName	node name
    @return		node value
  */

  private String getNodeValue(Element root, String nodeName) {
    NodeList nodeList1 = root.getElementsByTagName(nodeName);
    return nodeList1.item(0).getFirstChild().getNodeValue();
  }

  /** Create GUI */

  private void createGUI() {
    setDefaultLookAndFeelDecorated(true);
    setUndecorated(true);
    setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
    setResizable(false);

    ImageIcon titleIcon = new ImageIcon(getResource(Common.iconPath));
    setIconImage(titleIcon.getImage());

    Container window = getContentPane();
    window.setPreferredSize(new Dimension(frameWidth, frameHeight));
    panelSetting = new JPanel();
    panelSetting.setPreferredSize(new Dimension(frameWidth, 250));

    panelLang = new JPanel();
    panelLang.setPreferredSize(new Dimension(200, 150));
    panelLang.setLayout(new BoxLayout(panelLang, BoxLayout.Y_AXIS));
    panelLang.setBorder(BorderFactory.createTitledBorder(advanced.translate("title.setting.lang")));

    // English option
    radioEN = new JRadioButton(advanced.translate("title.setting.lang.eng"));
    radioEN.setAlignmentX(CENTER_ALIGNMENT);
    panelLang.add(radioEN);

    // Chinese option
    radioCN = new JRadioButton(advanced.translate("title.setting.lang.chn"));
    radioCN.setAlignmentX(CENTER_ALIGNMENT);
    panelLang.add(radioCN);

    aButtonGroup = new ButtonGroup();
    aButtonGroup.add(radioEN);
    aButtonGroup.add(radioCN);

    panelMode = new JPanel();
    panelMode.setPreferredSize(new Dimension(200, 100));
    panelMode.setLayout(new BoxLayout(panelMode, BoxLayout.Y_AXIS));
    panelMode.setBorder(BorderFactory.createTitledBorder(advanced.translate("title.setting.mode")));

    // beginner mode
    radioBeginner = new JRadioButton(advanced.translate("title.setting.mode.beginner"));
    radioBeginner.setAlignmentX(CENTER_ALIGNMENT);
    panelMode.add(radioBeginner);

    // advanced mode
    radioAdvanced = new JRadioButton(advanced.translate("title.setting.mode.advanced"));
    radioAdvanced.setAlignmentX(CENTER_ALIGNMENT);
    panelMode.add(radioAdvanced);

    aButtonGroup = new ButtonGroup();
    aButtonGroup.add(radioBeginner);
    aButtonGroup.add(radioAdvanced);

    panelDown = new JPanel();
    panelDown.setPreferredSize(new Dimension(200, 100));
    panelDown.setLayout(new GridBagLayout());
    GridBagConstraints constraints1 = new GridBagConstraints();

    constraints1.gridx = 0;
    constraints1.gridy = 0;
    btnOk = new JButton(advanced.translate("btn.setting.ok"));
    btnOk.addActionListener(this);
    panelDown.add(btnOk, constraints1);

    constraints1.gridx = 1;
    constraints1.gridy = 0;
    btnCancel = new JButton(advanced.translate("btn.setting.cancel"));
    btnCancel.addActionListener(this);
    panelDown.add(btnCancel, constraints1);

    panelSetting.add(panelLang);
    panelSetting.add(panelMode);
    panelSetting.add(panelDown);
    window.add(panelSetting);
  }

  /**
    Respond to action event.

    @param e  action event
  */

  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == btnOk) {
      if (radioEN.isSelected()) {
	advanced.lang = "en-GB";
	advanced.initLang(langEN);
	advanced.resetLang();
      }
      else if (radioCN.isSelected()) {
	advanced.lang = "zh-CN";
	advanced.initLang(langCN);
	advanced.resetLang();
      }
      if (radioBeginner.isSelected())
	advanced.changeSetting("Beginner", "Mode");
      else if (radioAdvanced.isSelected())
	advanced.changeSetting("Advanced", "Mode");

      JOptionPane.showMessageDialog(this, advanced.translate("setting.popup"));
      setVisible(false);
    }
    else
      setVisible(false);
  }

  /**
    Get URL for resource/library file.

    @param fileName	file name relative to program base directory
    @return		file input stream
  */

  private URL getResource(String fileName) {
    return(getClass().getClassLoader().getResource(fileName));
  }

}

