/*> do cc -g -I$EPSINC -L$EPSLIB -o %P %F -lcast
 *
 * extracts the colours used in an AST
 * works on an external (file) representation
 * makes use of the colour type ST (string lists)
 */

# include <stdio.h>
# include "cast.hh"

/* really, not used, since the file is neither loaded nor saved */
TIOCOLOURS iocolours [] = { OTHERS };

ST* clrs;		/* table of colours found */

main (argc, argv)
     int argc;
     char* argv[];
{
  FILE* fl;		/* file to read */
  char name[BUFSIZ];	/* name of the colour */
  int iname;
  char c;
  int type;
  
  if (argc == 1)
    fl= stdin;
  if (argc == 2)
    fl= fopen (argv[1], "r");
  if (argc > 2) {
    (void) fprintf (stderr, "usage: %s [file]\n", argv[0]);
    exit (1);
  }
  
  cast_init (iocolours);	/* initialize EPS */
  clrs= STcreate (20, 4, 2);	/* sorted table of strings */
  for (;;) {
    c= getc (fl);
    if (c == EOF)
      break;			/* end of file: goto print */
    (void) fscanf (fl, "%d", &type);
    c= getc (fl);		/* skip tree information */

				/* hardwired colours */
    if ((c= getc (fl)) == '{') {
      (void) STadd ("#value0", clrs, TRUE);
      while ((c= getc (fl)) != '}')
	if (c == '\\')
	  c= getc (fl);
      if ((c= getc (fl)) == '{') {
	(void) STadd ("#value1", clrs, TRUE);
	while ((c= getc (fl)) != '}')
	  if (c == '\\')
	    c= getc (fl);
	c= getc (fl);
      }
    }

    for (;;) {			/* process colours */
      while (c == ' ' || c == '\t')
	c= getc (fl);
      if (c == '\n')
	break;
				/* load colour name */
      iname= 0;
      do {
	name[iname++]= c;
      } while ((c= getc (fl)) != '{');
      name[iname++]= 0;
				/* add to table, reallocating space */
      (void) STadd (name, clrs, FALSE);
      while ((c= getc (fl)) != '}')
	if (c == '\\')
	  c= getc (fl);
      c= getc (fl);		/* skip '}' */
    }
  }
				/* print table */
  putST (stdout, (CLR_TYPE) clrs);
  exit (0);
}
