/*> do cc -g -I$EPSINC -L$EPSLIB -o %P %F -lcast
 *
 * copies an AST file
 * similar to /bin/cp, but uses internal representation of AST
 * knows of colour types, and handles appropiately

 * rmoves 2nd hardwired colour
 */

# include <stdio.h>
# include <ctype.h>
# include "cast.hh"

TIOCOLOURS iocolours [] = {		/* io driver */
  "int",      1, IO_int,	/* integer */
  "I2",       2, IO_I2, 	/* integer pair */
  "str",      3, IO_str,	/* string */
  "lxv",      4, IO_lxv,	/* shared strings via hash table */
  "intlist",  5, IO_IL,		/* list of integers */
  "strlist",  6, IO_SL,		/* list of strings */
  "IT",       7, IO_IT,		/* table of integers */
  "ST",       8, IO_ST,		/* table of strings */
  "IAT",      9, IO_IAT,	/* table of integer arrays */
  "ignore",  10, IO_ign,	/* forget about this colour */
  OTHERS			/* for the rest: copy */
  };

FILE* fl= stdin;

main (argc, argv)
     int argc;
     char* argv[];
{
  if (argc > 2) {
    fprintf (stderr, "usage: copy.others [file]\n");
    exit (1);
  }
  if (argc == 2)
    fl= fopen (argv[1], "r");

  HWclr[1].get= NULL;
  cast_init (iocolours);
  save_tree (stdout, restore (fl));
  exit (0);
}
