/*> do cc -g -I$EPSINC -L$EPSLIB -o %P %F -lcast
 *
 * draws a tree
 * in a (slightly) more friendly manner
 * by replacing tree codes into indentation of brothers/sons
 *
 * every colour is handled as unknown
 */

# include <stdio.h>
# include <ctype.h>
# include "cast.hh"

TIOCOLOURS iocolours [] = {		/* io driver */
	NULL, others, getstring, putstring, freestring, copystring
	};

int depth= -1;
FILE* fl= stdin;

main (argc, argv)
     int argc;
     char* argv[];
{
  while (argc > 1) {
    if (argv[1][0] == '-') {
      if (isdigit (argv[1][1]))
	depth= atoi (&argv[1][1]);
      else {
	fprintf (stderr, "usage: drast [-depth] [file]\n");
	exit (1);
      }
    }
    else
      fl= fopen (argv[1], "r");
    argc--;
    argv++;
  }
  cast_init (iocolours);
  drn_tree (restore (fl), depth);
  exit (0);
}
