# include "swbus.h"

PRIVATE FILE* sfp= stdin;

PRIVATE	TIOCOLOURS iocolours [] = {	
  "GL",    c_grnl,    IO_IAT,
  "L",     c_lexv,    IO_int,
  "N",     c_line,    IO_I2,
  "LL",    c_ll,      IO_ST,

  "value", c_value,   IO_int,
  OTHERS
  };

main (argc, argv)
     int argc;
     char* argv[];
{
  TNODE  *astroot;		/* AST root creation*/
  int    i;
  char   c;

  while (argc > 1) {
    if (argv[1][0] == '-') {
      i = 0;
      while ((c = argv[1][++i]) != '\0')
	switch (c) {
	  default:
	    exit(1);
	  }
    }
    argc--;
    argv++;
  }

  cast_init (iocolours);
  astroot= restore (sfp);	/* The AST is loaded on memory */
  if (astroot == NULL)
    exit (1);

  grnl = (IAT*) find_attr (c_grnl, astroot)->value;
  SymbolTable = (ST*) find_attr (c_ll, astroot)->value;

  rag (astroot);		/* Table creation from the AST */
  if (ragerrors == 0) {
    save_tree (stdout, astroot);
    exit(0);
  }
  else {
    fprintf (stderr, "calc: %d errors found\n", ragerrors);
/*
    save_tree (stderr, astroot);
*/
    exit(1);
  }
}
