# include "swbus.h"

int errorcount= 0;
int lexdebug= 0;
int yydebug= 0;
HT hidtbl;
char* progname;
IAT* grnl;

int nfname= 0;
FILE*   sfp;
char    sfile[BUFSIZ];

void    help ();
FILE*   efopen ();

PRIVATE TIOCOLOURS iocolours [] = {
  "GL",    c_grnl,    IO_IAT,
  "L",     c_lexv,    IO_int,
  "N",     c_line,    IO_I2,
  "LL",    c_ll,      IO_ST,
  NULL,    others,    IO_ign
  };

PRIVATE void
help    ()
{
  (void) fprintf (stderr, "usage: expressions [-ly]\n");
  (void) fprintf (stderr, "expressions    : arithmetic expression from the input\n");
  (void) fprintf (stderr, "expressions -l : lex debugging\n");
  (void) fprintf (stderr, "expressions -y : yacc debugging\n");
}

PUBLIC int
main (argc, argv)
    int     argc;
    char*   argv[];
{
  TNODE* tree;
  int i, c;
    
  progname= argv[0];
  (void) strcpy (sfile, "stdin");
  sfp= stdin;

  while (argc > 1) {
    if (argv[1][0] == '-') {
      i = 0;
      while ((c = argv[1][++i]) != '\0')
	switch (c) {
	case 'l':
	  lexdebug++;
	  break;
	case 'y':
	  yydebug++;
	  break;
	default:
	  help ();
	  exit (1);
	}
    }
    else
      (void) strcpy (sfile, argv[1]);
    argc--;
    argv++;
  }

  cast_init (iocolours);
  stinit (100);
  SymbolTable= STcreate (100, 0, 1);
  hidtbl= STHinit (SymbolTable, 5119);
  nfname= STHadd (sfile, SymbolTable, hidtbl, FALSE);
  grnl= IATcreate (100, 10, 1);

  tree= bast();

  if (errorcount == 0 && tree != NULL) {
    set_attr(c_ll, tree, (CLR_TYPE) SymbolTable);
    set_attr(c_grnl, tree, (CLR_TYPE) grnl);
    save_tree(stdout, tree);
    exit (0);
  }
  exit (1);
}
