#ifndef bsc_input_HH
#define bsc_input_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "bsc_input.hh": BaSiC INPUT functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************
 $Log: bsc_input.desc,v $
 * Revision 1.4  1993/01/12  16:36:39  eps
 * portability issues
 *
 * Revision 1.3  1992/01/14  15:45:13  eps
 * distribution issues
 *
 * Revision 1.2  92/01/14  15:28:07  eps
 * minor bugs
 * 
 * Revision 1.1  91/07/11  12:49:21  eps
 * Initial revision
 * 
 ***********************************
 $Id: bsc_input.desc,v 1.4 1993/01/12 16:36:39 eps Exp $
 ***********************************/


typedef struct
{ char *chr;
  int size;
  int level;
  int i, imax;
  int next_chr;
  int lno;
  int eof;
} sIBUF;	/* input buffer structure */

/* input buffer (you mustn't use it) */
#ifndef bsc_input_IMP
extern	sIBUF _IBUF;
#else
	sIBUF _IBUF= { NULL, 0, 0, 0, -1, '\0', 0, FALSE };
#endif

/* returns TRUE if the string is a word */

int	is_word ();

/* gets a word, or NULL if cannot (uses a static buffer) */

char *	get_word ();

/* returns TRUE if the string is a single line */

int	is_line ();

/* gets a line, or NULL if cannot (uses a static buffer) */

char *	get_line ();

/* ungets last input in current line, or returns FALSE if cannot */

int	unget ();

/* starts a new line if EOL was reached, else returns FALSE */

int	new_line ();

/* gets current line number, or 0 if no character was read */

#define get_lno()	(_IBUF.lno)

/* returns TRUE if EOF was reached or error detected */

#define is_eof()	(_IBUF.eof)

/* starts a new file (only if EOL was reached), else returns FALSE */

int	new_file ();

#endif
