#ifndef err_handl_HH
#define err_handl_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "err_handl.hh": ERRor HANDLing functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************
 $Log: err_handl.desc,v $
 * Revision 1.3  1993/01/12  16:36:30  eps
 * portability issues
 *
 * Revision 1.2  1992/01/14  15:45:03  eps
 * distribution issues
 *
 * Revision 1.1  91/07/11  12:48:33  eps
 * Initial revision
 *
 ***********************************
 $Id: err_handl.desc,v 1.3 1993/01/12 16:36:30 eps Exp $
 ***********************************/

/* KJT 29/10/04: changed to use "stdarg" instead of "varargs" */

extern char *prog_name;	/* program name (user provided) */

/* writes an error message with a NEWLINE appended
 * (if xcode is 0, returns, else exits with xcode)
 */

void	xerror (int xcode, char *msg, ...);

/* writes an error message with a NEWLINE appended, then aborts */

void	berror (char *msg, ...);

/* writes an error message and appends a NEWLINE, then exits (code 1) */

void	error (char *msg, ...);

#endif
