#ifndef fld_basic_HH
#define fld_basic_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "fld_basic.hh": FieLD BASIC functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************
 $Log: fld_basic.desc,v $
 * Revision 1.3  1993/01/12  16:36:43  eps
 * portability issues
 *
 * Revision 1.2  1992/01/14  15:45:16  eps
 * distribution issues
 *
 * Revision 1.1  91/07/11  12:49:31  eps
 * Initial revision
 * 
 ***********************************
 $Id: fld_basic.desc,v 1.3 1993/01/12 16:36:43 eps Exp $
 ***********************************/


#define ESYM	0		/* end/error symbol */
#define ESTR	NULL		/* end/error string */
#define EINT	MAXINT		/* end/error integer */

typedef char *tSYM_LST[];	/* symbol list type */

extern tSYM_LST sym_lst;	/* symbol list (user provided) */

/* returns TRUE if the string is a symbol */

#define is_sym(str)	is_word(str)

/* creates a new symbol (returns ESYM if null symbol) */

int	new_sym ();

/* returns the id number of a symbol, or ESYM if not found */

int	sym_id ();

/* returns the name of a symbol, or NULL if not found */

char *	sym_name ();

/* returns TRUE if the string is a single line one */

#define is_str(str)	is_line(str)

/* returns TRUE if the string is an integer */

int	is_int ();

#endif
