#ifndef indent_HH
#define indent_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "indent.hh": code INDENTation functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************
 $Log: indent.desc,v $
 * Revision 1.5  1993/01/12  16:36:59  eps
 * portability issues
 *
 * Revision 1.4  1992/03/04  08:34:12  eps
 * macros into functions for poor C compilers (as HP's)
 *
 * Revision 1.3  92/03/03  19:46:39  eps
 * use macro or function for HP
 *
 * Revision 1.2  92/01/14  15:45:33  eps
 * distribution issues
 *
 * Revision 1.1  91/12/02  18:56:30  eps
 * Initial revision
 *
 ***********************************
 $Id: indent.desc,v 1.5 1993/01/12 16:36:59 eps Exp $
 ***********************************/

/* KJT 29/10/04: changed to use "stdarg" instead of "varargs" */

/* default indentation increase indicator */

#define DFLT_INDT	-1

/* filling indicators for indentation advances */

#define FILL	TRUE
#define NOFILL	FALSE

typedef struct
{ int *size;
  int level;
  int limit;
  int dflt;
  int incr;
} sINDT;	/* indentation stack structure */

/* indentation stack (you mustn't use it) */
#ifndef indent_IMP
extern	sINDT _INDT;
#else
	sINDT _INDT= { NULL, 0, 0, 0, 0 };
#endif

/* initializes the indentation stack, and sets the default increase
 * (indentation is only enabled if a positive default is provided)
 */

void	init_indt ();

/* increases the indentation level */

#ifndef test_HP_bug	/* stupid HP C compilers!!! */
void	incr_indt ();

#else
void _exp_indt();

#define _incr_indt()					\
	  (_INDT.level == _INDT.limit? _exp_indt()	\
				     : NOOP(),		\
	   _INDT.size[++_INDT.level]=			\
	     _INDT.size[_INDT.level - 1] + _INDT.incr,	\
	   NOOP()					\
	  )

#define incr_indt(_incr)				\
	  (_INDT.incr= (_incr),				\
	   _INDT.dflt > 0?				\
	     (_INDT.incr < 0?				\
		(_INDT.incr= _INDT.dflt, NOOP())	\
	      : NOOP(),					\
	      _incr_indt()				\
	     )						\
	   : NOOP()					\
	  )
#endif

/* decreases the indentation level */

#ifndef test_HP_bug	/* stupid HP C compilers!!! */
void	decr_indt ();

#else
#define _decr_indt()	eval_if(_INDT.level > 0,		\
				(--_INDT.level, NOOP()))

#define decr_indt()	(_INDT.dflt > 0? _decr_indt(): NOOP())
#endif

/* indents from the current position */

void _wrt_indt();

#define _indent()	(_wrt_indt(_INDT.size[_INDT.level]))

#define indent()	(_INDT.dflt > 0? _indent(): NOOP())

/* advances the indentation while writes the text up to given increase
 * (or text length if higher), filling at end with blanks if asked for
 */

void	advc_indt (int incr, int fill, char *format, ...);

#endif
