#ifndef rec_input_HH
#define rec_input_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "rec_input.hh": RECord INPUT functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************
 $Log: rec_input.desc,v $
 * Revision 1.4  1993/01/12  16:36:51  eps
 * portability issues
 *
 * Revision 1.3  1992/05/06  17:28:20  eps
 * new function: set_fld
 *
 * Revision 1.2  92/01/14  15:45:22  eps
 * distribution issues
 * 
 * Revision 1.1  91/07/11  12:50:20  eps
 * Initial revision
 * 
 ***********************************
 $Id: rec_input.desc,v 1.4 1993/01/12 16:36:51 eps Exp $
 ***********************************/

#include "rec_basic.hh"


/* starts input of next record, or returns FALSE if cannot */

sREC *_new_rec();

#define new_rec(rec)	(((rec)= _new_rec(rec)) != NULL)

/* adds a new field to a record (returns field error if cannot) */

sFLD *_add_fld();

#define add_fld(rec, type)	(_add_fld(rec, type)->F.type)

/* sets a field and adds to a record (returns field error if cannot) */

typedef struct
{ int (*SYM)();
  char *(*STR)();
  int (*INT)();
} sSET_FLD;	/* set field structure */

int _set_sym();
char *_set_str();
int _set_int();

/* set field functions (you mustn't use it) */
#ifndef rec_input_IMP
extern	sSET_FLD _set_fld;
#else
	sSET_FLD _set_fld= { _set_sym, _set_str, _set_int };
#endif

#ifndef lint
#define set_fld(rec, type, value)	((*_set_fld.type)(rec, value))
#else
sREC *_set_rec;

#define set_fld(rec, type, value)		\
	  ((_set_rec= (rec)),			\
	   (_set_rec->fld[0].FT= type),		\
	   (_set_rec->fld[0].F.type= (value)),	\
	   ((*_set_fld.type)(_set_rec))		\
	  )
#endif
#endif
