/***********************************************
 (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************************
 $Log: report.c,v $
 * Revision 2.5  1993/06/15  11:03:24  eps
 * is a LINTLIBRARY
 *
 * Revision 2.4  1993/01/12  16:35:45  eps
 * portability issues
 *
 * Revision 2.3  1992/01/14  15:44:03  eps
 * distribution issues
 *
 * Revision 2.2  92/01/14  15:27:18  eps
 * adapt to case independent cast
 * 
 * Revision 2.1  90/10/30  08:45:16  eps
 * plenty of small fixes:
 * visit, new classes, integrated tree traversal for evaluation, ...
 * 
 * Revision 1.3  90/03/16  16:53:13  eps
 * cosmetics
 * 
 * Revision 1.2  90/01/29  14:57:28  eps
 * fixing license details
 * 
 * Revision 1.1  90/01/25  19:54:35  eps
 * Initial revision
 * 
 **********************************************/

/* LINTLIBRARY */

#ifndef lint
static char rcsid[]= "$Id: report.c,v 2.5 1993/06/15 11:03:24 eps Exp $";
#endif

# include <stdio.h>
# include "rag.hh"

PUBLIC int ragerrors= 0;
PUBLIC ST* SymbolTable= NULL;

PUBLIC void
report (node, attr_line)
     TNODE* node;
     int attr_line;
{
  TNODE* initial= node;
  TATTR* attr= NULL;
  int* where;
  int sline;
  char* sname;

  if (node != NULL)
    while ((attr= find_attr (attr_line, node)) == NULL)
      if (node->sons != NULL)
	node= node->sons;
      else {
	while (node != initial &&
	       node->brothers == NULL)
	  node= node->father;
	if (node == initial)
	  break;
	else
	  node= node->brothers;
      }
  if (SymbolTable == NULL) {
    if (attr == NULL)
      (void) fprintf (stderr, "???: ");
    else
      (void) fprintf (stderr, "%d: ", (int) attr->value);
  }
  else {
    if (attr == NULL)
      (void) fprintf (stderr, "???: ");
    else {
      where= (int*) attr->value;
      sline= where[0];
      sname= SymbolTable->data[where[1]];
      (void) fprintf (stderr, "%s:%d: ", sname, sline);
    }
  }
  ragerrors++;
}
