/******************************************************************
 *  (C) Copyright 1994; dit/upm
 *  Distributed under the conditions stated in the
 *  TOPO General Public License (see file LICENSE)
 ******************************************************************
 *  $Log$
 ******************************************************************/

#ifndef lint
static char rcsid[]= "$Id$";
#endif

/******************************************************************
 *  
 *  Santiago Pavon Gomez
 *
 *  30 Nov 1990
 *
 *  Elements used in lotos specifications
 *  
 *  COMPILATION FLAGS:
 *  
 *  LOG:
 *
 ******************************************************************/

/* LINTLIBRARY */


#include "badefca.h"
#include "licell.h"
#include "limisc.h"
#include "babeh.h"
#include "baattr.h"
#include "batables.h"


/******************************************************************
 *                                                                *
 *        Definition of the basic cell and attributes types       *
 *                                                                *
 ******************************************************************/
/* InitLotosK
 * Init the module cell with LOTOS values.
 */
void InitLotosK()
{
  InitCell();
  
  /* LOTOS semantics' Operators */
  
  DeclareCell(RelabellingC  ,"RelabellingC",    (char*(*)())NULL);
  DeclareCell(HidingC       ,"HidingC",         (char*(*)())NULL);
  DeclareCell(ChoiceC       ,"ChoiceC",         (char*(*)())NULL);
  DeclareCell(PletC         ,"PletC",           (char*(*)())NULL);
  DeclareCell(LetC          ,"LetC",            (char*(*)())NULL);
  DeclareCell(EnablingC     ,"EnablingC",       (char*(*)())NULL);
  DeclareCell(DisablingC    ,"DisablingC",      (char*(*)())NULL); 
  DeclareCell(ParallelC     ,"ParallelC",       (char*(*)())NULL);
  DeclareCell(AlternativeC  ,"AlternativeC",    (char*(*)())NULL);
  DeclareCell(GuardC        ,"GuardC",          (char*(*)())NULL);
  DeclareCell(GateC         ,"GateC",           GetG_name);
  DeclareCell(IC            ,"IC",              (char*(*)())NULL);
  DeclareCell(ExitC         ,"ExitC",           (char*(*)())NULL);
  DeclareCell(StopC         ,"StopC",           (char*(*)())NULL);
  DeclareCell(ProcessInstC  ,"ProcessInstC",    GetP_name);
  DeclareCell(ProcessDefC   ,"ProcessDefC",     GetP_name);
  DeclareCell(SpecificationC,"SpecificationC",  GetP_name);
  DeclareCell(GateChoiceC   ,"GateChoiceC",     (char*(*)())NULL);
  DeclareCell(ParC          ,"ParC",            (char*(*)())NULL);

#ifdef TIME  
  DeclareCell(TletC          ,"TletC",            (char*(*)())NULL);
#endif 

  
  /* Auxiliary cells */
  
  DeclareCell(BehaviourC    ,"BehaviourC",      (char*(*)())NULL);
  
  
  /* Interleaved Expansion cell definitions */
  
  DeclareCell(InterleavedC  ,"InterleavedC",    (char*(*)())NULL);
  DeclareCell(TerminationC  ,"TerminationC",    (char*(*)())NULL);
  DeclareCell(ContSetC      ,"ContSetC",        (char*(*)())NULL);
  
  
  /* LOTOS Attributes */
  
  DeclareAttr(GLA  ,"GL",   DrawGL,    FreeGL,
	      (AttrValueTyp(*)()) CopyGL,
	      (AttrValueTyp(*)()) EchoInt);
  DeclareAttr(GSA  ,"GS",   DrawGS,    FreeGS, 
	      (AttrValueTyp(*)()) CopyGS,
	      (AttrValueTyp(*)()) EchoInt);
  DeclareAttr(PA   ,"P",    PrintPred, FreePred,  
	      (AttrValueTyp(*)()) CopyPred,
	      (AttrValueTyp(*)()) UnsharePred);
  DeclareAttr(ELA  ,"EL",   PrintEL,   FreeEL, 
	      (AttrValueTyp(*)()) CopyEL,
	      (AttrValueTyp(*)()) UnshareEL);
  DeclareAttr(OLA  ,"OL",   PrintOL,   FreeOL, 
	      (AttrValueTyp(*)()) CopyOL,
	      (AttrValueTyp(*)()) UnshareOL);
  DeclareAttr(RFLA ,"RFL",  PrintRFL,  FreeRFL,
	      (AttrValueTyp(*)()) CopyRFL,
	      (AttrValueTyp(*)()) EchoInt);
  DeclareAttr(VALA ,"VAL",  PrintVAL,  FreeVAL,
	      (AttrValueTyp(*)()) CopyVAL,
	      (AttrValueTyp(*)()) UnshareVAL);
  DeclareAttr(GDLA ,"GDL",  PrintGDL,  FreeGDL, 
	      (AttrValueTyp(*)()) CopyGDL,
	      (AttrValueTyp(*)()) EchoInt);
  
  
  /* Interleaved Expansion attr's definitions */
  
  DeclareAttr(ITCLA,"ITCL", PrintITCL, FreeITCL,
	      (AttrValueTyp(*)()) CopyITCL,
	      (AttrValueTyp(*)()) EchoInt);
  DeclareAttr(BHT1A,"BHT1", (void (*)())VoidF, (void (*)())Free_HT,
	      (AttrValueTyp(*)())VoidF,
	      (AttrValueTyp(*)())VoidF);
  DeclareAttr(BHT2A,"BHT2", (void (*)())VoidF, (void (*)())Free_HT, 
	      (AttrValueTyp(*)())VoidF,
	      (AttrValueTyp(*)())VoidF);
  
  
  /* Debugging-Purpose attributes */
  
  DeclareAttr(STA  ,"ST",   PrintST,   FreeST, 
	      (AttrValueTyp(*)()) CopyST,
	      (AttrValueTyp(*)()) EchoInt);
  DeclareAttr(SSLA ,"SSL",  PrintSSL,  FreeSSL,
	      (AttrValueTyp(*)()) EchoInt,
	      (AttrValueTyp(*)()) EchoInt);
  
  /* Time attribute */
#ifdef TIME  
  DeclareAttr(TA ,"TIME",  PrintT,  FreeT,
              (AttrValueTyp(*)()) CopyT,
	      (AttrValueTyp(*)()) UnshareT);
#endif   

}

/*----------------------------------------------------------------*/





