/******************************************************************
 *  (C) Copyright 1994; dit/upm
 *  Distributed under the conditions stated in the
 *  TOPO General Public License (see file LICENSE)
 ******************************************************************
 *  $Log$
 ******************************************************************/

#ifndef lint
static char rcsid[]= "$Id$";
#endif

/******************************************************************
 *  
 *  Juan Carlos Berrocal Colmenarejo
 *  David Larrabeiti Lopez
 *
 *  17 Mar 1991
 *
 *  Management of variable assignment lists.
 *  
 *  COMPILATION FLAGS:
 *  
 *  LOG:
 *
 ******************************************************************/

/* LINTLIBRARY */

/* KJT 12/02/12: Added */
#include <stdlib.h>
#include "baattr.h"
#include "limisc.h"
#include "listrbk.h"

/******************************************************************
 *                                                                *
 *          GDLA -> Gate Declaration List (GateDecListTyp)        *
 *                                                                *
 ******************************************************************/


static int new_gd_count      = 0;
static int released_gd_count = 0;
static int max_gd_count      = 0;

/*----------------------------------------------------------------*/

/* InitGD
 * Init this module
 */
void InitGD()
{
#ifdef SDEBUG
  new_gd_count      = 0;
  released_gd_count = 0;
  max_gd_count      = 0;
#endif
}

/*----------------------------------------------------------------*/

/* StatGD
 * new      : number of cell queries the system has granted this module with.
 * released : number of cell releases.
 * max      : max number of cells hold on by this module till now.
 */
void StatGD( new, released, max )
     int * new, *released, *max;
{
  *new      = new_gd_count;
  *released = released_gd_count;
  *max      = max_gd_count;
}

/*----------------------------------------------------------------*/

/* NewGateDec
 * Get memory for a new gate declaration struct
 */
static PGateDecTyp NewGateDec()
{
  PGateDecTyp p;
  
#ifdef SDEBUG
  new_gd_count++;
  max_gd_count=MAX( max_gd_count, new_gd_count-released_gd_count );
#endif
  p      = (PGateDecTyp)NewCellM(sizeof(GateDecTyp));
  p->agl = NULL;
  p->fgs = NULL;
  return p;
}  

/*----------------------------------------------------------------*/

/* DispGateDec
 * Free the memory used by a gate declaration struct
 */
static void DispGateDec(gd)
     PGateDecTyp gd;
{
  FreeCellM((void*)gd,sizeof(GateDecTyp));
#ifdef SDEBUG
  released_gd_count++;
#endif
}

/*----------------------------------------------------------------*/

/* StatisticGDL
 * Return the number of list nodes (n) used in the gate list, and
 * the number of gate sets (gs) used in the declaration list gdl.
 */
void StatisticGDL( gdl,n,gs )
     GateDecListTyp  gdl;
     int            *n, *gs; 
{
  PGateDecTyp gd;
  
  *n  = 0;
  *gs = 0;
  while (gdl != NULL) {
    (*n)++;
    gd  = (PGateDecTyp)LookInfo_list(gdl);
    *n += Length_list(gd->agl);
    (*gs)++;
    gdl = Next_list(gdl);
  }
}

/*----------------------------------------------------------------*/

/* MakeGD
 * Make a gate declaration with agl and fgs.
 */
PGateDecTyp MakeGD( agl, fgs )
     GateListTyp agl;
     GateSetTyp  fgs;
{
  PGateDecTyp gd;
  
  gd      = NewGateDec();
  gd->agl = agl;
  gd->fgs = fgs;
  return gd;
}

/*----------------------------------------------------------------*/

/* FreeGD
 * Free the memory used by the gate declaration
 */
void FreeGD( gd )
     PGateDecTyp gd; 
{
  FreeGS(gd->fgs);
  FreeGL(gd->agl);
  DispGateDec(gd);
}

/*----------------------------------------------------------------*/

/* CopyGD
 * Copy the gate declaration gd
 */
PGateDecTyp CopyGD( gd )
     PGateDecTyp gd;
{
  PGateDecTyp ngd;
  
  ngd      = NewGateDec();
  ngd->agl = CopyGL(gd->agl);
  ngd->fgs = CopyGS(gd->fgs);
  return ngd;
}

/*----------------------------------------------------------------*/

/* SPrintGD
 * Make a string with the gate declaration gd.
 */
char * SPrintGD( gd )
     PGateDecTyp gd;
{
  char * str;
  StrBckTyp strBck;
  
  str     = SPrintGS(gd->fgs);
  strBck  = ConcatStrBck( CreateStrBck(), str );
  free(str);
  strBck  = ConcatStrBck( strBck, " in [" );
  str     = SPrintGL( gd->agl );
  strBck  = ConcatStrBck( strBck, str );
  free(str);
  strBck  = ConcatStrBck( strBck, "]" );
  str = GetStrStrBck( strBck) ;
  FreeStrBck( strBck );
  
  return str;
}

/*----------------------------------------------------------------*/

/* CreateGDL
 * Create an empty gate declaration list.
 */
GateDecListTyp CreateGDL()
{
  return Create_list();
}

/*----------------------------------------------------------------*/

/* FreeGDL
 * Free the memory used by the gate declaration list gdl
 */
void FreeGDL( gdl )
     GateDecListTyp gdl; 
{
  Free_list(gdl,FreeGD);
}

/*----------------------------------------------------------------*/

/* CopyGDL
 * Copy the gate declaration list gdl
 */
GateDecListTyp CopyGDL( gdl )
     GateDecListTyp gdl; 
{ 
  return Copy_list(gdl,(DataListTyp(*)())CopyGD);
}

/*----------------------------------------------------------------*/

/* SPrintGDL
 * Make a string with the gate declaration list gdl
 */
char * SPrintGDL( gdl )
     GateDecListTyp gdl;
{
  LASSERT(gdl!=NULL);
  return SPrint_list( gdl, SPrintGD );
}

/*----------------------------------------------------------------*/

/* PrintGDL
 * Print the gate declaration list gdl.
 * pstr is the function used to print strings.
 */
void PrintGDL( gdl, pstr )
     GateDecListTyp gdl;
     void           (*pstr)(); 
{
  char * str;
  
  LASSERT(gdl!=NULL);
  str = SPrintGDL( gdl );
  pstr(str);
  (void)free(str);
}

/*----------------------------------------------------------------*/

/* AddGDL
 * Add the gate declaration gd to the gate declaration list gdl
 */
GateDecListTyp AddGDL( gd, gdl )
     PGateDecTyp    gd;
     GateDecListTyp gdl; 
{
  return Add_list((DataListTyp)gd,gdl);
}

/*----------------------------------------------------------------*/

/* InsertGDL
 * Insert the gate declaration gd into the gate declaration list gdl
 */
GateDecListTyp InsertGDL( gd,gdl )
     PGateDecTyp gd;
     GateDecListTyp gdl; 
{ 
  return Insert_list((DataListTyp)gd,gdl); 
}

/*----------------------------------------------------------------*/

/* EqualGD
 * Decide if 2 gate declarations are equal.
 */
boolean EqualGD( gd1, gd2 )
     PGateDecTyp gd1,gd2;
{
  return ( EqualGL( gd1->agl, gd2->agl) && EqualGS( gd1->fgs, gd2->fgs ) );
}

/*----------------------------------------------------------------*/

/* EqualGDL
 * Decide if 2 gatedec lists are equal.
 */
boolean EqualGDL( gdl1, gdl2 )
     GateDecListTyp gdl1,gdl2;
{
  return Equal_list( gdl1, gdl2, EqualGD );
}

/*----------------------------------------------------------------*/




