/******************************************************************
 *  (C) Copyright 1994; dit/upm
 *  Distributed under the conditions stated in the
 *  TOPO General Public License (see file LICENSE)
 ******************************************************************
 *  $Log$
 ******************************************************************/

/******************************************************************
 
  Author  Gualberto Rabay 
	  David Larrabeit 
	   

  24 Mar 1994

  Title
  
  This module defines  the Time Attribute and functions to manage it. 


 ******************************************************************/
#ifdef TIME

#ifndef batime_H
#define batime_H

#include "listdh.h"
#include "lilists.h"
#include "lihash.h"
#include "babeh.h"
#include "baexpr.h"


/*
 *   Time Type definition
 */
typedef struct { ExprTyp tvar;
                 ExprTyp upper_bound;
		 ExprTyp lower_bound;
	       } TimeTyp, *PTimeTyp;

/* StatTime
 * Give statistics about the time cells allocated and released.
 * uc  : number of time cell queries originated by this module. 
 * rc  : time cell releases.
 * mc  : max used time cells
 */ 
void StatTime(/*  nc, rc, mc */);
 /*  int * nc, *rc, *mc; */ 


/* InitT 
 *  Call TranslateTime to eliminate the "time" gates from spec
 *  and to add time attributes to other gates 
 */
extern void InitT();

/* NewT 
 * Create an  empty time structure   
 */
extern PTimeTyp NewT();

/* MakeT  
 * Create and  initialize a time structure
 * t0 is the time variable, t1 is the lower bound, 
 * t2 is the upper bound 
 */
extern  PTimeTyp MakeT(/* t0, t1, t2 */);
/* ExprTyp t0,t1,t2 ;  */ 


/* PT 
 * Print the time - used for debuging  purpose 
 */ 
void PT (/* t */); 
/* PTimeTyp   t; */ 

/* PrintT
 * Print the time 
 * pstr is the function used to print strings
 */
extern void PrintT(/* t, pstr */);
/* TimeTyp t  ;
   void  (* pstr)();  */ 

/* SPrintT
 * Return a char string with the time bounds
 */
extern char *  SPrintT(/* t */);
   /* TimeTyp t;  */ 


/* DispT
 * Free the memory used by the time cell t
 */
extern void DispT(/* t */);
/*  PTimeTyp t; */


/*  FreeT
 *  Free the memory used by the time attribute t.
 */
extern  void  FreeT ( /* t */ ); 
/* TimeTyp t; */ 


/* CopyT
 * Copy the time attribute t 
 */
extern  PTimeTyp  CopyT(/* t */); 
   /* PTimeTyp t;  */ 

/* UnshareT
 * Decrement the share counter of all expressions contained in the time cell
 */
extern PTimeTyp UnshareT(/* t */);
 /* PTimeTyp    t;   */ 


/* TranslateTime
 *  Apply the translation from time actions to time attribute 
 *  over the whole specification 
 */ 
extern void TranslateTime();

/* DeleteT 
 * Remove the "time" gates from the spec and processes gate lists 
 */ 
extern void DeleteT(/* b */);
/* BehTyp b */ 


/* InterT 
 * Check if there is a intersection between two time intervals
 */
extern ExprTyp InterT (/* t1,t2 */);
/* PTimeTyp t1,t2 */


/* LowerT
 * Calculate the greatest lower bound between time intervals t1 and t2 
 */
extern ExprTyp LowerT (/* t1, t2 */);
/* PTimeTyp t1,t2 */


/* UpperT
 * Calculate the least upper bound between time intervals t1 and t2 
 */
extern ExprTyp UpperT  (/* t1, t2 */);
/* PTimeTyp t1,t2 */



/* IsGt  
 * Test if time instant t1  is gt than time instant t2
 */
extern boolean IsGt(/* t1,t2 */);
/*  ExprTyp t1,t2;  */


/* IsGe  
 * Test if t1 is greater  than or equal to  t2 
*/
extern boolean IsGe (/* t1, t2 */);
/*  ExprTyp t1,t2;  */

/* AgeGateT 
 * Age the time attribute of a gate
 * return false if time attribute is lesser than age value 
 */ 
extern boolean AgeGateT ( /* e,b */);
/*  ExprTyp e;
    BehTyp  b;    */


/* Age1T  
 *  Age  Behaviour b with "e"  units of time
 */
extern void Age1T(/* e, b */);
/* ExprTyp e; 
   BehTyp b;    */


/* ChoiceT 
 * Construct  a choice with guards from time attributes
 * For instance:   
 *      choice time:nat [] [t1 le time]->[time le t2]-> 
 */ 
extern BehTyp ChoiceT (/* td, t1,t2, */);
/*  DescriptorTyp td;
    PTimeTyp t1,t2  ;  */


/* AsapT 
 *  Apply the asap semantics  to behaviour b 
 */ 
extern BehTyp AsapT( /* b */ );
/* BehTyp  b;  */ 

 
/* MinT 
 * Calculate the minimal lower bound of  the i gates  from behaviour b
 */
extern void MinT (/* tmin, b */) ; 
/* BehTyp  b; 
   ExprTyp *tmin;  */ 



/* CutAsapT
 * Transform into Stop those branches that do not conform with the time 
 * constraints
 */ 
extern void CutAsapT (/* tmin, b */);
/* ExprTyp tmin;   
   BehTyp  b;  */


/* AgeLet 
 * Age assignments of time variables in let expressions 
 */ 
extern PAttrTyp AgeLet (/* e1,time,vala */);
/*  PAttrTyp         vala;
    PTimeTyp time ;
    ExprTyp e1;   */

/* Subst_TA_SV 
 * Substitute  variables of time attributes that are in the SV table
 */
extern void Subst_TA_SV(/* time, td */);
/*   PTimeTyp     time;
 *    SVdescriptorTyp  *td;
 */ 

/* TLetProc 
 * Move the operator tlet through the tree. Works like LetProc but 
 * it is removed whenever a gate is found, i.e. it does not propagate. 
 */
extern BehTyp TLetProc(/*  b, vala, sv */);
/*  BehTyp           b;
    PAttrTyp         vala;
    SVdescriptorTyp *sv;  */

#endif 
#endif
