/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  Santiago Pavon Gomez
  
  27 March 1990
  
  Reads files with LOTOS specifications in the EPS (El Prado System) format
  and fills the internal data structures of the module BA to represent this
  specification.
  
  COMPILATION OPTIONS: The behaviour of this module can be modified
  by the following compilation flags:
  
  SDEBUG : activate depuration mode
  
  TYPE DEFINITIONS:
  
  
  FUNCTION DEFINITIONS:
  
  InitTR   : initiation of TR module.
  LoadSpec : load a LOTOS specification.
  
  ************************************/


#ifndef TRtranslator_H
#define TRtranslator_H

#include "babeh.h"


/* InitTR
 * Initiation of TR module.
 * This function must be only called when lola is invoked.
 */
extern void InitTR();



/* LoadSpec
 * Translate and loads a LOTOS specification.
 * name is the name of the spec_file.
 */
extern BehTyp  LoadSpec ( /* name */ );
/* char * name; */


#endif
