/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  David Larrabeiti Lopez
  
  15-02-91
  
  Disabling operator one-level expansion.
  
  Expansion of the Disabling behaviour b.
  
  b = b1 [> b2
  
  where b1 is a 1-immediate behaviour.
  
  
  COMPILATION OPTIONS: The behaviour of this module can be modified
  by the following compilation flags:
  
  (none)
  
  ************************************/

#include "limisc.h"
#include "licell.h"
#include "badefca.h"
#include "eximmed.h"
#include "expre_br.h"

/*----------------------------------------------------------------*/

static BehTyp beh2,beh2p,out;

static BehTyp Disabling_Expand_Branch( branch )
     BehTyp branch;
{
  BehTyp act,bi,disabling;
  CellTypeTyp type;
#ifdef TIME 
  PTimeTyp time;
  PAttrTyp ta;
  BehTyp   act2;  
  DescriptorTyp  tvar; 
  ExprTyp e1;
#endif 
  
  
  act  = LookActionUB( branch ); 

  type = LookTypeB( act );
  if ( type!=ExitC ) {
    if ( type==StopC ) {
      FreeB( branch );
      return NULL;
    }
    
    if ( type==TerminationC )
      return act;
#ifdef TIME
    act2 = CopyUntilActB( beh2p);
    ShareB(act2);
    UnshareAttrsUntilActB (act2);
    UnshareB(act2);
    ta= LookA(LookActionUB(act),TA);
    time = (PTimeTyp)LookAInfo(ta);
    if (!EqualE( time->lower_bound, time->upper_bound) && 
	(time->tvar ==NULL)){
      if ((tvar=FindV("time", FindS("time")))==0)
	tvar = Declare_var("time",FindS("time"));
      else 
	tvar = EqualV_entry(tvar);
      e1 =  MakeE(tvar,VariableC);
      time = (PTimeTyp)GetAInfo(ta);
      time->tvar = ShareE(e1);
      PutAInfo(ta,(AttrValueTyp) time);
      Age1T(e1,act2);
    }
    else if   ( (time->tvar !=NULL) && 
	       (!IsConstE(time->tvar)))
      Age1T(time->tvar,act2) ;
    else
      Age1T(time->lower_bound,act2);
    bi        = GetArgB( act, 1 );
    disabling = MakeB( 0, DisablingC );
    PutArgB( act, disabling, 1 );
    PutArgB( disabling, bi, 1 );
    PutArgB( disabling,act2, 2 );
    return branch;
#else     /* timeless LOLA */
 
    bi        = GetArgB( act, 1 );
    disabling = MakeB( 0, DisablingC );
    PutArgB( act, disabling, 1 );
    PutArgB( disabling, bi, 1 );
    PutArgB( disabling, beh2p, 2 );
#endif 
    
  }
  return branch;
}


/* Disabling_Expand
 * Expansion of a Disabling behaviour b.
 *
 *      b = beh1 [> beh2
 *
 * where beh1,beh2 are one-immediate behaviours and
 *       beh2 = Exp(b2) if IS_PRE_PROC_EXP
 */
BehTyp Disabling_Expand( b, b2 )
     BehTyp b,b2;
{
  int    NumArg,i=0;
  BehTyp beh1;
  
  LASSERT( LookTypeB(b)==DisablingC );
  
  out  = NULL;
  beh1 = GetArgB(b,1);
  beh2 = GetArgB(b,2);
  
  if ( IS_NOT_PRE_PROC_EXP ){
    beh2p = b2; 
  }
  else 
    beh2p = beh2;
  
  FreeB(b);
  
  NumArg = NumArgIB(beh1);
  for ( i=1; i<=NumArg; i++ )
    out = AppendUB( out, Disabling_Expand_Branch( GetArgIB(beh1,i) ) );
  
  if (NumArg>1)
    FreeB(beh1);                           /* Frees the old tree */
  
  if ( IS_NOT_PRE_PROC_EXP )
    FreeB(beh2p);
  
  beh2 = GetUntilActB(beh2);
  return AppendUB( out, beh2 );
  
}



