/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  David Larrabeiti Lopez
  
  5-3-1991
  
  Module to detect & manage duplicated behaviours
  through a HashTable.
  
  The elements used are cells like this:
  
  BehaviourC
  name
  copy
  B1   B2
  
  where B2 is the behaviour to be processed,
  and   name:=-1|BehHashKey(B2);
  
  COMPILATION OPTIONS: The behaviour of this module can be modified
  by the following compilation flags:
  
  TYPE DEFINITIONS:
  DupBehListsTyp, PDupBehListsTyp : formal variables lists and actual
  expressions lists of the new process.
  
  FUNCTION DEFINITIONS:
  BehHashKey : behaviour hash key except for variables names
  InitHashBehDef : initializes the behaviour hash table
  GetHashBehDef : saves a behaviour in the behaviour hash table or
  returns the duplicate behaviour of it (when found) 
  FreeHashBehDef : frees a behaviour hash table
  PrintHashBehDef : prints the behaviour hash table
  StatHashBehDef : statistics on behaviour hash table occupation
  
  ************************************/


#ifndef EXdupbeh_H
#define EXdupbeh_H

#include "lihash.h"
#include "baattr.h"


typedef struct { ExprListTyp DupBehForVL;
		 ExprListTyp DupBehActEL1;
		 ExprListTyp DupBehActEL2;
	       } *PDupBehListsTyp,DupBehListsTyp;

typedef HashDTyp BehHashTabTyp;


/* BehHashKey
 * Calculates the hash key of the behaviour beh.
 */
extern int BehHashKey(/* beh */);
/*     BehTyp beh;*/



/* InitHashBehDef
 * Inits the behaviour hash table. 
 * It must be called whenever an expansion with duplicated behaviour 
 * detection is going to be performed.
 * size is the number of slots.
 * If owner is TRUE the behaviours in the tables are owned by the hash table
 *    so that they will be freed with FreeB in FreeHashBehDef.
 * otherwise
 *    no behaviour release will be done.
 */
extern BehHashTabTyp InitHashBehDef(/* size, owner */);
/*       int size;
         boolean owner; */


/* GetHashBehDef
 * Looks for a duplicated behaviour of beh.
 * If it does exist then returns the duplicated behaviour and the
 * expression and variable list needed to make the instantiations.
 * If beh has not a duplicated behaviour it is inserted in the table 
 * and NULL is returned.
 */
extern BehTyp GetHashBehDef( /* bhtd, beh, dblPt */ );
/* BehHashTabTyp   bhtd;
   BehTyp          beh;
   PDupBehListsTyp dblPt;*/


/* FreeHashBehDef
 * Frees the hash table.
 * It must be called when the expansion has finished.
 */
extern void FreeHashBehDef(/* bhtd */);
/* BehHashTabTyp   bhtd; */


/* PrintHashBehDef
 * Prints the duplicated behaviour hash table.
 */
extern void PrintHashBehDef(/* bhtd */);
/* BehHashTabTyp   bhtd; */


/* StatHashBehDef
 * Displays statistics about table occupation and collisions.
 */
extern void StatHashBehDef(/* bhtd */);
/* BehHashTabTyp   bhtd; */


#endif


