/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  Santiago Pavon gomez
  
  7 March 1991
  
  Expansion Post Processing
  
  COMPILATION OPTIONS: The behaviour of this module can be modified
  by the following compilation flags:
  
  (none)
  
  TYPE DEFINITIONS:
  
  (none)
  
  FUNCTION DEFINITIONS:
  RmAltStopInBeh : removes stop alternatives from a behaviour
  ClearBeh : BehaviourC-typed cells removal after expansion and freeexp
  PClearBeh : BehaviourC-typed cells removal and unparameterization
  after parameterized expansion 
  
  ************************************/


#ifndef EXpost_expan_H
#define EXpost_expan_H


#include "babeh.h"


/* RmAltStopInBeh
 * Explores the behaviour b and removes the stop alternatives.
 */
extern BehTyp RmAltStopInBeh( /* b */ );
/* BehTyp b; */


/* ClearBeh
 * Post-processing applied to the expanded behaviour and duplicated processes
 * after the expansion or free_expansion
 * The auxiliary cells of type BehaviourC are removed from the tree.
 * Predicates are converted to LOTOS format.
 */
extern void ClearBeh ( /* ptr */ );
/* BehTyp ptr; */


/* PClearBeh
 * Post Processing after the parameterized expansion.
 * The parameterization is removed and the expressions are rewritten.
 */
extern void PClearBeh( /* b,lastproc */ );
/* BehTyp        b; 
   DescriptorTyp lastproc; */


#endif

