
/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ERROR = 258,
     NUM = 259,
     BRANCH = 260,
     POSIC = 261,
     ROOT = 262,
     REWRITE = 263,
     PRINT = 264,
     LOAD = 265,
     IDENT = 266,
     SAVE = 267,
     DATA = 268,
     STAT = 269,
     EXPAND = 270,
     FREE = 271,
     VAR = 272,
     TEST = 273,
     ONE = 274,
     IT = 275,
     MOVE = 276,
     STEP = 277,
     QUIT = 278,
     HELP = 279,
     SET = 280,
     CMD = 281,
     PI = 282,
     VCNR = 283,
     K = 284,
     VC = 285,
     OF = 286,
     EXIT = 287,
     MENU = 288,
     UNDO = 289,
     TRACE = 290,
     SYNC = 291,
     STEPHELP = 292,
     REFUSED = 293,
     SELECT = 294,
     OPT_A = 295,
     OPT_B = 296,
     OPT_C = 297,
     OPT_D = 298,
     OPT_E = 299,
     OPT_G = 300,
     OPT_I = 301,
     OPT_O = 302,
     OPT_P = 303,
     OPT_Q = 304,
     OPT_S = 305,
     OPT_T = 306,
     OPT_U = 307,
     OPT_V = 308,
     OPT_X = 309,
     OPT_Y = 310
   };
#endif
/* Tokens.  */
#define ERROR 258
#define NUM 259
#define BRANCH 260
#define POSIC 261
#define ROOT 262
#define REWRITE 263
#define PRINT 264
#define LOAD 265
#define IDENT 266
#define SAVE 267
#define DATA 268
#define STAT 269
#define EXPAND 270
#define FREE 271
#define VAR 272
#define TEST 273
#define ONE 274
#define IT 275
#define MOVE 276
#define STEP 277
#define QUIT 278
#define HELP 279
#define SET 280
#define CMD 281
#define PI 282
#define VCNR 283
#define K 284
#define VC 285
#define OF 286
#define EXIT 287
#define MENU 288
#define UNDO 289
#define TRACE 290
#define SYNC 291
#define STEPHELP 292
#define REFUSED 293
#define SELECT 294
#define OPT_A 295
#define OPT_B 296
#define OPT_C 297
#define OPT_D 298
#define OPT_E 299
#define OPT_G 300
#define OPT_I 301
#define OPT_O 302
#define OPT_P 303
#define OPT_Q 304
#define OPT_S 305
#define OPT_T 306
#define OPT_U 307
#define OPT_V 308
#define OPT_X 309
#define OPT_Y 310




/* Copy the first part of user declarations.  */
#line 1 "inparser.y"

  /***********************************
    (C) Copyright 1992-1993; dit/upm
    Distributed under the conditions stated in the
    TOPO General Public License (see file LICENSE)
    ***********************************/

  /***********************************

    Santiago Pavon Gomez

    25-07-1990

    Command Interpreter
    Parser of value expressions
    main program

    ************************************/


#include "inparser.h"
#include "listdh.h"
#include "listdout.h"
#include "ligetlin.h"
#include "limisc.h"
#include "batables.h"
#include "bainit.h"
#include "bamove.h"
#include "inhelp.h"
#include "batransl.h"
#include "badefca.h"
#include "incomm.h"
#include "ststep.h"
#include "ie_vc.h"
#include "ie_nrec.h"
#include "ie_k.h"
#include "baprint.h"
#include "basust_v.h"

/* KJT 22/01/23: added function prototypes */
int yylex();

  /******************************************************************
   *
   *      Types to specify movements
   *
   ******************************************************************/


  /* Types of movements */
#define POSITION 1
#define STRING 2
#define CHAR 3


  /* mvrelTyp
   * Position structure like 1b, 3u, etc...
   */
  typedef struct { int  num;
		   char mov;
		 } mvrelTyp ;


  /* mvTyp
   * Structure for the three diferents kinds of hight level
   * movements.
   */
  typedef union { char     *proc;
		  mvrelTyp  mvrel;
		  char      root;
		} mvTyp;


  /* moveTyp
   * Structure for the three diferents kinds of hight level
   * movements with its type in each case.
   */
  typedef struct { mvTyp mv;
		   int   mvType;
		 } moveTyp;



  /******************************************************************
   *
   *  Syntactical and lexical analyser
   *
   *******************************************************************/

  /* MAX_LINE
   * Maximum characters number of a commands input line and a string type.
   */
#define MAX_LINE BUF_SIZE

  /* YYMAXDEPTH
   * Maximum parsing depth. ( yacc default = 150 )
   * The memory requested by the parser is YYMAXDEPTH x MAXLINE
   */
#define YYMAXDEPTH 300

  /* MAX_ARGS
   * Maximum number of elements in a list.
   */
#define MAX_ARGS MAX_GATE_TABLE

  /* MAX_OPTS
   * Maximum number of options in a command.
   */
#define MAX_OPTS 128

  /* MAX_MOVE
   * Maximum number of move commands in a command line.
   */
#define MAX_MOVE 32


  /* PRINT_DEPTH
   * Default print depth is:
   *     1 in STEP mode
   *     UNDEFINED otherwise
   */
#define PRINT_DEPTH (lex_mode==STEPLEXMODE ? 1 : UNDEFINED)


  /* InputLineIsEmpty
   * This variable is set to true when the input line is only '\n'.
   * This variable must be set to FALSE before calling to yyparse.
   */
  static boolean InputLineIsEmpty;


  static int numMove;
  static int numOpc;
  static int numGate;

  static char str_empty[1] = { '\0' };

  static ListTyp createdExpCell = NULL;
  static DescriptorTyp expectedSort = 0;

  /*----------------------------------------------------------------*/

  /* KJT 21/08/07: moved from earlier */

  /* lex_mode
   * mode of lex: CMDLEXMODE, NUMLEXMODE, EXPLEXMODE, STEPLEXMODE
   */
  #define CMDLEXMODE  0
  #define NUMLEXMODE  1
  #define EXPLEXMODE  2
  #define STEPLEXMODE 3
  static int lex_mode;

  /* KJT 21/08/07: moved from earlier */
  static boolean ResError,changes;
  static char ResErrorMsg[100];

  /******************************************************************
   *
   *  Values set by parser. They are used by Code()
   *
   *******************************************************************/

  typedef struct { char          *name;
		   ListTyp       pos_dname;
		   boolean       infix;
		   DescriptorTyp dsort;
		   ListTyp       argl;
		 } ExpCellTyp,*PExpCellTyp;

  /*----------------------------------------------------------------*/

  /* KJT 21/08/07: function prototype definitions */
  static PExpCellTyp NewExpCell();
  static ExprTyp ResExpr(PExpCellTyp c);
  static void FreeExpCell();

  /******************************************************************
   *
   *  Values sets by parser. They are used by Code()
   *
   *******************************************************************/

  static ExprTyp expr_rw;

  static char *success_event, *process_name, *expected_response;

  static boolean default_success_event;

  static char *env_variable, *env_value;

  static int branch;

  static char *command_name;

  static char *outfile_name;

  static char option;
  static int  low_limit, high_limit;

  static char *optionList;
  static int  lengthOpcList;

  static int depth;
  static int seed;
  static int one_execs;
  static int verbose_level;
  static int undos_num;

  static int bhsize, percentage;

  static moveTyp movement_tab[MAX_MOVE];
  static int     num_mov;

  static char *gate_list1[MAX_ARGS];
  static int  numGate1;
  static char *gate_list2[MAX_ARGS];
  static int  numGate2;

  static char *cmd_file;
  static int command_token;

  static ListTyp number_list;

  /*----------------------------------------------------------------*/

#define OPT_ERR  1
#define CMD_ERR  2
#define EXPR_ERR 3

  static int what_error = 0;

/* KJT 22/01/23: added "void" type */
void yyerror(msg)
    char* msg;
  {
    msg = msg; /* "syntax error" */
    /*
       switch ( what_error ){
       case OPT_ERR:
       printError("      Invalid option.\n\n");
       break;
       case CMD_ERR:
       printError("      Command error.\n\n");
       break;
       case EXPR_ERR:
       printError("      Expression: ");
       printError(msg);
       printError("\n\n");
       break;
       }
       */
    return ;
  }

  /******************************************************************
   *
   *  Functions to fill the variables defined above with the values parsed.
   *
   *******************************************************************/

  /* Reset_values_parsed
   * Reset all the variables defined above to store the values parsed.
   */
  static void Reset_values_parsed()
    {
      expr_rw               = NULL;
      success_event         = CopyString(str_empty);
      default_success_event = (((char*)Default("success_event"))[0]!='\0');
      process_name          = CopyString(str_empty);
      expected_response     = CopyString(str_empty);
      env_variable          = CopyString(str_empty);
      env_value             = CopyString(str_empty);
      branch                = 0;
      command_name          = CopyString(str_empty);
      outfile_name          = CopyString(str_empty);
      option                = '\0';
      low_limit             = 0;
      high_limit            = 0;
      optionList            = CopyString(str_empty);
      lengthOpcList         = 0;
      depth                 = UNDEFINED;
      seed                  = 0;
      bhsize                = UNDEFINED;
      percentage            = 100; /* % */
      one_execs             = 1;
      verbose_level         = 0;
      undos_num             = -1;
      /* movement_tab[MAX_MOVE] */
      num_mov               = 0;
      /* gate_list1[MAX_ARGS]   */
      numGate1              = 0;
      /* gate_list2[MAX_ARGS]   */
      numGate2              = 0;
      command_token         = 0;
      number_list           = Create_list();
    }

  /*----------------------------------------------------------------*/

  /* Fill_mov_list
   * Fill the variables to store the movement list parsed.
   */
  static void Fill_mov_list( contmove, move_lst )
    int      contmove;
  moveTyp *move_lst;
  {
    int i;

    num_mov = contmove;
    if (contmove!=0) {
      for (i = 0 ; i < contmove ; i++)
	if (move_lst[i].mvType == POSITION) {
	  movement_tab[i].mv.mvrel.num = move_lst[i].mv.mvrel.num;
	  movement_tab[i].mv.mvrel.mov = move_lst[i].mv.mvrel.mov;
	  movement_tab[i].mvType = POSITION;
	}
	else if (move_lst[i].mvType == STRING) {
	  movement_tab[i].mv.proc = CopyString(move_lst[i].mv.proc);
	  movement_tab[i].mvType = STRING;
	}
	else if (move_lst[i].mvType == CHAR) {
	  movement_tab[i].mv.root = move_lst[i].mv.root;
	  movement_tab[i].mvType = CHAR;
	}
    }
  }

  /*----------------------------------------------------------------*/

  /* Fill_gate_list1
   * Fill the variables to store the first gate list parsed.
   */
  static void Fill_gate_list1(lgl1,gl1)
    int   lgl1;
  char *gl1[];
  {
    int i;

    numGate1 = lgl1;
    for (i=0 ; i<lgl1 ; i++)
      gate_list1[i] = gl1[i];
  }

  /*----------------------------------------------------------------*/

  /* Fill_gate_list2
   * Fill the variables to store the second gate list parsed.
   */
  static void Fill_gate_list2(lgl2,gl2)
    int lgl2;
  char *gl2[];
  {
    int i;

    numGate2 = lgl2;
    for (i=0 ; i<lgl2 ; i++)
      gate_list2[i] = gl2[i];
  }

  /*----------------------------------------------------------------*/

  /* Fill_option_list
   * Fill the variables to store the option list parsed.
   */
  static void Fill_option_list(optlist,numopt)
    int   numopt;
  char *optlist;
  {
    lengthOpcList   = numopt;
    optlist[numOpc] = '\0';
    optionList      = CopyString(optlist);
  }


  static boolean StoreOption(c,opts)
    char c;
  char *opts;
  {
    if (numOpc < MAX_OPTS){
      opts[numOpc++] = c;
      return TRUE;
    }
    else {
      (void)printf("      WARNING : option <-%c> ignored\n",c);
      return FALSE;
    }
  }



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
#line 389 "inparser.y"
{ int            branch;
	 int            num;
	 char           option;
	 char           opt_lst[MAX_OPTS];
	 char           *ident_lst[MAX_ARGS];
	 char           *string;
	 mvrelTyp       posic;
	 moveTyp        tab_move[MAX_MOVE];
	 PExpCellTyp    expc;
	 ListTyp        le;
	 DescriptorTyp  descr;
	 ExprTyp        expr;
	 ListTyp        nl;
       }
/* Line 187 of yacc.c.  */
#line 609 "y.tab.c"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 216 of yacc.c.  */
#line 622 "y.tab.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  85
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   424

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  59
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  27
/* YYNRULES -- Number of rules.  */
#define YYNRULES  156
/* YYNRULES -- Number of states.  */
#define YYNSTATES  209

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   310

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      56,    57,     2,     2,    58,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     4,     6,     8,    10,    12,    14,    18,
      21,    24,    28,    29,    33,    34,    37,    39,    43,    44,
      48,    51,    55,    60,    62,    64,    66,    68,    70,    73,
      77,    79,    81,    84,    86,    89,    91,    94,    97,   101,
     106,   109,   113,   116,   120,   123,   127,   131,   136,   142,
     149,   155,   160,   166,   173,   181,   184,   188,   193,   197,
     202,   208,   210,   212,   214,   216,   219,   222,   225,   229,
     233,   237,   241,   245,   249,   254,   259,   264,   269,   274,
     279,   282,   286,   291,   296,   302,   304,   307,   311,   315,
     318,   321,   322,   323,   330,   331,   332,   339,   340,   341,
     348,   349,   353,   354,   357,   360,   363,   366,   368,   370,
     372,   374,   376,   378,   379,   382,   385,   388,   391,   394,
     397,   401,   404,   407,   411,   416,   420,   424,   429,   434,
     440,   443,   444,   447,   450,   454,   456,   458,   460,   462,
     465,   468,   471,   474,   477,   478,   481,   484,   487,   488,
     491,   494,   497,   500,   502,   505,   506
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      60,     0,    -1,    -1,    68,    -1,    61,    -1,     4,    -1,
      62,    -1,    63,    -1,    62,    11,    63,    -1,    64,    66,
      -1,    11,    65,    -1,    56,    62,    57,    -1,    -1,    56,
      67,    57,    -1,    -1,    31,    11,    -1,    62,    -1,    67,
      58,    62,    -1,    -1,     8,    69,    61,    -1,    22,    80,
      -1,    22,    11,    80,    -1,    22,    11,    11,    80,    -1,
      32,    -1,    33,    -1,    35,    -1,    34,    -1,     5,    -1,
      36,     4,    -1,    36,     4,    11,    -1,    37,    -1,    38,
      -1,    39,    85,    -1,    24,    -1,    24,    11,    -1,    12,
      -1,    12,    11,    -1,    13,    78,    -1,    13,    78,     4,
      -1,    13,    78,     4,     4,    -1,    15,    82,    -1,    15,
       4,    82,    -1,    17,    82,    -1,    17,     4,    82,    -1,
      16,    82,    -1,    16,     4,    82,    -1,    19,     4,    82,
      -1,    19,     4,    11,    82,    -1,    19,     4,    11,     4,
      82,    -1,    19,     4,    11,     4,     4,    82,    -1,    19,
       4,    11,    11,    82,    -1,    19,     4,     4,    82,    -1,
      19,     4,     4,     4,    82,    -1,    19,     4,    11,    11,
       4,    82,    -1,    19,     4,    11,    11,     4,     4,    82,
      -1,    20,    83,    -1,    20,     4,    83,    -1,    20,     4,
      11,    83,    -1,    20,    11,    83,    -1,    20,    11,    11,
      83,    -1,    20,     4,    11,    11,    83,    -1,    14,    -1,
      23,    -1,    10,    -1,     9,    -1,     9,    81,    -1,     9,
       4,    -1,     9,    11,    -1,     9,    81,     4,    -1,     9,
      81,    11,    -1,     9,     4,    11,    -1,     9,     4,    81,
      -1,     9,    11,     4,    -1,     9,    11,    81,    -1,     9,
      81,     4,    11,    -1,     9,    81,    11,     4,    -1,     9,
       4,    81,    11,    -1,     9,     4,    11,    81,    -1,     9,
      11,     4,    81,    -1,     9,    11,    81,     4,    -1,    18,
      79,    -1,    18,    11,    79,    -1,    18,    11,    11,    79,
      -1,    18,     4,    11,    79,    -1,    18,     4,    11,    11,
      79,    -1,    25,    -1,    25,    11,    -1,    25,    11,    11,
      -1,    25,    11,     4,    -1,    26,    11,    -1,    21,    77,
      -1,    -1,    -1,    28,    70,    84,    58,    71,    84,    -1,
      -1,    -1,    30,    72,    84,    58,    73,    84,    -1,    -1,
      -1,    29,    74,    84,    58,    75,    84,    -1,    -1,    27,
      76,    84,    -1,    -1,    77,     6,    -1,    77,     4,    -1,
      77,    11,    -1,    77,     7,    -1,    50,    -1,    53,    -1,
      47,    -1,    48,    -1,    45,    -1,     1,    -1,    -1,    79,
      51,    -1,    79,    40,    -1,    79,    50,    -1,    79,    44,
      -1,    79,    43,    -1,    79,    53,    -1,    79,    53,     4,
      -1,    79,    46,    -1,    79,    55,    -1,    79,    54,    11,
      -1,    79,    54,    11,    49,    -1,    79,    41,     4,    -1,
      79,    48,     4,    -1,    79,    48,     4,     4,    -1,    79,
      48,     4,    45,    -1,    79,    48,     4,     4,    45,    -1,
      79,     1,    -1,    -1,    80,    51,    -1,    80,    43,    -1,
      80,    52,     4,    -1,    48,    -1,    51,    -1,    40,    -1,
      42,    -1,    81,    48,    -1,    81,    51,    -1,    81,    40,
      -1,    81,    42,    -1,    81,     1,    -1,    -1,    82,    53,
      -1,    82,    46,    -1,    82,     1,    -1,    -1,    83,    43,
      -1,    83,    48,    -1,    83,    53,    -1,    83,     1,    -1,
      11,    -1,    84,    11,    -1,    -1,    85,     4,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   481,   481,   482,   483,   484,   487,   503,   505,   516,
     523,   528,   534,   535,   540,   541,   552,   556,   563,   563,
     566,   568,   571,   576,   578,   580,   582,   584,   587,   590,
     594,   596,   598,   600,   601,   604,   605,   608,   612,   616,
     621,   623,   627,   629,   633,   635,   639,   642,   646,   651,
     657,   662,   666,   671,   677,   685,   687,   690,   697,   703,
     707,   713,   715,   717,   720,   722,   725,   727,   730,   733,
     737,   740,   743,   746,   750,   754,   758,   762,   766,   770,
     776,   778,   784,   788,   795,   801,   802,   805,   808,   812,
     815,   818,   818,   818,   824,   824,   824,   830,   830,   830,
     836,   836,   841,   842,   851,   860,   868,   878,   879,   880,
     881,   882,   883,   888,   889,   890,   891,   892,   893,   894,
     895,   898,   899,   900,   903,   912,   914,   916,   919,   922,
     926,   931,   932,   933,   934,   939,   940,   941,   942,   943,
     944,   945,   946,   947,   953,   954,   955,   956,   962,   963,
     964,   965,   966,   971,   976,   983,   984
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ERROR", "NUM", "BRANCH", "POSIC",
  "ROOT", "REWRITE", "PRINT", "LOAD", "IDENT", "SAVE", "DATA", "STAT",
  "EXPAND", "FREE", "VAR", "TEST", "ONE", "IT", "MOVE", "STEP", "QUIT",
  "HELP", "SET", "CMD", "PI", "VCNR", "K", "VC", "OF", "EXIT", "MENU",
  "UNDO", "TRACE", "SYNC", "STEPHELP", "REFUSED", "SELECT", "OPT_A",
  "OPT_B", "OPT_C", "OPT_D", "OPT_E", "OPT_G", "OPT_I", "OPT_O", "OPT_P",
  "OPT_Q", "OPT_S", "OPT_T", "OPT_U", "OPT_V", "OPT_X", "OPT_Y", "'('",
  "')'", "','", "$accept", "inter", "expression", "value_expression",
  "simple_expression", "term_expression", "value_expression_list",
  "sort_indication", "value_expression_seq", "command", "@1", "@2", "@3",
  "@4", "@5", "@6", "@7", "@8", "move_lst", "dt_option", "test_option_lst",
  "step_option_lst", "print_option_lst", "exp_option_lst",
  "iexp_option_lst", "gate_lst", "num_lst", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,    40,    41,    44
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    59,    60,    60,    60,    60,    61,    62,    62,    63,
      64,    64,    65,    65,    66,    66,    67,    67,    69,    68,
      68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
      68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
      68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
      68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
      68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
      68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
      68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
      68,    70,    71,    68,    72,    73,    68,    74,    75,    68,
      76,    68,    77,    77,    77,    77,    77,    78,    78,    78,
      78,    78,    78,    79,    79,    79,    79,    79,    79,    79,
      79,    79,    79,    79,    79,    79,    79,    79,    79,    79,
      79,    80,    80,    80,    80,    81,    81,    81,    81,    81,
      81,    81,    81,    81,    82,    82,    82,    82,    83,    83,
      83,    83,    83,    84,    84,    85,    85
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     1,     1,     1,     1,     1,     3,     2,
       2,     3,     0,     3,     0,     2,     1,     3,     0,     3,
       2,     3,     4,     1,     1,     1,     1,     1,     2,     3,
       1,     1,     2,     1,     2,     1,     2,     2,     3,     4,
       2,     3,     2,     3,     2,     3,     3,     4,     5,     6,
       5,     4,     5,     6,     7,     2,     3,     4,     3,     4,
       5,     1,     1,     1,     1,     2,     2,     2,     3,     3,
       3,     3,     3,     3,     4,     4,     4,     4,     4,     4,
       2,     3,     4,     4,     5,     1,     2,     3,     3,     2,
       2,     0,     0,     6,     0,     0,     6,     0,     0,     6,
       0,     3,     0,     2,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     0,     2,     2,     2,     2,     2,     2,
       3,     2,     2,     3,     4,     3,     3,     4,     4,     5,
       2,     0,     2,     2,     3,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     0,     2,     2,     2,     0,     2,
       2,     2,     2,     1,     2,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       2,     5,    27,    18,    64,    63,    12,    35,     0,    61,
     144,   144,   144,   113,     0,   148,   102,   131,    62,    33,
      85,     0,   100,    91,    97,    94,    23,    24,    26,    25,
       0,    30,    31,   155,     0,     0,     4,     6,     7,    14,
       3,     0,    66,    67,   137,   138,   135,   136,     0,     0,
      10,    36,   112,   111,   109,   110,   107,   108,    37,   144,
       0,   144,     0,   144,     0,     0,   113,     0,   144,   148,
     148,     0,    90,   131,    20,    34,    86,    89,     0,     0,
       0,     0,    28,    32,     0,     1,     0,     0,     9,    19,
      70,     0,    72,     0,   143,    68,    69,   141,   142,   139,
     140,    16,     0,    38,     0,   147,   146,   145,     0,     0,
     113,   113,     0,   130,   115,     0,   118,   117,   121,     0,
     116,   114,   119,     0,   122,   144,   144,     0,   148,     0,
     148,     0,   152,   149,   150,   151,   104,   103,   106,   105,
     131,    21,   133,   132,     0,    88,    87,   153,   101,     0,
       0,     0,    29,   156,    11,     8,    15,     0,    76,     0,
      79,    74,    75,    13,     0,    39,   113,     0,     0,   125,
     126,   120,   123,   144,     0,   144,   144,     0,   148,     0,
       0,    22,   134,   154,    92,    98,    95,    17,     0,   127,
     128,   124,     0,   144,     0,   144,     0,     0,     0,     0,
       0,   129,     0,   144,     0,    93,    99,    96,     0
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    35,    36,    37,    38,    39,    50,    88,   102,    40,
      41,    79,   198,    81,   200,    80,   199,    78,    72,    58,
      67,    74,    48,    60,    71,   148,    83
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -77
static const yytype_int16 yypact[] =
{
     287,   -77,   -77,   -77,   361,   -77,   -42,     4,   198,   -77,
      26,    41,    42,    20,    45,    31,   -77,    14,   -77,    30,
      86,    94,   -77,   -77,   -77,   -77,   -77,   -77,   -77,   -77,
     100,   -77,   -77,   -77,    28,    32,   -77,    96,   -77,    88,
     -77,    28,   373,   366,   -77,   -77,   -77,   -77,   327,    28,
     -77,   -77,   -77,   -77,   -77,   -77,   -77,   -77,   124,   -77,
      33,   -77,    43,   -77,    99,   118,   119,    21,    36,   127,
     129,    55,   106,   131,   -24,   -77,    91,   -77,   138,   138,
     138,   138,   142,   152,    25,   -77,    28,   146,   -77,   -77,
     -22,   334,   -22,   346,   -77,   147,   155,   -77,   -77,   -77,
     -77,    96,   -46,   167,   160,   -77,   -77,   -77,   208,   210,
     164,   -77,    37,   -77,   -77,   174,   -77,   -77,   -77,   179,
     -77,   -77,   191,   178,   -77,   225,   114,   214,   201,    58,
     -77,   120,   -77,   -77,   -77,   -77,   -77,   -77,   -77,   -77,
     -77,   -24,   -77,   -77,   227,   -77,   -77,   -77,   221,     2,
       5,    12,   -77,   -77,   -77,   -77,   -77,   339,   -77,   351,
     -77,   -77,   -77,   -77,    28,   -77,   -77,    93,   126,   -77,
       6,   -77,    82,   -77,   216,   230,   235,   218,   -77,   154,
     185,   -24,   -77,   -77,   -77,   -77,   -77,    96,   150,    90,
     -77,   -77,   220,   -77,   222,   240,   224,   187,   138,   138,
     138,   -77,   226,   -77,   236,   221,   221,   221,   241
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
     -77,   -77,   206,   -32,   163,   -77,   -77,   -77,   -77,   -77,
     -77,   -77,   -77,   -77,   -77,   -77,   -77,   -77,   -77,   -77,
     -57,   -67,   306,   -11,   -62,   -76,   -77
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -85
static const yytype_int16 yytable[] =
{
      62,    64,    84,   149,   150,   151,   141,   129,   131,   112,
     189,   163,   164,   183,    49,    51,   183,   101,    44,   142,
      45,   -80,   113,   183,    65,    73,    46,   143,   144,    47,
      59,    66,    85,   -40,   105,    69,    86,   -81,   113,     6,
     125,    75,    70,   -44,   105,    61,    63,   126,   104,    68,
     108,   190,   109,   167,   168,   -55,   132,   127,   -56,   132,
     184,   114,   115,   185,   116,   117,   179,   118,   180,   119,
     186,   120,   121,   181,   122,   123,   124,   114,   115,   106,
     116,   117,   154,   118,    34,   119,   107,   120,   121,   106,
     122,   123,   124,   -83,   113,   145,   107,    76,   133,   -42,
     105,   133,   146,   134,    82,    77,   134,    86,   135,   188,
     136,   135,   137,   138,   174,   177,   197,   139,   175,    87,
     -58,   132,   205,   206,   207,   176,   -82,   113,   103,   110,
     111,   191,   187,   114,   115,   201,   116,   117,   128,   118,
     130,   119,   140,   120,   121,   106,   122,   123,   124,   147,
     -84,   113,   107,   152,   -57,   132,   153,   156,   161,   162,
     -41,   105,   192,   133,   194,   196,   114,   115,   134,   116,
     117,   165,   118,   135,   119,   166,   120,   121,   169,   122,
     123,   124,   202,   170,   204,   -59,   132,   -60,   132,   172,
     114,   115,   208,   116,   117,   171,   118,   133,   119,    52,
     120,   121,   134,   122,   123,   124,   106,   135,   -45,   105,
     -43,   105,   178,   107,   -46,   105,   -51,   105,   -47,   105,
     -52,   105,   -48,   105,   -50,   105,   -49,   105,   133,   173,
     133,   182,   183,   134,   193,   134,   -53,   105,   135,   195,
     135,   -54,   105,    53,   203,    54,    55,    89,    56,   155,
       0,    57,     0,     0,   106,     0,   106,     0,     0,     0,
     106,   107,   106,   107,   106,     0,   106,   107,   106,   107,
     106,   107,   106,   107,     0,   107,     0,   107,     0,   107,
       0,     0,   106,     0,     0,     0,     0,   106,     0,   107,
       0,     1,     2,     0,   107,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,     0,    26,
      27,    28,    29,    30,    31,    32,    33,   -65,    94,     0,
       0,    95,     0,     0,   -71,    94,     0,     0,    96,   -77,
      94,     0,     0,    34,     0,   158,   -73,    94,    91,    93,
     160,   -78,    94,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    42,     0,    97,     0,    98,
      92,     0,    43,     0,    97,    99,    98,     0,   100,    97,
       0,    98,    99,     0,    90,   100,    97,    99,    98,     0,
     100,    97,     0,    98,    99,     0,   157,   100,   159,    99,
       0,    44,   100,    45,     0,     0,    44,     0,    45,    46,
       0,     0,    47,    44,    46,    45,     0,    47,     0,     0,
       0,    46,     0,     0,    47
};

static const yytype_int16 yycheck[] =
{
      11,    12,    34,    79,    80,    81,    73,    69,    70,    66,
       4,    57,    58,    11,    56,    11,    11,    49,    40,    43,
      42,     0,     1,    11,     4,    11,    48,    51,    52,    51,
       4,    11,     0,     0,     1,     4,    11,     0,     1,    11,
       4,    11,    11,     0,     1,     4,     4,    11,    59,     4,
      61,    45,    63,   110,   111,     0,     1,    68,     0,     1,
      58,    40,    41,    58,    43,    44,   128,    46,   130,    48,
      58,    50,    51,   140,    53,    54,    55,    40,    41,    46,
      43,    44,    57,    46,    56,    48,    53,    50,    51,    46,
      53,    54,    55,     0,     1,     4,    53,    11,    43,     0,
       1,    43,    11,    48,     4,    11,    48,    11,    53,   166,
       4,    53,     6,     7,   125,   126,   178,    11,     4,    31,
       0,     1,   198,   199,   200,    11,     0,     1,     4,    11,
      11,    49,   164,    40,    41,    45,    43,    44,    11,    46,
      11,    48,    11,    50,    51,    46,    53,    54,    55,    11,
       0,     1,    53,    11,     0,     1,     4,    11,    11,     4,
       0,     1,   173,    43,   175,   176,    40,    41,    48,    43,
      44,     4,    46,    53,    48,    11,    50,    51,     4,    53,
      54,    55,   193,     4,   195,     0,     1,     0,     1,    11,
      40,    41,   203,    43,    44,     4,    46,    43,    48,     1,
      50,    51,    48,    53,    54,    55,    46,    53,     0,     1,
       0,     1,    11,    53,     0,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,    43,     4,
      43,     4,    11,    48,     4,    48,     0,     1,    53,     4,
      53,     0,     1,    45,     4,    47,    48,    41,    50,    86,
      -1,    53,    -1,    -1,    46,    -1,    46,    -1,    -1,    -1,
      46,    53,    46,    53,    46,    -1,    46,    53,    46,    53,
      46,    53,    46,    53,    -1,    53,    -1,    53,    -1,    53,
      -1,    -1,    46,    -1,    -1,    -1,    -1,    46,    -1,    53,
      -1,     4,     5,    -1,    53,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    39,     0,     1,    -1,
      -1,     4,    -1,    -1,     0,     1,    -1,    -1,    11,     0,
       1,    -1,    -1,    56,    -1,    11,     0,     1,    42,    43,
       4,     0,     1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     4,    -1,    40,    -1,    42,
       4,    -1,    11,    -1,    40,    48,    42,    -1,    51,    40,
      -1,    42,    48,    -1,    11,    51,    40,    48,    42,    -1,
      51,    40,    -1,    42,    48,    -1,    90,    51,    92,    48,
      -1,    40,    51,    42,    -1,    -1,    40,    -1,    42,    48,
      -1,    -1,    51,    40,    48,    42,    -1,    51,    -1,    -1,
      -1,    48,    -1,    -1,    51
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     4,     5,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    32,    33,    34,    35,
      36,    37,    38,    39,    56,    60,    61,    62,    63,    64,
      68,    69,     4,    11,    40,    42,    48,    51,    81,    56,
      65,    11,     1,    45,    47,    48,    50,    53,    78,     4,
      82,     4,    82,     4,    82,     4,    11,    79,     4,     4,
      11,    83,    77,    11,    80,    11,    11,    11,    76,    70,
      74,    72,     4,    85,    62,     0,    11,    31,    66,    61,
      11,    81,     4,    81,     1,     4,    11,    40,    42,    48,
      51,    62,    67,     4,    82,     1,    46,    53,    82,    82,
      11,    11,    79,     1,    40,    41,    43,    44,    46,    48,
      50,    51,    53,    54,    55,     4,    11,    82,    11,    83,
      11,    83,     1,    43,    48,    53,     4,     6,     7,    11,
      11,    80,    43,    51,    52,     4,    11,    11,    84,    84,
      84,    84,    11,     4,    57,    63,    11,    81,    11,    81,
       4,    11,     4,    57,    58,     4,    11,    79,    79,     4,
       4,     4,    11,     4,    82,     4,    11,    82,    11,    83,
      83,    80,     4,    11,    58,    58,    58,    62,    79,     4,
      45,    49,    82,     4,    82,     4,    82,    83,    71,    75,
      73,    45,    82,     4,    82,    84,    84,    84,    82
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
				       );
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval,yyval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */



  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
	case 2:
#line 481 "inparser.y"
    { InputLineIsEmpty=TRUE;}
    break;

  case 6:
#line 488 "inparser.y"
    {  if (ResError) {
  printError(ResErrorMsg);
  (yyval.expr) = NULL;
}
else {
  if ( (yyvsp[(1) - (1)].expc)->dsort == 0 )
    (yyvsp[(1) - (1)].expc)->dsort = expectedSort;
  (yyval.expr) = ResExpr((yyvsp[(1) - (1)].expc));
  if (ResError) {
    printError(ResErrorMsg);
  }
}
   FreeExpCell();
 }
    break;

  case 7:
#line 504 "inparser.y"
    { (yyval.expc) = (yyvsp[(1) - (1)].expc); }
    break;

  case 8:
#line 506 "inparser.y"
    { (yyval.expc) = NewExpCell();
  (yyval.expc)->name = CopyString((yyvsp[(2) - (3)].string));
  (yyval.expc)->argl = Insert_list((DataListTyp)(yyvsp[(1) - (3)].expc),
			 Insert_list((DataListTyp)(yyvsp[(3) - (3)].expc),
				     Create_list()));
  (yyval.expc)->infix = TRUE;
}
    break;

  case 9:
#line 517 "inparser.y"
    { (yyval.expc) = (yyvsp[(1) - (2)].expc);
  (yyval.expc)->dsort = (yyvsp[(2) - (2)].descr);
}
    break;

  case 10:
#line 524 "inparser.y"
    { (yyval.expc) = NewExpCell();
  (yyval.expc)->name = CopyString((yyvsp[(1) - (2)].string));
  (yyval.expc)->argl = (yyvsp[(2) - (2)].le);
}
    break;

  case 11:
#line 529 "inparser.y"
    { (yyval.expc) = (yyvsp[(2) - (3)].expc); }
    break;

  case 12:
#line 534 "inparser.y"
    { (yyval.le) = NULL; }
    break;

  case 13:
#line 536 "inparser.y"
    { (yyval.le) = (yyvsp[(2) - (3)].le); }
    break;

  case 14:
#line 540 "inparser.y"
    { (yyval.descr) = 0; }
    break;

  case 15:
#line 542 "inparser.y"
    { (yyval.descr) = FindS((yyvsp[(2) - (2)].string));
  if ((yyval.descr)==0) {
    ResError = TRUE;
    (void)sprintf(ResErrorMsg,
		  "\n     ERROR: sort %s unknown.\n\n",
		  (yyvsp[(2) - (2)].string));
  }
}
    break;

  case 16:
#line 553 "inparser.y"
    { (yyval.le) = Insert_list((DataListTyp)(yyvsp[(1) - (1)].expc),
		   Create_list());
}
    break;

  case 17:
#line 557 "inparser.y"
    { (yyval.le) = Add_list((DataListTyp)(yyvsp[(3) - (3)].expc),(yyvsp[(1) - (3)].le));
}
    break;

  case 18:
#line 563 "inparser.y"
    {lex_mode=EXPLEXMODE;}
    break;

  case 19:
#line 563 "inparser.y"
    {expr_rw       = (yyvsp[(3) - (3)].expr);
					   command_token = REWRITE;}
    break;

  case 20:
#line 566 "inparser.y"
    { command_token = STEP;
			     Fill_option_list((yyvsp[(2) - (2)].opt_lst),numOpc);}
    break;

  case 21:
#line 568 "inparser.y"
    { process_name  = CopyString((yyvsp[(2) - (3)].string));
			       command_token = STEP;
			       Fill_option_list((yyvsp[(3) - (3)].opt_lst),numOpc);}
    break;

  case 22:
#line 571 "inparser.y"
    { success_event = CopyString((yyvsp[(2) - (4)].string));
					  process_name  = CopyString((yyvsp[(3) - (4)].string));
					  command_token = STEP;
					  Fill_option_list((yyvsp[(4) - (4)].opt_lst),numOpc);}
    break;

  case 23:
#line 576 "inparser.y"
    {command_token = EXIT;}
    break;

  case 24:
#line 578 "inparser.y"
    {command_token = MENU;}
    break;

  case 25:
#line 580 "inparser.y"
    {command_token = TRACE;}
    break;

  case 26:
#line 582 "inparser.y"
    {command_token = UNDO;}
    break;

  case 27:
#line 584 "inparser.y"
    {branch = (yyvsp[(1) - (1)].num);
	  command_token = BRANCH;}
    break;

  case 28:
#line 587 "inparser.y"
    {branch = (yyvsp[(2) - (2)].num);
		  command_token = SYNC;}
    break;

  case 29:
#line 590 "inparser.y"
    {branch = (yyvsp[(2) - (3)].num);
		  process_name = CopyString((yyvsp[(3) - (3)].string));
		  command_token = SYNC;}
    break;

  case 30:
#line 594 "inparser.y"
    {command_token = STEPHELP;}
    break;

  case 31:
#line 596 "inparser.y"
    {command_token = REFUSED;}
    break;

  case 32:
#line 598 "inparser.y"
    {command_token = SELECT;}
    break;

  case 33:
#line 600 "inparser.y"
    { command_token = HELP;}
    break;

  case 34:
#line 601 "inparser.y"
    { command_name  = CopyString((yyvsp[(2) - (2)].string));
	       command_token = HELP;}
    break;

  case 35:
#line 604 "inparser.y"
    { command_token = SAVE;}
    break;

  case 36:
#line 605 "inparser.y"
    { outfile_name  = CopyString((yyvsp[(2) - (2)].string));
		command_token = SAVE;}
    break;

  case 37:
#line 608 "inparser.y"
    {option        = (yyvsp[(2) - (2)].option);
			   low_limit     = 0;
			   high_limit    = 0;
			   command_token = DATA;}
    break;

  case 38:
#line 612 "inparser.y"
    {option        = (yyvsp[(2) - (3)].option);
			   low_limit     = (yyvsp[(3) - (3)].num);
			   high_limit    = 0;
			   command_token = DATA;}
    break;

  case 39:
#line 616 "inparser.y"
    {option        = (yyvsp[(2) - (4)].option);
			   low_limit     = (yyvsp[(3) - (4)].num);
			   high_limit    = (yyvsp[(4) - (4)].num);
			   command_token = DATA;}
    break;

  case 40:
#line 621 "inparser.y"
    {Fill_option_list((yyvsp[(2) - (2)].opt_lst),numOpc);
			      command_token = EXPAND;}
    break;

  case 41:
#line 623 "inparser.y"
    {depth = (yyvsp[(2) - (3)].num);
			      Fill_option_list((yyvsp[(3) - (3)].opt_lst),numOpc);
			      command_token = EXPAND;}
    break;

  case 42:
#line 627 "inparser.y"
    {Fill_option_list((yyvsp[(2) - (2)].opt_lst),numOpc);
			    command_token = VAR;}
    break;

  case 43:
#line 629 "inparser.y"
    {depth = (yyvsp[(2) - (3)].num);
			    Fill_option_list((yyvsp[(3) - (3)].opt_lst),numOpc);
			    command_token = VAR;}
    break;

  case 44:
#line 633 "inparser.y"
    {Fill_option_list((yyvsp[(2) - (2)].opt_lst),numOpc);
			    command_token = FREE;}
    break;

  case 45:
#line 635 "inparser.y"
    {depth = (yyvsp[(2) - (3)].num);
			    Fill_option_list((yyvsp[(3) - (3)].opt_lst),numOpc);
			    command_token = FREE;}
    break;

  case 46:
#line 639 "inparser.y"
    {depth = (yyvsp[(2) - (3)].num);
					  Fill_option_list((yyvsp[(3) - (3)].opt_lst),numOpc);
					  command_token = ONE;}
    break;

  case 47:
#line 642 "inparser.y"
    {depth = (yyvsp[(2) - (4)].num);
					  process_name  = CopyString((yyvsp[(3) - (4)].string));
					  Fill_option_list((yyvsp[(4) - (4)].opt_lst),numOpc);
					  command_token = ONE;}
    break;

  case 48:
#line 646 "inparser.y"
    {depth = (yyvsp[(2) - (5)].num);
					  seed  = (yyvsp[(4) - (5)].num);
					  process_name  = CopyString((yyvsp[(3) - (5)].string));
					  Fill_option_list((yyvsp[(5) - (5)].opt_lst),numOpc);
					  command_token = ONE;}
    break;

  case 49:
#line 651 "inparser.y"
    {depth        = (yyvsp[(2) - (6)].num);
					  seed         = (yyvsp[(4) - (6)].num);
					  one_execs    = (yyvsp[(5) - (6)].num);
					  process_name = CopyString((yyvsp[(3) - (6)].string));
					  Fill_option_list((yyvsp[(6) - (6)].opt_lst),numOpc);
					  command_token = ONE;}
    break;

  case 50:
#line 657 "inparser.y"
    {depth = (yyvsp[(2) - (5)].num);
					  success_event = CopyString((yyvsp[(3) - (5)].string));
					  process_name  = CopyString((yyvsp[(4) - (5)].string));
					  Fill_option_list((yyvsp[(5) - (5)].opt_lst),numOpc);
					  command_token = ONE;}
    break;

  case 51:
#line 662 "inparser.y"
    {depth = (yyvsp[(2) - (4)].num);
					  seed  = (yyvsp[(3) - (4)].num);
					  Fill_option_list((yyvsp[(4) - (4)].opt_lst),numOpc);
					  command_token = ONE;}
    break;

  case 52:
#line 666 "inparser.y"
    {depth     = (yyvsp[(2) - (5)].num);
					  seed      = (yyvsp[(3) - (5)].num);
					  one_execs = (yyvsp[(4) - (5)].num);
					  Fill_option_list((yyvsp[(5) - (5)].opt_lst),numOpc);
					  command_token = ONE;}
    break;

  case 53:
#line 671 "inparser.y"
    {depth = (yyvsp[(2) - (6)].num);
					  seed  = (yyvsp[(5) - (6)].num);
					  success_event = CopyString((yyvsp[(3) - (6)].string));
					  process_name  = CopyString((yyvsp[(4) - (6)].string));
					  Fill_option_list((yyvsp[(6) - (6)].opt_lst),numOpc);
					  command_token = ONE;}
    break;

  case 54:
#line 677 "inparser.y"
    {depth = (yyvsp[(2) - (7)].num);
					      seed  = (yyvsp[(5) - (7)].num);
					      one_execs = (yyvsp[(6) - (7)].num);
					      success_event = CopyString((yyvsp[(3) - (7)].string));
					      process_name  = CopyString((yyvsp[(4) - (7)].string));
					      Fill_option_list((yyvsp[(7) - (7)].opt_lst),numOpc);
					      command_token = ONE;}
    break;

  case 55:
#line 685 "inparser.y"
    {Fill_option_list((yyvsp[(2) - (2)].opt_lst),numOpc);
				      command_token = IT;}
    break;

  case 56:
#line 687 "inparser.y"
    {depth = (yyvsp[(2) - (3)].num);
				      Fill_option_list((yyvsp[(3) - (3)].opt_lst),numOpc);
				      command_token = IT;}
    break;

  case 57:
#line 690 "inparser.y"
    {depth = (yyvsp[(2) - (4)].num);
				      if ( default_success_event )
					process_name  = CopyString((yyvsp[(3) - (4)].string));
				      else
					success_event = CopyString((yyvsp[(3) - (4)].string));
				      Fill_option_list((yyvsp[(4) - (4)].opt_lst),numOpc);
				      command_token = IT;}
    break;

  case 58:
#line 697 "inparser.y"
    {if ( default_success_event )
					process_name  = CopyString((yyvsp[(2) - (3)].string));
else
  success_event = CopyString((yyvsp[(2) - (3)].string));
				      Fill_option_list((yyvsp[(3) - (3)].opt_lst),numOpc);
				      command_token = IT;}
    break;

  case 59:
#line 703 "inparser.y"
    {success_event = CopyString((yyvsp[(2) - (4)].string));
				      process_name  = CopyString((yyvsp[(3) - (4)].string));
				      Fill_option_list((yyvsp[(4) - (4)].opt_lst),numOpc);
				      command_token = IT;}
    break;

  case 60:
#line 707 "inparser.y"
    {depth = (yyvsp[(2) - (5)].num);
				      success_event = CopyString((yyvsp[(3) - (5)].string));
				      process_name  = CopyString((yyvsp[(4) - (5)].string));
				      Fill_option_list((yyvsp[(5) - (5)].opt_lst),numOpc);
				      command_token = IT;}
    break;

  case 61:
#line 713 "inparser.y"
    {command_token = STAT;}
    break;

  case 62:
#line 715 "inparser.y"
    {command_token = QUIT;}
    break;

  case 63:
#line 717 "inparser.y"
    {command_token = LOAD;}
    break;

  case 64:
#line 720 "inparser.y"
    {depth = PRINT_DEPTH;
				    command_token = PRINT;}
    break;

  case 65:
#line 722 "inparser.y"
    {depth = PRINT_DEPTH;
				    Fill_option_list((yyvsp[(2) - (2)].opt_lst),numOpc);
				    command_token = PRINT;}
    break;

  case 66:
#line 725 "inparser.y"
    {depth = (yyvsp[(2) - (2)].num);
				    command_token = PRINT;}
    break;

  case 67:
#line 727 "inparser.y"
    {depth = PRINT_DEPTH;
				    outfile_name = CopyString((yyvsp[(2) - (2)].string));
				    command_token = PRINT;}
    break;

  case 68:
#line 730 "inparser.y"
    {depth = (yyvsp[(3) - (3)].num);
				    Fill_option_list((yyvsp[(2) - (3)].opt_lst),numOpc);
				    command_token = PRINT;}
    break;

  case 69:
#line 733 "inparser.y"
    {depth = PRINT_DEPTH;
				    Fill_option_list((yyvsp[(2) - (3)].opt_lst),numOpc);
				    outfile_name = CopyString((yyvsp[(3) - (3)].string));
				    command_token = PRINT;}
    break;

  case 70:
#line 737 "inparser.y"
    {depth = (yyvsp[(2) - (3)].num);
				    outfile_name = CopyString((yyvsp[(3) - (3)].string));
				    command_token = PRINT;}
    break;

  case 71:
#line 740 "inparser.y"
    {depth = (yyvsp[(2) - (3)].num);
				    Fill_option_list((yyvsp[(3) - (3)].opt_lst),numOpc);
				    command_token = PRINT;}
    break;

  case 72:
#line 743 "inparser.y"
    {depth = (yyvsp[(3) - (3)].num);
				    outfile_name = CopyString((yyvsp[(2) - (3)].string));
				    command_token = PRINT;}
    break;

  case 73:
#line 746 "inparser.y"
    {depth = PRINT_DEPTH;
				    Fill_option_list((yyvsp[(3) - (3)].opt_lst),numOpc);
				    outfile_name = CopyString((yyvsp[(2) - (3)].string));
				    command_token = PRINT;}
    break;

  case 74:
#line 750 "inparser.y"
    {depth = (yyvsp[(3) - (4)].num);
				    Fill_option_list((yyvsp[(2) - (4)].opt_lst),numOpc);
				    outfile_name = CopyString((yyvsp[(4) - (4)].string));
				    command_token = PRINT;}
    break;

  case 75:
#line 754 "inparser.y"
    {depth = (yyvsp[(4) - (4)].num);
				    Fill_option_list((yyvsp[(2) - (4)].opt_lst),numOpc);
				    outfile_name = CopyString((yyvsp[(3) - (4)].string));
				    command_token = PRINT;}
    break;

  case 76:
#line 758 "inparser.y"
    {depth = (yyvsp[(2) - (4)].num);
				    Fill_option_list((yyvsp[(3) - (4)].opt_lst),numOpc);
				    outfile_name = CopyString((yyvsp[(4) - (4)].string));
				    command_token = PRINT;}
    break;

  case 77:
#line 762 "inparser.y"
    {depth = (yyvsp[(2) - (4)].num);
				    Fill_option_list((yyvsp[(4) - (4)].opt_lst),numOpc);
				    outfile_name = CopyString((yyvsp[(3) - (4)].string));
				    command_token = PRINT;}
    break;

  case 78:
#line 766 "inparser.y"
    {depth = (yyvsp[(3) - (4)].num);
				    Fill_option_list((yyvsp[(4) - (4)].opt_lst),numOpc);
				    outfile_name = CopyString((yyvsp[(2) - (4)].string));
				    command_token = PRINT;}
    break;

  case 79:
#line 770 "inparser.y"
    {depth = (yyvsp[(4) - (4)].num);
				    Fill_option_list((yyvsp[(3) - (4)].opt_lst),numOpc);
				    outfile_name = CopyString((yyvsp[(2) - (4)].string));
				    command_token = PRINT;}
    break;

  case 80:
#line 776 "inparser.y"
    {Fill_option_list((yyvsp[(2) - (2)].opt_lst),numOpc);
					command_token = TEST;}
    break;

  case 81:
#line 778 "inparser.y"
    {if ( default_success_event )
					  process_name  = CopyString((yyvsp[(2) - (3)].string));
else
  success_event = CopyString((yyvsp[(2) - (3)].string));
					Fill_option_list((yyvsp[(3) - (3)].opt_lst),numOpc);
					command_token = TEST;}
    break;

  case 82:
#line 784 "inparser.y"
    {success_event = CopyString((yyvsp[(2) - (4)].string));
				       process_name  = CopyString((yyvsp[(3) - (4)].string));
				       Fill_option_list((yyvsp[(4) - (4)].opt_lst),numOpc);
				       command_token = TEST;}
    break;

  case 83:
#line 788 "inparser.y"
    {depth = (yyvsp[(2) - (4)].num);
					if ( default_success_event )
					  process_name  = CopyString((yyvsp[(3) - (4)].string));
					else
					  success_event = CopyString((yyvsp[(3) - (4)].string));
					Fill_option_list((yyvsp[(4) - (4)].opt_lst),numOpc);
					command_token = TEST;}
    break;

  case 84:
#line 795 "inparser.y"
    {depth = (yyvsp[(2) - (5)].num);
					success_event = CopyString((yyvsp[(3) - (5)].string));
					process_name  = CopyString((yyvsp[(4) - (5)].string));
					Fill_option_list((yyvsp[(5) - (5)].opt_lst),numOpc);
					command_token = TEST;}
    break;

  case 85:
#line 801 "inparser.y"
    {command_token = SET;}
    break;

  case 86:
#line 802 "inparser.y"
    {env_variable  = CopyString((yyvsp[(2) - (2)].string));
				  env_value     = "\0";
				  command_token = SET;}
    break;

  case 87:
#line 805 "inparser.y"
    {env_variable  = CopyString((yyvsp[(2) - (3)].string));
				  env_value     = CopyString((yyvsp[(3) - (3)].string));
				  command_token = SET;}
    break;

  case 88:
#line 808 "inparser.y"
    {env_variable  = CopyString((yyvsp[(2) - (3)].string));
				  env_value     = IntToString((yyvsp[(3) - (3)].num));
				  command_token = SET;}
    break;

  case 89:
#line 812 "inparser.y"
    {cmd_file      = CopyString((yyvsp[(2) - (2)].string));
				  command_token = CMD;}
    break;

  case 90:
#line 815 "inparser.y"
    { Fill_mov_list(numMove,(yyvsp[(2) - (2)].tab_move));
		    command_token = MOVE;}
    break;

  case 91:
#line 818 "inparser.y"
    {numGate=0;}
    break;

  case 92:
#line 818 "inparser.y"
    {numGate1 = numGate;
				  Fill_gate_list1(numGate1,(yyvsp[(3) - (4)].ident_lst));
				  numGate=0;}
    break;

  case 93:
#line 821 "inparser.y"
    {numGate2 = numGate;
	      Fill_gate_list2(numGate2,(yyvsp[(6) - (6)].ident_lst));
	      command_token = VCNR;}
    break;

  case 94:
#line 824 "inparser.y"
    {numGate=0;}
    break;

  case 95:
#line 824 "inparser.y"
    {numGate1 = numGate;
				  Fill_gate_list1(numGate1,(yyvsp[(3) - (4)].ident_lst));
				  numGate=0;}
    break;

  case 96:
#line 827 "inparser.y"
    {numGate2 = numGate;
	      Fill_gate_list2(numGate2,(yyvsp[(6) - (6)].ident_lst));
	      command_token = VC;}
    break;

  case 97:
#line 830 "inparser.y"
    {numGate=0;}
    break;

  case 98:
#line 830 "inparser.y"
    {numGate1 = numGate;
				  Fill_gate_list1(numGate1,(yyvsp[(3) - (4)].ident_lst));
				  numGate=0;}
    break;

  case 99:
#line 833 "inparser.y"
    {numGate2 = numGate;
	      Fill_gate_list2(numGate2,(yyvsp[(6) - (6)].ident_lst));
	      command_token = K;}
    break;

  case 100:
#line 836 "inparser.y"
    {numGate=0;}
    break;

  case 101:
#line 836 "inparser.y"
    {numGate1 = numGate;
				  Fill_gate_list1(numGate1,(yyvsp[(3) - (3)].ident_lst));
				  command_token = PI;}
    break;

  case 102:
#line 841 "inparser.y"
    { /* empty */ }
    break;

  case 103:
#line 842 "inparser.y"
    { if (numMove < MAX_MOVE) {
  (yyval.tab_move)[numMove].mv.mvrel.num = (yyvsp[(2) - (2)].posic).num;
  (yyval.tab_move)[numMove].mv.mvrel.mov = (yyvsp[(2) - (2)].posic).mov;
  (yyval.tab_move)[numMove].mvType = POSITION;
  ++numMove;
}
else
  (void)printf("      WARNING : movement <%d%c> ignored\n",(yyvsp[(2) - (2)].posic).num,(yyvsp[(2) - (2)].posic).mov);
			}
    break;

  case 104:
#line 851 "inparser.y"
    { if (numMove < MAX_MOVE) {
  (yyval.tab_move)[numMove].mv.mvrel.num = (yyvsp[(2) - (2)].num);
  (yyval.tab_move)[numMove].mv.mvrel.mov = 'l';
  (yyval.tab_move)[numMove].mvType = POSITION;
  ++numMove;
}
else
  (void)printf("      WARNING : movement <%dl> ignored\n",(yyvsp[(2) - (2)].num));
			}
    break;

  case 105:
#line 860 "inparser.y"
    { if (numMove < MAX_MOVE) {
  (yyval.tab_move)[numMove].mv.proc = (yyvsp[(2) - (2)].string);
  (yyval.tab_move)[numMove].mvType = STRING;
  ++numMove;
}
else
  (void)printf("      WARNING : movement <%s> ignored\n",(yyvsp[(2) - (2)].string));
			}
    break;

  case 106:
#line 868 "inparser.y"
    { if (numMove < MAX_MOVE) {
  (yyval.tab_move)[numMove].mv.root = '^';
  (yyval.tab_move)[numMove].mvType = CHAR;
  ++numMove;
}
else
  (void)printf("      WARNING : movement <^> ignored\n");
			}
    break;

  case 112:
#line 883 "inparser.y"
    { /* no error is raised by now */
  what_error = OPT_ERR;
}
    break;

  case 113:
#line 888 "inparser.y"
    { /* empty */ }
    break;

  case 114:
#line 889 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 115:
#line 890 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 116:
#line 891 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 117:
#line 892 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 118:
#line 893 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 119:
#line 894 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 120:
#line 895 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (3)].option),(yyval.opt_lst));
				      verbose_level = (yyvsp[(3) - (3)].num);
				    }
    break;

  case 121:
#line 898 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 122:
#line 899 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 123:
#line 900 "inparser.y"
    { if (StoreOption((yyvsp[(2) - (3)].option),(yyval.opt_lst)))
					expected_response = CopyString((yyvsp[(3) - (3)].string));
				    }
    break;

  case 124:
#line 903 "inparser.y"
    { if (StoreOption((yyvsp[(2) - (4)].option),(yyval.opt_lst))){
  expected_response = CopyString((yyvsp[(3) - (4)].string));
  (void)StoreOption((yyvsp[(4) - (4)].option),(yyval.opt_lst));
}
				    }
    break;

  case 125:
#line 912 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (3)].option),(yyval.opt_lst));
				      bhsize = (yyvsp[(3) - (3)].num); }
    break;

  case 126:
#line 914 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (3)].option),(yyval.opt_lst));
				      percentage = (yyvsp[(3) - (3)].num); }
    break;

  case 127:
#line 916 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (4)].option),(yyval.opt_lst));
				      seed       = (yyvsp[(4) - (4)].num);
				      percentage = (yyvsp[(3) - (4)].num); }
    break;

  case 128:
#line 919 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (4)].option),(yyval.opt_lst));
				      (void)StoreOption((yyvsp[(4) - (4)].option),(yyval.opt_lst));
				      percentage = (yyvsp[(3) - (4)].num); }
    break;

  case 129:
#line 922 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (5)].option),(yyval.opt_lst));
					(void)StoreOption((yyvsp[(5) - (5)].option),(yyval.opt_lst));
					seed       = (yyvsp[(4) - (5)].num);
					percentage = (yyvsp[(3) - (5)].num); }
    break;

  case 130:
#line 926 "inparser.y"
    { /* no error is raised by now */
  what_error = OPT_ERR;
}
    break;

  case 131:
#line 931 "inparser.y"
    { /* empty */ }
    break;

  case 132:
#line 932 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 133:
#line 933 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 134:
#line 934 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (3)].option),(yyval.opt_lst));
				      undos_num = (yyvsp[(3) - (3)].num);
				    }
    break;

  case 135:
#line 939 "inparser.y"
    { (void)StoreOption((yyvsp[(1) - (1)].option),(yyval.opt_lst)); }
    break;

  case 136:
#line 940 "inparser.y"
    { (void)StoreOption((yyvsp[(1) - (1)].option),(yyval.opt_lst)); }
    break;

  case 137:
#line 941 "inparser.y"
    { (void)StoreOption((yyvsp[(1) - (1)].option),(yyval.opt_lst)); }
    break;

  case 138:
#line 942 "inparser.y"
    { (void)StoreOption((yyvsp[(1) - (1)].option),(yyval.opt_lst)); }
    break;

  case 139:
#line 943 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 140:
#line 944 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 141:
#line 945 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 142:
#line 946 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 143:
#line 947 "inparser.y"
    {
  /* no error is raised by now */
  what_error = OPT_ERR;
}
    break;

  case 144:
#line 953 "inparser.y"
    { /* empty */ }
    break;

  case 145:
#line 954 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 146:
#line 955 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 147:
#line 956 "inparser.y"
    { /* no error is raised by now */
  what_error = OPT_ERR;
}
    break;

  case 148:
#line 962 "inparser.y"
    { /* empty */ }
    break;

  case 149:
#line 963 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 150:
#line 964 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 151:
#line 965 "inparser.y"
    { (void)StoreOption((yyvsp[(2) - (2)].option),(yyval.opt_lst)); }
    break;

  case 152:
#line 966 "inparser.y"
    { /* no error is raised by now */
  what_error = OPT_ERR;
}
    break;

  case 153:
#line 971 "inparser.y"
    {if (numGate < MAX_ARGS)
				(yyval.ident_lst)[numGate++] = (yyvsp[(1) - (1)].string);
 else
   (void)printf("      WARNING : gate <%s> ignored\n",(yyvsp[(1) - (1)].string));
			    }
    break;

  case 154:
#line 976 "inparser.y"
    {if (numGate < MAX_ARGS)
		    (yyval.ident_lst)[numGate++] = (yyvsp[(2) - (2)].string);
else
  (void)printf("      WARNING : gate <%s> ignored\n",(yyvsp[(2) - (2)].string));
		}
    break;

  case 155:
#line 983 "inparser.y"
    { /* empty */ }
    break;

  case 156:
#line 984 "inparser.y"
    { number_list = Add_list((yyvsp[(2) - (2)].num),number_list); }
    break;


/* Line 1267 of yacc.c.  */
#line 3085 "y.tab.c"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


#line 987 "inparser.y"



/******************************************************************
 *
 *      Lexical analyser.
 *
 *******************************************************************/

#define    isspecchar(c) (c=='#')||(c=='%')||(c=='&')||(c=='*')||(c=='+')||\
(c=='-')||(c=='.')||(c=='/')||(c=='<')||(c=='=')||\
(c=='>')||(c=='@')||(c=='\\')||(c=='^')||(c=='~')||\
(c=='{')||(c=='}')

#ifdef unix
# define ischar2(c) isalpha(c)||(c=='.')||(c=='_')||(c=='/')
#else
# define ischar2(c) isalpha(c)||(c=='.')||(c=='_')||(c=='\\')
#endif
#define    iscomma(c)      (c==',')
#define    isleftpar(c)  (c=='(')
#define    isrightpar(c) (c==')')
#define    isexclam(c)      (c=='!')
#define    isgreater(c)  (c=='>')
#define    iscomment(c)  (c=='%')
#define    isnull(c)      (c=='\0')

/* line
 * The input line is stored in this array.
 */
static char line[MAX_LINE];


/* pos_line
 * The value of this variable gives the next character of the input line.
 */
static int pos_line = -1;



/* ctoken
 * Current token.
 */
static char ctoken[MAX_LINE];


/* pos_ctoken
 * Position in ctoken.
 */
static int pos_ctoken;


/* gtchar
 * It returns the next character of the commands input line.
 * If there are no more characters, it requests one command line
 * input.
 */
static char gtchar()
{
  pos_line++;
  return(line[pos_line]);
}


/* ungtc
 * It decrements pos_line.
 */
static int ungtc()
{
  --pos_line;
}


static void ReadLine( s )
     char *s;
{
  int i=0;
  pos_line = -1;
  while ((line[i++]=*s++)!='\n')
    ;
  line[i]='\0';
}

/*----------------------------------------------------------------*/


/* TokenNameTyp
 * Pairs token name and token code.
 */
typedef struct Cell_Tokns { char *comand;
			    int tokns;
			  } TokenNameTyp;


/* CmdTokenNameTable
 * The equivalence between commands names and tokens are stored in this array.
 */
static TokenNameTyp CmdTokenNameTable[] = {
#ifdef INVEXP
  "vc*"           , VC,
  "vcnr*"         , VCNR,
  "pi*"           , PI,
  "k*"            , K,
#endif /* INVEXP */
  "r*ewrite"      , REWRITE,
  "p*rint"        , PRINT,
  "l*oad"         , LOAD,
  "d*atatable"    , DATA,
  "e*xpand"       , EXPAND,
  "f*reeexpand"   , FREE,
  "h*elp"         , HELP,
  "v*arexpand"    , VAR,
  "t*estexpand"   , TEST,
  "o*neexpand"    , ONE,
  "s*tep"         , STEP,
  "m*ove"         , MOVE,
  "q*uit"         , QUIT,
  "se*t"          , SET,
  "c*ommand"      , CMD,
#if defined(sun) || defined(MSDOS)
  "sta*tistics"    , STAT,
#endif
#ifdef SDEBUG
  "sa*ve"         , SAVE,
#endif
  "i*nterexpand"  , IT
};


/* StepTokenNameTable
 * The equivalence between commands names and tokens are store in this array.
 */
static TokenNameTyp StepTokenNameTable[] = {
  "p*rint"     ,PRINT,
  "e*xit"      ,EXIT,
  "m*enu"      ,MENU,
  "u*ndo"      ,UNDO,
  "t*race"     ,TRACE,
  "s*ync"      ,SYNC,
  "r*efused"   ,REFUSED,
  "?*"         ,STEPHELP,
  "sel*ect"    ,SELECT
};


/* cont_cmd
 * Number of commands stored in the CmdTokenNameTable
 */
static int cont_cmd=sizeof(CmdTokenNameTable)/sizeof(CmdTokenNameTable[0]);


/* cont_step
 * Number of commands stored in the StepTokenNameTable
 */
static int cont_step=sizeof(StepTokenNameTable)/sizeof(StepTokenNameTable[0]);



/* strcomp
 * It returns TRUE if "s1" is equal to "s2" until the character "*",
 * and a prefix of "s2" after the character "*".
 */
static boolean strcomp(s1,s2)
     char *s1;
     char *s2;
{ int i;

  for (i = 0 ; ; i++) {
    LASSERT(s2[i]!='\0');
    if (s2[i]=='*') break;
    if (s1[i]=='\0') return FALSE;
    if (s1[i]!= s2[i]) return FALSE;
  }
  for ( ; ; i++) {
    if (s1[i]=='\0') return TRUE;
    if (s2[i+1]=='\0') return FALSE;
    if (s1[i]!= s2[i+1]) return FALSE;
  }
}



/* Search_In_CmdTable
 * It searches in the commands table if string is a command. If
 * it is one command, it returns this position, otherwise -1.
 */
/* KJT 22/01/23: added 2int" type */
int Search_In_CmdTable(string)
     char *string;
{
  int aux;

  aux = 0;
  while (aux != cont_cmd) {
    if (strcomp(string,CmdTokenNameTable[aux].comand))
      return aux;
    else ++aux;
  }
  return(-1);
}

/* Search_In_StepTable
 * It searches in the step commands table if string is a command. If
 * it is one command, it returns this position, otherwise -1.
 */
/* KJT 22/01/23: added "int" type */
int Search_In_StepTable(string)
     char *string;
{
  int aux;

  aux = 0;
  while (aux != cont_step) {
    if (strcomp(string,StepTokenNameTable[aux].comand))
      return aux;
    else ++aux;
  }
  return(-1);
}


/* Get_CmdCommand
 * It returns the token of the command which commands table
 * position is pos.
 */
/* KJT 22/01/23: added 2int" type */
int Get_CmdCommand(pos)
     int pos;
{
  return(CmdTokenNameTable[pos].tokns);
}

/* Get_StepCommand
 * It returns the token of the command which commands table
 * position is pos.
 */
/* KJT 22/01/23: added 2int" type */
int Get_StepCommand(pos)
     int pos;
{
  return(StepTokenNameTable[pos].tokns);
}


/* Is_Cmd_Command
 * It returns the commands table position of the command string.
 * If string is not a command, it returns -1.
 */
static int Is_Cmd_Command(string)
     char *string;
{ int pos;

  LowerString(string);
  if ((pos = Search_In_CmdTable(string)) != -1)
    return(Get_CmdCommand(pos));
  return -1;
}

/* Is_Step_Command
 * It returns the commands table position of the command string.
 * If string is not a command, it returns -1.
 */
static int Is_Step_Command(string)
     char *string;
{ int pos;

  LowerString(string);
  if ((pos = Search_In_StepTable(string)) != -1)
    return(Get_StepCommand(pos));
  return -1;
}



/*----------------------------------------------------------------*/

/* WhichOption
 * return the option token related to char c
 */
int WhichOption( c )
     char c;
{
  /* char cs[2]; */

  switch (c){
  case 'a':
    return OPT_A;
  case 'b':
    return OPT_B;
  case 'c':
    return OPT_C;
  case 'd':
    return OPT_D;
  case 'e':
    return OPT_E;
  case 'g':
    return OPT_G;
  case 'i':
    return OPT_I;
  case 'o':
    return OPT_O;
  case 'p':
    return OPT_P;
  case 'q':
    return OPT_Q;
  case 's':
    return OPT_S;
  case 't':
    return OPT_T;
  case 'u':
    return OPT_U;
  case 'v':
    return OPT_V;
  case 'x':
    return OPT_X;
  case 'y':
    return OPT_Y;
  default :
    what_error = OPT_ERR;
    return ERROR;
  }
}

/*----------------------------------------------------------------*/



/* first_token
 * When first_token is TRUE:
 *    - identifiers in the input line are treated as command names.
 *    - numbers indicates a branch for Step mode (BRANCH token).
 * If first_token is FALSE:
 *    - identifiers in the input line are treated as IDENT tokens.
 *    - numbers are numbers *NUM token).
 */
static boolean first_token;


static int yylex_cmd(), yylex_step(), yylex_num(), yylex_expr();


/* yylex
 * This function provides the lexical analysis.
 */
int yylex()
{
  switch(lex_mode)
    { case CMDLEXMODE:
	return yylex_cmd();
      case NUMLEXMODE:
	return yylex_num();
      case EXPLEXMODE:
	return yylex_expr();
      case STEPLEXMODE:
	return yylex_step();
      default:
	Error("Unknown lex mode.");
      }
  return -1;
}


/* yylex_cmd
 * This function provides the lexical analysis.
 */
static int yylex_cmd()
{
  int c,aux,numb;

  pos_ctoken = 0;

  while ((c = gtchar()) == ' ' || c == '\t') ;

  if (c == '^')
    return ROOT;

  if (c == '\0') {
    return QUIT;
  }

  if (c == ',') {
    return c;
  }

  if (c == '\n') {
    return (int)NULL;
  }

  if (ischar2(c)) {
    while (isdigit(c) || ischar2(c) || (c=='-') || (c==':')) {
      ctoken[pos_ctoken++] = c;
      c = gtchar();
    }
    ungtc();
    ctoken[pos_ctoken] = '\0';
    LowerString(ctoken);
    if (first_token) {
      first_token = FALSE;
      if ( (aux = Is_Cmd_Command(ctoken)) != -1) {
	yylval.string = CopyString(ctoken);
	return aux;
      }
      else {
	return ERROR;
      }
    }
    else   {
      yylval.string = CopyString(ctoken);
      return IDENT;
    }
  }

  if (isdigit(c)) {
    while (isdigit(c)) {
      ctoken[pos_ctoken++] = c;
      c = gtchar();
    }
    ctoken[pos_ctoken] = '\0';
    numb = StringToInt(ctoken);
    if (isalpha(c)) {
      yylval.posic.num = numb;
      yylval.posic.mov = c;
      return POSIC;
    }
    else {
      ungtc();
      if (first_token)
	return ERROR;
      else {
	yylval.num = numb;
	return NUM;
      }
    }
  }

  if (c == '-')
    { c = gtchar();
      if (isalpha(c) != 0)
	{ yylval.option = c;
	  return WhichOption(c);
	}

      if (isdigit(c))
	{ ctoken[pos_ctoken++] = '-';
	  while (isdigit(c))
	    { ctoken[pos_ctoken++] = c;
	      c = gtchar();
	    }
	  ctoken[pos_ctoken] = '\0';
	  yylval.num = StringToInt(ctoken);
	  if (isalpha(c) == 0)
	    { ungtc();
	      return NUM;
	    }
	  else  { yylval.posic.num = yylval.num;
		  yylval.posic.mov = c;
		  return POSIC;
		}
	}
      ungtc();
      c = '-';
    }

  if (c == '+')
    { c = gtchar();
      if (isdigit(c))
	{ while (isdigit(c) != 0)
	    { ctoken[pos_ctoken++] = c;
	      c = gtchar();
	    }
	  ctoken[pos_ctoken] = '\0';
	  yylval.num = StringToInt(ctoken);
	  if (isalpha(c) == 0)  /* c no es letra */
	    { ungtc();
	      return NUM;
	    }
	  else  { yylval.posic.num = yylval.num;
		  yylval.posic.mov = c;
		  return POSIC;
		}
	}
      else { ungtc();
	     c = '+';
	   }
    }

  return ERROR;
}


/* yylex_step
 * This function provides the lexical analysis for the STEP mode.
 */
static int yylex_step()
{
  int c,aux,numb;

  pos_ctoken = 0;

  while ((c = gtchar()) == ' ' || c == '\t') ;

  if (c == '\0') {
    return QUIT;
  }

  if (c == '\n') {
    return (int)NULL;
  }

  if (ischar2(c) || (c=='?')) {
    while (isdigit(c) || ischar2(c) || (c=='-') || (c==':') || (c=='?')) {
      ctoken[pos_ctoken++] = c;
      c = gtchar();
    }
    ungtc();
    ctoken[pos_ctoken] = '\0';
    LowerString(ctoken);
    if (first_token) {
      first_token = FALSE;
      if ( (aux = Is_Step_Command(ctoken)) != -1) {
	yylval.string = CopyString(ctoken);
	return aux;
      }
      else
	return ERROR;
    }
    else   {
      yylval.string = CopyString(ctoken);
      return IDENT;
    }
  }

  if (isdigit(c)) {
    while (isdigit(c)) {
      ctoken[pos_ctoken++] = c;
      c = gtchar();
    }
    ungtc();
    ctoken[pos_ctoken] = '\0';
    numb = StringToInt(ctoken);
    if (first_token) {
      first_token = FALSE;
      yylval.num = numb;
      return BRANCH;
    }
    else   {
      yylval.num = numb;
      return NUM;
    }
  }


  if (c == '-') {
    c = gtchar();
    if (isalpha(c) != 0) {
      yylval.option = c;
      return WhichOption(c);
    }
    if (isdigit(c)) {
      ctoken[pos_ctoken++] = '-';
      while (isdigit(c)) {
	ctoken[pos_ctoken++] = c;
	c = gtchar();
      }
      ctoken[pos_ctoken] = '\0';
      yylval.num = StringToInt(ctoken);
      if (isalpha(c) == 0) {
	ungtc();
	if (first_token) {
	  first_token = FALSE;
	  return BRANCH;
	}
	else {
	  return NUM;
	}
      }
      else
	return ERROR;
    }
    ungtc();
    c = '-';
  }

  if (c == '+')
    { c = gtchar();
      if (isdigit(c))
	{ while (isdigit(c) != 0)
	    { ctoken[pos_ctoken++] = c;
	      c = gtchar();
	    }
	  ctoken[pos_ctoken] = '\0';
	  yylval.num = StringToInt(ctoken);
	  if (isalpha(c) == 0)  /* c no es letra */
	    { ungtc();
	      return NUM;
	    }
	  else
	    return ERROR;
	}
      else { ungtc();
	     c = '+';
	   }
    }

  return ERROR;
}



/* yylex_num
 * This function provides the lexical analysis for natural numbers.
 */
static int yylex_num()
{
  int c,numb;

  pos_ctoken = 0;

  while ((c = gtchar()) == ' ' || c == '\t') ;

  if (c == '\0') return (int)NULL;

  if (c == '\n') return (int)NULL;

  if (isdigit(c)) {
    while (isdigit(c)) {
      ctoken[pos_ctoken++] = c;
      c = gtchar();
    }
    ctoken[pos_ctoken] = '\0';
    numb = StringToInt(ctoken);
    if (isalpha(c))
      return ERROR;
    else {
      ungtc();
      yylval.num = numb;
      return NUM;
    }
  }
  else
    return NUM;
}



/* yylex_expr
 * This function provides the lexical analysis.
 */
static int yylex_expr()
{
  int c;

  pos_ctoken = 0;

  while (isspace(c=gtchar())) ;

  if (c == EOF)
    return 0;

  if (c == '\0')
    return (int)NULL;

  if (c == '\n')
    return c;

  if (iscomma(c)||isleftpar(c)||isrightpar(c))
    return c;

  if (isalnum(c)) {
    while (isalnum(c) || (c == '_')) {
      ctoken[pos_ctoken++] = c;
      c = gtchar();
    }
    ungtc();
    ctoken[pos_ctoken] = '\0';
    LowerString(ctoken);
    yylval.string = CopyString(ctoken);
    if (strcmp(ctoken,"of") == 0)
      return OF;
    else if (ctoken[pos_ctoken] == '_')
      return ERROR;
    else
      return IDENT;
  }

  if (isspecchar(c)) {
    while (isspecchar(c)) {
      ctoken[pos_ctoken++] = c;
      c = gtchar();
    }
    ungtc();
    ctoken[pos_ctoken] = '\0';
    yylval.string = CopyString(ctoken);
    return IDENT;
  }

  return ERROR;
}



/******************************************************************
 *
 *
 *
 *******************************************************************/


/* InitInterpreter
 * Inits the module.
 */
/*
   void InitInterpreter()
   {
   lex_mode = CMDLEXMODE;
   }
   */


/******************************************************************
 *
 *   Command: Move.
 *
 *******************************************************************/

/* ECmove
 * Execute the command move.
 * contmove is the number of movements and move_lst is the list
 * of movements.
 */
static void ECmove(contmove,move_lst)
     int contmove;
     moveTyp *move_lst;
{ int i;

  if (GetCursor() != NULL)
    { for (i = 0;i<contmove;i++)
	if (move_lst[i].mvType == POSITION)
	  {(void)printf("move %d%c\n",move_lst[i].mv.mvrel.num,
			move_lst[i].mv.mvrel.mov);
	   (void)Move(move_lst[i].mv.mvrel.num,move_lst[i].mv.mvrel.mov);
	 }
	else if (move_lst[i].mvType == STRING)
	  {(void)printf("move %s\n",move_lst[i].mv.proc);
	   (void)MoveProc(move_lst[i].mv.proc);
	 }
	else if (move_lst[i].mvType == CHAR)
	  {(void)printf("move %c\n",move_lst[i].mv.root);
	   (void)MoveRoot();
	 }
    }
  else
    (void)printf("There is not any tree to move.\n");
  (void)printf("\n");
}


/*----------------------------------------------------------------*/

/* HelpComm
 * It writes the sinopsis of the command which token is its
 * parameter, token.
 * If h id TRUE then a explication is given.
 */
static void HelpComm(token,h)
     int token;
     boolean h;
{
  switch (token)
    { case REWRITE:
	Rewrite_Help(h);
	break;
      case LOAD :
	Load_Help(h);
	break;
      case PRINT :
	Print_Help(h);
	break;
      case SAVE :
	Save_Help(h);
	break;
      case DATA :
	Data_Help(h);
	break;
      case EXPAND :
	Expand_Help(h);
	break;
      case FREE :
	Free_Help(h);
	break;
      case VAR :
	Var_Help(h);
	break;
      case TEST :
	Test_Help(h);
	break;
      case ONE :
	One_Help(h);
	break;
      case IT:
	IT_Help(h);
	break;
      case SET:
	Set_Help(h);
	break;
      case CMD:
	Cmd_Help(h);
	break;
      case STAT:
	Stat_Help(h);
	break;
      case STEP :
	Step_Help(h);
	break;
      case MOVE :
	Move_Help(h);
	break;
      case QUIT :
	Quit_Help(h);
	break;
      case HELP :
	Help_Help(h);
	break;
#ifdef INVEXP
      case PI :
	PI_Help(h);
	break;
      case VC :
	VC_Help(h);
	break;
      case VCNR:
	VCNR_Help(h);
	break;
      case K:
	K_Help(h);
	break;
#endif /* INVEXP */

      default:
	(void)printf("  No help entry.\n");
      }
}


/*----------------------------------------------------------------*/

/* EChelp
 * Executes the command help.
 * cmd is the name of a command.
 */
static void EChelp(cmd)
     char *cmd;
{
  int aux;

  (void)printf("help ");
  if (cmd[0]!='\0') {
    (void)printf("%s\n\n",cmd);
    if ((aux = Is_Cmd_Command(cmd)) != -1)
      HelpComm(aux,TRUE);
    else
      (void)printf("%s: Unknown command\n",cmd);
  }
  else {
    (void)printf("\n\n");
    HelpComm(HELP,FALSE);
    HelpComm(LOAD,FALSE);
    HelpComm(SET,FALSE);
    HelpComm(CMD,FALSE);
    HelpComm(PRINT,FALSE);
#ifdef SDEBUG
    HelpComm(SAVE,FALSE);
#endif
    HelpComm(DATA,FALSE);
#if defined(sun) || defined(MSDOS)
    HelpComm(STAT,FALSE);
#endif
    HelpComm(MOVE,FALSE);
    HelpComm(QUIT,FALSE);
    (void)printf("  -------------- EXPANSION ---------------\n");
    HelpComm(FREE,FALSE);
    HelpComm(EXPAND,FALSE);
    HelpComm(VAR,FALSE);
    HelpComm(IT,FALSE);

    (void)printf("  ---------- TESTING EXPANSION -----------\n");
    HelpComm(TEST,FALSE);
    HelpComm(ONE,FALSE);


#ifdef INVEXP
    (void)printf("  ---------- INVERSE EXPANSION -----------\n");
    HelpComm(VC,FALSE);
    HelpComm(VCNR,FALSE);
    HelpComm(K,FALSE);
    HelpComm(PI,FALSE);
#endif /* INVEXP */

    (void)printf("  -------------- SIMULATION --------------\n");
    HelpComm(STEP,FALSE);
    HelpComm(REWRITE,FALSE);
  }
  (void)printf("\n");
}


/*----------------------------------------------------------------*/


/* code
 * It executes the command line input getting all commands with their
 * arguments of the internal stack.
 */
void code()
{
  switch (command_token)
    {
#ifdef INVEXP
    case VC:
      ECvis_com(numGate1,gate_list1,numGate2,gate_list2);
      CleanLinesMovements();
      break;
    case VCNR:
      ECvc_nrec(numGate1,gate_list1,numGate2,gate_list2);
      CleanLinesMovements();
      break;
    case K:
      ECk(numGate1,gate_list1,numGate2,gate_list2);
      CleanLinesMovements();
      break;
    case PI:
      ECpure_int(numGate1,gate_list1);
      CleanLinesMovements();
      break;
#endif /* INVEXP */
    case HELP:
      EChelp(command_name);
      break;
    case QUIT:
      ECquit();
      break;
    case REWRITE :
      ECrewrite(expr_rw);
      lex_mode = CMDLEXMODE;
      break;
    case LOAD :
      (void)ECload(CopyString(str_empty),CopyString(str_empty));
      break;
    case PRINT :
      switch(lex_mode) {
      case CMDLEXMODE:
	ECprint(lengthOpcList,optionList,depth,outfile_name,PrintString);
	break;
      case STEPLEXMODE:
	ECstep_print(lengthOpcList,optionList,depth,outfile_name,PrintString);
	break;
      default:
	(void)printf("     Lex mode error.\n\n");
      }
      break;
    case SAVE :
      ECsave(outfile_name,PrintString);
      break;
    case DATA :
      ECdata(option,low_limit,high_limit);
      break;
    case EXPAND :
      ECexpand(depth,lengthOpcList,optionList);
      CleanLinesMovements();
      break;
    case FREE :
      ECfree(depth,lengthOpcList,optionList);
      CleanLinesMovements();
      break;
    case VAR :
      ECvar(depth,lengthOpcList,optionList);
      CleanLinesMovements();
      break;
    case TEST :
      ECtest(lengthOpcList,depth,success_event,process_name,optionList,
	     expected_response,bhsize,seed,percentage,verbose_level);
      CleanLinesMovements();
      break;
    case SET :
      ECset( env_variable, env_value );
      break;
    case CMD :
      ECcmd( cmd_file );
      break;
    case ONE :
      for ( ; one_execs>0; one_execs-- )
	seed = ECone(depth,success_event,process_name,seed,
		     lengthOpcList,optionList,one_execs);
      CleanLinesMovements();
      break;
    case IT :
      ECit(lengthOpcList,depth,success_event,process_name,optionList);
      CleanLinesMovements();
      break;
    case STAT :
      ECstat();
      break;
    case MENU :
      ECstep_menu();
      break;
    case STEP :
      { BehTyp b,b_test;
	ListTyp dvl;
	DescriptorTyp sed, proc;
	SVdescriptorTyp sv;

	lex_mode = STEPLEXMODE;

	if (ECstep_start_CheckBehEventTest(success_event, process_name,
					   &sed, &proc,
					   lengthOpcList, optionList,
					   undos_num )) {
	  dvl = ECstep_start_GetUnassignedVars();
	  sv = CreateSV();
	  ECstep_start_ReadParameters(dvl,&sv);
	  Disp_list(dvl);
	  b = ECstep_start_Behaviour(&sv);
	  FreeSV(&sv);

	  b_test = ECstep_start_ComposeWithTest( b, sed, proc );
	  if (b_test == NULL) {
	    lex_mode = CMDLEXMODE;
	  }
	  else {
	    ECstep_start_Expan(b_test,undos_num);
	    ECstep_menu();
	  }
	}
	else
	  lex_mode = CMDLEXMODE;
	CleanLinesMovements();
	break;
      }
    case EXIT:
      ECstep_exit();
      lex_mode = CMDLEXMODE;
      break;
    case TRACE :
      ECstep_trace();
      break;
    case UNDO :
      (void)ECstep_undo();
      break;
    case BRANCH :
      ECstep_branch(branch);
      ECstep_menu();
      break;
    case SYNC :
      ECstep_sync(branch, process_name);
      break;
    case SELECT :
      ECstep_select(number_list);
      Disp_list(number_list);
      break;
    case STEPHELP :
      ECstep_help();
      break;
    case REFUSED :
      (void)ECstep_refused();
      break;
    case MOVE:
      if (num_mov!=0) {
	ECmove(num_mov,movement_tab);
	CleanLinesMovements();
      }
      else {
	(void)printf("\n");
	PrintMoves(PrintString,GetCursor(),0,TRUE);
	(void)printf("\n");
      }
      break;
    }
}


/******************************************************************
 *
 *  Resolving expression. (ExpCell to ExprTyp).
 *
 *******************************************************************/

/* NewExpCell
 * Get memory for a new cell
 */
static PExpCellTyp NewExpCell()
{
  PExpCellTyp c;

  c = (PExpCellTyp) emalloc(sizeof(ExpCellTyp));
  createdExpCell = Insert_list((DataListTyp)c,createdExpCell);
  c->name = NULL;
  c->pos_dname = NULL;
  c->infix = FALSE;
  c->dsort = 0;
  c->argl = NULL;
  return c;
}


/* DispExpCell
 * Free memory of a cell
 */
static void DispExpCell( c )
     PExpCellTyp    c;
{
  Disp_list(c->pos_dname);
  Disp_list(c->argl);
  free((char*)c);
}


/* FreeExpCell
 * Free the memory allocated by the ExpCell structs.
 */
static void FreeExpCell()
{
  Free_list(createdExpCell,DispExpCell);
  createdExpCell = NULL;
}


/* PrintExpCell
 * Prints ExpCell structs.
 * "pstr" is the function used to print strings.
 * Note: IntToString loss memory.
 */
static void PrintExpCell(c,pstr)
     PExpCellTyp    c;
     void (*pstr)();
{
  ListTyp al;

  if (c!=NULL) {
    pstr(" ");
    pstr(c->name);
    pstr(".");
    PrintInt(pstr,c->dsort);
    pstr("{");
    Print_list(c->pos_dname,IntToString,pstr);
    pstr("} (");
    for (al=c->argl ; al!=NULL ; al=Next_list(al))
      PrintExpCell((PExpCellTyp)LookInfo_list(al),pstr);
    pstr(")");
  }
}

/*----------------------------------------------------------------*/

/* SortArg_Fix_SortFather
 * Checks that the sort of the arguments are possible according
 * with the sort of the father operation.
 * Impossible arguments are deleted.
 */
static void SortArg_Fix_SortFather(c)
     PExpCellTyp c;
{
  ListTyp al,ldc,lsa,s,nexts;
  ListTyp lscai; /* list of sorts of c. Argument i. */
  int n,i;
  PExpCellTyp a;

  for (al=c->argl,n=0 ; (al!=NULL) && (!ResError) ; al=Next_list(al),n++) {

    lscai = Create_list();
    for (ldc = c->pos_dname ; ldc!=NULL ; ldc=Next_list(ldc)) {
      lsa = GetO_argl((DescriptorTyp)LookInfo_list(ldc));
      for (i=1 ; i<=n ; i++)
	lsa = Next_list(lsa);
      lscai = Insert_list(LookInfo_list(lsa),lscai);
    }

    a= (PExpCellTyp) LookInfo_list(al);
    lsa = a->pos_dname;
    for (s=lsa ; s!=NULL ; s=nexts) {
      nexts = Next_list(s);
      if (!In_list((DataListTyp)GetO_sort((DescriptorTyp)LookInfo_list(s)),
		   lscai,EqInt)) {
	lsa = DeleteNode_list(s,lsa);
	changes = TRUE;
      }
    }
    a->pos_dname = lsa;
    Disp_list(lscai);

    if (a->pos_dname==NULL) {
      ResError = TRUE;
      if (c->infix)
	(void)sprintf(ResErrorMsg,
		      "\n      ERROR: _%s_ %s\n\n",
		      c->name,"operation undefined.");
      else
	(void)sprintf(ResErrorMsg,
		      "\n      ERROR: %s %s\n\n",
		      c->name,"operation undefined.");
    }
  }
  for (al=c->argl; (al!=NULL) && (!ResError) ; al=Next_list(al))
    SortArg_Fix_SortFather((PExpCellTyp) LookInfo_list(al));
}

/*----------------------------------------------------------------*/

/* SortFather_Fix_SortArg
 * Checks that the fathers are possible according with the sort of
 * the arguments.
 * Impossible fathers are deleted.
 */
static void SortFather_Fix_SortArg(c)
     PExpCellTyp c;
{
  ListTyp al,lds,ldc,d,nextd,lda;
  PExpCellTyp a;
  int n,i;
  boolean found;

  ldc = c->pos_dname;
  for (d=ldc ; (d!=NULL) && (!ResError) ; d=nextd) {
    nextd = Next_list(d);
    lds = GetO_argl((DescriptorTyp)LookInfo_list(d));
    n = 0;
    while(lds!=NULL) {
      al = c->argl;
      for (i=1 ; i<=n ; i++)
	al = Next_list(al);
      a = (PExpCellTyp) LookInfo_list(al);

      found = FALSE;
      for (lda=a->pos_dname ; (lda!=NULL)&&(!found) ; lda=Next_list(lda))
	if ((DescriptorTyp)LookInfo_list(lds) ==
	    GetO_sort((DescriptorTyp)LookInfo_list(lda)))
	  found = TRUE;

      if (!found) {
	ldc = DeleteNode_list(d,ldc);
	changes = TRUE;
	break;
      }

      lds=Next_list(lds);
      n++;
    }
    c->pos_dname = ldc;

    if (c->pos_dname==NULL) {
      ResError = TRUE;
      if (c->infix)
	(void)sprintf(ResErrorMsg,"\n      ERROR: _%s_ %s\n\n",
		      c->name,"operation undefined.");
      else
	(void)sprintf(ResErrorMsg,"\n      ERROR: %s %s\n\n",
		      c->name,"operation undefined.");
    }
  }
  for (al=c->argl; (al!=NULL) && (!ResError) ; al=Next_list(al))
    SortFather_Fix_SortArg((PExpCellTyp)LookInfo_list(al));
}

/*----------------------------------------------------------------*/

/* CheckNumArg
 * Checks the number of arguments of the operations.
 * Wrong operations are deleted.
 */
static void CheckNumArg(c)
     PExpCellTyp c;
{
  int nson;
  ListTyp ld,i,nexti;

  nson = Length_list(c->argl);
  ld = c->pos_dname;
  for (i=ld ; i!=NULL ; i=nexti) {
    nexti = Next_list(i);
    if (Length_list(GetO_argl((DescriptorTyp)LookInfo_list(i)))!=nson)
      ld = DeleteNode_list(i,ld);
  }
  c->pos_dname=ld;
  if (c->pos_dname==NULL) {
    ResError = TRUE;
    if (c->infix)
      (void)sprintf(ResErrorMsg,"\n      ERROR: _%s_ %s\n\n",
		    c->name,"operation undefined.");
    else
      (void)sprintf(ResErrorMsg,"\n      ERROR: %s %s\n\n",
		    c->name,"operation undefined.");
  }

  for (i=c->argl; (i!=NULL) && (!ResError) ; i=Next_list(i))
    CheckNumArg((PExpCellTyp)LookInfo_list(i));
}

/*----------------------------------------------------------------*/

/* Get_possibles
 * Returns a list with the possible descriptors.
 */
static ListTyp Get_possibles(name,dsort,infix)
     char          *name;
     DescriptorTyp dsort;
     boolean       infix;
{
  ListTyp lp;
  int i;

  lp = Create_list();
  for (i=LastTableO() ; i>0 ; i--)
    if (dsort==0) {
      if ((strcmp(GetO_name(i),name)==0) && (GetO_infix(i)==infix))
	lp = Insert_list((DataListTyp)i,lp);
    }
    else
      if ((strcmp(GetO_name(i),name)==0) && (GetO_sort(i)==dsort)
	  && (GetO_infix(i)==infix))
	lp = Insert_list((DataListTyp)i,lp);
  return lp;
}


/* Possibles
 * Calculates the possible descriptors for all the ExpCell.
 */
static boolean Possibles( c )
     PExpCellTyp c;
{
  ListTyp al;

  if (c!=NULL) {
    c->pos_dname = Get_possibles(c->name,c->dsort,c->infix);
    if (c->pos_dname==NULL) {
      ResError = TRUE;
      if (c->infix)
	(void)sprintf(ResErrorMsg,
		      "\n      ERROR: _%s_ %s\n\n",
		      c->name,"operation undefined.");
      else
	(void)sprintf(ResErrorMsg,
		      "\n      ERROR: %s %s\n\n",
		      c->name,"operation undefined.");
    }
    for (al=c->argl ; (al!=NULL) && (!ResError) ; al=Next_list(al))
      Possibles( (PExpCellTyp)LookInfo_list(al) );
  }
}

/*----------------------------------------------------------------*/

/* ExamResult
 * Examines the result seachching ExpCell with zero or more than
 * one possible descriptors.
 */
static void ExamResult(c)
     PExpCellTyp    c;
{
  ListTyp al;
  int l;

  if (!ResError) {
    l = Length_list(c->pos_dname);
    if (l==0) {
      ResError = TRUE;
      if (c->infix)
	(void)sprintf(ResErrorMsg,
		      "\n      ERROR: _%s_ %s\n\n",
		      c->name,"operation undefined.");
      else
	(void)sprintf(ResErrorMsg,
		      "\n      ERROR: %s %s\n\n",
		      c->name,"operation undefined.");
    }
    else if (l>1) {
      ResError = TRUE;
      if (c->infix)
	(void)sprintf(ResErrorMsg,
		      "\n      ERROR: _%s_ %s\n\n",
		      c->name,"operation ambiguous.");
      else
	(void)sprintf(ResErrorMsg,
		      "\n      ERROR: %s %s\n\n",
		      c->name,"operation ambiguous.");
    }
  }
  for (al=c->argl ; al!=NULL ; al=Next_list(al))
    ExamResult((PExpCellTyp)LookInfo_list(al));
}

/*----------------------------------------------------------------*/

/* ExpCellToExpr
 * Translation: ExpCellTyp to ExprTyp.
 */
static ExprTyp ExpCellToExpr( c )
     PExpCellTyp    c;
{
  ExprTyp e;
  ListTyp al;

  e = MakeE((DescriptorTyp)LookInfo_list(c->pos_dname),OperationC);
  for (al=c->argl ; al!=NULL ; al=Next_list(al))
    AddArgE(e,ExpCellToExpr((PExpCellTyp)LookInfo_list(al)));
  return e;
}

/*----------------------------------------------------------------*/

/* ResExpr
 * Transforms the PExpCellTyp "c" into a ExprTyp if the expression
 * can exist, or return NULL.
 */
static ExprTyp ResExpr(c)
     PExpCellTyp c;
{
  ExprTyp e;

  ResError = FALSE;
  Possibles(c);
  CheckNumArg(c);
  do {
    changes = FALSE;
    SortArg_Fix_SortFather(c);
    SortFather_Fix_SortArg(c);
  } while (changes);
  ExamResult(c);
  if (!ResError)
    e = ExpCellToExpr(c);
  else
    e = NULL;
  return e;
}

/*----------------------------------------------------------------*/

/* ReadNum
 * Reads a natural number form the keyboard.
 */
int ReadNum()
{
  int r, old_lex_mode;

  /*
     getline2(line);
     */
  ReadLine(getline2(""));

  InputLineIsEmpty = FALSE;
  old_lex_mode = lex_mode;
  lex_mode = NUMLEXMODE;
  Reset_values_parsed();
  if(yyparse()) {
    (void)printf("   Number: Syntax error.\n");
    r = -1;
  }
  else
    r = yyval.num;
  lex_mode = old_lex_mode;
  return r;
}

/*----------------------------------------------------------------*/

/* ReadExpr
 * Reads an expression from the keyboard and returns its associated
 * ExprTyp in "*pe".
 * If there is an error FALSE if returned.
 * prompt is the prompt.
 * expSort is the expected sort.
 */
boolean ReadExpr( prompt, pe, expSort )
     char          * prompt;
     ExprTyp       * pe;
     DescriptorTyp expSort;
{
  boolean result;
  int old_lex_mode;

  InputLineIsEmpty = FALSE;
  ResError         = FALSE;
  ReadLine(getline2(prompt));
  old_lex_mode = lex_mode;
  lex_mode     = EXPLEXMODE;
  expectedSort = expSort;
  Reset_values_parsed();
  if(yyparse()) {
    (void)printf("\n      Expression: Syntax error.\n\n");
    *pe = NULL;
    result = FALSE;
  }
  else {
    FreeExpCell();
    if (InputLineIsEmpty) {
      *pe = NULL;
      result = TRUE;
    }
    else {
      *pe = yyval.expr;
      result = !ResError;
    }
  }
  lex_mode = old_lex_mode;
  expectedSort = 0;
  return result;
}


/*----------------------------------------------------------------*/

/* StringToExpr
 * Takes the string "s" and returns its associated ExprTyp in "*pe".
 * If there is an error FALSE if returned.
 * "expSort" is the expected sort.
 */
boolean StringToExpr( s, pe, expSort )
     char          * s;
     ExprTyp       * pe;
     DescriptorTyp expSort;
{
  boolean result;
  int old_lex_mode;

  if (strlen(s)>=MAX_LINE) {
    printError("\n      Error: Expression too long.\n\n");
    *pe = NULL;
    result = FALSE;
  }

  InputLineIsEmpty = FALSE;
  ResError         = FALSE;
  (void)sprintf(line,"%s",s);
  pos_line = -1;
  old_lex_mode = lex_mode;
  lex_mode     = EXPLEXMODE;
  expectedSort = expSort;
  Reset_values_parsed();
  if(yyparse()) {
    printError("\n      Expression: Syntax error.\n\n");
    *pe = NULL;
    result = FALSE;
  }
  else {
    FreeExpCell();
    if (InputLineIsEmpty) {
      *pe = NULL;
      result = TRUE;
    }
    else {
      *pe = yyval.expr;
      result = !ResError;
    }
  }
  lex_mode = old_lex_mode;
  expectedSort = 0;
  return result;
}


/*----------------------------------------------------------------*/

/* ParseLine
 * interprets the command line placed in line[]
 */
static void ParseLine()
{
  int old_mode;

  what_error       = 0;
  ResError         = FALSE;
  InputLineIsEmpty = FALSE;
  numMove          = 0;
  numOpc           = 0;
  old_mode         = lex_mode;
  first_token      = TRUE;
  FreeExpCell();
  Reset_values_parsed();
  if ( yyparse() || what_error ) {
    switch(lex_mode)
      { case CMDLEXMODE:
	case STEPLEXMODE:
	  switch ( what_error ){
	  case OPT_ERR:
	    printTarget("      Option error.\n\n");
	    break;
	  default:
	    printTarget("      Command error.\n\n");
	    break;
	  }
	  break;
	case EXPLEXMODE:
	  printTarget("      Expression: Syntax error.\n\n");
	  break;
	default:
	  Error("Lex mode error.");
	}
    lex_mode = old_mode;
  }
  else {
    code();
  }
}


/* CommandInt
 * Command Interpreter.
 */
void CommandInt()
{
  lex_mode = CMDLEXMODE;
  while (TRUE) {
    switch(lex_mode)
      { case CMDLEXMODE:
	  ReadLine(getline2("lola> "));
	  break;
	case EXPLEXMODE:
	  ReadLine(getline2("expr> "));
	  break;
	case STEPLEXMODE:
	  ReadLine(getline2("<n>,Undo,Menu,Refused,Sync,Print,Trace,Exit,?> "));
	  break;
	default:
	  Error("Lex mode error.");
	}
    ParseLine();
  }
}

/*----------------------------------------------------------------*/

/* CommandLineInt
 * Command Line Interpreter.
 * Take a command line as input, execute it and return.
 * Leave the LEX MODE unchanged.
 */
void CommandLineInt( input_line )
     char * input_line;
{
  ReadLine( input_line );
  ParseLine();
}

/*----------------------------------------------------------------*/


















