/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  Santiago Pavon Gomez
  
  25-07-1990
  
  ************************************/


#ifndef inparser_H
#define inparser_H

/* LINTLIBRARY */

#include "baexpr.h"
#include "ligetlin.h"


/* ReadNum
 * Reads a natural number form the keyboard.
 */
extern int ReadNum();


/* ReadExpr
 * Reads a expression from the keyboard and returns its associates
 * ExprTyp in "*pe".
 * If there is an error NULL if returned.
 */
extern boolean ReadExpr( /* prompt, pe, expSort */ );
/*  char * prompt;
    ExprTyp * pe;
    DescriptorTyp expSort; */


/* StringToExpr
 * Takes the string "s" and returns its associated ExprTyp in "*pe".
 * If there is an error FALSE if returned.
 * "expSort" is the expected sort.
 */
extern boolean StringToExpr( /* s, pe, expSort */ );
/*  char          * s;
    ExprTyp       * pe;
    DescriptorTyp expSort;  */


/* CommandInt
 * Command Interpreter.
 */
extern void CommandInt();


/* CommandLineInt
 * Command Line Interpreter.
 * Take a command line as input, execute it and return.
 * Leave the LEX MODE unchanged.
 */
extern void CommandLineInt(/* line */);
/*       char * line; */


#endif




