/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  David Larrabeiti Lopez
  
  27 Nov 1992
  
  String Blocks management.
  
  
  COMPILATION OPTIONS: The behaviour of this module can be modified
  by the following compilation flags:
  
  (none)
  
  TYPE DEFINITIONS:
  StrBckTyp : strings with header : ( size , last position )
  
  FUNCTION DEFINITIONS:
  
  InitStrBck : init this module
  CreateStrBck : create a string block with a string of size STRBCKINC
  FreeStrBck : free a String Block
  CleanStrBck : clean a string block
  CopyStrStrBck : Make a copy of the string of a string block
  LookStrStrBck : Look at the string of a string block
  ConcatStrBck : Concat a string into a string block.
  CopyStrBck :  Copy a String Block
  
  ************************************/


#ifndef listrbk_H
#define listrbk_H

#include "limisc.h"


/* 
 * Descriptor of a String Block
 */
typedef void * StrBckTyp;


/* InitStrBck
 * Init the module
 */
extern void InitStrBck();


/* StatStrBck
 * Number of asked  and released strbk nodes
 */
extern void StatStrBck(/* new, released */);
/*       int * new, *released; */


/* CreateStrBck
 * create a string block with an array of char of size STRBCKINC
 */
extern StrBckTyp CreateStrBck();


/* FreeStrBck
 * Free a String Block
 */
extern void FreeStrBck(/* strBck */);
/*       StrBckTyp strBck; */


/* CleanStrBck
 * clean a string block
 */
extern void CleanStrBck(/* strBck */);
/*       StrBckTyp strBck; */


/* CopyStrBck
 * Copy a String Block
 */
extern StrBckTyp CopyStrBck(/* strBck */);
/*       StrBckTyp strBck; */


/* CopyStrStrBck
 * Make a copy of the string of a string block
 */
extern char * CopyStrStrBck(/* strBck */);
/*       StrBckTyp strBck; */


/* LookStrStrBck
 * Look at the string of a string block
 */
extern char * LookStrStrBck(/* strBck */);
/*       StrBckTyp strBck; */


/* GetStrStrBck
 * Returns the string stored in the string block "strBck" and
 * sets the string "strBck" to NULL.
 */
extern char * GetStrStrBck(/* strBck */);
/*       StrBckTyp strBck; */


/* ConcatStrBck
 * Concat a char string into a String Block. Never mind size overflow.
 */
extern StrBckTyp ConcatStrBck(/* strBck, str */);
/*       StrBckTyp strBck ;
         char    * str;  */


/* ConcatIntStrBck
 * Convert a integer into a char string and concat it into a String Block.
 */
extern StrBckTyp ConcatIntStrBck(/* strBck, n */);
/*       StrBckTyp strBck ;
         int       n; */


#endif





