# define PRIVATE static
# define PUBLIC 

#ifndef TRUE
# define TRUE  1
# define FALSE 0
#endif

#include <stdio.h>
#include <string.h>

#include "ldc.hh"
#include <lotos.hh>

#include "swbus.h"

PRIVATE char user_req= '0';
PRIVATE char user_data[BUFSIZ];

/* just draw the option menu */

PRIVATE void
draw_menu ()
{
    printf ("\n");
    printf ("Select one of:\n");
    printf ("1   ConReq\n");
    printf ("2   ConResp\n");
    printf ("3   DatReq\n");
    printf ("4   DisReq\n");
    printf ("5   repeated send (size)\n");
}

PUBLIC int
key_press ()
{
  char c;
  static int dmenu= TRUE;
  int i, size;

		    /* keep DatReq 'pressed' until otherwise stated */
  if (! cready (0) && user_req == '5')
    return TRUE;

  if (dmenu) {
    draw_menu();
    dmenu= FALSE;
  }
  if (! cready (0))
    return FALSE;

  user_req= cget (0);
  while (cready (0))
    c= cget (0);
  c= 0;
  dmenu= TRUE;
  if ('1' <= user_req && user_req <= '5') {
    if (user_req == '3') {
      printf ("Data to send: ");
      fflush (stdout);
      for (i= 0; c != '\n'; i++)
	user_data[i]= c= cget (0);
      user_data[i-1]= 0;
    }
    if (user_req == '5') {
      printf ("size of data packages to send: ");
      fflush (stdout);
      (void) scanf ("%d", &size);
      for (i= 0; i < size; i++)
	user_data[i]= '.';
      user_data[size]= 0;
    }
    return TRUE;
  } 
  else
    return FALSE;
}  

PUBLIC kdatum
user_input ()
{
  static kdatum repeated_pdu= NULL;

  switch (user_req) {
  case '1':
    return ConReq ();
  case '2':
    return ConResp ();
  case '3':
    return DatReq (mk_sdu (user_data));
  case '4':
    return DisReq ();
  case '5':
    if (repeated_pdu == NULL)
      repeated_pdu= kd_const(DatReq (mk_sdu (user_data)));
    return repeated_pdu;
  default:
    fprintf (stderr, "user_input requested without data, why?\n");
    exit (1);
  }
}

PUBLIC void
send_asp (sp)
  kdatum sp;
{
  printf ("\t%s\n", kd_gdraw (sp,1));
		    /* also makes an implicit kd_free */
}

PUBLIC void
clean_kb ()
{
  setblock (0, TRUE);
}

