# *************************************************************
#	Tartan.mk: Tartan Ada compiler, code generation
#		   (tested release 3.02)
# *************************************************************
#***********************************
# (C) Copyright 1993; dit/upm
#  Distributed under the conditions stated in the
#  TOPO General Public License (see file LICENSE)
#***********************************
# $Id: Tartan.mk,v 1.1 1993/06/23 16:13:55 lotos Exp $
#***********************************

FILTER=	sed -e 's/[^a-zA-Z0-9_]/_/g'	\
	    -e 's/___*/_/g'		\
	    -e 's/^_//'			\
	    -e 's/_$$//'		\
	    -e '/^[0-9]/s/^/_/'

init:
	(lib=`pwd | $(FILTER)`			;\
	 set -x					;\
	 adalib mkprj "$$lib" .			;\
	 echo "setprj $$lib" > .adalibrc	;\
	 mkdir Lbrry				;\
	 adalib mklib lib.root Lbrry		;\
	 echo "setlib lib.root" >> .adalibrc	;\
	)
import:
	(here=`pwd`				;\
	 cd "$(LIB)"				;\
	 lib=`pwd | $(FILTER)`			;\
	 cd "$$here"				;\
	 set -x					;\
	 adalib import "$$lib":lib.spec '*'	;\
	)
export:
	(lib=`pwd | $(FILTER)`			;\
	 set -x					;\
	 adalib mklib -s spec			;\
	 adalib exportcu -L=lib.spec '*'	;\
	 adalib freeze lib.spec			;\
	 adalib glbl "$$lib"			;\
	 adalib exportlib lib.spec		;\
	)
compile:
	tada $(SRC)
link:
	adalib link $(MAIN) -o $(TRGT)
clean:
	(lib=`pwd | $(FILTER)`			;\
	 set -x					;\
	 rm -f Prjct.Db				;\
	 rm -fr Lbrry				;\
	 rm -f .adalibrc			;\
	 adalib rmprj "$$lib"			;\
	)
