#ifndef dlng_HH
#define dlng_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "dlng.hh": symbols of lotos Data LaNGuage.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: dlng.sym,v $
 * Revision 1.12  1993/06/10  14:01:43  lotos
 * new annotation CALL
 *
 * Revision 1.11  1993/05/25  11:01:09  lotos
 * nueva anotacion ldcend
 *
 * Revision 1.10  1993/03/24  17:50:25  lotos
 * new annotation 'infix'
 *
 * Revision 1.9  1993/01/18  18:12:01  lotos
 * distribution issues
 *
 * Revision 1.8  1992/11/17  18:37:55  lotos
 * new annotation ldcinit
 *
 * Revision 1.7  1992/10/14  18:06:06  lotos
 * sort annotation added
 *
 * Revision 1.6  1992/09/02  14:00:15  lotos
 * accepts labelled equations
 * accepts textual equations
 *
 * Revision 1.5  92/05/06  17:54:37  lotos
 * shorter symbols
 * 
 * Revision 1.4  92/01/14  15:24:36  lotos
 * distribution issues
 * 
 * Revision 1.3  91/11/20  12:54:50  lotos
 * included parse annotation
 * 
 * Revision 1.2  91/11/14  12:56:24  lotos
 * annotation fail, added
 * 
 * Revision 1.1  91/07/11  14:04:09  lotos
 * Initial revision
 * 
 ***********************************
 $Id: dlng.sym,v 1.12 1993/06/10 14:01:43 lotos Exp $
 ***********************************/


/* Sorts Declaration */

#define BEGIN_SORTS_DECL	  1
#define   SORT_DECL		  2
#define END_SORTS_DECL		  3

/* Operations Declaration */

#define BEGIN_OPERATIONS_DECL	  4
#define   OPERATION_DECL	  5
#define END_OPERATIONS_DECL	  6

/* Declaration Type */

#define DEFINED			  7
#define IMPORTED		  8

/* Operation Definition */

#define BEGIN_OPERATION_DEF	  9
#define   BEGIN_RULE		 10
#define     BEGIN_PATTERN	 11
#define       OPERATION_MATCH	 12
#define       VALUE_MATCH	 13
#define     END_PATTERN		 14
#define     BEGIN_CONDITION	 15
#define     END_CONDITION	 16
#define     BEGIN_REPLACEMENT	 17
#define       OPERATION_EVAL	 18
#define       VALUE_EVAL	 19
#define     END_REPLACEMENT	 20
#define   END_RULE		 21
#define   BUILD			 22
#define END_OPERATION_DEF	 23

/* Operation Definition Type */

#define BUILD			 22
#define REWRITE			 24
#define GENERAL			 25

/* Identifiers */

#define EQUAL			 26

/* Comments */

#define COMMENT			 27
#define BEGIN_COMMENT		 28
#define END_COMMENT		 29
#define ANNOTATION		 30
#define BEGIN_ANNOTATION	 31
#define END_ANNOTATION		 32
#define LINE_QUOTE		 33

/* Annotation Identifiers */

#define LDC_ANNOTATION		 34
#define DRAW_ANNOTATION		 35
#define PARSE_ANNOTATION	 36
#define EQUAL_ANNOTATION	 37
#define FREE_ANNOTATION		 38
#define PARTIAL_ANNOTATION	 39
#define FAIL_ANNOTATION		 40
#define RULE_ANNOTATION		 41
#define SORT_ANNOTATION		 42
#define LDCINIT_ANNOTATION	 43
#define INFIX_ANNOTATION	 44
#define LDCEND_ANNOTATION	 45
#define CALL_ANNOTATION		 46

/* symbol table */
#ifndef dlng_IMP
extern	tSYM_LST sym_lst;
#else
	tSYM_LST sym_lst= { "a",
                            "b",
                            "c",
                            "d",
                            "e",
                            "f",
                            "g",
                            "h",
                            "i",
                            "j",
                            "k",
                            "l",
                            "m",
                            "n",
                            "o",
                            "p",
                            "q",
                            "r",
                            "s",
                            "t",
                            "u",
                            "v",
                            "w",
                            "x",
                            "y",
                            "z",
                            "#",
                            "[",
                            "]",
                            "!",
                            "{",
                            "}",
                            "%",
                            "A",
                            "B",
                            "C",
                            "D",
                            "E",
                            "F",
                            "G",
                            "H",
                            "I",
                            "J",
                            "K",
                            "L",
                            "M",
                            ESYM
                          };
#endif

#endif
