# **********************************************************************
#    "split.awk": splits long lines into words.
# **********************************************************************

#***********************************
# (C) Copyright 1990, 1991; dit/upm
#  Distributed under the conditions stated in the
#  TOPO General Public License (see file LICENSE)
#***********************************
#$Log: split.awk,v $
# Revision 3.2  1993/09/30  17:39:53  lotos
# awk was complaining: too many fields; no longer
#
# Revision 3.1  1993/05/25  11:08:41  lotos
# new release
#
# Revision 2.1  91/07/11  14:17:02  lotos
# using alga
# 
# Revision 1.1  91/06/12  14:49:37  lotos
# Initial revision
# 
#***********************************
# $Id: split.awk,v 3.2 1993/09/30 17:39:53 lotos Exp $
#***********************************


BEGIN	{
	  MAX_LENGTH= 200
	  SPLIT_HMSG= "-- BEGIN splitted line (offset %d)\n"
	  SPLIT_TMSG= "-- END splitted line\n"
	}

length > MAX_LENGTH \
	{
	  line= $0
	  imax= length(line)
	  for (i= 1; i <= imax; ++i)
	    if (substr(line, i, 1) == " ")
	      continue;
	    else
	      break;
	  if (i >= imax)
	  { printf "\n"
	    next
	  }
	  if (i > 1)
	    line= substr(line, i);
	  offset= i - 1
	  printf SPLIT_HMSG, offset
	  if (line ~ /"/ || line ~ /'/)
	    printf "%s\n", substr(line, offset + 1)
	  else
	  { imax= length(line)
	    for (i= 1; i <= imax; ++i)
	      if (substr(line, i, 1) == " ")
	        printf "\n"
	      else
		printf "%s", substr(line, i, 1)
	    printf "\n"
	  }
	  printf SPLIT_TMSG, offset
	  next
	}

	{
	  print
	}
