/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: LDM.h,v $
 * Revision 1.12  1993/06/10  14:00:13  lotos
 * new annotation CALL
 *
 * Revision 1.11  1993/05/25  10:59:09  lotos
 * nueva anotacion ldcend
 *
 * Revision 1.10  1993/03/24  17:51:24  lotos
 * new annotation 'infix'
 *
 * Revision 1.9  1993/01/18  18:12:15  lotos
 * distribution issues
 *
 * Revision 1.8  1992/11/17  18:40:37  lotos
 * new annotation ldcinit
 *
 * Revision 1.7  1992/10/14  17:49:41  lotos
 * sort annotation added
 *
 * Revision 1.6  1992/09/02  15:44:35  lotos
 * new option to remove externa annotations
 * new option to print and label the equations
 * new debugging options: save modified CAST
 * overall debugging and improvements
 *
 * Revision 1.5  92/05/06  18:48:08  lotos
 * shorter symbols
 * 
 * Revision 1.4  92/01/14  15:24:53  lotos
 * distribution issues
 * 
 * Revision 1.3  91/11/20  13:04:25  lotos
 * parse annotation added
 * 
 * Revision 1.2  91/11/14  20:11:39  lotos
 * added fail annotation of LDM
 * 
 * Revision 1.1  91/02/06  20:09:37  lotos
 * Initial revision
 * 
 ***********************************/

/***********************************************************************

     "LDM.h": cabecera de "LDM.o".

***********************************************************************/

#ifndef LDM_H
#define LDM_H


/*
	SIMBOLOS DEL LENGUAJE
*/

/* Sorts Declaration */

#define BEGIN_SORTS_DECL	"a"
#define   SORT_DECL		"b"
#define END_SORTS_DECL		"c"

/* Operations Declaration */

#define BEGIN_OPERATIONS_DECL	"d"
#define   OPERATION_DECL	"e"
#define END_OPERATIONS_DECL	"f"

/* Declaration Type */

#define DEFINED			"g"
#define IMPORTED		"h"

/* Operation Definition */

#define BEGIN_OPERATION_DEF	"i"
#define   BEGIN_RULE		"j"
#define     BEGIN_PATTERN	"k"
#define       OPERATION_MATCH	"l"
#define       VALUE_MATCH	"m"
#define     END_PATTERN		"n"
#define     BEGIN_CONDITION	"o"
#define     END_CONDITION	"p"
#define     BEGIN_REPLACEMENT	"q"
#define       OPERATION_EVAL	"r"
#define       VALUE_EVAL	"s"
#define     END_REPLACEMENT	"t"
#define   END_RULE		"u"
#define   BUILD			"v"
#define END_OPERATION_DEF	"w"

/* Operation Definition Type */

#define BUILD			"v"
#define REWRITE			"x"
#define GENERAL			"y"

/* Identifiers */

#define EQUAL			"z"
#define OPERATION_IDENTIFIER_ROOT	"g"
#define SORT_IDENTIFIER_ROOT		"s"
#define NEW_VARIABLE_IDENTIFIER		"v"

/* Comments */

#define COMMENT			"#"
#define BEGIN_COMMENT		"["
#define END_COMMENT		"]"
#define ANNOTATION		"!"
#define BEGIN_ANNOTATION	"{"
#define END_ANNOTATION		"}"
#define LINE_QUOTE		"%"

/* Annotation Identifiers */

#define LDC_ANNOTATION		"A"
#define DRAW_ANNOTATION		"B"
#define PARSE_ANNOTATION	"C"
#define EQUAL_ANNOTATION	"D"
#define FREE_ANNOTATION		"E"
#define PARTIAL_ANNOTATION	"F"
#define FAIL_ANNOTATION		"G"
#define RULE_ANNOTATION		"H"
#define SORT_ANNOTATION		"I"
#define LDCINIT_ANNOTATION	"J"
#define INFIX_ANNOTATION	"K"
#define LDCEND_ANNOTATION	"L"
#define CALL_ANNOTATION		"M"


/*
	MACROS PARA SANGRAR EL LENGUAJE
*/

unsigned _TamSang;	/* Tamano del nivel de sangrado. */
unsigned _SangAct;	/* Sangrado actual. */

/* Incrementa el nivel de sangrado. */
#define IncSang()					\
	{						\
	  aborta_si(_SangAct + _TamSang < _SangAct)	\
	  _SangAct+= _TamSang;				\
	}						\

/* Decrementa el nivel de sangrado. */
#define DecSang()					\
	{						\
	  aborta_si(_SangAct < _TamSang)		\
	  _SangAct-= _TamSang;				\
	}

/* Sangra a partir de la posicion actual. */
#define Sangra()					\
	{ unsigned _i;					\
							\
	  for (_i= _SangAct; _i > 0; --_i)		\
	    (void) putchar(' ');			\
	}

/* Inicializa el sangrado. */
#define InicSang(Tam)					\
	{						\
	  _TamSang= (Tam);				\
	  _SangAct= 0;					\
	}


/*
	FUNCIONES BASICAS PARA ESCRIBIR EL LENGUAJE
*/

void EscComCl();
/* Escribe un comentario acerca de una clase. */

void EscComOp();
/* Escribe un comentario acerca de una operacion. */

void EscComRegla();
/* Escribe un comentario acerca de una regla. */

void EscAnotRegla();
/* Escribe una anotacion acerca de una regla. */

void EscAnot();
/* Escribe una anotacion. */

void EscRefExp();
/* Escribe la referencia a una expresion. */

void EscExp();
/* Escribe una expresion. */

void EscRegla();
/* Escribe una regla. */

#endif
