/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: errores.c,v $
 * Revision 1.15  1993/03/29  18:09:10  lotos
 * add constructor verification/s
 *
 * Revision 1.14  1993/03/24  17:51:24  lotos
 * new message format (emacs-like)
 * remove unnecessary messages, that go into glad
 *
 * Revision 1.13  1993/01/18  18:12:15  lotos
 * distribution issues
 *
 * Revision 1.12  1993/01/12  20:20:28  lotos
 * portability issues
 *
 * Revision 1.11  1992/12/02  10:59:06  lotos
 * remove error message: unnamed sort
 * a warning moved into an error: unnamed operation
 *
 * Revision 1.10  1992/10/14  17:43:47  lotos
 * forget about ophuscation
 *
 * Revision 1.9  1992/05/06  18:50:55  lotos
 * avoid lint complaints w.r.t. exit()
 *
 * Revision 1.8  92/02/21  17:18:12  lotos
 * minor fixs
 *
 * Revision 1.7  92/01/30  18:10:44  lotos
 * better error reporting
 *
 * Revision 1.6  92/01/14  15:25:22  lotos
 * distribution issues
 *
 * Revision 1.5  92/01/13  19:24:52  lotos
 * adaptec to ophuscate
 *
 * Revision 1.4  91/11/20  13:17:53  lotos
 * new error messages about draw and parse annotations
 *
 * Revision 1.3  91/11/14  20:45:18  lotos
 * some new messages for annotation preprocessing
 *
 * Revision 1.2  91/04/11  18:33:56  lotos
 * new and/or better error messages
 *
 * Revision 1.1  91/02/06  20:15:51  lotos
 * Initial revision
 *
 ***********************************/

/* KJT 29/10/04: changed to use "stdarg" instead of "varargs" */

#ifndef lint
static char rcsid[]= "$Id: errores.c,v 1.15 1993/03/29 18:09:10 lotos Exp $";
#endif

/***********************************************************************

     "errores.o": modulo de tratamiento de errores.

***********************************************************************/

/* KJT 12/02/12: Added */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "idle.h"
#include "LDM.h"

#include <stdarg.h>

void Error(CodErr IdErr, ...)
/* Escribe un mensaje de error con formato variable. */
{
  va_list Arg;

  va_start(Arg, IdErr);
  switch (IdErr)
  { case ERR_COND_ANORMAL:
    { char *NomFich;
      int NumLin;

      NomFich= va_arg(Arg, char *);
      NumLin= va_arg(Arg, int);
      (void) fprintf(stderr, "%s: abnormal condition: ",
		     NomProg);
      (void) fprintf(stderr, "file \"%s\", line %d.\n",
		     NomFich, NumLin);
      abort();
    }
    case ERR_NO_HAY_MEM:
    {
      (void) fprintf(stderr, "%s: not enough memory.\n",
		     NomProg);
      exit(1);
    }
    case ERR_FUN_NO_IMPLEM:
    { char *NomFun;

      NomFun= va_arg(Arg, char *);
      (void) fprintf(stderr, "%s: %s: FUNCION NO IMPLEMENTADA.\n",
		     NomProg, NomFun);
      exit(1);
    }
    case ERR_OPC_DESCON:
    {
      (void) fprintf(stderr, "%s: unknown option.\n",
		     NomProg);
      exit(1);
    }
    case ERR_NO_ABR_FICH:
    { char *NomFich;

      NomFich= va_arg(Arg, char *);
      (void) fprintf(stderr, "%s: cannot open file \"%s\".\n",
		     NomProg, NomFich);
      exit(1);
    }
    case ERR_MIEM_IZ_VAR:
    { char *NomObj;
      char *NomFich;
      int NumLin;

      NomObj= va_arg(Arg, char *);
      NomFich= va_arg(Arg, char *);
      NumLin= va_arg(Arg, int);
      (void) fprintf(stderr, "%s: %s(%d): unallowed left member.\n",
		     NomProg, NomFich, NumLin);
      (void) fprintf(stderr, "%*s", strlen(NomProg), "");
      (void) fprintf(stderr, "  (\"%s\" must be an operation).\n",
		     NomObj);
      break;
    }
    case ERR_MIEM_DCHO_INCOR:
    { char *NomObj;
      char *NomFich;
      int NumLin;

      NomObj= va_arg(Arg, char *);
      NomFich= va_arg(Arg, char *);
      NumLin= va_arg(Arg, int);
      (void) fprintf(stderr, "%s: %s(%d): incorrect right member.\n",
		     NomProg, NomFich, NumLin);
      (void) fprintf(stderr, "%*s", strlen(NomProg), "");
      (void) fprintf(stderr,
		     "  (\"%s\" doesn't appear in left member).\n",
		     NomObj);
      break;
    }
    case ERR_PREMISA_INCOR:
    { char *NomObj;
      char *NomFich;
      int NumLin;

      NomObj= va_arg(Arg, char *);
      NomFich= va_arg(Arg, char *);
      NumLin= va_arg(Arg, int);
      (void) fprintf(stderr, "%s: %s(%d): incorrect premiss.\n",
		     NomProg, NomFich, NumLin);
      (void) fprintf(stderr, "%*s", strlen(NomProg), "");
      (void) fprintf(stderr,
		     "  (\"%s\" doesn't appear in left member).\n",
		     NomObj);
      break;
    }
    case ERR_MIEM_IZ_EXPEXT:
    { char *NomObj;
      char *NomFich;
      int NumLin;

      NomObj= va_arg(Arg, char *);
      NomFich= va_arg(Arg, char *);
      NumLin= va_arg(Arg, int);
      (void) fprintf(stderr, "%s: %s(%d): unallowed external expression ",
		     NomProg, NomFich, NumLin);
      (void) fprintf(stderr, "in left member.\n");
      (void) fprintf(stderr, "%*s", strlen(NomProg), "");
      (void) fprintf(stderr, "  (arguments of \"%s\" must be ", NomObj);
      (void) fprintf(stderr, "constant expressions).\n");
      break;
    }
    case ERR_MIEM_IZ_NOCONS:
    { char *NomObj;
      char *NomFich;
      int NumLin;

      NomObj= va_arg(Arg, char *);
      NomFich= va_arg(Arg, char *);
      NumLin= va_arg(Arg, int);
      (void) fprintf(stderr, "%s: %s(%d): unallowed operation ",
		     NomProg, NomFich, NumLin);
      (void) fprintf(stderr, "in left member.\n");
      (void) fprintf(stderr, "%*s", strlen(NomProg), "");
      (void) fprintf(stderr, "  (\"%s\" is of an internal sort, ",
		     NomObj);
      (void) fprintf(stderr, "so it must be a constructor).\n");
      break;
    }
    case ERR_NOCONS_NOEC:
    { char *NomObj;
      char *NomFich;
      int NumLin;

      NomObj= va_arg(Arg, char *);
      NomFich= va_arg(Arg, char *);
      NumLin= va_arg(Arg, int);
      (void) fprintf(stderr, "%s: %s(%d): incorrect internal operation.\n",
		     NomProg, NomFich, NumLin);
      (void) fprintf(stderr, "%*s", strlen(NomProg), "");
      (void) fprintf(stderr, "  (\"%s\" is a non-constructor, ",
		     NomObj);
      (void) fprintf(stderr, "so it must have equations).\n");
      break;
    }
    case ERR_COMPIL_ABORT:
    {
      (void) fprintf(stderr, "%s: unable to generate code, ",
		     NomProg);
      (void) fprintf(stderr, "COMPILATION ABORTED.\n");
      exit(1);
    }
    default:
    {
      (void) fprintf(stderr, "%s: ERROR DESCONOCIDO.\n",
		     NomProg);
      abort();
    }
  }
  va_end(Arg);
}
