/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: patrones.h,v $
 * Revision 1.3  1993/01/18  18:12:15  lotos
 * distribution issues
 *
 * Revision 1.2  1992/01/14  15:25:00  lotos
 * distribution issues
 *
 * Revision 1.1  91/02/06  20:10:49  lotos
 * Initial revision
 * 
 ***********************************/

/***********************************************************************

     "patrones.h": cabecera de "patrones.o".

***********************************************************************/

#ifndef PATRONES_H
#define PATRONES_H


typedef struct ElemPat
{ int Tipo;
  TNODE *Ref;
  struct ElemPat *Ant;
} EstElemPat;	/* Estructura de un elemento de un patron. */

/* Tipos de elementos de un patron. */
#define Nulo		0
#define Operacion	1
#define Valor		2

typedef struct
{ int NumElem;
  EstElemPat *UltElem;
} EstPat;	/* Estructura para el manejo de patrones. */

/* Indica si un patron es incorrecto. */
#define PatIncorr(PatObj)					\
	  ((PatObj) == NULL ||					\
	   (PatObj)->NumElem < 0 ||				\
	   ((PatObj)->NumElem == 0? (PatObj)->UltElem != NULL	\
				  : (PatObj)->UltElem == NULL))

void InicPat();
/* Inicializa un patron. */

void AgrElemPat();
/* Agrega un elemento a un patron. */

void SuprElemPat();
/* Suprime un elemento de un patron. */

void SuprPat();
/* Suprime un patron. */

#endif
