%{
/* Revision 2000/07/00  16:32:00  kjt
   changed YYMAXDEPTH to 512 */

# include "swbus.h"
# define YYMAXDEPTH      512
# define YYSTYPE         yystype
# define putgrn(n)       (void)ITadd(n, gl)
# define class(nt)       { cls= 0; xxc= nt-1;   \
               for (xc= 0; xc < nt; xc++, xxc--)    \
                             if (stpick(xc)->type != tNULL) \
                 cls += (1 << xxc);}
# define ndput(tp)   { stput(tp);   \
               if (gn != NULL){gn->value0=  \
                  (CLR_TYPE)IAT_IT_add(gl, grnl); \
                  gl->size= 0;} \
               gn= (sttype() == tNULL) ? NULL : sttop(); }
# define ndterm(tp, val) { stput (tp);  \
                       staclr (c_lexv, (CLR_TYPE)val.name); \
                       staclr (c_line, (CLR_TYPE)val.line);}

IT* gl;
TNODE*  gn;
int cls;
int xc;
int xxc;

%}

%token QUIT 260
%token LOAD 261
%token XEWRITE 262
%token CHECK 263
%token VAR 264
%token LET 265
%token FREE 266
%token RESETVAR 267
%token IF 268
%token FI 269
%token ELSE 270
%token OF 271
%token DISPLAY 272
%token SORTS 273
%token OPNS 274
%token EQNS 275
%token VARS 276
%token SETDEB 277
%token SPECIAL 278
%token STAT 279
%token WRITE 280
%token STRING 281
%token RESET 282
%token EXEC 283
%token HELP 284
%token RENAME 285
%token IS 286
%token TRACE 287
%token IDENTIFIER 288
%token FILEID 289

%start cmdl


%%

I1repa                  :
	 /* empty */
	{ ndput(tNULL); }
	;

I1repa                  :
	 I1repa cmd
	{
	if (errorcount == 0)
	{
	 if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	}
	}
	;

cmdl                    :
	 I1repa
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tcmdl);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(1);
	}
	}
	;

cmd                     :
	 quit
	{
	if (errorcount == 0)
	{
	 putgrn(2);
	}
	}
	;

cmd                     :
	 load
	{
	if (errorcount == 0)
	{
	 putgrn(3);
	}
	}
	;

cmd                     :
	 rewrite
	{
	if (errorcount == 0)
	{
	 putgrn(4);
	}
	}
	;

cmd                     :
	 check
	{
	if (errorcount == 0)
	{
	 putgrn(5);
	}
	}
	;

cmd                     :
	 var
	{
	if (errorcount == 0)
	{
	 putgrn(6);
	}
	}
	;

cmd                     :
	 let
	{
	if (errorcount == 0)
	{
	 putgrn(7);
	}
	}
	;

cmd                     :
	 if
	{
	if (errorcount == 0)
	{
	 putgrn(8);
	}
	}
	;

cmd                     :
	 display
	{
	if (errorcount == 0)
	{
	 putgrn(9);
	}
	}
	;

cmd                     :
	 setdeb
	{
	if (errorcount == 0)
	{
	 putgrn(10);
	}
	}
	;

cmd                     :
	 stat
	{
	if (errorcount == 0)
	{
	 putgrn(11);
	}
	}
	;

cmd                     :
	 write
	{
	if (errorcount == 0)
	{
	 putgrn(12);
	}
	}
	;

cmd                     :
	 reset
	{
	if (errorcount == 0)
	{
	 putgrn(13);
	}
	}
	;

cmd                     :
	 exec
	{
	if (errorcount == 0)
	{
	 putgrn(14);
	}
	}
	;

cmd                     :
	 help
	{
	if (errorcount == 0)
	{
	 putgrn(15);
	}
	}
	;

cmd                     :
	 rename
	{
	if (errorcount == 0)
	{
	 putgrn(16);
	}
	}
	;

cmd                     :
	 trace
	{
	if (errorcount == 0)
	{
	 putgrn(17);
	}
	}
	;

cmd                     :
	 xfree
	{
	if (errorcount == 0)
	{
	 putgrn(18);
	}
	}
	;

cmd                     :
	 resetvar
	{
	if (errorcount == 0)
	{
	 putgrn(19);
	}
	}
	;

quit                    :
	 QUIT
	{
	if (errorcount == 0)
	{
	 ndput(tquit);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(20);
	}
	}
	;

load                    :
	 LOAD file_name
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tload);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(21);
	}
	}
	;

rewrite                 :
	 XEWRITE value_expression
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(trewrite);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(22);
	}
	}
	;

check                   :
	 CHECK value_expression '=' value_expression
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tcheck);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(23);
	}
	}
	;

var                     :
	 VAR variable_declaration
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tvar);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(24);
	}
	}
	;

let                     :
	 LET identifier '=' value_expression
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tlet);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(25);
	}
	}
	;

I2repp_sep              :
	 identifier_declaration
	;

I2repp_sep              :
	 I2repp_sep ',' identifier_declaration
	{ if (errorcount == 0) stlrlink (); }
	;

variable_declaration    :
	 I2repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tvariable_declaration);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(26);
	}
	}
	;

identifier_declaration  :
	 identifier_declaration_list ':' sort_identifier
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tidentifier_declaration);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(27);
	}
	}
	;

I3repp_sep              :
	 identifier
	;

I3repp_sep              :
	 I3repp_sep ',' identifier
	{ if (errorcount == 0) stlrlink (); }
	;

identifier_declaration_list :
	 I3repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tidentifier_declaration_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(28);
	}
	}
	;

I4opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I4opt                   :
	 ':' sort_identifier
	;

xfree                   :
	 FREE identifier_free_list I4opt
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(txfree);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(29);
	}
	}
	;

I5repp_sep              :
	 identifier
	;

I5repp_sep              :
	 I5repp_sep ',' identifier
	{ if (errorcount == 0) stlrlink (); }
	;

identifier_free_list    :
	 I5repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tidentifier_free_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(30);
	}
	}
	;

I6opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I6opt                   :
	 ':' sort_identifier
	;

resetvar                :
	 RESETVAR identifier_reset_list I6opt
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tresetvar);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(31);
	}
	}
	;

I7repp_sep              :
	 identifier
	;

I7repp_sep              :
	 I7repp_sep ',' identifier
	{ if (errorcount == 0) stlrlink (); }
	;

identifier_reset_list   :
	 I7repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tidentifier_reset_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(32);
	}
	}
	;

if                      :
	 IF '(' value_expression '=' value_expression ')' cmdl FI
	{
	if (errorcount == 0)
	{
	 class(3);
	 stlrlink ();
	 stlrlink ();
	 ndput(tif);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(33);
	}
	}
	;

if                      :
	 IF '(' value_expression '=' value_expression ')' cmdl ELSE cmdl FI
	{
	if (errorcount == 0)
	{
	 class(4);
	 stlrlink ();
	 stlrlink ();
	 stlrlink ();
	 ndput(tif);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(34);
	}
	}
	;

I8opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I8opt                   :
	 OF sort_identifier
	;

value_expression        :
	 term_expression I8opt
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tvalue_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(35);
	}
	}
	;

I9opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I9opt                   :
	 OF sort_identifier
	;

value_expression        :
	 value_expression operation_identifier term_expression I9opt
	{
	if (errorcount == 0)
	{
	 class(4);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tvalue_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(36);
	}
	}
	;

I10opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I10opt                  :
	 '(' value_expression_list ')'
	;

term_expression         :
	 operation_identifier I10opt
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tterm_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(37);
	}
	}
	;

term_expression         :
	 '(' value_expression ')'
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tterm_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(38);
	}
	}
	;

I11repp_sep             :
	 value_expression
	;

I11repp_sep             :
	 I11repp_sep ',' value_expression
	{ if (errorcount == 0) stlrlink (); }
	;

value_expression_list   :
	 I11repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tvalue_expression_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(39);
	}
	}
	;

I12opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I12opt                  :
	 item
	;

display                 :
	 DISPLAY I12opt
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tdisplay);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(40);
	}
	}
	;

item                    :
	 sort
	{
	if (errorcount == 0)
	{
	 putgrn(41);
	}
	}
	;

item                    :
	 opn
	{
	if (errorcount == 0)
	{
	 putgrn(42);
	}
	}
	;

item                    :
	 eqn
	{
	if (errorcount == 0)
	{
	 putgrn(43);
	}
	}
	;

item                    :
	 vars
	{
	if (errorcount == 0)
	{
	 putgrn(44);
	}
	}
	;

sort                    :
	 SORTS
	{
	if (errorcount == 0)
	{
	 ndput(tsort);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(45);
	}
	}
	;

opn                     :
	 OPNS
	{
	if (errorcount == 0)
	{
	 ndput(topn);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(46);
	}
	}
	;

eqn                     :
	 EQNS
	{
	if (errorcount == 0)
	{
	 ndput(teqn);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(47);
	}
	}
	;

vars                    :
	 VARS
	{
	if (errorcount == 0)
	{
	 ndput(tvars);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(48);
	}
	}
	;

I13opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I13opt                  :
	 deb_value
	;

setdeb                  :
	 SETDEB I13opt
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tsetdeb);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(49);
	}
	}
	;

deb_value               :
	 SPECIAL
	{
	if (errorcount == 0)
	{
	 ndput(tdeb_value);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(50);
	}
	}
	;

stat                    :
	 STAT stat_value
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tstat);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(51);
	}
	}
	;

stat_value              :
	 SPECIAL
	{
	if (errorcount == 0)
	{
	 ndput(tstat_value);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(52);
	}
	}
	;

write                   :
	 WRITE string
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(twrite);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(53);
	}
	}
	;

string                  :
	 STRING
	{
	if (errorcount == 0)
	{
	 ndput(tstring);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(54);
	}
	}
	;

reset                   :
	 RESET
	{
	if (errorcount == 0)
	{
	 ndput(treset);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(55);
	}
	}
	;

exec                    :
	 EXEC file_name
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(texec);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(56);
	}
	}
	;

I14opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I14opt                  :
	 identifier
	;

help                    :
	 HELP I14opt
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(thelp);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(57);
	}
	}
	;

rename                  :
	 RENAME identifier IS identifier
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(trename);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(58);
	}
	}
	;

rename                  :
	 RENAME
	{
	if (errorcount == 0)
	{
	 ndput(trename);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(59);
	}
	}
	;

I15opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I15opt                  :
	 identifier
	;

trace                   :
	 TRACE I15opt
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(ttrace);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(60);
	}
	}
	;

operation_identifier    :
	 SPECIAL
	{
	if (errorcount == 0)
	{
	 ndput(toperation_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(61);
	}
	}
	;

operation_identifier    :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(toperation_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(62);
	}
	}
	;

sort_identifier         :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(tsort_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(63);
	}
	}
	;

identifier              :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(tidentifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(64);
	}
	}
	;

file_name               :
	 FILEID
	{
	if (errorcount == 0)
	{
	 ndput(tfile_name);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(65);
	}
	}
	;

%%

PRIVATE int
yylex ()
{
    token *tk;

   tk = gtk ();
   yylval = tk->yylval;
   return tk->type;
}

PUBLIC TNODE*
bast ()
{
   gl= ITcreate (4, 2, 1);
   gn= NULL;
   (void)yyparse();
   if (gn != NULL) gn->value0= (CLR_TYPE)IAT_IT_add(gl, grnl);
   return sttop();
}
