/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 * $Log: ildi.c,v $
 * Revision 2.5  1994/07/18  18:32:22  lotos
 * segregated LDI library (interpreter)
 *
 * Revision 2.4  1993/09/20  12:39:05  lotos
 * synchronized with kaos development
 * adpated to kdatum
 * udatum are not expected to be used
 * reduce number of reserved words: new user lexicon
 *
 * Revision 2.3  1993/08/02  16:58:34  lotos
 * fix declaration of help (warning)
 *
 * Revision 2.2  1993/06/22  08:49:38  lotos
 * fix variable redeclaration
 * fix standard input reading (batch mode)
 *
 * Revision 2.1  1993/06/10  13:37:30  lotos
 * completely remade
 *
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: ildi.c,v 2.5 1994/07/18 18:32:22 lotos Exp $";
#endif

# include "swbus.h"

/* KJT 20/01/23: added function prototypes */
PUBLIC void initline ();
void gl_cleanup();

char *prog_name = "ildi";

PUBLIC IAT* grnl;
PUBLIC FILE*   fin;
PUBLIC int nfname =-1;
PUBLIC char* filename;
PUBLIC char	sfile[BUFSIZ];
PUBLIC HT	hidtbl;

PUBLIC char*    palabra=NULL;

int     ildidebug= 0;
int     lexdebug= 0;
int     quit;
int	errorcount= 0;

PRIVATE TIOCOLOURS iocolours [] = {
# include "colours.c"
	"onode",   c_onode,     NULL,   dr_kdatum, NULL,   NULL,
	"snode",   c_snode,     NULL,   dr_klink,  NULL,   NULL,
	"sort",    c_sort,      IO_int,
	"ffath",   c_ffath,     getINTlist, putINTlist, NULL,        NULL,
	"poss",    c_poss,      getINTlist, putINTlist, NULL,        NULL,
	"rposs",   c_rposs,     getINTlist, putINTlist, NULL,        NULL,
	"item",    c_item,      IO_int,
	"opid",    c_opid,      IO_int,
	"nar",     c_nar,       IO_int,
	OTHERS
	};

PRIVATE void
help    ()
{
  (void) fprintf (stderr, "usage: ildi [-d] [-t] [sourcefile]\n");
}


PUBLIC int
main (argc, argv)
     int argc;
     char* argv[];
{
  int i, c;
  int res;

  while (argc > 1) {
    if (argv[1][0] == '-') {
      i= 0;
      while ((c= argv[1][++i]) != '\0')
	switch (c) {
	case 'd':
	  lexdebug++;
	  ildidebug++;
	  break;
	default:
	  help ();
	  exit (1);
	}
    }
    else
      (void) strcpy (sfile, argv[1]);
    argc--;
    argv++;
  }
  kaos.debug= TRUE;
  cast_init(iocolours);
  stinit(5000);
  SymbolTable= STcreate(100, 0, 1, TRUE);
  hidtbl= STHinit (SymbolTable, 5119);
  grnl= IATcreate (100, 10, 1);


  (void) printf ("\n\nLotos Data Command Interpreter. \n");
  (void) printf ("Introduce commands:\n");

  if (strlen (sfile) != 0){
    if (-1 == cload (sfile))
      exit(0);
  }

  (void) signal (SIGINT, usrbreak);

  res = 1;
  initline ();
  while (res != 0)
    res = exec ("");
  gl_cleanup ();
  exit (0);

  return 0;
}
