/***********************************
  (C) Copyright 1992; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 * $Log: swbus.h,v $
 * Revision 2.7  1994/07/19  12:34:06  lotos
 * adapted to revised ldi naming
 *
 * Revision 2.6  1994/07/18  18:33:25  lotos
 *  segregated LDI library (interpreter)
 *
 * Revision 2.5  1993/10/19  19:34:40  lotos
 * intkaos.hh becomes public
 *
 * Revision 2.4  1993/10/19  18:33:16  lotos
 * ported to BSD/386
 *
 * Revision 2.3  1993/09/20  12:39:05  lotos
 * synchronized with kaos development
 * adpated to kdatum
 * udatum are not expected to be used
 * reduce number of reserved words: new user lexicon
 *
 * Revision 2.2  1993/06/22  08:49:38  lotos
 * fix variable redeclaration
 * fix standard input reading (batch mode)
 *
 * Revision 2.1  1993/06/10  13:37:30  lotos
 * completely remade
 *
 ***********************************/

#define PUBLIC
#define SHARED  extern
#define PRIVATE static

#ifndef TRUE
# define FALSE 0
# define TRUE  1
#endif

/*****  Includes  *****/

# include <assert.h>
# include <stdio.h>
# include <string.h>
# include <ctype.h>
# include <assert.h>
# include <signal.h>
# include "rag.hh"
# include "nodes.h"
# include "cast.hh"
# include "ldi.hh"

# define nil(type) (type) NULL

# define infix 1
# define prefix 0

# define DSORTS	1
# define DOPNS	2
# define DEQNS	3
# define DVARS	4

SHARED  int     trace;
SHARED  int     ildidebug;
SHARED  int     lexdebug;
SHARED  int     quit;
SHARED  int     lineno;
SHARED  char    *prog_name;

SHARED  int     seqn;
SHARED  int     srw;
SHARED  int     sr;


SHARED  FILE*   fin;
SHARED  HT      hidtbl;     /* for SymbolTable */

SHARED  char*   palabra;
/*****  constants  *****/
# include "colours.h"
# define c_onode 102
# define c_sort  103
# define c_item  104
# define c_ffath 105
# define c_poss  106
# define c_opid  107
# define c_nar   108
# define c_snode 109
# define c_rposs 110

/*****  exported types  *****/

typedef struct stname {
        int	name;
        int*    line;
	char*	ckey;
	char*	cval;
        } yystype;

typedef struct  {
        int     type;
        yystype yylval;
        } token;


/*****  exported variables  *****/

SHARED  int     nfname;
SHARED  char*   filename;

SHARED  IAT*    grnl;

SHARED  int     errorcount;
SHARED  int     fcomm;
SHARED  char*   comm;

/**** extern functions ****/

PUBLIC	TNODE*	bast	();
PUBLIC	token*	gtk	();

/*****  exported functions  *****/

PUBLIC void	usrbreak	();

PUBLIC void	ildimsg		();
PUBLIC void	ildireport	();

PUBLIC int	lksort		();
PUBLIC int	lkvsort		();
PUBLIC int	getnar		();
PUBLIC int	nson		();

PUBLIC int	getoid		();
PUBLIC INTlist	getposs		();
PUBLIC INTlist	getnf		();
PUBLIC INTlist	getrpos		();

/**** Command interface ******/
PUBLIC void	chelp		();
PUBLIC void	cstat		();
PUBLIC void	cwrite		();
PUBLIC void	showdeb		();
PUBLIC void	setdeb		();
PUBLIC void	showtrace	();
PUBLIC void	settrace	();
PUBLIC int	exec		();
PUBLIC int	cload		();

/**** Colours functions ******/

PUBLIC void dr_kdatum ();
PUBLIC void dr_klink  ();


/*****  *****/
