/**************************************************************
 *       cond.c - LBM Interpreter Condition Handling Functions
 **************************************************************/
/***********************************************
 (C) Copyright 1994; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************************
 $Log: cond.c,v $
 * Revision 1.1  1994/11/08  17:00:02  lotos
 * Initial revision
 *
 **********************************************
 $Id: cond.c,v 1.1 1994/11/08 17:00:02 lotos Exp $
 **********************************************/

# include "swbus.h"


/* Returns the number of elements in list cl
 */
PUBLIC int
CNDlen (cl)
  CNDlist cl;
{
  int i = 0;

  for ( ; cl != NULL; cl = cl->next)
    i++;

  return i;
}

/* Check if element cnd is in cl
 */
PUBLIC boolean
CNDIsIn (cnd, cl)
  cond   cnd;
  CNDlist cl;
{
  for ( ; cl != NULL; cl = cl->next)
    if (cl->c == cnd)
      return TRUE;
  return FALSE;
}

/* Insert as is
 */
PUBLIC CNDlist
CNDcons (cnd, cl)
  cond   cnd;
  CNDlist cl;
{
  CNDlist aux = new_CNDlist ();

  aux->c    = cnd;
  aux->next = cl;
  return aux;
}

/* Do not duplicate
 */
PUBLIC CNDlist
CNDadd (cnd, cl)
  cond   cnd;
  CNDlist cl;
{
  CNDlist aux;

  if (NOTCNDIsIn (cnd, cl)) {
    aux = new_CNDlist ();

    aux->c    = cnd;
    aux->next = cl;
    cl = aux;
  }

  return cl;
}

/* Append two list.
 * First list is duplicated.
 * Second is shared (can be viewed as freeded)
 * It does not duplicate!
 */
PUBLIC CNDlist
CNDappend (cl1, cl2)
  CNDlist cl1, cl2;
{
  for ( ; cl1 != NULL; cl1 = cl1->next)
    if (NOTCNDIsIn (cl1->c, cl2))
      cl2 = CNDadd (cl1->c, cl2);

  return cl2;
}

/* Delete element cnd from list cl
 * the resulting list is returned
 */
PUBLIC CNDlist
CNDdel (cnd, cl)
  cond   cnd;
  CNDlist cl;
{
  CNDlist aux = NULL;

  if (cl != NULL) {
    if (cl->c == cnd) {
      aux = cl;
      cl->next = NULL;
      free_CNDlist (cl);
      cl = aux;
    }
    else {
      cl->next = CNDdel (cnd, cl->next);
    }
  }
  return cl;
}

/* Duplicate a list
 */
PUBLIC CNDlist
CNDcopy (cl)
  CNDlist cl;
{
  CNDlist aux = NULL;

  if (cl == NULL)
    return NULL;

  aux = new_CNDlist ();
  aux->c = cl->c;
  aux->next = CNDcopy (cl->next);
  return aux;
}

/* It returns the first element of a list
 */
PUBLIC cond
CNDfirst (cl)
  CNDlist cl;
{
  assert (cl != NULL);

  return cl->c;
}

/* It returns the list without the first element
 */
PUBLIC CNDlist
CNDtail (cl)
  CNDlist cl;
{
  if (cl == NULL)
    return NULL;

  return cl->next;
}

PUBLIC CNDlist
search_grd_kt (kt)
  krnlt kt;
{
  CNDlist cndl = NULL;

  if (kt->fth != NULL)
    cndl = search_grd_kt (kt->fth);

  return CNDappend (kt->grdl, cndl);
}
