%{
/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: lfe.spe,v $
 * Revision 2.20  2000/07/00  16:32:00  kjt
 * changed YYMAXDEPTH to 512
 *
 * Revision 2.19  1993/06/15  12:49:18  lotos
 * added funny colour to annotation nodes (# of lines)
 *
 * Revision 2.18  1993/03/24  18:02:51  lotos
 * new annotations for glad
 *
 * Revision 2.17  1993/01/18  18:04:54  lotos
 * distribution issues
 *
 * Revision 2.16  1992/11/19  18:26:07  lotos
 * bug fix
 *
 * Revision 2.15  1992/11/17  17:45:12  lotos
 * add source line information in 'i' and 'stop' nodes
 *
 * Revision 2.14  1992/11/04  16:30:57  lotos
 * add colour ldcinit
 * permit annotation ldc at the end of the spec
 * fix syntactical checking of parse annotation
 *
 * Revision 2.13  1992/10/14  19:19:47  lotos
 * added annotations type & copy
 * check contents pf annotations: empty, nonempty, one word
 *
 * Revision 2.12  1992/10/14  18:35:08  lotos
 * preserve behavioural annotations in their excom nodes
 * preserve annotations ordering
 * check consistency of combinations of annotations
 * remove annotations from STOP nodes
 * add new annotation IF, and USE
 *
 * Revision 2.11  1992/09/11  15:02:28  lotos
 * remove executable comments from tree, onto independent nodes
 *
 * Revision 2.10  1992/09/02  14:47:27  lotos
 * keep annotations as independent (and sorted!) nodes in AST
 *
 * Revision 2.9  92/01/14  15:22:33  lotos
 * distribution issues
 * 
 * Revision 2.8  92/01/13  16:23:35  lotos
 * ophuscation details
 * 
 * Revision 2.7  92/01/10  15:20:24  lotos
 * modified for ophuscation
 * 
 * Revision 2.6  92/01/10  14:58:43  lotos
 * annotations added for ascom compiler
 * allow to put default annotations about every undefined var declaration
 * 
 * Revision 2.5  91/08/28  15:51:12  lotos
 * added colours: internal, lexical, lexicalifpossible, using,
 *                constructor, nonconstructor, and Einfix
 * 
 * Revision 2.4  91/08/28  09:58:20  lotos
 * error productions added
 * 
 * Revision 2.3  91/04/15  15:19:09  lotos
 * change annotation C->lbc at the end of the spec
 * 
 * Revision 2.2  91/02/28  17:15:17  lotos
 * rule 'premiss ::= _value_expression' removed
 * consequences: colours c_bool, c_rectrue, c_true removed
 * unique identifier per class generated
 * 
 * 
 * Revision 2.1  90/10/30  14:11:41  lotos
 * compressed AST
 * use of hardwired colours
 * compressed value expressions
 * annotations to colours
 * 
 * Revision 1.5  90/06/04  15:22:47  lotos
 * if then else fi, removed
 * final match, removed
 * last ';' of eqns, made optional
 * executable comments are always lists
 * minor changes to shut lint up
 * adclr -> set_attr
 * 
 * Revision 1.4  90/03/16  17:38:39  lotos
 * new room for annotations lbc and ldc
 * 
 * Revision 1.3  90/01/29  13:06:25  lotos
 * fixing license details
 * 
 * Revision 1.2  90/01/25  15:56:38  lotos
 * carefully control where to put % { and % }
 * around version log
 * to avoid yacc complains
 * 
 * Revision 1.1  90/01/24  14:45:09  lotos
 * Initial revision
 * 
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: lfe.spe,v 2.19 1993/06/15 12:49:18 lotos Exp $";
#endif
%}
%{
# include "swbus.h"
# define YYMAXDEPTH      512
# define YYSTYPE         yystype
# define putgrn(n)       (void)ITadd(n, gl)
# define class(nt)       { cls= 0; xxc= nt-1;   \
               for (xc= 0; xc < nt; xc++, xxc--)    \
                             if (stpick(xc)->type != tNULL) \
                 cls += (1 << xxc);}
# define ndput(tp)   { stput(tp);   \
               if (gn != NULL){gn->value0=  \
                  (CLR_TYPE)IAT_IT_add(gl, grnl); \
                  gl->size= 0;} \
               gn= (sttype() == tNULL) ? NULL : sttop(); }
# define ndterm(tp, val) { stput (tp);  \
                       staclr (c_lexv, (CLR_TYPE)val.name); \
                       staclr (c_line, (CLR_TYPE)val.line);}

IT* gl;
TNODE*  gn;
int cls;
int xc;
int xxc;

%}

%token SPECIFICATION 260
%token BEHAVIOUR 261
%token ENDSPEC 262
%token WHERE 263
%token LIBRARY 264
%token ENDLIB 265
%token STYPE 266
%token IS 267
%token ENDTYPE 268
%token ACTUALIZEDBY 269
%token USING 270
%token RENAMEDBY 271
%token FORMALSORTS 272
%token FORMALOPNS 273
%token FORMALEQNS 274
%token SORTS 275
%token OPNS 276
%token EQNS 277
%token SORTNAMES 278
%token OPNNAMES 279
%token FOR 280
%token FORALL 281
%token ARROW 282
%token OFSORT 283
%token IMPLICATION 284
%token PROCESS 285
%token DEFINITION 286
%token ENDPROC 287
%token EXIT 288
%token NOEXIT 289
%token LET 290
%token IN 291
%token CHOICE 292
%token FAT_BAR 293
%token PAR 294
%token SYNCHRONIZATION 295
%token INTERLEAVING 296
%token LEFT_PAR 297
%token RIGHT_PAR 298
%token HIDE 299
%token ENABLE 300
%token ACCEPT 301
%token DISABLE 302
%token I 303
%token STOP 304
%token ANY 305
%token OF 306
%token IDENTIFIER 307
%token SPECIAL 308
%token EXCOMM 309

%start module


%%

module                  :
	 specification
	{
	if (errorcount == 0)
	{
	 putgrn(1);
	}
	}
	;

module                  :
	 data_type_definitions
	{
	if (errorcount == 0)
	{
	 putgrn(2);
	}
	}
	;

specification           :
	 SPECIFICATION specification_identifier formal_parameter_list executable_comment_list data_type_definitions BEHAVIOUR definition_block ENDSPEC executable_comment_list
	{
	if (errorcount == 0)
	{
	 class(6);
	 stlrlink ();
	 stlrlink ();
	 stlrlink ();
	 stlrlink ();
	 stlrlink ();
	 ndput(tspecification);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(3);
	}
	}
	;

specification           :
	 SPECIFICATION specification_identifier formal_parameter_list executable_comment_list data_type_definitions BEHAVIOUR error ENDSPEC executable_comment_list
	{
	if (errorcount == 0)
	{
	 class(6);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tspecification);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(4);
	}
	}
	;

specification           :
	 SPECIFICATION error BEHAVIOUR definition_block ENDSPEC executable_comment_list
	{
	if (errorcount == 0)
	{
	 class(3);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tspecification);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(5);
	}
	}
	;

specification           :
	 SPECIFICATION error ENDSPEC executable_comment_list
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tspecification);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(6);
	}
	}
	;

I1opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I1opt                   :
	 WHERE local_definitions
	;

definition_block        :
	 behaviour_expression I1opt
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tdefinition_block);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(7);
	}
	}
	;

I2repp                  :
	 local_definition
	;

I2repp                  :
	 I2repp local_definition
	{ if (errorcount == 0) stlrlink (); }
	;

local_definitions       :
	 I2repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tlocal_definitions);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(8);
	}
	}
	;

local_definition        :
	 data_type_definition
	{
	if (errorcount == 0)
	{
	 putgrn(9);
	}
	}
	;

local_definition        :
	 process_definition
	{
	if (errorcount == 0)
	{
	 putgrn(10);
	}
	}
	;

I3repa                  :
	 /* empty */
	{ ndput(tNULL); }
	;

I3repa                  :
	 I3repa data_type_definition
	{
	if (errorcount == 0)
	{
	 if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	}
	}
	;

data_type_definitions   :
	 I3repa
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tdata_type_definitions);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(11);
	}
	}
	;

data_type_definition    :
	 type_definition
	{
	if (errorcount == 0)
	{
	 putgrn(12);
	}
	}
	;

data_type_definition    :
	 LIBRARY library_declaration ENDLIB
	{
	if (errorcount == 0)
	{
	 putgrn(13);
	}
	}
	;

data_type_definition    :
	 LIBRARY error ENDLIB
	{
	if (errorcount == 0)
	{
	 putgrn(14);
	}
	}
	;

type_definition         :
	 STYPE type_identifier IS p_expression ENDTYPE
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(ttype_definition);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(15);
	}
	}
	;

type_definition         :
	 STYPE error ENDTYPE
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(ttype_definition);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(16);
	}
	}
	;

I4repp_sep              :
	 type_identifier
	;

I4repp_sep              :
	 I4repp_sep ',' type_identifier
	{ if (errorcount == 0) stlrlink (); }
	;

library_declaration     :
	 I4repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tlibrary_declaration);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(17);
	}
	}
	;

I5opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I5opt                   :
	 type_union
	;

p_expression            :
	 I5opt p_specification
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tp_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(18);
	}
	}
	;

p_expression            :
	 type_identifier ACTUALIZEDBY type_union USING replacement
	{
	if (errorcount == 0)
	{
	 class(3);
	 stlrlink ();
	 stlrlink ();
	 ndput(tp_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(19);
	}
	}
	;

p_expression            :
	 type_identifier RENAMEDBY replacement
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tp_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(20);
	}
	}
	;

I6repp_sep              :
	 type_identifier
	;

I6repp_sep              :
	 I6repp_sep ',' type_identifier
	{ if (errorcount == 0) stlrlink (); }
	;

type_union              :
	 I6repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(ttype_union);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(21);
	}
	}
	;

I7opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I7opt                   :
	 FORMALSORTS formal_sorts
	;

I8opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I8opt                   :
	 FORMALOPNS formal_operations
	;

I9opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I9opt                   :
	 FORMALEQNS formal_equations
	;

I10opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I10opt                  :
	 SORTS sorts
	;

I11opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I11opt                  :
	 OPNS operations
	;

I12opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I12opt                  :
	 EQNS equations
	;

p_specification         :
	 I7opt I8opt I9opt I10opt I11opt I12opt
	{
	if (errorcount == 0)
	{
	 class(6);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tp_specification);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(22);
	}
	}
	;

I13opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I13opt                  :
	 SORTNAMES sort_pair_list
	;

I14opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I14opt                  :
	 OPNNAMES operation_pair_list
	;

replacement             :
	 I13opt I14opt
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(treplacement);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(23);
	}
	}
	;

I15repp                 :
	 sort_pair
	;

I15repp                 :
	 I15repp sort_pair
	{ if (errorcount == 0) stlrlink (); }
	;

sort_pair_list          :
	 I15repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tsort_pair_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(24);
	}
	}
	;

I16repp                 :
	 operation_pair
	;

I16repp                 :
	 I16repp operation_pair
	{ if (errorcount == 0) stlrlink (); }
	;

operation_pair_list     :
	 I16repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(toperation_pair_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(25);
	}
	}
	;

sort_pair               :
	 sort_identifier FOR sort_identifier
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tsort_pair);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(26);
	}
	}
	;

operation_pair          :
	 operation_identifier FOR operation_identifier
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(toperation_pair);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(27);
	}
	}
	;

I17repp_sep             :
	 sort_identifier
	;

I17repp_sep             :
	 I17repp_sep ',' sort_identifier
	{ if (errorcount == 0) stlrlink (); }
	;

formal_sorts            :
	 I17repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tformal_sorts);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(28);
	}
	}
	;

I18repp                 :
	 operation
	;

I18repp                 :
	 I18repp operation
	{ if (errorcount == 0) stlrlink (); }
	;

formal_operations       :
	 I18repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tformal_operations);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(29);
	}
	}
	;

I19opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I19opt                  :
	 FORALL identifier_declarations
	;

formal_equations        :
	 I19opt equation_lists
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tformal_equations);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(30);
	}
	}
	;

I20repp_sep             :
	 sort_id_comm
	;

I20repp_sep             :
	 I20repp_sep ',' sort_id_comm
	{ if (errorcount == 0) stlrlink (); }
	;

sorts                   :
	 I20repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tsorts);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(31);
	}
	}
	;

sort_id_comm            :
	 sort_identifier executable_comment_list
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tsort_id_comm);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(32);
	}
	}
	;

I21repp                 :
	 operation
	;

I21repp                 :
	 I21repp operation
	{ if (errorcount == 0) stlrlink (); }
	;

operations              :
	 I21repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(toperations);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(33);
	}
	}
	;

I22opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I22opt                  :
	 argument_list
	;

operation               :
	 descriptor_list ':' I22opt ARROW sort_identifier
	{
	if (errorcount == 0)
	{
	 class(3);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(toperation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(34);
	}
	}
	;

I23repp_sep             :
	 operation_descriptor
	;

I23repp_sep             :
	 I23repp_sep ',' operation_descriptor
	{ if (errorcount == 0) stlrlink (); }
	;

descriptor_list         :
	 I23repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tdescriptor_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(35);
	}
	}
	;

operation_descriptor    :
	 operation_identifier executable_comment_list
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(toperation_descriptor);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(36);
	}
	}
	;

operation_descriptor    :
	 '_' operation_identifier '_' executable_comment_list
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(toperation_descriptor);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(37);
	}
	}
	;

I24repp_sep             :
	 sort_identifier
	;

I24repp_sep             :
	 I24repp_sep ',' sort_identifier
	{ if (errorcount == 0) stlrlink (); }
	;

argument_list           :
	 I24repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(targument_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(38);
	}
	}
	;

I25opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I25opt                  :
	 FORALL identifier_declarations
	;

equations               :
	 I25opt equation_lists
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tequations);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(39);
	}
	}
	;

I26repp                 :
	 equation_list
	;

I26repp                 :
	 I26repp equation_list
	{ if (errorcount == 0) stlrlink (); }
	;

equation_lists          :
	 I26repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tequation_lists);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(40);
	}
	}
	;

I27opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I27opt                  :
	 FORALL identifier_declarations
	;

equation_list           :
	 OFSORT sort_identifier I27opt eqn_list
	{
	if (errorcount == 0)
	{
	 class(3);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tequation_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(41);
	}
	}
	;

I28repp_sep             :
	 equation
	;

I28repp_sep             :
	 I28repp_sep ';' equation
	{ if (errorcount == 0) stlrlink (); }
	;

eqn_list                :
	 I28repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(teqn_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(42);
	}
	}
	;

equation                :
	 simple_equation
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tequation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(43);
	}
	}
	;

equation                :
	 premisses IMPLICATION simple_equation
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tequation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(44);
	}
	}
	;

equation                :
	/* empty */
	{
	if (errorcount == 0)
	{
	 ndput(tequation);
	 putgrn(45);
	}
	}
	;

I29repp_sep             :
	 premiss
	;

I29repp_sep             :
	 I29repp_sep ',' premiss
	{ if (errorcount == 0) stlrlink (); }
	;

premisses               :
	 I29repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tpremisses);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(46);
	}
	}
	;

premiss                 :
	 simple_equation
	{
	if (errorcount == 0)
	{
	 putgrn(47);
	}
	}
	;

premiss                 :
	 implicit_true
	{
	if (errorcount == 0)
	{
	 putgrn(48);
	}
	}
	;

implicit_true           :
	 value_expression
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(timplicit_true);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(49);
	}
	}
	;

simple_equation         :
	 value_expression '=' value_expression
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tsimple_equation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(50);
	}
	}
	;

process_definition      :
	 PROCESS process_identifier formal_parameter_list DEFINITION definition_block ENDPROC
	{
	if (errorcount == 0)
	{
	 class(3);
	 stlrlink ();
	 stlrlink ();
	 ndput(tprocess_definition);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(51);
	}
	}
	;

process_definition      :
	 PROCESS error DEFINITION definition_block ENDPROC
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tprocess_definition);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(52);
	}
	}
	;

process_definition      :
	 PROCESS process_identifier formal_parameter_list DEFINITION error ENDPROC
	{
	if (errorcount == 0)
	{
	 class(3);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tprocess_definition);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(53);
	}
	}
	;

process_definition      :
	 PROCESS error ENDPROC
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tprocess_definition);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(54);
	}
	}
	;

I30opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I30opt                  :
	 gate_parameter_list
	;

I31opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I31opt                  :
	 value_parameter_list
	;

formal_parameter_list   :
	 I30opt I31opt functionality_list
	{
	if (errorcount == 0)
	{
	 class(3);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tformal_parameter_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(55);
	}
	}
	;

gate_parameter_list     :
	 '[' gate_declaration_list ']'
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tgate_parameter_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(56);
	}
	}
	;

gate_parameter_list     :
	 '[' error ']'
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tgate_parameter_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(57);
	}
	}
	;

value_parameter_list    :
	 '(' identifier_declarations ')'
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tvalue_parameter_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(58);
	}
	}
	;

value_parameter_list    :
	 '(' error ')'
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tvalue_parameter_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(59);
	}
	}
	;

I32opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I32opt                  :
	 '(' exit_list ')'
	;

functionality_list      :
	 ':' EXIT I32opt
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tfunctionality_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(60);
	}
	}
	;

functionality_list      :
	 ':' NOEXIT
	{
	if (errorcount == 0)
	{
     ndput(tfunctionality_list);
	 putgrn(61);
	}
	}
	;

I33repp_sep             :
	 sort_identifier
	;

I33repp_sep             :
	 I33repp_sep ',' sort_identifier
	{ if (errorcount == 0) stlrlink (); }
	;

exit_list               :
	 I33repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(texit_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(62);
	}
	}
	;

behaviour_expression    :
	 local_definition_expression
	{
	if (errorcount == 0)
	{
	 putgrn(63);
	}
	}
	;

behaviour_expression    :
	 sum_expression
	{
	if (errorcount == 0)
	{
	 putgrn(64);
	}
	}
	;

behaviour_expression    :
	 par_expression
	{
	if (errorcount == 0)
	{
	 putgrn(65);
	}
	}
	;

behaviour_expression    :
	 hiding_expression
	{
	if (errorcount == 0)
	{
	 putgrn(66);
	}
	}
	;

behaviour_expression    :
	 enable_exp
	{
	if (errorcount == 0)
	{
	 putgrn(67);
	}
	}
	;

local_definition_expression :
	 LET identifier_equations IN behaviour_expression
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tlocal_definition_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(68);
	}
	}
	;

local_definition_expression :
	 LET error IN behaviour_expression
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tlocal_definition_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(69);
	}
	}
	;

I34repp_sep             :
	 identifier_equation
	;

I34repp_sep             :
	 I34repp_sep ',' identifier_equation
	{ if (errorcount == 0) stlrlink (); }
	;

identifier_equations    :
	 I34repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tidentifier_equations);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(70);
	}
	}
	;

identifier_equation     :
	 identifier_declaration '=' value_expression
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tidentifier_equation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(71);
	}
	}
	;

sum_expression          :
	 CHOICE sum_domain_expression FAT_BAR behaviour_expression
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tsum_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(72);
	}
	}
	;

sum_expression          :
	 CHOICE error FAT_BAR behaviour_expression
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tsum_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(73);
	}
	}
	;

sum_domain_expression   :
	 identifier_declarations
	{
	if (errorcount == 0)
	{
	 putgrn(74);
	}
	}
	;

sum_domain_expression   :
	 gate_declarations
	{
	if (errorcount == 0)
	{
	 putgrn(75);
	}
	}
	;

par_expression          :
	 PAR par_domain_expression parallel_operator behaviour_expression
	{
	if (errorcount == 0)
	{
	 class(3);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tpar_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(76);
	}
	}
	;

par_expression          :
	 PAR error parallel_operator behaviour_expression
	{
	if (errorcount == 0)
	{
	 class(3);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tpar_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(77);
	}
	}
	;

par_domain_expression   :
	 gate_declarations
	{
	if (errorcount == 0)
	{
	 putgrn(78);
	}
	}
	;

parallel_operator       :
	 SYNCHRONIZATION
	{
	if (errorcount == 0)
	{
     ndput(tparallel_operator);
	 putgrn(79);
	}
	}
	;

parallel_operator       :
	 INTERLEAVING
	{
	if (errorcount == 0)
	{
     ndput(tparallel_operator);
	 putgrn(80);
	}
	}
	;

I35opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I35opt                  :
	 gate_list
	;

parallel_operator       :
	 LEFT_PAR I35opt RIGHT_PAR
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tparallel_operator);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(81);
	}
	}
	;

parallel_operator       :
	 LEFT_PAR error RIGHT_PAR
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tparallel_operator);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(82);
	}
	}
	;

hiding_expression       :
	 hiding_operator behaviour_expression
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(thiding_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(83);
	}
	}
	;

hiding_operator         :
	 HIDE gate_declaration_list IN
	{
	if (errorcount == 0)
	{
	 putgrn(84);
	}
	}
	;

hiding_operator         :
	 HIDE error IN
	{
	if (errorcount == 0)
	{
	 putgrn(85);
	}
	}
	;

enable_exp              :
	 disable_exp
	{
	if (errorcount == 0)
	{
	 putgrn(86);
	}
	}
	;

enable_exp              :
	 enable_expression
	{
	if (errorcount == 0)
	{
	 putgrn(87);
	}
	}
	;

enable_expression       :
	 disable_exp enable_operator enable_exp
	{
	if (errorcount == 0)
	{
	 class(3);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tenable_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(88);
	}
	}
	;

I36opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I36opt                  :
	 ACCEPT identifier_declarations IN
	;

enable_operator         :
	 ENABLE I36opt
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tenable_operator);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(89);
	}
	}
	;

disable_exp             :
	 parallel_exp
	{
	if (errorcount == 0)
	{
	 putgrn(90);
	}
	}
	;

disable_exp             :
	 disable_expression
	{
	if (errorcount == 0)
	{
	 putgrn(91);
	}
	}
	;

disable_expression      :
	 parallel_exp DISABLE disable_exp
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tdisable_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(92);
	}
	}
	;

parallel_exp            :
	 choice_exp
	{
	if (errorcount == 0)
	{
	 putgrn(93);
	}
	}
	;

parallel_exp            :
	 parallel_expression
	{
	if (errorcount == 0)
	{
	 putgrn(94);
	}
	}
	;

parallel_expression     :
	 choice_exp parallel_operator parallel_exp
	{
	if (errorcount == 0)
	{
	 class(3);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tparallel_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(95);
	}
	}
	;

choice_exp              :
	 guarded_exp
	{
	if (errorcount == 0)
	{
	 putgrn(96);
	}
	}
	;

choice_exp              :
	 choice_expression
	{
	if (errorcount == 0)
	{
	 putgrn(97);
	}
	}
	;

choice_expression       :
	 guarded_exp FAT_BAR choice_exp
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tchoice_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(98);
	}
	}
	;

guarded_exp             :
	 guarded_expression
	{
	if (errorcount == 0)
	{
	 putgrn(99);
	}
	}
	;

guarded_exp             :
	 action_prfix
	{
	if (errorcount == 0)
	{
	 putgrn(100);
	}
	}
	;

guarded_expression      :
	 guarded_operator guarded_exp
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tguarded_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(101);
	}
	}
	;

guarded_operator        :
	 guard ARROW
	{
	if (errorcount == 0)
	{
	 putgrn(102);
	}
	}
	;

guard                   :
	 '[' premiss ']'
	{
	if (errorcount == 0)
	{
	 putgrn(103);
	}
	}
	;

guard                   :
	 '[' error ']'
	{
	if (errorcount == 0)
	{
	 putgrn(104);
	}
	}
	;

action_prfix            :
	 action_prefix_expression
	{
	if (errorcount == 0)
	{
	 putgrn(105);
	}
	}
	;

action_prfix            :
	 atomic_expression
	{
	if (errorcount == 0)
	{
	 putgrn(106);
	}
	}
	;

action_prfix            :
	 process_instantiation
	{
	if (errorcount == 0)
	{
	 putgrn(107);
	}
	}
	;

action_prefix_expression :
	 executable_comment_list action_denotation ';' action_prfix
	{
	if (errorcount == 0)
	{
	 class(3);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(taction_prefix_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(108);
	}
	}
	;

action_denotation       :
	 gate_identifier executable_comment_list
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(taction_denotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(109);
	}
	}
	;

action_denotation       :
	 gate_identifier experiment_offer_list selection_predicate executable_comment_list
	{
	if (errorcount == 0)
	{
	 class(4);
	 stlrlink ();
	 stlrlink ();
	 stlrlink ();
	 ndput(taction_denotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(110);
	}
	}
	;

action_denotation       :
	 I executable_comment_list
	{
	if (errorcount == 0)
	{
  if (errorcount == 0)
  {
    class(1);
    ndput(taction_denotation);
    sttop()->value1= (CLR_TYPE)cls;
    if (stpick(1)->type == tNULL)
    {stswap(); stpop();}
    else stsflink ();
    staclr (c_line, (CLR_TYPE)$1.line);
    putgrn(111);
  }
	 putgrn(111);
	}
	}
	;

I37repp                 :
	 experiment_offer
	;

I37repp                 :
	 I37repp experiment_offer
	{ if (errorcount == 0) stlrlink (); }
	;

experiment_offer_list   :
	 I37repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(texperiment_offer_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(112);
	}
	}
	;

experiment_offer        :
	 '?' identifier_declaration_list ':' sort_identifier
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(texperiment_offer);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(113);
	}
	}
	;

experiment_offer        :
	 '!' value_expression
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(texperiment_offer);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(114);
	}
	}
	;

I38opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I38opt                  :
	 guard
	;

selection_predicate     :
	 I38opt
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tselection_predicate);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(115);
	}
	}
	;

atomic_expression       :
	 STOP
	{
	if (errorcount == 0)
	{
	  ndput(tatomic_expression);
	 putgrn(116);
	}
	}
	;

I39opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I39opt                  :
	 '(' exit_entry_list ')'
	;

atomic_expression       :
	 executable_comment_list EXIT I39opt
	{
	if (errorcount == 0)
	{
  if (errorcount == 0)
  {
    class(2);
    if (sttype() == tNULL) stpop();
    else if (stpick(1)->type == tNULL) {stswap(); stpop();}
    else stlrlink();
    ndput(tatomic_expression);
    sttop()->value1= (CLR_TYPE)cls;
    if (stpick(1)->type == tNULL)
                  {stswap(); stpop();}
    else stsflink ();
    putgrn(117);
    staclr (c_line, (CLR_TYPE)$2.line);
  }
	 putgrn(117);
	}
	}
	;

atomic_expression       :
	 executable_comment_list '(' behaviour_expression ')'
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tatomic_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(118);
	}
	}
	;

atomic_expression       :
	 executable_comment_list '(' error ')'
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tatomic_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(119);
	}
	}
	;

I40repp_sep             :
	 exit_entry
	;

I40repp_sep             :
	 I40repp_sep ',' exit_entry
	{ if (errorcount == 0) stlrlink (); }
	;

exit_entry_list         :
	 I40repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(texit_entry_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(120);
	}
	}
	;

exit_entry              :
	 value_expression
	{
	if (errorcount == 0)
	{
	 putgrn(121);
	}
	}
	;

exit_entry              :
	 ANY sort_identifier
	{
	if (errorcount == 0)
	{
	 putgrn(122);
	}
	}
	;

I41opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I41opt                  :
	 actual_gate_list
	;

I42opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I42opt                  :
	 '(' value_expression_list ')'
	;

process_instantiation   :
	 executable_comment_list process_identifier I41opt I42opt
	{
	if (errorcount == 0)
	{
	 class(4);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tprocess_instantiation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(123);
	}
	}
	;

actual_gate_list        :
	 '[' gate_list ']'
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tactual_gate_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(124);
	}
	}
	;

actual_gate_list        :
	 '[' error ']'
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tactual_gate_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(125);
	}
	}
	;

I43opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I43opt                  :
	 OF sort_identifier
	;

value_expression        :
	 term_expression I43opt
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tvalue_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(126);
	}
	}
	;

I44opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I44opt                  :
	 OF sort_identifier
	;

value_expression        :
	 value_expression operation_identifier term_expression I44opt
	{
	if (errorcount == 0)
	{
	 class(4);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tvalue_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(127);
	}
	}
	;

I45opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I45opt                  :
	 '(' value_expression_list ')'
	;

term_expression         :
	 operation_identifier I45opt
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tterm_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(128);
	}
	}
	;

term_expression         :
	 '(' value_expression ')'
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tterm_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(129);
	}
	}
	;

term_expression         :
	 '(' error ')'
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tterm_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(130);
	}
	}
	;

I46repp_sep             :
	 value_expression
	;

I46repp_sep             :
	 I46repp_sep ',' value_expression
	{ if (errorcount == 0) stlrlink (); }
	;

value_expression_list   :
	 I46repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tvalue_expression_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(131);
	}
	}
	;

I47repp_sep             :
	 identifier_declaration
	;

I47repp_sep             :
	 I47repp_sep ',' identifier_declaration
	{ if (errorcount == 0) stlrlink (); }
	;

identifier_declarations :
	 I47repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tidentifier_declarations);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(132);
	}
	}
	;

identifier_declaration  :
	 identifier_declaration_list ':' sort_identifier
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tidentifier_declaration);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(133);
	}
	}
	;

I48repp_sep             :
	 gate_declaration
	;

I48repp_sep             :
	 I48repp_sep ',' gate_declaration
	{ if (errorcount == 0) stlrlink (); }
	;

gate_declarations       :
	 I48repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tgate_declarations);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(134);
	}
	}
	;

I49repp_sep             :
	 gate_identifier
	;

I49repp_sep             :
	 I49repp_sep ',' gate_identifier
	{ if (errorcount == 0) stlrlink (); }
	;

gate_list               :
	 I49repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tgate_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(135);
	}
	}
	;

I50repp_sep             :
	 gate_identifier
	;

I50repp_sep             :
	 I50repp_sep ',' gate_identifier
	{ if (errorcount == 0) stlrlink (); }
	;

gate_declaration_list   :
	 I50repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tgate_declaration_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(136);
	}
	}
	;

gate_declaration        :
	 identifier_declaration_list IN '[' gate_list ']'
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tgate_declaration);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(137);
	}
	}
	;

I51repp_sep             :
	 identifier
	;

I51repp_sep             :
	 I51repp_sep ',' identifier
	{ if (errorcount == 0) stlrlink (); }
	;

identifier_declaration_list :
	 I51repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tidentifier_declaration_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(138);
	}
	}
	;

specification_identifier :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(tspecification_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(139);
	}
	}
	;

type_identifier         :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(ttype_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(140);
	}
	}
	;

sort_identifier         :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(tsort_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(141);
	}
	}
	;

operation_identifier    :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(toperation_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(142);
	}
	}
	;

operation_identifier    :
	 SPECIAL
	{
	if (errorcount == 0)
	{
	 ndput(toperation_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(143);
	}
	}
	;

process_identifier      :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(tprocess_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(144);
	}
	}
	;

gate_identifier         :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(tgate_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(145);
	}
	}
	;

identifier              :
	 IDENTIFIER executable_comment_list
	{
	if (errorcount == 0)
	{
	class(1);
	ndput(tidentifier);
	sttop()->value1= (CLR_TYPE)cls;
	if (stpick(1)->type == tNULL)
	{stswap(); stpop();}
	else stsflink ();
	staclr (c_lexv, (CLR_TYPE)$1.name);
	staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(146);
	}
	}
	;

I52repa                 :
	 /* empty */
	{ ndput(tNULL); }
	;

I52repa                 :
	 I52repa excomm
	{
	if (errorcount == 0)
	{
	 if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	}
	}
	;

executable_comment_list :
	 I52repa
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(texecutable_comment_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(147);
	}
	}
	;

excomm                  :
	 EXCOMM
	{
	if (errorcount == 0)
	{
	  ndput(texcomm);
	  staclr (c_ckey, (CLR_TYPE)$1.ckey);
	  staclr (c_cval, (CLR_TYPE)$1.cval);
	  staclr (c_line, (CLR_TYPE)$1.line);
	  staclr (c_funny, (CLR_TYPE)$1.name);
	 putgrn(148);
	}
	}
	;

%%

PRIVATE int
yylex ()
{
    token *tk;

   tk = gtk ();
   yylval = tk->yylval;
   return tk->type;
}

PUBLIC TNODE*
bast ()
{
   gl= ITcreate (4, 2, 1);
   gn= NULL;
   (void)yyparse();
   if (gn != NULL) gn->value0= (CLR_TYPE)IAT_IT_add(gl, grnl);
   return sttop();
}
