/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: swbus.h,v $
 * Revision 2.12  1993/03/24  18:02:51  lotos
 * new annotations for glad
 *
 * Revision 2.11  1993/01/18  18:04:54  lotos
 * distribution issues
 *
 * Revision 2.10  1993/01/12  20:19:06  lotos
 * portability issues
 *
 * Revision 2.9  1993/01/12  14:11:05  lotos
 * use conf.h for portability
 *
 * Revision 2.8  1992/11/17  17:47:19  lotos
 * fix typing of public functions
 *
 * Revision 2.7  1992/10/14  19:20:48  lotos
 * check contents of annotations: empty, nonempty, one word
 *
 * Revision 2.6  1992/09/02  14:47:27  lotos
 * keep annotations as independent (and sorted!) nodes in AST
 *
 * Revision 2.5  92/02/21  17:11:23  lotos
 * flags -t -w -n
 *
 * Revision 2.4  92/01/14  15:22:51  lotos
 * distribution issues
 *
 * Revision 2.3  92/01/10  15:20:54  lotos
 * modified for ophuscation
 *
 * Revision 2.2  91/02/28  17:18:00  lotos
 * rule 'premiss ::= _value_expression' removed
 * consequences: colours c_bool, c_rectrue, c_true removed
 * unique identifier per class generated
 *
 *
 * Revision 2.1  90/10/30  14:13:38  lotos
 * compressed AST
 * use of hardwired colours
 * compressed value expressions
 * annotations to colours
 *
 * Revision 1.3  90/06/04  15:23:55  lotos
 * if then else fi, removed
 * final match, removed
 * last ';' of eqns, made optional
 * executable comments are always lists
 * minor changes to shut lint up
 * adclr -> set_attr
 *
 * Revision 1.2  90/01/29  13:06:54  lotos
 * fixing license details
 *
 * Revision 1.1  90/01/24  14:38:30  lotos
 * Initial revision
 *
 ***********************************/

#define PUBLIC
#define PRIVATE static
#define SHARED extern

# include <stdlib.h>
# include <stdio.h>
# include <string.h>
# include <ctype.h>
# include <assert.h>
# include "version.h"

# define nil(type) (type) NULL

/*****  Includes  *****/

# include "rag.hh"
# include "nodes.h"

/*****  constants  *****/
# include "colours.h"

# define c_tree         201
# define c_troo         202
# define c_ckey         203
# define c_cval         204
# define c_vclrs        205
# define c_preserve     206

# define c_keylist	211
# define c_vallist	212


# define BCOMM  -1
# define COMM   -2
# define ECOMM  -3

/*****  exported types  *****/

typedef struct stname {
	int	name;
	int*    line;
	char*	ckey;
	char*	cval;
	} yystype;

typedef struct  {
	int     type;
	yystype yylval;
	} token;


/*****  exported variables  *****/

SHARED	char    sfile[BUFSIZ];
SHARED	int     nfname;

SHARED	char    lfile[BUFSIZ];
SHARED	char    cfile[BUFSIZ];

SHARED	FILE*   sfp;
SHARED	FILE*   lfp;
SHARED	FILE*   cfp;

SHARED  HT      hidtbl;	/* for SymbolTable */
SHARED  IAT*    grnl;

SHARED	int     flagc;
SHARED	int     flage;
SHARED	int     flagl;
SHARED	int     flagd;
SHARED	int     flagn;
SHARED	int     flagt;
SHARED	int     flagw;

SHARED  int     errorcount;
/* KJT 12/02/12: Omitted SHARED  int     fcomm; */
SHARED  char*   comm;

/*****  exported functions  *****/

PUBLIC  token*	gtk	();
PUBLIC  int	yyerror	();

PUBLIC	TNODE*	bast	();
PUBLIC	void	putgrn	();
PUBLIC	int	validexc ();
PUBLIC	void	putexc	();

PUBLIC	TNODE*	tv1	();
PUBLIC	TNODE*	tv2	();
PUBLIC	TNODE*	tt1	();
PUBLIC	TNODE*	tt2	();
PUBLIC	TNODE*	tt3	();
PUBLIC	TNODE*	tvl1	();
PUBLIC	TNODE*	simple_eq ();

PUBLIC  void    check_empty ();
PUBLIC  void    check_nonempty ();
PUBLIC  void    check_one_word ();

PUBLIC void excheck1 ();
PUBLIC void excheck2 ();
PUBLIC void excheck3 ();

/*****  *****/
