/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
$Log: swbus.h,v $
 * Revision 2.11  1993/01/18  18:10:59  lotos
 * distribution issues
 *
 * Revision 2.10  1993/01/12  20:19:58  lotos
 * portability issues
 *
 * Revision 2.9  1993/01/12  14:19:52  lotos
 * use conf.h for portability
 * move colour numbers upwards
 *
 * Revision 2.8  1992/02/21  17:14:04  lotos
 * adapted to new lfe
 * better presentation of reports
 *
 * Revision 2.7  92/01/14  15:23:54  lotos
 * distribution issues
 * 
 * Revision 2.6  92/01/14  11:28:54  lotos
 * include rag.hh
 * 
 * Revision 2.5  92/01/13  19:31:13  lotos
 * identification of names
 * adaption to phuscation
 * 
 * Revision 2.4  92/01/13  17:00:54  lotos
 * consider formal (sorts|operations)
 * 
 * Revision 2.3  91/02/28  19:31:05  lotos
 * adapted to lack of rule 'premiss ::= _value_expression'
 * adapted to information contained in AT
 * 
 * Revision 2.2  90/10/30  14:18:34  lotos
 * adapted to compressed CAST
 * 
 * Revision 2.1  90/06/01  15:08:29  lotos
 * handles identifier classification
 * 
 * Revision 1.2  90/01/29  13:14:05  lotos
 * fixing license details
 * 
 * Revision 1.1  90/01/22  12:50:30  lotos
 * Initial revision
 * 
 ***********************************/

#define PUBLIC
#define PRIVATE static
#define SHARED extern

# include <stdlib.h>
# include <stdio.h>
# include <string.h>
# include <ctype.h>
# include <assert.h>
# include "version.h"

# include "rag.hh"
# include "nodes.h"

# include "colours.h"

# define c_dec         91 /* This is an auxiliar colour. It oblies to
                          /* call the putid funtion */
# define c_sname       92
# define c_legend      93
# define c_aux_legend  94
# define c_gateoval    95
# define c_isname      96

/*+++++ +++++*/
# define TSPEC  1
# define TTYPE  2
# define TSORT  3
# define TOPN   4
# define TPROC  5
# define TGATE  6
# define TVAL   7

# define NONE	0
# define TFSORT	8
# define TFOPN	9

# define TNAME 10
/*+++++ +++++*/

typedef struct LineList {
        int     line;
        struct  LineList* next;
        } LNODE;

typedef struct Symbol {
        int     lexv;
        int     idclass;
        int     iddec;
        int     line;
        LNODE*  refs;
        struct  Symbol* left;
        struct  Symbol* right;
        INTlist legend;
        INTlist aux_legend;
        } SNODE;

/* As the colour legend is a INTlist, the special symbols
   have to be coded. A negative number is chosen in order to
   differenciate them of the lexv valua which are positive numbers.
   The -1 should not be used, because it is reserved to the built
   tree root. The following constants make this coding. As
   commentaries, which should to be printed.
*/

# define LEFT_ARROW    -2   /* ->       */
# define RIGTH_BRACKET -3   /* ]        */
# define LEFT_BRACKET  -4   /* [        */
# define RIGTH_PAREN   -5   /* )        */
# define LEFT_PAREN    -6   /* (        */
# define COLON         -7   /* :        */
# define COMMA         -8   /* ,        */
# define COLON_NOEXIT  -9   /* : noexit */
# define COLON_EXIT    -10  /* : exit   */
# define EXIT_PAREN    -11  /* : exit ( */

SHARED char     *progname;
SHARED AT       *ATable;

PUBLIC char*    emalloc ();
PUBLIC SNODE*   putid ();
PUBLIC void     print_ts ();
PUBLIC INTlist  INT2cons ();
PUBLIC int      mygetlexv ();
