/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: frame.c,v $
 * Revision 2.6  1993/11/08  17:08:00  lotos
 * clear new value array in newframe
 *
 * Revision 2.5  1993/06/28  19:12:30  lotos
 * max_var -> max_accepted
 *
 * Revision 2.4  1993/03/29  15:30:45  lotos
 * bug fixed w.r.t. # of values
 *
 * Revision 2.3  1993/01/18  18:25:53  lotos
 * distribution issues
 *
 * Revision 2.2  1992/11/17  17:27:06  lotos
 * var -> rav
 * success -> xto
 * distinguish kdatum / udatum
 *
 * Revision 2.1  1992/10/20  17:49:56  lotos
 * new KT evaluation algorithm
 * new Lbeta interface
 * cleaning, code optimization, space saving, bugs, ...
 *
 * Revision 1.8  1992/05/07  19:53:02  lotos
 * initialization of structures revisited for completeness
 *
 * Revision 1.7  92/05/06  18:54:09  lotos
 * send traces to stderr
 * make min-delay functionality upward compatible
 * 
 * Revision 1.6  92/03/05  17:37:07  lotos
 * just a few more bugs went to the hell
 * 
 * Revision 1.5  92/03/04  14:52:48  lotos
 * 100 minor bugettes
 * 
 * Revision 1.4  92/02/29  13:26:08  lotos
 * miscellaneous bug fixing
 * 
 * Revision 1.3  92/02/12  18:47:44  lotos
 * ni idea, era una version que andaba por ahi ...
 * 
 * Revision 1.2  92/01/15  12:41:04  lotos
 * a bug in frames
 * change success and values
 * 
 * Revision 1.1  92/01/14  19:25:43  lotos
 * Initial revision
 * 
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: frame.c,v 2.6 1993/11/08 17:08:00 lotos Exp $";
#endif

#include "swbus.h"
/* LINTLIBRARY */

  /*------------------------------------------------
    -- FRAMES FOR LOTOS PROCESSES AND ENVIRONMENT --
    ------------------------------------------------*/
       



  /*------------------------------------------------
    ------------------------------------------------
    --             MEMORY MANAGEMENT             --
    ------------------------------------------------
    ------------------------------------------------*/

#define FRM_BUCK  200

PRIVATE frame free_frames = NULL;
PUBLIC int max_val;

       /*  --         CREATE        -- */

PUBLIC frame
newframe ()
{
 register frame f;
 value_list v;
 register int i;
 register int j;

 if (free_frames == NULL) {
   f= (frame) my_malloc (sizeof(st_frame) * FRM_BUCK);
   v= (value_list) my_malloc (FRM_BUCK * max_val * sizeof(value)); 
   free_frames = f;
   for (i= 0; i < (FRM_BUCK -1); i++) {
     f[i].mmg= &f[i+1];
     f[i].rav= &v[i * max_val];
     for (j= 0; j < max_val; j++) 
	f[i].rav[j]= NULL;
   }
   f[FRM_BUCK -1].mmg= NULL;
   f[FRM_BUCK -1].rav   = &v[(FRM_BUCK -1)* max_val];
 } 
 f= free_frames;
 free_frames= f->mmg;
 f->ch=  NULL;
 f->dis= NULL;
 f->off= NULL;

 return f;
} 

       /*  --         DESTROY       -- */
    
PUBLIC void 
freeframe  (f)
  frame f;
{ 
  register int i;

  for (i= 0; i < max_val; i++) 
    if (f->rav[i] != NULL) {
      ud_free (TSsorts[f->but][i], f->rav[i]);
      f->rav[i]= NULL;
    }
  if (f->off != NULL) {
    freeoff (f->off);
    f->off= NULL;
  }
  f->mmg= free_frames;
  free_frames= f;
}

       /*  --         COPY          -- */

PUBLIC frame
frmcpy  (src)
  frame src;
{
  static    frame dst;
  register  int   i;

  dst = newframe ();
  dst->but    = src->but;
  dst->ent    = src->ent;

  for(i= 0; i < max_val; i++)
    if (src->rav[i] != NULL) 
      dst->rav[i]   = ud_copy(TSsorts[src->but][i],src->rav[i]);
  dst->ch =  src->ch;
  dst->dis=  src->dis;
  return dst;
}

       /*  --        OTHERS         -- */
  
  /*------------------------------------------------
    ------------------------------------------------
    --                    DRAW                    --
    ------------------------------------------------
    ------------------------------------------------*/


 
PUBLIC void   
draw_frame (n)
frame n;
{
  dump_frame (stderr ,n);
}
        
  
PUBLIC void   
  dump_frame( fp , f)
FILE * fp;
frame f;
{ 
  if (f != NULL) 
    if (g_flag)
      (void) fprintf (fp, " <%s.%d>",TSprocesses[f->but],f->ent);
    else
      (void) fprintf (fp, " <%d-%d>",f->but, f->ent);
}



/*********************** recolocarlo ********************/

