# include "rag.hh"
# include "nodes.h"
# include "grc.h"

IAT* grnl= NULL;

# include "swbus.h"

PRIVATE void
PROCESINI (r)
    TNODE* r;
{
  TNODE* h[33];
  /* KJT 20/01/23: added "int" type */
  register int i;
  int nr;
  int* grl;

  while (r != NULL) {
    h[0]= r;
    heval (r, h);
    grl= grnl->data[(int)(r->value0)];
    for (i= 0; grl[i] != 0; i++) {
     nr= grl[i];
     switch (nr) {
      case module_2:
	 adclr (-c_indent, h[0], 1);
	 break;
      case _specification_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 2);
	 if (h[3] != NULL)
	  adclr (-c_indent, h[3], 3);
	 if (h[4] != NULL)
	  adclr (-c_indent, h[4], 4);
	 if (h[5] != NULL)
	  adclr (-c_indent, h[5], 5);
	 if (h[6] != NULL)
	  adclr (-c_indent, h[6], 6);
	 break;
      case _definition_block_1:
	 if (h[1] != NULL)
	  adclr (-c_indent, h[1], 7);
	 if (h[2] != NULL)
	  adclr (-c_indent, h[2], 8);
	 break;
      case _local_definitions_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_indent, h[3], 9);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 break;
      case _data_type_definitions_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_indent, h[3], 10);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 break;
      case _type_definition_1:
	 adclr (-c_box, h[0], 11);
	 adclr (-c_indent, h[2], 12);
	 break;
      case _library_declaration_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 13);
	 break;
      case _p_expression_1:
	 if (h[2] != NULL)
	  adclr (-c_indent, h[2], 14);
	 break;
      case _p_expression_2:
	 adclr (-c_box, h[0], 15);
	 adclr (-c_indent, h[3], 16);
	 break;
      case _p_expression_3:
	 adclr (-c_box, h[0], 17);
	 adclr (-c_indent, h[2], 18);
	 break;
      case _type_union_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 19);
	 break;
      case _p_specification_1:
	 if (h[3] != NULL)
	  adclr (-c_indent, h[3], 20);
	 if (h[6] != NULL)
	  adclr (-c_indent, h[6], 21);
	 break;
      case _sort_pair_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 22);
	 break;
      case _operation_pair_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 23);
	 break;
      case _sort_pair_1:
	 adclr (-c_box, h[0], 24);
	 break;
      case _operation_pair_1:
	 adclr (-c_box, h[0], 25);
	 break;
      case _formal_sorts_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 26);
	 break;
      case _formal_operations_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 27);
	 break;
      case _formal_equations_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 28);
	 if (h[2] != NULL)
	  adclr (-c_indent, h[2], 29);
	 break;
      case _sorts_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 30);
	 break;
      case _sort_id_comm_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 31);
	 break;
      case _operations_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 32);
	 break;
      case _operation_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 33);
	 break;
      case _descriptor_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 34);
	 break;
      case _operation_descriptor_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 35);
	 break;
      case _operation_descriptor_2:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 36);
	 break;
      case _argument_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 37);
	 break;
      case _equations_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 38);
	 if (h[2] != NULL)
	  adclr (-c_indent, h[2], 39);
	 break;
      case _equation_lists_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_indent, h[3], 40);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 break;
      case _equation_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 41);
	 if (h[3] != NULL)
	  adclr (-c_indent, h[3], 42);
	 break;
      case _eqn_list_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_indent, h[3], 43);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 break;
      case _equation_1:
	 adclr (-c_box, h[0], 44);
	 break;
      case _equation_2:
	 adclr (-c_box, h[0], 45);
	 break;
      case _premisses_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 46);
	 break;
      case _simple_equation_1:
	 adclr (-c_box, h[0], 47);
	 break;
      case _process_definition_1:
	 adclr (-c_box, h[0], 48);
	 adclr (-c_indent, h[3], 49);
	 break;
      case _formal_parameter_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 50);
	 break;
      case _gate_parameter_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 51);
	 break;
      case _value_parameter_list_1:
	 adclr (-c_box, h[0], 52);
	 break;
      case _functionality_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 53);
	 break;
      case _functionality_list_2:
	 adclr (-c_box, h[0], 54);
	 break;
      case _exit_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 55);
	 break;
      case _local_definition_expression_1:
	 adclr (-c_box, h[0], 56);
	 adclr (-c_indent, h[2], 57);
	 break;
      case _identifier_equations_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 58);
	 break;
      case _identifier_equation_1:
	 adclr (-c_box, h[0], 59);
	 break;
      case _sum_expression_1:
	 adclr (-c_box, h[0], 60);
	 adclr (-c_indent, h[2], 61);
	 break;
      case _par_expression_1:
	 adclr (-c_box, h[0], 62);
	 adclr (-c_indent, h[3], 63);
	 break;
      case _parallel_operator_1:
	 adclr (-c_box, h[0], 64);
	 break;
      case _parallel_operator_2:
	 adclr (-c_box, h[0], 65);
	 break;
      case _parallel_operator_3:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 66);
	 break;
      case _hiding_expression_1:
	 adclr (-c_box, h[0], 67);
	 adclr (-c_indent, h[2], 68);
	 break;
      case _enable_expression_1:
	 adclr (-c_indent, h[1], 69);
	 adclr (-c_indent, h[3], 70);
	 break;
      case _enable_operator_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 71);
	 break;
      case _disable_expression_1:
	 adclr (-c_indent, h[1], 72);
	 adclr (-c_indent, h[2], 73);
	 break;
      case _parallel_expression_1:
	 adclr (-c_indent, h[1], 74);
	 adclr (-c_indent, h[3], 75);
	 break;
      case _choice_expression_1:
	 adclr (-c_indent, h[1], 76);
	 adclr (-c_indent, h[2], 77);
	 break;
      case _guarded_expression_1:
	 adclr (-c_box, h[0], 78);
	 adclr (-c_indent, h[2], 79);
	 break;
      case _action_prefix_expression_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 80);
	 if (h[1] != NULL)
	  adclr (-c_indent, h[1], 81);
	 if (h[3] != NULL)
	  adclr (-c_indent, h[3], 82);
	 break;
      case _action_denotation_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 83);
	 break;
      case _action_denotation_2:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 84);
	 break;
      case _action_denotation_3:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 85);
	 break;
      case _experiment_offer_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 86);
	 break;
      case _experiment_offer_1:
	 adclr (-c_box, h[0], 87);
	 break;
      case _experiment_offer_2:
	 adclr (-c_box, h[0], 88);
	 break;
      case _selection_predicate_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 89);
	 break;
      case _atomic_expression_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 90);
	 break;
      case _atomic_expression_2:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 91);
	 break;
      case _atomic_expression_3:
	 if (h[1] != NULL)
	  adclr (-c_indent, h[1], 92);
	 if (h[2] != NULL)
	  adclr (-c_indent, h[2], 93);
	 break;
      case _exit_entry_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 94);
	 break;
      case exit_entry_1:
	 adclr (-c_box, h[0], 95);
	 break;
      case _process_instantiation_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 96);
	 if (h[1] != NULL)
	  adclr (-c_indent, h[1], 97);
	 break;
      case _actual_gate_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 98);
	 break;
      case _value_expression_list_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_box, h[3], 99);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 100);
	 break;
      case _identifier_declarations_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 101);
	 break;
      case _identifier_declaration_1:
	 adclr (-c_box, h[0], 102);
	 break;
      case _gate_declarations_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 103);
	 break;
      case _gate_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 104);
	 break;
      case _gate_declaration_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 105);
	 break;
      case _gate_declaration_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 106);
	 break;
      case _identifier_declaration_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 107);
	 break;
      case _specification_identifier_1:
	 adclr (-c_box, h[0], 108);
	 break;
      case _type_identifier_1:
	 adclr (-c_box, h[0], 109);
	 break;
      case _sort_identifier_1:
	 adclr (-c_box, h[0], 110);
	 break;
      case _operation_identifier_1:
	 adclr (-c_box, h[0], 111);
	 break;
      case _operation_identifier_2:
	 adclr (-c_box, h[0], 112);
	 break;
      case _process_identifier_1:
	 adclr (-c_box, h[0], 113);
	 break;
      case _gate_identifier_1:
	 adclr (-c_box, h[0], 114);
	 break;
      case _identifier_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 115);
	 break;
      case _executable_comment_list_1:
	 if (h[0] != NULL)
	  adclr (-c_box, h[0], 116);
	 break;
      default:
	 assert ((1 <= nr) && (nr <= LAST_RULE));
      }
    } /* end of while (ngr != NULL) */
    r= succ (r, PREORDER);
  } /* end of while (r != NULL) */
} /* end of PROCESINI */

PUBLIC CLR_TYPE
eval (nar, r)
    int nar;
    TNODE* r;
{
  TNODE* h[33];

  if (r == NULL) return (CLR_TYPE)NULL;
  switch (nar) {
  case 1:
    h[0]= r;
   return (CLR_TYPE) 0 ;
  case 2:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom ("SPECIFICATION");
	pbegin ();
	  pbox ((BOX)fdclr (c_box,h[1], nar));
	  pbox ((BOX)fdclr (c_box,h[2], nar));
	pbox (pend (OPTS));
	return (CLR_TYPE) pend (HS);
  }
  case 3:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) 0 ;
  case 4:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) 0 ;
  case 5:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) i_incr ;
  case 6:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) 0 ;
  case 7:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     (int) fdclr (c_indent,h[0], nar) ;
  case 8:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 9:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE)
      fdclr (c_indent,h[0], nar) ;
  case 10:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE)
       fdclr (c_indent,h[0], nar) ;
  case 11:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom ("TYPE");
	 pbox ((BOX) fdclr (c_box,h[1], nar));
	 patom ("IS");
	return (CLR_TYPE) pend (HS);
  }
  case 12:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 13:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

  {
       pbegin ();
	 patom ("LIBRARY");
	 pbox (shift (i_incr, slist (h[0], ",")));
	 patom ("ENDLIB");
	return (CLR_TYPE) pend (OPTS);
  }
  case 14:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     fdclr (c_indent,h[0], nar) ;
  case 15:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	pbox ((BOX)fdclr (c_box,h[1], nar));
	patom ("ACTUALIZEDBY");
	pbox ((BOX)fdclr (c_box,h[2], nar));
	patom ("USING");
	return (CLR_TYPE) pend (HS);
  }
  case 16:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     fdclr (c_indent,h[0], nar) ;
  case 17:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
       pbox ((BOX)fdclr (c_box,h[1], nar));
       patom ("RENAMEDBY");
	return (CLR_TYPE) pend (HS);
  }
  case 18:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     fdclr (c_indent,h[0], nar) ;
  case 19:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) slist (h[0], ",") ;
  case 20:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 21:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 22:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

  {
       TNODE* nd;
       pbegin ();
       for (nd= h[1]; nd != NULL; nd=gt_rb(nd))
	 pbox ((BOX) fdclr (c_box, nd, -11));
	return (CLR_TYPE) pend (VL);
  }
  case 23:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

  {
       TNODE* nd;
       pbegin ();
       for (nd= h[1]; nd != NULL; nd=gt_rb(nd))
	 pbox ((BOX) fdclr (c_box, nd, -12));
	return (CLR_TYPE) pend (VL);
  }
  case 24:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
       pbox ((BOX)fdclr (c_box,h[1], nar));
       patom ("FOR");
       pbox ((BOX)fdclr (c_box,h[2], nar));
	return (CLR_TYPE) pend (HS);
  }
  case 25:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
       pbox ((BOX)fdclr (c_box,h[1], nar));
       patom ("FOR");
       pbox ((BOX)fdclr (c_box,h[2], nar));
	return (CLR_TYPE) pend (HS);
  }
  case 26:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) slist (h[0], ",") ;
  case 27:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

  {
       TNODE* nd;
       pbegin ();
       for (nd= h[1]; nd != NULL; nd=gt_rb(nd))
	 pbox ((BOX) fdclr (c_box, nd, -13));
	return (CLR_TYPE) pend (VL);
  }
  case 28:
    h[0]= r;
    heval (h[0], h);

  {
       if (h[1]) {
	pbegin ();
	  patom ("FORALL");
	  pbox ((BOX)fdclr (c_box,h[1], nar));
	 return (CLR_TYPE) pend (HS);
       }
       else
	 return (CLR_TYPE) NULL;
  }
  case 29:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     fdclr (c_indent,h[0], nar) ;
  case 30:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) slist (h[0], ",") ;
  case 31:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 pbox ((BOX)fdclr (c_box,h[1], nar));
	  pbegin ();
	    pbox (pr_excom (h[1], c_draw));
	    pbox (pr_excom (h[1], c_equal));
	    pbox (pr_excom (h[1], c_extern));
	    pbox (pr_excom (h[1], c_free));
	    pbox (pr_excom (h[1], c_name));
	    pbox (pr_excom (h[1], c_parse));
	  pbox (pend (OPTS));
	return (CLR_TYPE) pend (HS);
  }
  case 32:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

  {
       TNODE* nd;
       pbegin ();
       for (nd= h[1]; nd != NULL; nd= gt_rb(nd))
	 pbox ((BOX) fdclr (c_box, nd, -14));
	return (CLR_TYPE) pend (VL);
  }
  case 33:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
       pbegin ();
       pbox ((BOX)fdclr (c_box,h[1], nar));
       patom (":");
       pbox (pend(HD));
       if (h[2]) pbox ((BOX)fdclr (c_box,h[2], nar));
       patom ("->");
       pbox ((BOX)fdclr (c_box,h[3], nar));
	return (CLR_TYPE) pend (HS);
  }
  case 34:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) slist (h[0], ",");
  case 35:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	pbox ((BOX)fdclr (c_box,h[1], nar));
	pbegin ();
	  pbox (pr_excom (h[1], c_extern));
	  pbox (pr_excom (h[1], c_name));
	  pbox (pr_excom (h[1], c_partial));
	  pbox (pr_excom (h[1], c_internal));
	  pbox (pr_excom (h[1], c_lexical));
	  pbox (pr_excom (h[1], c_lexicalifpossible));
	  pbox (pr_excom (h[1], c_using));
	  pbox (pr_excom (h[1], c_usingsort));
	  pbox (pr_excom (h[1], c_constructor));
	  pbox (pr_excom (h[1], c_nonconstructor));
	  pbox (pr_excom (h[1], c_call));
	pbox (pend (OPTS));
	return (CLR_TYPE) pend (HS);
  }
  case 36:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	patom ("_");
	pbox ((BOX)fdclr (c_box,h[1], nar));
	patom ("_");
	pbegin ();
	  pbox (pr_excom (h[1], c_extern));
	  pbox (pr_excom (h[1], c_name));
	  pbox (pr_excom (h[1], c_partial));
	  pbox (pr_excom (h[1], c_internal));
	  pbox (pr_excom (h[1], c_lexical));
	  pbox (pr_excom (h[1], c_lexicalifpossible));
	  pbox (pr_excom (h[1], c_using));
	  pbox (pr_excom (h[1], c_usingsort));
	  pbox (pr_excom (h[1], c_constructor));
	  pbox (pr_excom (h[1], c_nonconstructor));
	  pbox (pr_excom (h[1], c_call));
	pbox (pend (OPTS));
	return (CLR_TYPE) pend (HS);
  }
  case 37:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) slist (h[0], ",");
  case 38:
    h[0]= r;
    heval (h[0], h);

  {
       if (h[1]) {
	pbegin ();
	  patom ("FORALL");
	  pbox ((BOX)fdclr (c_box,h[1], nar));
	 return (CLR_TYPE) pend (HS);
       }
       else
	 return (CLR_TYPE) NULL;
  }
  case 39:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     fdclr (c_indent,h[0], nar) ;
  case 40:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE)
     fdclr (c_indent,h[0], nar) ;
  case 41:
    h[0]= r;
    heval (h[0], h);

  {
       if (h[2]) {
	pbegin ();
	  pbegin ();
	    patom ("OFSORT");
	    pbox ((BOX)fdclr (c_box,h[1], nar));
	  pbox (pend (HS));
	  pbegin ();
	    patom ("FORALL");
	    pbox ((BOX)fdclr (c_box,h[2], nar));
	  pbox (pend (HS));
	 return (CLR_TYPE) pend (VL);
       }
       else {
	pbegin ();
	  patom ("OFSORT");
	  pbox ((BOX)fdclr (c_box,h[1], nar));
	 return (CLR_TYPE) pend (HS);
       }
  }
  case 42:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 43:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE)
     fdclr (c_indent,h[0], nar) ;
  case 44:
    h[0]= r;
    heval (h[0], h);

  {
      pbegin ();
      pbox ((BOX) fdclr (c_box,h[1], nar));
      patom (";");
       return (CLR_TYPE) pend (HS);
  }
  case 45:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 pbegin ();
	   pbox ((BOX) fdclr (c_box,h[1], nar));
	   patom ("=>");
	 pbox (pend (HS));
	 pbegin ();
	   pbox ((BOX) fdclr (c_box,h[2], nar));
	  patom (";");
	 pbox (shift (i_incr, pend (HS)));
	return (CLR_TYPE) pend (VL);
  }
  case 46:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) slist (h[0], ",");
  case 47:
    h[0]= r;
    heval (h[0], h);

  {
       if (find_attr(c_funny, h[0]) != NULL)
	  return (CLR_TYPE) build_ve (h[1]);
       else {
	 pbegin ();
	  pbegin ();
	    pbox (build_ve (h[1]));
	    patom ("=");
	  pbox (pend (HS));
	  pbox (shift (i_incr, build_ve (h[2])));
	  return (CLR_TYPE) pend (OPTS);
       }
  }
  case 48:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom ("PROCESS");
	pbegin ();
	  pbox ((BOX) fdclr (c_box,h[1], nar));
	  pbegin ();
	    pbox ((BOX) fdclr (c_box,h[2], nar));
	    patom (":=");
	  pbox (pend (HS));
	pbox (pend (OPTS));
	return (CLR_TYPE) pend (HS);
  }
  case 49:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 50:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 if (h[1]) pbox ((BOX)fdclr (c_box,h[1], nar));
	 if (h[2]) pbox ((BOX)fdclr (c_box,h[2], nar));
	 pbox ((BOX)fdclr (c_box,h[3], nar));
	return (CLR_TYPE) pend (OPTS);
  }
  case 51:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom ("[");
	 pbox ((BOX)fdclr (c_box,h[1], nar));
	 patom ("]");
	return (CLR_TYPE) pend (HD);
  }
  case 52:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom ("(");
	 pbox ((BOX)fdclr (c_box,h[1], nar));
	 patom (")");
	return (CLR_TYPE) pend (HD);
  }
  case 53:
    h[0]= r;
    heval (h[0], h);

  {
	pbegin ();
	patom (": EXIT");
	if (h[1]) {
	  pbegin ();
	   patom ("(");
	   pbox ((BOX)fdclr (c_box,h[1], nar));
	   patom (")");
	  pbox (pend (HD));
	}
	 return (CLR_TYPE) pend (HS);
  }
  case 54:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) batom (": NOEXIT");
  case 55:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    return (CLR_TYPE) slist (h[0], ",");
  case 56:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom ("LET");
	 pbox ((BOX)fdclr (c_box,h[1], nar));
	 patom ("IN");
	return (CLR_TYPE) pend (HS);
  }
  case 57:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 58:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    return (CLR_TYPE) slist (h[0], ",");
  case 59:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 pbox ((BOX)fdclr (c_box,h[1], nar));
	 patom ("=");
	 pbox (build_ve (h[2]));
	return (CLR_TYPE) pend (HS);
  }
  case 60:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom ("CHOICE");
	 pbox ((BOX)fdclr (c_box,h[1], nar));
	 patom ("[]");
	return (CLR_TYPE) pend (HS);
  }
  case 61:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 62:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom ("PAR");
	 pbox ((BOX)fdclr (c_box,h[1], nar));
	 pbox ((BOX)fdclr (c_box,h[2], nar));
	return (CLR_TYPE) pend (HS);
  }
  case 63:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 64:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) batom("||");
  case 65:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) batom("|||");
  case 66:
    h[0]= r;
    heval (h[0], h);

  {
	pbegin ();
	patom ("|[");
	if (h[1]) pbox ((BOX)fdclr (c_box,h[1], nar));
	patom ("]|");
	 return (CLR_TYPE) pend (HD);
  }
  case 67:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom ("HIDE");
	 pbox ((BOX)fdclr (c_box,h[1], nar));
	 patom ("IN");
	return (CLR_TYPE) pend (HS);
  }
  case 68:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 69:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 70:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     (h[3]->type == tenable_expression ?
	(int) fdclr (c_indent,h[0], nar) :
	((int) fdclr (c_indent,h[0], nar) + i_incr)) ;
  case 71:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom(">>");
	 if (h[1]) {
	   patom ("ACCEPT");
	   pbox ((BOX)fdclr (c_box,h[1], nar));
	   patom ("IN");
	 }
	return (CLR_TYPE) pend (HS);
  }
  case 72:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 73:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     (h[2]->type == tdisable_expression ?
	(int) fdclr (c_indent,h[0], nar) :
	((int) fdclr (c_indent,h[0], nar) + i_incr)) ;
  case 74:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 75:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     (h[3]->type == tparallel_expression ?
       (int) fdclr (c_indent,h[0], nar) :
       ((int) fdclr (c_indent,h[0], nar) + i_incr)) ;
  case 76:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 77:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     (h[2]->type == tchoice_expression ?
       (int) fdclr (c_indent,h[0], nar) :
       ((int) fdclr (c_indent,h[0], nar) + i_incr)) ;
  case 78:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom ("[");
	 pbox ((BOX) fdclr (c_box,h[1], nar));
	 patom ("]->");
	return (CLR_TYPE) pend (HD);
  }
  case 79:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) + i_incr) ;
  case 80:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 pbox ((BOX)fdclr (c_box,h[2], nar));
	 patom (";");
	return (CLR_TYPE) pend (HD);
  }
  case 81:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     fdclr (c_indent,h[0], nar) ;
  case 82:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     fdclr (c_indent,h[0], nar) ;
  case 83:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 pbox ((BOX) fdclr (c_box,h[1], nar));
	 if (h[2])
	   pbox ((BOX) fdclr (c_box,h[2], nar));
	return (CLR_TYPE) pend (OPTS);
  }
  case 84:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 pbegin ();
	   pbox ((BOX) fdclr (c_box,h[1], nar));
	   pbox ((BOX) fdclr (c_box,h[2], nar));
	 pbox (pend (HS));
	 if (fdclr (c_box,h[3], nar))
	   pbox ((BOX) fdclr (c_box,h[3], nar));
	 if (h[4])
	   pbox ((BOX) fdclr (c_box,h[4], nar));
	return (CLR_TYPE) pend (OPTS);
  }
  case 85:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom("I");
	 if (h[1])
	   pbox ((BOX) fdclr (c_box,h[1], nar));
	return (CLR_TYPE) pend (HS);
  }
  case 86:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

  {
       TNODE* nd;
       pbegin ();
	 for (nd= h[1]; nd != NULL; nd= gt_rb (nd))
	   pbox ((BOX)fdclr(c_box,nd, -15));
	return (CLR_TYPE) pend (OPTS);
  }
  case 87:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom ("?");
	 pbox ((BOX) fdclr (c_box,h[1], nar));
	 patom (":");
	 patom (" ");
	 pbox ((BOX) fdclr (c_box,h[2], nar));
       return (CLR_TYPE) pend (HD);
  }
  case 88:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 patom ("!");
	 pbox (build_ve (h[1]));
	return (CLR_TYPE) pend (HD);
  }
  case 89:
    h[0]= r;
    heval (h[0], h);

  {
       if (h[1]) {
	 pbegin ();
	   patom ("[");
	   pbox ((BOX) fdclr (c_box,h[1], nar));
	   patom ("]");
	  return (CLR_TYPE) pend (HD);
       }
       else
	  return (CLR_TYPE) NULL;
  }
  case 90:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 if (h[1])
	   pbox ((BOX) fdclr (c_box,h[1], nar));
	 patom ("STOP");
	return (CLR_TYPE) pend (HS);
  }
  case 91:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 if (h[1])
	   pbox ((BOX) fdclr (c_box,h[1], nar));
	 patom ("EXIT");
	 if (h[2]) {
	   pbegin ();
	     patom ("(");
	     pbox ((BOX) fdclr (c_box,h[2], nar));
	     patom (")");
	   pbox (pend (HD));
	 }
	return (CLR_TYPE) pend (HS);
  }
  case 92:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) +i_incr) ;
  case 93:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     ((int) fdclr (c_indent,h[0], nar) +i_incr) ;
  case 94:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

  {
       TNODE* nd;
       pbegin ();
	 for (nd= h[1]; nd != NULL; nd= nd->brothers) {
	   pbegin ();
	   if (nd->type == tsort_identifier)
	     patom ("ANY ");
	   pbox ((BOX) fdclr (c_box, nd, -16));
	   if (nd->brothers)
	     patom (",");
	   pbox (pend (HD));
	 }
	return (CLR_TYPE) pend (OPTS);
  }
  case 95:
    h[0]= r;
   return (CLR_TYPE)
     build_ve (h[0]) ;
  case 96:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 pbox ((BOX) fdclr (c_box,h[2], nar));
	 if (h[3] || h[4]) {
	   pbegin ();
	   if (h[3])
	     pbox ((BOX) fdclr (c_box,h[3], nar));
	   if (h[4]) {
	     pbegin ();
	       patom ("(");
	       pbox ((BOX) fdclr (c_box,h[4], nar));
	       patom (")");
	     pbox (pend (HD));
	   }
	   pbox (pend (OPTS));
	 }
	return (CLR_TYPE) pend (HS);
  }
  case 97:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE)
     fdclr (c_indent,h[0], nar) ;
  case 98:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
       patom ("[");
       pbox ((BOX) fdclr (c_box,h[1], nar));
       patom ("]");
     return (CLR_TYPE) pend (HD);
  }
  case 99:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE)
     build_ve (h[3]) ;
  case 100:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE)
     slist (h[0], ",") ;
  case 101:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    return (CLR_TYPE) slist (h[0], ",");
  case 102:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 pbegin ();
	   pbox ((BOX)fdclr (c_box,h[1], nar));
	   patom (":");
	 pbox (pend (HD));
       pbox ((BOX) fdclr (c_box,h[2], nar));
      return (CLR_TYPE) pend (HS);
  }
  case 103:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    return (CLR_TYPE) slist (h[0], ",");
  case 104:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    return (CLR_TYPE) slist (h[0], ",");
  case 105:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) slist (h[0], ",");
  case 106:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
	 pbox ((BOX) fdclr (c_box,h[1], nar));
	 patom ("IN");
	 pbegin ();
	   patom ("[");
	   pbox ((BOX) fdclr (c_box,h[2], nar));
	   patom ("]");
	 pbox (pend (HD));
	return (CLR_TYPE) pend (HS);
  }
  case 107:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) slist (h[0], ",");
  case 108:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) bident (h[0]);
  case 109:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) bident (h[0]);
  case 110:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) bident (h[0]);
  case 111:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) bident (h[0]);
  case 112:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) bident (h[0]);
  case 113:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) bident (h[0]);
  case 114:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) bident (h[0]);
  case 115:
    h[0]= r;
    heval (h[0], h);

  {
       pbegin ();
       pbox (bident (h[0]));
       if (h[1])
	 pbox ((BOX) fdclr (c_box,h[1], nar));
	return (CLR_TYPE) pend (OPTS);
  }
  case 116:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

  {
       TNODE* nd;
       pbegin ();
       for (nd= h[1]; nd != NULL; nd= gt_rb(nd))
	pbox (pr_excom_it (nd));
	return (CLR_TYPE) pend (OPTS);
  }
     }
  return (CLR_TYPE)NULL;
}






PUBLIC void
visit (r)
	TNODE*	r;
{
	TNODE*	h[33];
	int	nar;

  if (r == NULL) return;
  nar= *(grnl->data[(int)(r->value0)]);
  switch (nar) {

   case module_2 :
    h[0]= r;
	{
	 visit (h[0]);
	}
	break;

   case _specification_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 display (0, (BOX)fdclr (c_box,h[0], nar));
	 visit (h[3]);
	 visit (h[4]);
	 displaystr (0, "BEHAVIOUR");
	 visit (h[5]);
	 displaystr (0, "ENDSPEC");
	 visit (h[6]);
	}
	break;

   case _definition_block_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit (h[1]);
	 if (h[2]) {
	 displaystr ((int) fdclr (c_indent,h[0], nar), "WHERE");
	 visit (h[2]);
	 }
	}
	break;

   case _local_definitions_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* nd;
	 for (nd= h[1]; nd != NULL; nd= gt_rb(nd)) {
	 visit (nd);
	 if (nd->brothers)
	 skip ();
	 }
	}
	break;

   case _data_type_definitions_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* nd;
	 for (nd= h[0]->sons; nd != NULL; nd= nd->brothers) {
	 visit (nd);
	 if (nd->brothers)
	 skip ();
	 }
	}
	break;

   case _type_definition_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	 visit (h[2]);
	 displaystr ((int) fdclr (c_indent,h[0], nar) + i_incr, "ENDTYPE");
	}
	break;

   case _library_declaration_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	}
	break;

   case _p_expression_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (h[1])
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[1], nar));
	 visit (h[2]);
	}
	break;

   case _p_expression_2 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	 visit (h[3]);
	}
	break;

   case _p_expression_3 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	 visit (h[2]);
	}
	break;

   case _p_specification_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (h[1]) {
	 displaystr ((int) fdclr (c_indent,h[0], nar), "FORMALSORTS");
	 display ((int) fdclr (c_indent,h[0], nar) + i_incr,
	 (BOX)fdclr (c_box,h[1], nar));
	 }
	 if (h[2]) {
	 displaystr ((int) fdclr (c_indent,h[0], nar), "FORMALOPNS");
	 display ((int) fdclr (c_indent,h[0], nar) + i_incr,
	 (BOX)fdclr (c_box,h[2], nar));
	 }
	 if (h[3]) {
	 displaystr ((int) fdclr (c_indent,h[0], nar), "FORMALEQNS");
	 visit (h[3]);
	 }
	 if (h[4]) {
	 displaystr ((int) fdclr (c_indent,h[0], nar), "SORTS");
	 display ((int) fdclr (c_indent,h[0], nar) + i_incr,
	 (BOX)fdclr (c_box,h[4], nar));
	 }
	 if (h[5]) {
	 displaystr ((int) fdclr (c_indent,h[0], nar), "OPNS");
	 display ((int) fdclr (c_indent,h[0], nar) + i_incr,
	 (BOX)fdclr (c_box,h[5], nar));
	 }
	 if (h[6]) {
	 displaystr ((int) fdclr (c_indent,h[0], nar), "EQNS");
	 visit (h[6]);
	 }
	}
	break;

   case _replacement_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (h[1]) {
	 displaystr ((int) fdclr (c_indent,h[0], nar), "SORTNAMES");
	 display ((int) fdclr (c_indent,h[0], nar) + i_incr,
	 (BOX)fdclr (c_box,h[1], nar));
	 }
	 if (h[2]) {
	 displaystr ((int) fdclr (c_indent,h[0], nar), "OPNNAMES");
	 display ((int) fdclr (c_indent,h[0], nar) + i_incr,
	 (BOX)fdclr (c_box,h[2], nar));
	 }
	}
	break;

   case _formal_equations_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (h[1])
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	 visit (h[2]);
	}
	break;

   case _equations_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (h[1])
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	 visit (h[2]);
	}
	break;

   case _equation_lists_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* nd;
	 for (nd= h[1]; nd != NULL; nd= nd->brothers) {
	 visit (nd);
	 if (nd->brothers)
	 skip ();
	 }
	}
	break;

   case _equation_list_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	 visit (h[3]);
	}
	break;

   case _eqn_list_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* nd;
	 for (nd= h[1]; nd != NULL; nd= nd->brothers)
	 visit (nd);
	}
	break;

   case _equation_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	}
	break;

   case _equation_2 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	}
	break;

   case _process_definition_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	 visit (h[3]);
	 dendproc ((int) fdclr (c_indent,h[0], nar) + i_incr,
	 h[1]);
	}
	break;

   case _local_definition_expression_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	 visit (h[2]);
	}
	break;

   case _sum_expression_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	 visit (h[2]);
	}
	break;

   case _par_expression_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	 visit (h[2]);
	}
	break;

   case _hiding_expression_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	 visit (h[2]);
	}
	break;

   case _enable_expression_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit (h[1]);
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX)fdclr (c_box,h[2], nar));
	 visit (h[3]);
	}
	break;

   case _disable_expression_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit (h[1]);
	 displaystr ((int) fdclr (c_indent,h[0], nar), "[>");
	 visit (h[2]);
	}
	break;

   case _parallel_expression_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit (h[1]);
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[2], nar));
	 visit (h[3]);
	}
	break;

   case _choice_expression_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit (h[1]);
	 displaystr ((int) fdclr (c_indent,h[0], nar), "[]");
	 visit (h[2]);
	}
	break;

   case _guarded_expression_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	 visit (h[2]);
	}
	break;

   case _action_prefix_expression_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit (h[1]);
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	 visit (h[3]);
	}
	break;

   case _atomic_expression_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	}
	break;

   case _atomic_expression_2 :
    h[0]= r;
    heval (h[0], h);
	{
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	}
	break;

   case _atomic_expression_3 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit (h[1]);
	 displaystrn ((int) fdclr (c_indent,h[0], nar), "(");
	 visit (h[2]);
	 displaystr ((int) fdclr (c_indent,h[0], nar), ")");
	}
	break;

   case _process_instantiation_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit (h[1]);
	 display ((int) fdclr (c_indent,h[0], nar),
	 (BOX) fdclr (c_box,h[0], nar));
	}
	break;

   case _executable_comment_list_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* nd;
	 for (nd= h[1]; nd != NULL; nd= gt_rb(nd))
	 display ((int) fdclr (c_indent,h[0], nar), pr_excom_it (nd));
	}
	break;
  }
}

PUBLIC void
rag (r)
    TNODE* r;
{
  PROCESINI (r);
  if (ragerrors == 0)
    todo (r);
} /* end of rag */
